Lives = {}
local Lives = Lives

Lives.init = function(lives, maxLives)
	Lives.lives = assert(lives, "Invalid lives argument.")
	Lives.maxLives = maxLives or lives
end

Lives.isAlive = function()
	assert(Lives.lives, "Lives not initialised.")
	return Lives.lives > 0
end

Lives.getLives = function()
	assert(Lives.lives, "Lives not initialised.")
	return Lives.lives
end

Lives.getMaxLives = function()
	assert(Lives.maxLives, "Lives not initialised.")
	return Lives.maxLives
end

Lives.setLives = function(value)
	assert(Lives.lives, "Lives not initialised.")
	Lives.lives = assert(value >= 0 and value <= Lives.maxValue, "Invalid value argument.")
	if (Lives.lives == 0 and Lives.deathFunc) then deathFunc() end
end

Lives.setMaxLives = function(value)
	assert(Lives.maxLives, "Lives not initialised.")
	Lives.maxLives = assert(value >= Lives.lives, "Invalid value argument.")
end

Lives.incLives = function(value)
	value = (value and assert(value > 0, "Invalid value argument.") and value) or 1
	value = math.min(value, Lives.maxLives - Lives.lives)
	Lives.lives = Lives.lives + value
	if (Lives.incFunc) then Lives.incFunc(value) end
end

Lives.decLives = function(value)
	value = (value and assert(value > 0, "Invalid value argument.") and value) or 1
	value = math.min(value, Lives.lives)
	Lives.lives = Lives.lives - value
	if (Lives.decFunc) then Lives.decFunc(value) end
	if (Lives.lives <= 0) then
		if (Lives.deathFunc) then Lives.deathFunc() end
	end
end

Lives.toString = function()
	error("Unimplemented function called.")
end

Lives.setToStringFunc = function(func)
	assert(func, "Invalid func argument.")
	Lives.toString = function() return func(Lives.lives, Lives.maxLives) end
end

Lives.setIncFunc = function(func)
	Lives.incFunc = assert(func, "Invalid func argument.")
end

Lives.setDecFunc = function(func)
	Lives.decFunc = assert(func, "Invalid func argument.")
end

Lives.setDeathFunc = function(func)
	Lives.deathFunc = assert(func, "Invalid func argument.")
end
