Controller = {}
local Controller = Controller

Controller.init = function(player, mode, func)
	assert(player, "Invalid player argument.")
	assert(mode, "Invalid mode argument.")
	assert(func, "Invalid func argument.")
	Controller.actor = Actor.Create("controller", true, {Owner = player, Location = CPos.New(1, 1)})
	Controller.mode = mode
	Trigger.OnProduction(Controller.actor, function(_, produced)
		GivePlayerMoney()
		func(produced)
	end)
	return Controller.actor
end

Controller.getMode = function()
	return assert(Controller.mode, "Controller uninitialised.")
end

Controller.setMode = function(mode)
	assert(Controller.mode, "Controller uninitialised.")
	Controller.mode.Destroy()
	Controller.mode = assert(mode, "Invalid mode argument.")
end
