Array = {}
local Array = Array

Array.max = function(a)
	return math.max(unpack(a))
end

Array.min = function(a)
	return math.min(unpack(a))
end

Array.maxBy = function(a, f)
	assert(a, "Invalid a argument.")
	assert(f, "Invalid f argument.")
	local max = nil
	local fmax = -math.huge
	for _, v in ipairs(a) do
		if (fmax < f(v)) then
			max = v
			fmax = f(v)
		end
	end
	return max
end

Array.minBy = function(a, f)
	assert(a, "Invalid a argument.")
	assert(f, "Invalid f argument.")
	local min = nil
	local fmin = math.huge
	for _, v in ipairs(a) do
		if (fmin > f(v)) then
			min = v
			fmin = f(v)
		end
	end
	return min
end

Array.toSet = function(a)
	assert(a, "Invalid a argument")
	local s = {}
	for _, v in ipairs(a) do
		s[v] = true
	end
end

Array.copy = function(a)
	assert(a, "Invalid a argument.")
	return {unpack(a)}
end

Array.concat = function(...)
	local na = {}
	for _, a in ipairs(arg) do
		for _, v in ipairs(a) do
			table.insert(na, v)
		end
	end
	return na
end

Array.map = function(a, f, na)
	assert(a, "Invalid a argument.")
	assert(f, "Invalid f argument.")
	na = na or {}
	for _, v in ipairs(a) do
		local nv = f(v)
		table.insert(na, nv)
	end
	return na
end

Array.foldl = function(a, f, v, k)
	assert(a, "Invalid a argument.")
	assert(f, "Invalid f argument.")
	local ni, nv = next(a, k)
	return (ni and ni <= #a and f(v, Array.foldl(a, f, nv, ni))) or v
end

Array.foldr = function(a, f, v, k)
	assert(a, "Invalid a argument.")
	assert(f, "Invalid f argument.")
	local ni, nv = next(a, k)
	return (ni and ni <= #a and f(nv, Array.foldr(a, f, v, ni))) or v
end

Array.zip = function(...)
	assert(arg.n > 0, "Invalid number of arguments.")
	local na = {}
	local min = Array.min(Array.map(arg, function(a) return #a end))
	for i = 1, min do
		na[i] = {}
		for _, a in ipairs(arg) do
			table.insert(na[i], a[i])
		end
	end
	return na
end

Array.any = function(a, f)
	assert(a, "Invalid a argument.")
	assert(f, "Invalid f argument.")
	for _, v in ipairs(a) do
		if (f(v)) then return true end
	end
	return false
end

Array.all = function(a, f)
	assert(a, "Invalid a argument.")
	assert(f, "Invalid f argument.")
	for _, v in ipairs(a) do
		if (not f(v)) then return false end
	end
	return true
end

Array.filter = function(a, f)
	assert(a, "Invalid a argument.")
	assert(f, "Invalid f argument.")
	local na = {}
	for _, v in ipairs(a) do
		if (f(v)) then table.insert(na, v) end
	end
	return na
end

Array.toString = function(a)
	assert(a, "Invalid a argument.")
	local str = "["
	for i, v in ipairs(a) do
		str = str .. v .. ((next(a, i) and ", ") or "]")
	end
	return str
end
