Path = {}
local Path = Path

local Array			= assert(Array, "Invalid module.")
local MapUtility	= assert(MapUtility, "Invalid module.")

local setEnabled = function(t, state)
	for _, v in ipairs(t) do
		v.IsInWorld = state
	end
end

Path.updatePath = function()
	Path.path = Path.path or Utils.Where(Map.ActorsInWorld, function(a)
		return a.Type == "path"
	end)
	assert(next(Path.path), "No path actors in world")
	return Path.path
end

Path.updateBorder = function()
	Path.border = Path.border or Utils.Where(Map.ActorsInWorld, function(a)
		return a.Type == "border"
	end)
	assert(next(Path.border), "No border actors in world")
	return Path.border
end
	
Path.pathEnabled = function()
	local next = next
	return (Path.path or Path.updatePath()) and next(Path.path) and select(2, next(Path.path)).IsInWorld
end

Path.setPathEnabled = function(state)
	if (Path.pathEnabled() == state) then return end
	setEnabled(Path.path, state)
end

Path.borderEnabled = function()
	local next = next
	return (Path.border or Path.updateBorder()) and next(Path.border) and select(2, next(Path.border)).IsInWorld
end

Path.setBorderEnabled = function(state)
	if (Path.borderEnabled() == state) then return end
	setEnabled(Path.border, state)
end
