WaveManager = {}
local WaveManager = WaveManager

local Array		= Array
local Config	= Config
local Spawn		= Spawn
local Target	= Target

WaveManager.waveNum = 0
WaveManager.time = 0

WaveManager.getWaveNum = function()
	return WaveManager.waveNum
end

WaveManager.getTime = function()
	return WaveManager.time
end

WaveManager.setWaveNum = function(v)
	assert(value, "Invalid v argument")
	WaveManager.waveNum = v
end

WaveManager.setTime = function(v)
	assert(value and value >= 0, "Invalid v argument.")
	Interface.time = v
end

WaveManager.incWaveNum = function(v)
	v = v or 1
	assert(v > 0, "Invalid v argument")
	WaveManager.waveNum = WaveManager.waveNum + v
end

WaveManager.incTime = function(v)
	v = v or 1
	assert(v > 0, "Invalid v argument.")
	WaveManager.time = WaveManager.time + v
end

WaveManager.decWaveNum = function(v)
	v = v or 1
	assert(v > 0, "Invalid v argument")
	WaveManager.waveNum = WaveManager.waveNum - v
end

WaveManager.decTime = function(v)
	v = v or 1
	assert(v > 0, "Invalid v argument.")
	WaveManager.time = WaveManager.time - v
end

local assignActors = function(spawns, types)
	local nSpawns = Array.map(spawns, function(s)
		return {actors = {}, spawn = s, targets = Spawn.getSpawnTargets(s)}
	end)
	local actors = Array.map(types, function(t)
		return Actor.Create(t, false, {Owner = Config.enemy, Location = CPos.New(0, 0)})
	end)
	for _, a in ipairs(actors) do
		local s = Utils.Random(nSpawns)
		table.insert(s.actors, a)
	end
	return nSpawns, actors
end

local attachIdleTrigger = function(a, t)
	Trigger.OnIdle(a, function()
		a.EnterTransport(t)
	end)
end

local function timedDelay(func)
	assert(func, "Invalid func argument")
	if (Interface.time > 0) then 
		Interface.time = Interface.time - 1
		Trigger.AfterDelay(1, function() timedDelay(func) end)
	else
		func()
	end
end

local setTimedWaveEnd = function(time, func)
	assert(time and time > 0, "Invalid time argument.")
	assert(func, "Invalid func argument.")
	Interface.time = time
	timedDelay(func)
end

WaveManager.sendWave = function(types, spawns, deadFunc, time)
	assert(types, "Invalid types argument.")
	assert(deadFunc, "Invalid deadFunc argument.")
	if (not next(types)) then deadFunc() return {} end
	spawns = spawns or Spawn.getSpawns()
	local nSpawns, actors = assignActors(spawns, types)
	for _, s in ipairs(nSpawns) do
		local aCount = 0
		local enterID = Trigger.OnEnteredFootprint({s.spawn.Location}, function(a)
			if (a.Type ~= s.spawn.Type) then
				aCount = aCount + 1
			end
		end)
		Trigger.OnExitedFootprint({s.spawn.Location}, function(a, exitID)
			aCount = aCount - 1
			if (aCount == 0) then
				Trigger.AfterDelay(Config.spawnDelay, function()
					if (#s.actors > 0) then
						local a = table.remove(s.actors, 1)
						a.Teleport(s.spawn.Location)
						a.IsInWorld = true
						attachIdleTrigger(a, Utils.Random(s.targets))
					else
						Trigger.RemoveFootprintTrigger(enterID)
						Trigger.RemoveFootprintTrigger(exitID)
					end
				end)
			end
		end)
		if (#s.actors > 0) then
			local a = table.remove(s.actors, 1)
			a.Teleport(s.spawn.Location)
			a.IsInWorld = true
			attachIdleTrigger(a, Utils.Random(s.targets))
		end
	end
	Trigger.OnAllKilled(actors, deadFunc)
	if (time) then setTimedWaveEnd(time, function()
			Array.map(nSpawns, function(s)
				s.actors = {}
			end)
			Array.map(actors, function(a)
				if (not a.IsDead) then a.Kill() end
			end)
		end)
	end
	return actors
end
