Target = {}
local Target	= Target

local Set		= assert(Set, "Invalid module.")

Target.actors = {}

Target.isTarget = function(actor)
	return not not Target.actors[actor]
end

Target.makeTarget = function(actor, func)
	assert(actor, "Invalid actor argument.")
	assert(func, "Invalid func argument.")
	assert(actor.HasProperty("HasPassengers"), "Actor is not transport.")
	Target.actors[actor] = assert(not Target.actors[actor], "Actor is already a target")
	Trigger.OnPassengerEntered(actor, func)
end

Target.makeTargets = function(actors, func)
	assert(actors, "Invalid actors argument.")
	assert(func, "Invalid func argument.") 
	for _, actor in pairs(actors) do
		Target.makeTarget(actor, func)
	end
end

Target.removeTarget = function(actor)
	assert(actor, "Invalid actor argument")
	assert(Target.actors[actor], "Actor is not a target.")
	Trigger.Clear(actor, "OnPassengerEntered")
	Target.actors[actor] = nil
end

Target.removeTargets = function(actors)
	assert(actors, "Invalid actors argument")
	for _, actor in pairs(actors) do
		Target.removeTarget(actor)
	end
end

Target.getTargets = function()
	return Set.toArray(Target.actors)
end

Target.disguiseTarget = function(actor, asType)
	assert(Target.actors[actor], "Actor is not a target.")
	assert(asType, "Invalid asType argument.")
	actor.DisguiseAsType(asType, actor.Owner)
end

Target.disguiseTargets = function(actors, asType)
	assert(actors, "Invalid actors argument.")
	assert(asType, "Invalid actors argument.")
	for _, actor in ipairs(actors) do
		Target.disguiseTarget(actor, asType)
	end
end
