Utility = {} 

Utility.printTable = function(t)
	local str = ""
	for i, v in ipairs(t) do
		str = str .. v .. " "
	end
	print(tostring(str))
end

Utility.concat = function(t)
	local str = table.remove(t)
	return Utility.concat(t) .. str
end

Utility.map = function(f)
	return function(t)
		local mt = {}
		for i = 1, #t do
			mt[i] = f(t[i])
		end
		return mt
	end
end

Utility.reverse = function(t)
	local rt = {}
	for i = #t, 1, -1 do
		table.insert(rt, t[i])
	end
	return rt
end

Utility.transpose = function(ts)
	local tts = {}
	for x = 1, #ts do
		local col = {}
		for y = 1, #ts do
			table.insert(col, ts[y][x])
		end
		table.insert(tts, col)
	end
	return tts
end

Utility.zipWith = function(f)
	return function(t1)
		return function(t2)
			local nt = {}
			for i = 1, math.min(#t1, #t2) do
				local ne = f(t1[i])(t2[i])
				table.insert(nt, ne)
			end
			return nt
		end
	end
end

Utility.contains = function(t)
	return function(e)
		for i = 1, #t do
			if (t[i] == e) then
				return true
			end
		end
	end
end

Utility.between = function(x)
	return function(lowerBound)
		return function(upperBound)
			local isBetween = (x >= lowerBound and x <= upperBound)
			return isBetween
		end
	end
end

Utility.max = function(t)
	local max = t[1]
	for i = 2, #t do
		if t[i] > max then
			max = t[i]
		end
	end
	return max
end

Utility.maxBy = function(f)
	return function(t)
		nt = {}
		for i = 1, #t do
			nt[i] = f(t[i])
		end
		Utility.index(nt)(Utility.max(nt))
		return t[i]
	end
end

Utility.index = function(t)
	return function(x)
		for i, v in ipairs(t) do
			if (v == x) then
				return i
			end
		end
		return nil
	end
end

Utility.any = function(f)
	return function(t)
		for i = 1, #t do
			if (f(t[i])) then
				return true
			end
		end
		return false
	end
end

Utility.all = function(f)
	return function(t)
		for i = 1, #t do
			if (not f(t[i])) then
				return false
			end
		end
		return true
	end
end

Utility.filter = function(f)
	return function(t)
		local nt = {}
		for i = 1, #t do
			if (f(t[i])) then
				table.insert(nt, t[i])
			end
		end
		return nt
	end
end

Utility.replicate = function(n)
	return function(e)
		local t = {}
		for i = 1, n do
			table.insert(t, e)
		end
		return t
	end
end

Utility.sCopy = function(t)
	local ct = {}
	for i = 1, #t do
		ct[i] = t[i]
	end
	return ct
end

Utility.dCopy = function(t)
	if (type(t) == "table") then
		local ct = {}
		for i = 1, #t do
			ct[i] = Utility.dCopy(t[i])
		end
		return ct
	end
	return t
end

Utility.printGrid = function(table)
	local str = "\n"
	for y = 1, #table do
		for x = 1, #table do
			if (table[y][x]) then
				str = str .. "0"
			else
				str = str .. "-"
			end
		end
		str = str .. "\n"
	end
	print(str)
end
