TetrisArea = {}

TetrisArea.new = function(width)
	return function(height)
		local tArea = Area.new(width)(height)
		tArea.removeFullRows = function(xPos)
			return function(yPos)
				local destroyed = 0
				for y = 1, height do
					if (Utility.all(function(element) return not not element end)(tArea.grid[y])) then
						tArea.grid[y] = Utility.map(function(block) block.actor.Destroy() return nil end)(tArea.grid[y])
						for i = y, 2, -1 do
							tArea.grid[i] = tArea.grid[i - 1]
							for j = 1, #tArea.grid[i] do
								if (tArea.grid[i][j]) then
									tArea.grid[i][j].render(Player.GetPlayer("Neutral"))(xPos + j - 1)(yPos + i - 1)
								end
							end
						end
						tArea.grid[1] = Utility.replicate(width)(false)
						destroyed = destroyed + 1
					end
				end
				return destroyed
			end
		end
		return tArea
	end
end
