Shape = {}

Shape.new = function(shapeType)
	return function(template)
		local shape = {}
		shape.shape = Utility.map(Utility.map(
			function(element)
				if (element) then
					return Block.new(shapeType)
				end
				return false
			end))(template)
		shape.render = function(xPos)
			return function(yPos)
				for y = 1, #shape.shape do
					for x = 1, #shape.shape do
						shape.shape[y][x].render(Player.GetPlayer("Neutral"))(xPos + x - 1)(yPos + y - 1)
					end
				end
			end
		end
		shape.derender = function()
			shape.shape = Utility.map(Utility.map(
				function(block)
					if (block) then
						block.derender()
					end
					return block
				end))(shape.shape)
		end
		shape.rotateLeft = function()
			shape.shape = Utility.transpose(Utility.map(Utility.reverse)(shape.shape))
		end
		shape.rotateRight = function()
			shape.shape = Utility.map(Utility.reverse)(Utility.transpose(shape.shape))
		end
		return shape
	end
end
