tickCount = 0
count = 10
games = {}

WorldLoaded = function()
	local players = Player.GetPlayers(function(player) return not (player.IsBot or player.IsNonCombatant) end)
	for i = 1, #players do
		local xPos = 1 + (function() if (i % 2 == 0) then return 12 else return 0 end end)()
		local yPos = 1 + (function() if (i > 2) then return 24 else return 0 end end)()
		local game = Game.new(players[i])(xPos)(yPos)
		games[i] = game
	end
	countdown()
end

Tick = function()
	for i = 1, #games do
		if (games[i].playing) then
			games[i].tick(tickCount)
			displayScoreboard()
		end
	end
	tickCount = tickCount + 1
end

countdown = function()
	UserInterface.SetMissionText("Starting in " .. count)
	if (count > 0) then
		count = count - 1
		Trigger.AfterDelay(DateTime.Seconds(1), countdown)
	else
		games = Utility.map(function(game) game.playing = true return game end)(games)
	end
end

displayScoreboard = function()
	local str = ""
	for i = 1, #games do
		str = str .. games[i].player.Name .. " | Level: " .. games[i].level .. " | Score: " .. games[i].score
		if (not games[i].playing) then
			str = str .. " [FAILED]"
		end
		str = str .. "\n"
	end
	UserInterface.SetMissionText(str)
end
