if Map.LobbyOption("difficulty") == "2min" then
	switchEveryMinutes = 2
elseif Map.LobbyOption("difficulty") == "3min" then
	switchEveryMinutes = 3
elseif Map.LobbyOption("difficulty") == "4min" then
	switchEveryMinutes = 4
elseif Map.LobbyOption("difficulty") == "5min" then
	switchEveryMinutes = 5
elseif Map.LobbyOption("difficulty") == "6min" then
	switchEveryMinutes = 6
elseif Map.LobbyOption("difficulty") == "7min" then
	switchEveryMinutes = 7
elseif Map.LobbyOption("difficulty") == "8min" then
	switchEveryMinutes = 8
elseif Map.LobbyOption("difficulty") == "noswitch" then
	switchEveryMinutes = false
end

function round(num, idp)
  local mult = 10^(idp or 0)
  return math.floor(num * mult + 0.5) / mult
end

function isEqual(a,b)

   local function isEqualTable(t1,t2)

      if t1 == t2 then
         return true
      end

      for k,v in pairs(t1) do

         if type(t1[k]) ~= type(t2[k]) then
            return false
         end

         if type(t1[k]) == "table" then
            if not isEqualTable(t1[k], t2[k]) then
               return false
            end
         else
            if t1[k] ~= t2[k] then
               return false
            end
         end
      end

      for k,v in pairs(t2) do

         if type(t2[k]) ~= type(t1[k]) then
            return false
         end

         if type(t2[k]) == "table" then
            if not isEqualTable(t2[k], t1[k]) then
               return false
            end
         else
            if t2[k] ~= t1[k] then
               return false
            end
         end
      end

      return true
   end

   if type(a) ~= type(b) then
      return false
   end

   if type(a) == "table" then
      return isEqualTable(a,b)
   else
      return (a == b)
   end

end

getDistinctTeams = function()
	local allPlayers = Player.GetPlayers(function(Player) 
		return not Player.HasNoRequiredUnits()
	end)

	local allPlayerTeams = {}
	for k,v in ipairs(allPlayers) do
		local currentPlayer = v
    	local playerTeam = {}		

	    for k,v in ipairs(allPlayers) do
			if currentPlayer.IsAlliedWith(v) then
				table.insert(playerTeam, v)
			end
	    end

	    allPlayerTeams[k] = playerTeam
	end

    for key,value in ipairs(allPlayerTeams) do
    	currentPlayerTeam = value

	    for k,v in ipairs(allPlayerTeams) do
		  	if isEqual(currentPlayerTeam, v) and k ~= key then
		  		allPlayerTeams[k] = {}
		  	end	
	    end
	end

	local distinctTeams = {}
    for k,v in ipairs(allPlayerTeams) do
    	if #v > 0 then
    		table.insert(distinctTeams, v)
		end
    end	

   --  for k,v in ipairs(distinctTeams) do
   --  	local TeamNumber = k

	  --   for k,v in ipairs(v) do
			-- Media.DisplayMessage("TeamNumber: " .. TeamNumber .. " Player " .. v.InternalName)
	  --   end
   --  end

   return distinctTeams

end

getPlayerActors = function(Player)
	return Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(Actor) return Actor.Owner == Player end)
end

SwitchTeams = function()
	local function switchTeam(Team)
		local playersWithActors = {}
	    for k,v in ipairs(Team) do
	    	playersWithActors[k] = getPlayerActors(v)
	    end	

	    local switchWithPlayer = {}
	    for k,v in ipairs(Team) do
	    	local to = (k + 1) % #Team

	    	if to == 0 then
	    		to = k + 1
	    	end

	    	switchWithPlayer[k] = Team[to]
	    end	

	    for k,v in ipairs(switchWithPlayer) do
	    	Utils.Do(playersWithActors[k], function(a) a.Owner = v end)
	    end	
	end

	local distinctTeams = getDistinctTeams()

    for k,v in ipairs(distinctTeams) do
    	if #v > 1 then
    		switchTeam(v)
		end
    end	
end

ShareCashAndResources = function()
	local function share(Team)
		local totalCashInTeam = 0
	    for k,v in ipairs(Team) do
	    	totalCashInTeam = totalCashInTeam + v.Cash
	    end			

		local totalResourcesInTeam = 0
	    for k,v in ipairs(Team) do
	    	totalResourcesInTeam = totalResourcesInTeam + v.Resources
	    end			

	    local averageCashInTeam = round(totalCashInTeam / #Team, 0)
	    local averageResourcesInTeam = round(totalResourcesInTeam / #Team, 0)

	    for k,v in ipairs(Team) do
    		v.Cash = averageCashInTeam
    		v.Resources = averageResourcesInTeam
	    end
	end

	local distinctTeams = getDistinctTeams()

    for k,v in ipairs(distinctTeams) do
    	if #v > 1 then
    		share(v)
		end
    end
end

changeLighting = function()
	local change = 0.015

	if shouldDesaturate then
		if Lighting.Red > 0.02 then
			Lighting.Red = Lighting.Red - change
			Lighting.Green = Lighting.Green - change
			Lighting.Blue = Lighting.Blue - change
		end
	end

	if shouldSaturate then
		if Lighting.Red < 1 then
			Lighting.Red = Lighting.Red + change
			Lighting.Green = Lighting.Green + change
			Lighting.Blue = Lighting.Blue + change
		end
	end
end

Tick = function()
	changeLighting()

	if (DateTime.GameTime % DateTime.Seconds(1) == 0) then
		ShareCashAndResources()
	end

	if switchEveryMinutes ~= false then
		if (DateTime.GameTime % DateTime.Seconds(switchEveryMinutes * 60) == 0) then
			Media.PlaySound("siren.wav")

			Trigger.AfterDelay(DateTime.Seconds(3), function()
				shouldSaturate = false
				shouldDesaturate = true
			end)

			Trigger.AfterDelay(DateTime.Seconds(7), function()
				SwitchTeams()

				shouldDesaturate = false
				shouldSaturate = true		
			end)
		end
	end
end