TrackedPairs = {}
TrackedProduction = {}
ConditionRecord = {}
Upgrade_Producers = {}
ReinforcementLocations={}
ReinforcementSquads = {
	{"light_inf"},
	{"quad","quad","sardaukar","sardaukar"},
	{"saboteur","saboteur","guild_agent"}
	}
undiscoveredStarport={false, false}
OrdosMentat={"It is a fact - any faction may use this Rogue Starport to call in some combat vehicles.\nDoubtlessly they will be very expensive, but it might be worth it.",
"It is a decision - the Rogues are under attack and ask for our assistance.",
"It is a fact -  I am your best advisor in this situation.\nIt is a neccessity - Strenghten our income and base Infrastructure right away.\nIt is an inconvenience - We are not allowed to bring war-machines here.",
"It is a decision - Carryalls multiply our economy, Thopters multiply our surveillance abilities.",
"It is a chance - If we manage to Infiltrate the Harkonnen with Guild Agents and Saboteurs, we will likely take away the victory.",
"I have nothing to say",
"It is an option - upgrading the outpost will grant us air-reinforcements.",
"It is a conclusion - We are victorious and prooved that we were proceeding correctly."}
HarkonnenMentat={"It's not realy cheating, Baron. With just a bit of extra cash and a bribe on top of that we can buy some tanks at this Rogue Starport.\nHowever, the nasty Rogues also surely deliver vehicles to the Ordos..",
"Baron, baron! The Rogues are under attack by the Ordos right now -- shall we help them?",
"Here I am again! Your Humble Advisor..\nDear, dear Baron - A war of Assassins! How exquisite! A spectacular Infantry only battle awaits us!!\nFirst however.. we have to take care of boring building construction and OF COURSE spice - mooore SPICE!",
"Take us to the skies, Master! Elegant and quick with the Light Thopter or lumbering and spice-heavy with the Carryall.",
"We should hide our Assassins in the rocks, they are stealthy there - they are my little brothers, heh.",
"Sardaukar... Bulky, coarse and brutal. Good enough Baron, but not as disingenuous as me!",
"Baron - use our air support! Upgrade the outpost and we will get air reinforcements.",
"Haha, see those Ordos weaklings. We were right after all!\nWe are victorious, great Baron!"}


WorldLoaded = function()
mp0=Player.GetPlayer("Multi0")
mp1=Player.GetPlayer("Multi1")
Creeps=Player.GetPlayer("Creeps")
Neutral=Player.GetPlayer("Neutral")
hate1=Player.GetPlayer("HatesMulti1")
hate0=Player.GetPlayer("HatesMulti0")
laststance=Neutral

Actor89.RallyPoint=CPos.New(36,64) --fix multi1 palace waypoint 
RogueStarport=Actor33

--needed to disable normal silos after silo upgrade
if mp0 then Actor.Create("silo_negative_prereqisite_dummy", true, { Owner = mp0, Location = CPos.New(0,0) }) end
if mp1 then Actor.Create("silo_negative_prereqisite_dummy", true, { Owner = mp1, Location = CPos.New(0,0) }) end

--Mentat introduction
Trigger.AfterDelay(DateTime.Seconds(4),function()
	sayTo(mp0,HarkonnenMentat[3])
	sayTo(mp1,OrdosMentat[3])
 end)
--MentatVictoryMessages
 Trigger.OnPlayerLost(mp1, function(p) sayTo(mp0, HarkonnenMentat[8]) end)
 Trigger.OnPlayerLost(mp0, function(p) sayTo(mp1, OrdosMentat[8])     end)
 
 
--needed for Rogue Starport
Actor92.Owner=Neutral
Actor93.Owner=Neutral
Trigger.AfterDelay(DateTime.Seconds(1),--to prevent "explored map" discovering the starport
	function()
		Trigger.OnDiscovered(RogueStarport, 
			function(unit,player)
				if player==mp0 and HarkonnenMentat[1]~=nil
				then 
					Actor92.Owner=mp0
					sp0 = Actor92
					sayTo(mp0,HarkonnenMentat[1])
					HarkonnenMentat[1]=nil
				elseif player==mp1 and OrdosMentat[1]~=nil
				then 
					Actor93.Owner=mp1
					sp1 = Actor93 
					sayTo(mp1,OrdosMentat[1])
					OrdosMentat[1]=nil
				end
			end
		)
	end
)

--defend starport if it is damaged and ask for help
Trigger.OnDamaged(RogueStarport,
	function(attacked, attacker)
		local stance = false
		if attacker.Owner==mp1 
		then 
			stance=hate1
			laststance=hate1
			sayTo(mp0,HarkonnenMentat[2])
			HarkonnenMentat[2]=nil
		elseif attacker.Owner==mp0
		then 
			stance=hate0
			laststance=hate0
			sayTo(mp1,OrdosMentat[2])
			OrdosMentat[2]=nil		
		end 
		if stance
		then
			if not RogueStarport.IsDead then RogueStarport.StartBuildingRepairs(Neutral) end
			if not Actor21.IsDead then Actor21.Owner=stance end
			if not Actor23.IsDead then Actor23.Owner=stance end
			if not Actor27.IsDead then Actor27.Owner=stance end
			if not Actor32.IsDead then Actor32.Owner=stance end
		end
	end
)
Trigger.OnKilled(RogueStarport, 
	function(killed,killer)
		if sp0 then sp0.Destroy() end
		if sp1 then sp1.Destroy() end
	end
)
end

Tick = function()
	--check wether the starport defenders can be set back to Neutral (full health starport?)
	if not RogueStarport.IsDead and laststance~=Neutral and RogueStarport.Health >= (RogueStarport.MaxHealth-300)
	then
		laststance=Neutral
		Trigger.AfterDelay(DateTime.Seconds(3),
			function()
				if not Actor21.IsDead then Actor21.Owner=Neutral end
				if not Actor23.IsDead then Actor23.Owner=Neutral end
				if not Actor27.IsDead then Actor27.Owner=Neutral end
				if not Actor32.IsDead then Actor32.Owner=Neutral end
			end
		)
		if not reloading
		then
			Trigger.AfterDelay(DateTime.Seconds(20),
				function()
					--"reload" the mentat messages
					OrdosMentat[2]="Sire, the Rogues are under attack and ask for our assistance!"
					HarkonnenMentat[2]="Mylord, the Rogues are under attack by the Ordos - shall we help them?"
					reloading=false
				end
			)
		reloading=true	
		end
	end	
	for _,act in pairs(Map.ActorsInWorld) 
	do
		--...handle advanced_silo upgrade and guild agent upgrade icons on the outpost
		if act.Type=="construction_yard" or act.Type=="outpost" 
		then if noDuplicate(act, Upgrade_Producers)
		then
			table.insert(Upgrade_Producers,act)
			--for each new producer set a trigger
			Trigger.OnProduction(act, 
				function(producer, produced)		
					if produced.Type=="upgrade.silo"
					then
						replace_silos(act.Owner)
					end
					for _,entry in pairs(Upgrade_Producers)
					do
						if entry.IsInWorld and entry.Type=='outpost' and  entry.Owner==producer.Owner
						then grantProductionIcon(entry,produced) end		
					end
				end
			) end
		--...handle Airdop Powers check
		--required for airdrop powers
		elseif (act.Type=="waypoint_dummy_a" or act.Type=="waypoint_dummy_h" or act.Type=="waypoint_dummy_o") and noDuplicate(act, ReinforcementLocations)
		then
			dropAirReinforcements(act.Location,act)
			table.insert(ReinforcementLocations, act)
		--...handle saboteur entering a harvester which is getting picked up by a carryall before the Demolition charge explodes (Both will die)
		elseif (act.Type == "harvester" or act.Type == "advanced_harvester_h"  or act.Type == "advanced_harvester_a" or act.Type == "advanced_harvester_o" or act.Type == "harvester.starport") and TrackedPairs[tostring(act)]==nil
		then
			TrackedPairs[tostring(act)]='NoCarryall'
			Trigger.OnKilled(act, 
				function(harvester,killer)
					local MaybeCarryall = TrackedPairs[tostring(harvester)]
					if MaybeCarryall~='NoCarryall' and MaybeCarryall~=nil
					then
						if MaybeCarryall.HasProperty('Kill') 
						then 
							MaybeCarryall.Kill()
							Media.PlaySound('EXPLLG2.WAV')
						end
					else
					end
				end
			)
			Trigger.OnRemovedFromWorld(act, 
				function(harv)
					local carryalls = Map.ActorsInCircle(harv.CenterPosition, WDist.New(1), 
						function(carry) 
							if carry.Type=="carryall" then return carry else return nil end 
						end
					)
					if carryalls[1]~=nil 
					then 
						TrackedPairs[tostring(harv)]=carryalls[1]
					end
				end 
			)
			Trigger.OnAddedToWorld(act,function(harv)
					local carryalls = Map.ActorsInCircle(harv.CenterPosition, WDist.New(1), 
						function(carry) 
							if carry.Type=="carryall" then return carry else return nil end 
						end
					)
					if carryalls[1]~=nil
					then 
						TrackedPairs[tostring(harv)]='NoCarryall'
					end
				end 
			)
		--...handle guild agent unit-built icons on unit constructing buildings
		elseif (act.Type=="barracks" or act.Type=="light_factory" or act.Type=="heavy_factory" or act.Type=="high_tech_factory") and TrackedProduction[tostring(act)]==nil
		then
			TrackedProduction[tostring(act)]= true
			Trigger.OnProduction(act, 
				function(prod,prodded) 
					grantProductionIcon(prod,prodded) 
				end
			)
			--mentat messages weaved in
			if act.Type=="barracks" then 
				Trigger.OnProduction(act, 
					function(prod,prodded) 
						if prodded.Type=="assassin" 
						then 
							sayTo(mp0,HarkonnenMentat[5]) 
							HarkonnenMentat[5]=nil
						elseif prodded.Type=="sardaukar"
						then
							sayTo(mp0,HarkonnenMentat[6]) 
							HarkonnenMentat[6]=nil
						elseif prodded.Type=="saboteur"
						then
							sayTo(mp1,OrdosMentat[5]) 
							OrdosMentat[5]=nil
						end
					end
				)
			end
		elseif act.Type=="palace" and TrackedProduction[tostring(act)]==nil
		then
			TrackedProduction[tostring(act)]= true
			Trigger.OnProduction(act, 
				function(prod,prodded) 
					if prodded.Type=="sardaukar"
					then
						sayTo(mp0,HarkonnenMentat[6]) 
						HarkonnenMentat[6]=nil
					elseif prodded.Type=="guild_agent"
					then
						sayTo(mp1,OrdosMentat[5]) 
						OrdosMentat[5]=nil
					end
				end
			)
		elseif act.Type=="starport_dummy" and TrackedProduction[tostring(act)]==nil
		then--not working yet
			TrackedProduction[tostring(act)]= true
			Trigger.OnProduction(act, 
				function(prod,prodded) 
					grantProductionIcon(act,prodded) 
				end
			)
		end
	end
	--more mentat messages
	if mp0.HasPrerequisites({"outpost"}) 
	then
		sayTo(mp0,HarkonnenMentat[7]) 
		HarkonnenMentat[7]=nil
	end
	if mp0.HasPrerequisites({"high_tech_factory"}) 
	then
		sayTo(mp0,HarkonnenMentat[4]) 
		HarkonnenMentat[4]=nil
	end
	if mp1.HasPrerequisites({"outpost"}) 
	then
		sayTo(mp1,OrdosMentat[7]) 
		OrdosMentat[7]=nil
	end
	if mp1.HasPrerequisites({"high_tech_factory"}) 
	then
		sayTo(mp1,OrdosMentat[4]) 
		OrdosMentat[4]=nil
	end
end

grantProductionIcon = function(producer,unit)
	if ConditionRecord[tostring(producer)] 
	then
		producer.RevokeCondition(ConditionRecord[tostring(producer)])
		ConditionRecord[tostring(producer)]=nil
	end

	T=unit.Type
	if producer.Type == 'barracks' 
	then if T=='light_inf' or T=='trooper' or T=='engineer' or T=='thumper' or T=='assassin' or T=='grenadier' or T=='sardaukar' or T=='saboteur' or T=='propaganda_corps' or T=='guild_agent'
	then ConditionRecord[tostring(producer)] = producer.GrantCondition(tostring(unit.Type)..'_ICO') end
	
	elseif producer.Type == 'high_tech_factory'
	then if T=='carryall'
	then ConditionRecord[tostring(producer)] =producer.GrantCondition(tostring(unit.Type)..'_ICO') 
	elseif  T=='light_thopter.htf' 
	then ConditionRecord[tostring(producer)] =producer.GrantCondition(string.sub(tostring(unit.Type),1,-5)..'_ICO') end
	
	elseif producer.Type == 'starport_dummy'
	then if T=='carryall.starport' or T=='harvester.starport' or T=='combat_tank_m.starport' or T=='missile_tank.starport' or T=='siege_tank.starport' or T=='trike.starport' or T=='quad.starport' or T=='mobile_crane.starport'
	then ConditionRecord[tostring(producer)] =producer.GrantCondition(string.sub(tostring(unit.Type),1,-10)..'_ICO') end
	
	--[[ doesnt work because OnProduction doesn't trigger on structures
	elseif producer.Type == 'crane' or producer.Type =='construction_yard'
	then Media.Debug('after elseif') if T=='concretea' or T=='wind_trap' or T=='barracks' or T=='refinery' or T=='light_factory' or T=='heavy_factory' or T=='outpost' or T=='repair_pad' or T=='silo' or T=='advanced_silo' 
	then 
		Media.Debug('in cony')
		ConditionRecord[tostring(producer)] =producer.GrantCondition(tostring(unit.Type)..'_ICO') end
	
	elseif producer.Type == 'palace' or producer.Type =='construction_yard'
	then if T=='medium_gun_turret' or T=='large_gun_turret' or T=='wall'
	then ConditionRecord[tostring(producer)] =producer.GrantCondition(tostring(unit.Type)..'_ICO') end
	
	elseif producer.Type =='construction_yard'
	then if T=='starport' or T=='tech_lab' or T=='palace' or T=='high_tech_factory' 
	then ConditionRecord[tostring(producer)] =producer.GrantCondition(tostring(unit.Type)..'_ICO') end
	--]]
	elseif producer.Type =='outpost'
	then if T=='upgrade.barracks' or T=='upgrade.light' or T=='upgrade.heavy' or T=='upgrade.hightech' or T=='upgrade.conyard' or T=='upgrade.silo' or T=='upgrade.outpost'
	then 
		ConditionRecord[tostring(producer)] =producer.GrantCondition(string.sub(tostring(unit.Type),9)..'_ICO') end
	end
end

function replace_silos(player)
	local res = player.Resources
	for _, actor in pairs(player.GetActorsByType("silo")) do
		local loc=actor.Location
		actor.Destroy()
		Actor.Create("advanced_silo", true, { Owner = player, Location = loc })
	end
	--give the game time to contemplate consequences of rapid player.ResourceCapacity changes, then correct.
	Trigger.AfterDelay(DateTime.Seconds(0.1),
					function() 
						player.Resources = res
					end
				)
	--all future silos shall be advancedd silos
	player.GetActorsByType("silo_negative_prereqisite_dummy")[1].Destroy()
end

function noDuplicate(actor, actorlist)
  for _, value in pairs(actorlist) do
    if value == actor then
      return false
    end
  end
  return true
end

function sayTo(player, message)
	if message
	then
		if player==mp0 and not mp1.IsLocalPlayer 
		then 
			Media.DisplayMessage(message,"Mentat",HSLColor.Red)
		elseif player==mp1 and not mp0.IsLocalPlayer 
		then 
			Media.DisplayMessage(message,"Mentat",HSLColor.LawnGreen)
		end
	end
end

function dropAirReinforcements(location,dummy)
	local squad
	local transports = {"carryall.reinforce","controllable_carryall.reinforce","controllable_carryall.reinforce"}
	if dummy.Type=="waypoint_dummy_a" then squad=1
	elseif dummy.Type=="waypoint_dummy_h" then squad=2
	elseif dummy.Type=="waypoint_dummy_o" then squad=3 
	end
	--Carryall reinforcements
	local base = dummy.Owner.GetActorsByType("outpost")[1]
	local edge = getMapEdge(base.Location, location)
	local path = {edge,location}
	local units = Reinforcements.ReinforceWithTransport(dummy.Owner, transports[squad], ReinforcementSquads[squad], path, {path[2], path[1]})
	local carryall = units[1]
	Trigger.OnPassengerExited(carryall,function(carry, pass) if not  carry.HasPassengers then carry.Move(path[1]) carry.Destroy() end end)
end

function getMapEdge(posB,posA)
	--map dependent hack!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	boundary = {X=70, Y=70}	
	--catch zero devision errors
	if posB.X-posA.X == 0 
	then 
		if posB.Y<posA.Y then return CPos.New(posA.X,0)
		else return CPos.New(posA.X,boundary.Y)
		end
	elseif posB.Y-posA.Y == 0 
	then 
		if posB.X<posA.X then return CPos.New(0,posA.Y)
		else return CPos.New(boundary.X,posA.Y)
		end
	end
	
	--compute all boundary intersections
	local slope = (posB.Y-posA.Y)/(posB.X-posA.X)
	local topX   = posA.X - posA.Y/slope
	local bottomX= posA.X +((boundary.Y-posA.Y)/slope)
	local rightY = posA.Y +((boundary.X-posA.X)*slope)
	local leftY =  posA.Y - posA.X*slope
	
	local top = CPos.New(math.floor(topX),0)
	local bottom = CPos.New(math.floor(bottomX),boundary.Y)
	local right = CPos.New(boundary.X, math.floor(rightY))
	local left = CPos.New(0, math.floor(leftY))	
	
	--decide which of them is reasonable
	local positiveDelX = 0 < (posB.X-posA.X)
	local positiveSlope= 0 < slope 
	
	if positiveDelX and positiveSlope
	then 
		if bottom.X<=boundary.X then return bottom
		else return right
		end
	elseif positiveDelX and not positiveSlope
	then
		if top.X<=boundary.X then return top
		else return right
		end
	elseif not positiveDelX and positiveSlope
	then
		if top.X>=0 then return top
		else return left
		end
	elseif not positiveDelX and not positiveSlope
	then
		if bottom.X>=0 then return bottom
		else return left
		end
	end
	Media.DisplayMessage(" in Function getMapEdge, no Edge matched, returning default. (0,0)","Error")
	return CPos.New(0,0)
end