ReinforcementSquads = {
	{"vet_light_inf","vet_light_inf","vet_light_inf","vet_trooper","vet_trooper"},
	{"quad","quad_hmg","sardaukar", "sardaukar"},
	{"trooper","trooper","trooper","trooper", "trooper"},
	}
ReinforcementLocations={}
HarvestAmmout=12000
ResourceVictory=false
Annihillated = { ordos=true,atreides=true,mercenaries=true}
MissionText={"Commander, our advance in this funeral plain is facing growing ORDOS resistance. Also, the allegiance of the local MERCENARIES is unsure yet.\nAIR REINFORCEMENTS pour in to strengthen our enemies, but we can also call in reinforcements, once the OUTPOST UPGRADE is complete.\nEither DESTROY all opposing forces OR HARVEST ".. tostring(HarvestAmmout) .." solaris worth of spice to complete this mission.\n--Good luck!",
"Commander, the ATREIDES are invading our territory!\nDESTROY all attackers threatening this espionage outpost of ours or at least harvest a gain of "..tostring(HarvestAmmout).." solaris for our house.\nAIR REINFORCEMENTS are available after an OUTPOST UPGRADE.\nOur intelligence sources indicate the atreides may have bribed the MERCENARIES in this area. Beware.\n--Transmission End",
"Mercenary Captain, I have received the ATREIDES answer to our modest price for military aid against the ORDOS - Those stuck-ups declined!\nI want you to either HARVEST those "..tostring(HarvestAmmout).." solaris from this damned place anyway or to CAST OUT BOTH of those houses from here!\nYou have my permission to use AIR REINFORCEMENTS after an OUTPOST UPGRADE.\nNow go and make money!!"}
Warning={	"Atreides  have over 9000 resources!!\n" ,
			"The Ordos have over 9000 resources!!\n" ,
			"The Mercs have over 9000 resources!!\n" }


WorldLoaded = function()
	--players
	atreides = Player.GetPlayer("Atreides")
	ordos    = Player.GetPlayer("Ordos")
	mercenaries = Player.GetPlayer("Mercenaries")
	if atreides 
	then 
		Annihillated.atreides=false
		--set starting cash (rules:	PlayerResources: DefaultCashLocked: True currently bugged -> prevents players from joining)
		atreides.Cash =0
	end
	if ordos 
	then 
		Annihillated.ordos=false 
		ordos.Cash=0
	end
	if mercenaries 
	then 
		Annihillated.mercenaries=false 
		mercenaries.Cash=0
	end
	
	--DEBUG
	--Actor.Create("mcv", true, { Owner = atreides, Location = CPos.New(67,31) })
	
	--smugglers setup
	smugglers = Player.GetPlayer("Smugglers")
	Actor.Create("advanced_harvester_o", true, { Owner = smugglers, Location = CPos.New(80,56) })
	Actor.Create("advanced_harvester_o", true, { Owner = smugglers, Location = CPos.New(46,5) })
	Actor.Create("advanced_harvester_o", true, { Owner = smugglers, Location = CPos.New(9,62) })
	Trigger.AfterDelay(DateTime.Seconds(0.1),function()
		for _,act in pairs(smugglers.GetActors())
		do 
			if act.Type=="carryall.reinforce" then act.Kill() end
		end
	end)

	--reinforcements setup
	ReinforcementBase={Actor210.Location, Actor212.Location,Actor211.Location}

	--silo upgrade fix, mission text
	if mercenaries 
	then
		--Objectives and Mission
		ObjectiveM = mercenaries.AddPrimaryObjective("Harvest " .. tostring(HarvestAmmout) .. " Solaris worth of Spice or destroy all opposition.")
		Trigger.OnPlayerWon(mercenaries, 
			function(p)
				if Annihillated.ordos and Annihillated.atreides 
				then
					Media.DisplayMessage("The Mercenaries have annihilated all opposition!","Mission Success",HSLColor.Gold) 
				else
					Media.DisplayMessage("The Mercenaries have hoarded 12.000 solaris of spice!","Mission Success",HSLColor.Gold)
				end
			end)
		Trigger.OnPlayerLost(mercenaries, function(p) if not ResourceVictory then annihillate(p) end end)
		if mercenaries.IsLocalPlayer
		then 
			Media.DisplayMessage(MissionText[3],"Your Mission",HSLColor.Gold)
		end
		--Silo
		Trigger.OnProduction(Actor142, 
			function(producer, produced)
				if produced.Type=="upgrade.silo"
				then
					replace_silos(mercenaries)
				end 
			end
		)
	end
	if ordos
	then
		--Objectives and Mission
		ObjectiveO = ordos.AddPrimaryObjective("Harvest " .. tostring(HarvestAmmout) .. " Solaris worth of Spice or destroy all opposition.")
		Trigger.OnPlayerWon(ordos, 
			function(p)
				if Annihillated.mercenaries and Annihillated.atreides 
				then
					Media.DisplayMessage("The Ordos have annihilated all opposition!","Mission Success",HSLColor.LawnGreen) 
				else
					Media.DisplayMessage("The Ordos have hoarded 12.000 solaris of spice!","Mission Success",HSLColor.LawnGreen)
				end
			end)
		Trigger.OnPlayerLost(ordos, function(p) if not ResourceVictory then annihillate(p) end end)
		if ordos.IsLocalPlayer 
		then
			Media.DisplayMessage(MissionText[2],"Your Mission",HSLColor.LawnGreen) 
		end
		--Silo
		Trigger.OnProduction(Actor155, 
			function(producer, produced)
				if produced.Type=="upgrade.silo"
				then
					replace_silos(ordos)
				end 
			end
		)
	end
	if atreides
	then
		--Objectives and Mission
		ObjectiveA = atreides.AddPrimaryObjective("Harvest " .. tostring(HarvestAmmout) .. " Solaris worth of Spice or destroy all opposition.")
		Trigger.OnPlayerWon(atreides, 
			function(p)
				if Annihillated.ordos and Annihillated.mercenaries 
				then
					Media.DisplayMessage("The Atreides have annihilated all opposition!","Mission Success",HSLColor.Blue) 
				else
					Media.DisplayMessage("The Atreides have hoarded 12.000 solaris of spice!","Mission Success",HSLColor.Blue)
				end
			end)
		Trigger.OnPlayerLost(atreides, function(p) if not ResourceVictory then annihillate(p) end end)
		if atreides.IsLocalPlayer 
		then 
			Media.DisplayMessage(MissionText[1],"Your Mission",HSLColor.Blue) 
		end
		--Silo
		Trigger.OnProduction(Actor181, 
			function(producer, produced)
				if produced.Type=="upgrade.silo"
				then
					replace_silos(atreides)
				end 
			end
		)
	end	
end
			
Tick = function()
	--needed for airdrop powers
	for _ , act in pairs(Map.ActorsInWorld) do
		if (act.Type=="waypoint_dummy_a" or act.Type=="waypoint_dummy_h" or act.Type=="waypoint_dummy_o") and noDuplicate(act, ReinforcementLocations)
		then
			dropAirReinforcements(act.Location,act)
			table.insert(ReinforcementLocations, act)
		end
	end
 
	--resource victory check
	if atreides and atreides.Cash+atreides.Resources >= HarvestAmmout and not atreides.HasNoRequiredUnits()
	then 
		ResourceVictory=true
		atreides.MarkCompletedObjective(ObjectiveA)
		if ordos then ordos.MarkFailedObjective(ObjectiveO) end
		if mercenaries then mercenaries.MarkFailedObjective(ObjectiveM) end
	end
	if mercenaries and mercenaries.Cash+mercenaries.Resources >= HarvestAmmout and not mercenaries.HasNoRequiredUnits()
	then 
		ResourceVictory=true
		if atreides then atreides.MarkFailedObjective(ObjectiveA) end
		if ordos then ordos.MarkFailedObjective(ObjectiveO) end 
		mercenaries.MarkCompletedObjective(ObjectiveM)
	end
	if ordos and ordos.Cash+ordos.Resources >= HarvestAmmout and not ordos.HasNoRequiredUnits()
	then 
		ResourceVictory=true
		if atreides then atreides.MarkFailedObjective(ObjectiveA) end 
		ordos.MarkCompletedObjective(ObjectiveO)
		if mercenaries then mercenaries.MarkFailedObjective(ObjectiveM) end
	end

	--custom short game defeat check
	if atreides and atreides.HasNoRequiredUnits() then atreides.MarkFailedObjective(ObjectiveA) end
	if mercenaries and mercenaries.HasNoRequiredUnits() then mercenaries.MarkFailedObjective(ObjectiveM) end
	if ordos and ordos.HasNoRequiredUnits() then ordos.MarkFailedObjective(ObjectiveO) end
	
	--spice-meter and victory warnings:
	local warning = ""
	local resourcetext = ""
	local pcolor = HSLColor.Gray
	if not Annihillated.atreides and not atreides.IsLocalPlayer and atreides.Cash+atreides.Resources>9000 then warning = warning..Warning[1] end
	if not Annihillated.ordos and not ordos.IsLocalPlayer and ordos.Cash+ordos.Resources>9000 then warning = warning..Warning[2] end
	if not Annihillated.mercenaries and not mercenaries.IsLocalPlayer and mercenaries.Cash+mercenaries.Resources>9000 then warning = warning..Warning[3] end
	
	if not Annihillated.atreides and atreides.IsLocalPlayer 
	then
		resourcetext = "     Stored resources: " ..tostring(atreides.Cash+atreides.Resources) .. " / " .. HarvestAmmout.."     \n"
		pcolor = atreides.Color
	elseif not Annihillated.ordos and ordos.IsLocalPlayer
	then
		resourcetext = "     Stored resources: " ..tostring(ordos.Cash+ordos.Resources).. " / " .. HarvestAmmout.."     \n"
		pcolor = ordos.Color
	elseif not Annihillated.mercenaries and mercenaries.IsLocalPlayer
	then
		resourcetext = "     Stored resources: " .. tostring(mercenaries.Cash+mercenaries.Resources) .. " / " .. HarvestAmmout.."     \n"
		pcolor = mercenaries.Color
	end
	UserInterface.SetMissionText(resourcetext..warning, pcolor)
end

function annihillate(player)
	if player == atreides then Annihillated.atreides=true
	elseif player == mercenaries then Annihillated.mercenaries=true
	elseif player == ordos then Annihillated.ordos=true end

	for _,act in pairs(player.GetActors())
	do 
		if act.HasProperty("Kill") then act.Kill() end
	end
	
	--annihilation victory check
	if Annihillated.atreides and Annihillated.ordos then mercenaries.MarkCompletedObjective(ObjectiveM) end
	if Annihillated.atreides and Annihillated.mercenaries then ordos.MarkCompletedObjective(ObjectiveO) end
	if Annihillated.mercenaries and Annihillated.ordos then atreides.MarkCompletedObjective(ObjectiveA) end
end

function noDuplicate(actor, actorlist)
  for _, value in pairs(actorlist) do
    if value == actor then
      return false
    end
  end
  return true
end

function dropAirReinforcements(location,dummy)
	local squad
	if dummy.Type=="waypoint_dummy_a" then squad=1
	elseif dummy.Type=="waypoint_dummy_h" then squad=2
	elseif dummy.Type=="waypoint_dummy_o" then squad=3
	end
	--Carryall reinforcements
	local path = {ReinforcementBase[squad],location}
	local units = Reinforcements.ReinforceWithTransport(dummy.Owner, "carryall.reinforce", ReinforcementSquads[squad], path, {path[2], path[1]})
end

-- function dropAirReinforcements(location,owner)
	-- local squad
	-- if owner==atreides then squad=1 end
	-- if owner==ordos then squad=3 end
	-- if owner==mercenaries then squad=2 end
	-- --Carryall reinforcements
	-- local path = {ReinforcementBase[squad],location}
	-- local units = Reinforcements.ReinforceWithTransport(owner, "carryall.reinforce", ReinforcementSquads[squad], path, {path[2], path[1]})
-- end

function replace_silos(player)
	local actors = player.GetActors()
	local res = player.Resources
	for _, actor in pairs(actors) do
		if actor.Type == "silo" then
			local loc=actor.Location
			actor.Destroy()
			Actor.Create("advanced_silo", true, { Owner = player, Location = loc })
		end
	end
	--give the game time to contemplate consequences of rapid player.ResourceCapacity changes, then correct.
	Trigger.AfterDelay(DateTime.Seconds(0.1),
					function() 
						player.Resources = res
					end
				)
end