-- timer constants in seconds
antHuntTimer = 400
ant1Timer = 200
ant2Timer = 150
ant3Timer = 100

Nests = 
{
	{Enabled = true, Location = waypoint26.Location, Path = waypoint27.Location},
	{Enabled = true, Location = waypoint28.Location, Path = waypoint29.Location},
	{Enabled = true, Location = waypoint30.Location, Path = waypoint31.Location},
	{Enabled = true, Location = waypoint32.Location, Path = waypoint33.Location},
	{Enabled = true, Location = waypoint34.Location, Path = waypoint35.Location}
}

AntScouts = 
{
	{Type = "ant1", AIPlayer = "Ants1", Delay = ant1Timer},
	{Type = "ant2", AIPlayer = "Ants2", Delay = ant2Timer},
	{Type = "ant3", AIPlayer = "Ants3", Delay = ant3Timer}
}

CreateAnt = function(Nest, Type, AIPlayer, Delay)
	if not Nest.Enabled then
		return
	end
	Reinforcements.Reinforce(Player.GetPlayer(AIPlayer), {Type}, {Nest.Location, Nest.Path}, 25)
	Trigger.AfterDelay(DateTime.Seconds(Delay), function()
		CreateAnt(Nest, Type, AIPlayer, Delay)
	end)
end

AntHunt = function()
	AllAnts = Ants1.GetActorsByType("ant1")
	Utils.Do(AllAnts, function(unit)
		unit.Hunt()
	end)
	AllAnts = Ants2.GetActorsByType("ant2")
	Utils.Do(AllAnts, function(unit)
		unit.Hunt()
	end)
	AllAnts = Ants3.GetActorsByType("ant3")
	Utils.Do(AllAnts, function(unit)
		unit.Hunt()
	end)
	Trigger.AfterDelay(DateTime.Seconds(antHuntTimer), function()
		AntHunt()
	end)
end

WorldLoaded = function()
	Ants1 = Player.GetPlayer("Ants1")
	Ants2 = Player.GetPlayer("Ants2")
	Ants3 = Player.GetPlayer("Ants3")
	
	Utils.Do(Nests, function(Nest)
		-- activate ant timers
		Utils.Do(AntScouts, function(AntScout)
			Trigger.AfterDelay(DateTime.Seconds(AntScout.Delay), function()
				CreateAnt(Nest, AntScout.Type, AntScout.AIPlayer, AntScout.Delay)
			end)
		end)
		-- disable nest on enter
		local area = {Nest.Location + CVec.New(0, 1),
				Nest.Location + CVec.New(1, 0),
				Nest.Location + CVec.New(1, 1)}
		Trigger.OnEnteredFootprint(area, function(a, id)
			if a.Owner ~= Ants1 and a.Owner ~= Ants2 and a.Owner ~= Ants3 then
				Trigger.RemoveFootprintTrigger(id)
				Nest.Enabled = false
				local flare = Actor.Create("flare", true, { Owner = a.Owner, Location = Nest.Location })
			end
		end)
	end)
	
	-- all ants will hunt after a specific time
	Trigger.AfterDelay(DateTime.Seconds(antHuntTimer), function()
		AntHunt()
	end)
end