ThopterDiscovered=false
TroopCrawlerDiscovered=false
UnspottedUnits={}
Upgrade_Producers= {}
ReinforcementLocations={}
ReinforcementSquads = {
	{"light_inf","light_inf","light_inf","trooper","trooper"},
	{"quad","trike","light_inf", "light_inf"}
	}
AtreidesBaseAdvice={"Sovereign, we have to establish a BASE here first. Deploy the LEIGHTWEIGHT MCV, we can pack it back up later.",
"Sovereign, we should recruit some MORE TROOPS, our savings allow it.",
"Your Highness, to unlock UPGRADES for advanced troops build an OUTPOST.",
"Sire, if we UPGRADE the OUTPOST now we can get reinforcements later.",
"We are well established, Sire. We should prepare to move out with the leightweight MCV and TAKE NEW TERRITORY.",
"Your Highness, I propose we  build silos and upgrade them. It pays off in the long term.",
"Our base is now fully developed. We should order an MCV to gain access to all our technology."}
AtreidesMapAdvice={"Sire, our Fremen friends are somewhere in the North. CAPTURE one of their cliff SIETCHes to grant us powerful Fremen troops.",
"Sire, to the East SMUGGLER carryalls have been sighted. They might have a BASE there.",
"Sire, before us are the remnants of the former Ordos city. CAPTURE as much TECHNOLOGY and PRODUCTION as we can get.",
"Sire! The Harkonnen base! Be careful, it is well fortified!",
"Your Highness, those are Harkonnen ORNITHOPTERS. Unarmed, but we should shoot them down quickly.",
"Sire, those are Harkonnen troop transports. Beware, they might carry a squad of sardaukar!"}
HarkonnenBaseAdvice={"Sire, this cheap leased base doesn't have any building construction. Fortunately we can build defenses with the PALACE and purchase upgrades from the OUTPOST.",
"Also I, as your humble Advisor, propose we use our STARPORT to call in high tech troops the nasty Atreides can't deal with.\nWe should also scout the area wih our two LIGHT THOPTERS.",
"Your Highness! Our funds are dwindling - please order more HARVESTERS.",
"Baron, unfortunately it doesnt seem the Atreides are quickly defeated - it would be wise to ORDER AN MCV and extend our military production."}
HarkonnenMapAdvice={"Ah, the Smugglers, our friends! We could SEND ENGINEERS to take over their spice production, Sire.",
"Fremen Scum! Their SKYHUNTER INFANTRY can shoot down your Ornithopters, Milord. We might want to destroy all their cave Sietches.",
"There lie the remnants of the Ordos in ruin. You could order some of your ENGINEERS to CAPTURE valuable TECHNOLOGY, Milord.",
"Milord, the Atreides base! They seem to only have a LEIGHTWEIGHT MCV with them - and so, are restricted to basic technology."}
	
	
WorldLoaded = function()
ordos    = Player.GetPlayer("Ordos")
atreides = Player.GetPlayer("Atreides")
harkonnen = Player.GetPlayer("Harkonnen")
fremen 	=	Player.GetPlayer("Fremen")

--wither ordos walls
for iter, act in pairs(ordos.GetActors()) 
	do
		if act.Type == "wall" then act.Health = 0.2*act.MaxHealth 
		end
end
--kill automatic ordos carryalls
Trigger.AfterDelay(DateTime.Seconds(0.1),function()
		for _,act in pairs(ordos.GetActors())
		do 
			if act.Type=="carryall.reinforce" then act.Kill() end
		end
	end)
	
--Introductory text	
if atreides and atreides.IsLocalPlayer
	then
		Media.DisplayMessage("Spread Atreides influence and destroy all Harkonnen forces!","Your Mission",HSLColor.LawnGreen)
end
if harkonnen and harkonnen.IsLocalPlayer
	then
		Media.DisplayMessage("Destroy all Atreides forces!","Your Mission",HSLColor.Red)
end

--Set up part one of the mission-text triggers (Mentat Advisor help text)
summonAtreidesMentat()
summonHarkonnenMentat()

--needed to disable normal silos after silo upgrade
Actor.Create("silo_negative_prereqisite_dummy", true, { Owner = atreides, Location = CPos.New(0,0) })
Actor.Create("silo_negative_prereqisite_dummy", true, { Owner = harkonnen, Location = CPos.New(0,0) })
--spawn custom units
Actor.Create("mobile_crane", true, { Owner = atreides, Location = CPos.New(9,74) })
Actor.Create("light_thopter", true, { Owner = harkonnen, Location = CPos.New(91,32) })
Actor.Create("light_thopter", true, { Owner = harkonnen, Location = CPos.New(91,31) })
Actor.Create("fremen_skyhunter", true, { Owner = fremen, Location = CPos.New(48,12) })
Actor.Create("fremen_skyhunter", true, { Owner = fremen, Location = CPos.New(17,35) })
end

Tick = function()
--Silo Upgrade Producers Check
for _ , act in pairs(Map.ActorsInWorld) do
	if act.Type=="construction_yard" or act.Type=="outpost" 
	then
		if noDuplicate(act, Upgrade_Producers)
		then
			table.insert(Upgrade_Producers,act)
			--for each new producer set a trigger
			Trigger.OnProduction(act, 
				function(producer, produced) 
					if produced.Type=="upgrade.silo"
					then
						replace_silos(act.Owner)
					end
				end
			)
		end
--...and Airdop Powers check
	--required for airdrop powers
	elseif act.Type=="waypoint_dummy" and noDuplicate(act, ReinforcementLocations)
	then
		dropAirReinforcements(act.Location,act.Owner)
		table.insert(ReinforcementLocations, act)
--...and Atreides Mentat "Troop Transport discovered" message check (requires AnnounceOnSeen: on unit and Player: EnemyWatcher in map.yaml)
	elseif not TroopCrawlerDiscovered and act.Type=="troop_crawler" and noDuplicate(act, UnspottedUnits)
	then
		Trigger.OnDiscovered(act,function(discoveringAct,owner)
			if owner==atreides 
			then
				TroopCrawlerDiscovered=true
				sayTo(atreides, AtreidesMapAdvice[6])
				AtreidesMapAdvice[6]=nil
			end
		end)
		table.insert(UnspottedUnits, act)
--...and Atreides Mentat "Ornithopter discovered" message check (requires AnnounceOnSeen: on unit and Player: EnemyWatcher in map.yaml)
	elseif not ThopterDiscovered and act.Type=="light_thopter" and noDuplicate(act, UnspottedUnits)
	then
		Trigger.OnDiscovered(act, function(discoveringAct, owner)
			if owner==atreides 
			then
				ThopterDiscovered=true
				sayTo(atreides, AtreidesMapAdvice[5])
				AtreidesMapAdvice[5]=nil
			end
		end)
		table.insert(UnspottedUnits, act)
	end
end
--Set up part two of the mission-text triggers (Mentat Advisor help text)
taskAtreidesMentat()
taskHarkonnenMentat()

end

function summonAtreidesMentat()
--common/standard triggers used for mentat advice
Trigger.AfterDelay(DateTime.Seconds(10),function()
	sayTo(atreides, AtreidesBaseAdvice[1])
	end)
Trigger.AfterDelay(DateTime.Minutes(6),function()
	sayTo(atreides, AtreidesBaseAdvice[6])
	end)
Trigger.OnEnteredFootprint(getCPossesInRectangle(2,47,37,47),
	function(act,id)
		if act.Owner == atreides 
		then 
			sayTo(atreides, AtreidesMapAdvice[1])
			Trigger.RemoveFootprintTrigger(id)
		end
	end)

Trigger.OnEnteredFootprint(getCPossesInRectangle(46,63,46,82),
	function(act,id)
		if act.Owner == atreides 
		then 
			sayTo(atreides, AtreidesMapAdvice[2])
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
Trigger.OnEnteredFootprint(getCPossesInRectangle(36,35,44,49),
	function(act,id)
		if act.Owner == atreides 
		then 
			sayTo(atreides, AtreidesMapAdvice[3])
			AtreidesMapAdvice[3]=nil
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
Trigger.OnEnteredFootprint(getCPossesInRectangle(68,47,71,52),
	function(act,id)
		if act.Owner == atreides 
		then 
			sayTo(atreides, AtreidesMapAdvice[3])
			AtreidesMapAdvice[3]=nil
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
Trigger.OnEnteredFootprint(getCPossesInRectangle(78,19,92,37),
	function(act,id)
		if act.Owner == atreides 
		then 
			sayTo(atreides, AtreidesMapAdvice[4])
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
end

function summonHarkonnenMentat()
--common/standard triggers used for mentat advice
Trigger.AfterDelay(DateTime.Seconds(10),function()
	sayTo(harkonnen,HarkonnenBaseAdvice[1])
	end)
Trigger.AfterDelay(DateTime.Seconds(35),function()
	sayTo(harkonnen,HarkonnenBaseAdvice[2])
	end)
Trigger.AfterDelay(DateTime.Minutes(6),function()
	if not harkonnen.HasPrerequisites({"construction_yard"}) and	harkonnen.GetActorsByType("mcv.starport")[1]==nil
	then
		sayTo(harkonnen,HarkonnenBaseAdvice[4])
	end
	end)
	Trigger.OnEnteredFootprint(getCPossesInRectangle(76,50,93,50),
	function(act,id)
		if act.Owner == harkonnen 
		then 
			sayTo(harkonnen, HarkonnenMapAdvice[1])
			Trigger.RemoveFootprintTrigger(id)
		end
	end)	
Trigger.OnEnteredFootprint(getCPossesInRectangle(65,13,70,49),
	function(act,id)
		if act.Owner == harkonnen 
		then 
			sayTo(harkonnen, HarkonnenMapAdvice[3])
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
Trigger.OnEnteredFootprint(getCPossesInRectangle(44,7,51,14),
	function(act,id)
		if act.Owner == harkonnen 
		then 
			sayTo(harkonnen, HarkonnenMapAdvice[2])
			HarkonnenMapAdvice[2]=nil
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
Trigger.OnEnteredFootprint(getCPossesInRectangle(12,30,18,35),
	function(act,id)
		if act.Owner == harkonnen 
		then 
			sayTo(harkonnen, HarkonnenMapAdvice[2])
			HarkonnenMapAdvice[2]=nil
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
Trigger.OnEnteredFootprint(getCPossesInRectangle(3,68,18,80),
	function(act,id)
		if act.Owner == harkonnen 
		then 
			sayTo(harkonnen, HarkonnenMapAdvice[4])
			Trigger.RemoveFootprintTrigger(id)
		end
	end)
end
	
function taskAtreidesMentat()
--custom triggers used for mentat advice
if AtreidesBaseAdvice[2] and (atreides.HasPrerequisites({"barracks"}) or atreides.HasPrerequisites({"light_factory"}) or atreides.HasPrerequisites({"heavy_factory"}) )
then
	sayTo(atreides, AtreidesBaseAdvice[2])
	AtreidesBaseAdvice[2] = nil
end
if AtreidesBaseAdvice[3] and Utils.Any({{"barracks","light_factory"},{"barracks", "heavy_factory"},{"light_factory","heavy_factory"}},atreides.HasPrerequisites )
then
	if atreides.HasPrerequisites({"outpost"}) then AtreidesBaseAdvice[3] = nil end
	sayTo(atreides, AtreidesBaseAdvice[3])
	AtreidesBaseAdvice[3] = nil
end
if AtreidesBaseAdvice[4] and atreides.HasPrerequisites({"outpost"}) 
then
	sayTo(atreides, AtreidesBaseAdvice[4])
	AtreidesBaseAdvice[4] = nil
end
if AtreidesBaseAdvice[5] and atreides.HasPrerequisites({"refinery","barracks","light_factory","heavy_factory","outpost"}) 
then
	sayTo(atreides, AtreidesBaseAdvice[5])
	AtreidesBaseAdvice[5] = nil
end
if AtreidesBaseAdvice[7] and atreides.HasPrerequisites({"refinery","barracks","light_factory","heavy_factory","outpost","upgrade.outpost","upgrade.heavy","upgrade.light", "upgrade.barracks","repair_pad"})
then
	sayTo(atreides, AtreidesBaseAdvice[7])
	AtreidesBaseAdvice[7] = nil
end
end

function taskHarkonnenMentat()
--custom triggers used for mentat advice
if HarkonnenBaseAdvice[3] and harkonnen.Resources+harkonnen.Cash<3300
then 
	sayTo(harkonnen, HarkonnenBaseAdvice[3])
	HarkonnenBaseAdvice[3]=nil
end

--Air units unfortunately don't trigger Trigger.OnEnteredFootprint so...
local Advice = 0
for _,thopter in pairs(harkonnen.GetActorsByType("light_thopter")) do
	local x = thopter.Location.X
	local y = thopter.Location.Y
	if y>=60 and x>=69
	then
		Advice = 1
	elseif 49>=y and y>=14 and x<=71
	then
		Advice = 3
	elseif 38>=y and y>=25 and 18>=x and x>=10 --this entry is somehow bugged
	then 
		Advice = 2
	elseif 14>=y and y>=7 and 51>=x and x>=44
	then
		Advice = 2
	elseif x<=18 and y>=68
	then
		Advice = 4
	end
end
if Advice>0
then
	sayTo(harkonnen,HarkonnenMapAdvice[Advice])
	HarkonnenMapAdvice[Advice]=nil
end
end

function getCPossesInRectangle(left,top,right,bottom)
	local Cposses={}
	local length=right-left+1
	for i=top,bottom do 
		for j=left,right do 
			Cposses[(i-top)*length+(j+1-left)]=CPos.New(j,i)
		end
	end
	--for debugging
	--[[
	 for idx,cpos in pairs(Cposses) do
		Beacon.New(harkonnen,Map.CenterOfCell(cpos))
	 end
	 --]]
	return Cposses
end

function sayTo(player, message)
	if message
	then
		local color = HSLColor.LawnGreen --default is atreides
		if player==harkonnen then  color = HSLColor.Red end
		if player and player.IsLocalPlayer
		then
			Media.DisplayMessage(message,"Mentat",color)
		end
	end
end

function dropAirReinforcements(location,owner)
	local squad
	if owner==atreides then squad=1 end
	if owner==harkonnen then squad=2 end
	--Carryall reinforcements
	local base = owner.GetActorsByType("outpost")[1]
	local edge = getMapEdge(base.Location, location)
	local path = {edge,location}
	local units = Reinforcements.ReinforceWithTransport(owner, "carryall.reinforce", ReinforcementSquads[squad], path, {path[2], path[1]})
end

function getMapEdge(posB,posA)
	--map dependent hack!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	boundary = {X=95, Y=84}	
	--catch zero devision errors
	if posB.X-posA.X == 0 
	then 
		if posB.Y<posA.Y then return CPos.New(posA.X,0)
		else return CPos.New(posA.X,boundary.Y)
		end
	elseif posB.Y-posA.Y == 0 
	then 
		if posB.X<posA.X then return CPos.New(0,posA.Y)
		else return CPos.New(boundary.X,posA.Y)
		end
	end
	
	--compute all boundary intersections
	local slope = (posB.Y-posA.Y)/(posB.X-posA.X)
	local topX   = posA.X - posA.Y/slope
	local bottomX= posA.X +((boundary.Y-posA.Y)/slope)
	local rightY = posA.Y +((boundary.X-posA.X)*slope)
	local leftY =  posA.Y - posA.X*slope
	
	local top = CPos.New(math.floor(topX),0)
	local bottom = CPos.New(math.floor(bottomX),boundary.Y)
	local right = CPos.New(boundary.X, math.floor(rightY))
	local left = CPos.New(0, math.floor(leftY))	
	
	--decide which of them is reasonable
	local positiveDelX = 0 < (posB.X-posA.X)
	local positiveSlope= 0 < slope 
	
	if positiveDelX and positiveSlope
	then 
		if bottom.X<=boundary.X then return bottom
		else return right
		end
	elseif positiveDelX and not positiveSlope
	then
		if top.X<=boundary.X then return top
		else return right
		end
	elseif not positiveDelX and positiveSlope
	then
		if top.X>=0 then return top
		else return left
		end
	elseif not positiveDelX and not positiveSlope
	then
		if bottom.X>=0 then return bottom
		else return left
		end
	end
	Media.DisplayMessage(" in Function getMapEdge, no Edge matched, returning default. (0,0)","Error")
	return CPos.New(0,0)
end

function replace_silos(player)
	local res = player.Resources
	for _, actor in pairs(player.GetActorsByType("silo")) do
		local loc=actor.Location
		actor.Destroy()
		Actor.Create("advanced_silo", true, { Owner = player, Location = loc })
	end
	--give the game time to contemplate consequences of rapid player.ResourceCapacity changes, then correct.
	Trigger.AfterDelay(DateTime.Seconds(0.1),
					function() 
						player.Resources = res
					end
				)
	--all future silos shall be advancedd silos
	player.GetActorsByType("silo_negative_prereqisite_dummy")[1].Destroy()
end

function noDuplicate(actor, actorlist)
  for _, value in pairs(actorlist) do
    if value == actor then
      return false
    end
  end
  return true
end