Spies = { }

CarryallTimer = { }
CarryallTimer["easy"] = DateTime.Minutes(3)
CarryallTimer["normal"] = DateTime.Minutes(3) + DateTime.Seconds(45)
CarryallTimer["hard"] = DateTime.Minutes(4) + DateTime.Seconds(30)

CarryallPath = { CarryallEntry.Location, CarryallRally.Location }
Carryall = { "carryall" }
Harvester = { "harvester.starport" }

Upgrades = { "upgrade.barracks", "upgrade.light", "upgrade.conyard", "upgrade.heavy", "upgrade.hightech" }
Cargos = { "cargo_vehicle", "cargo_vehicle", "cargo_vehicle" }

Reinforcementses =
{
	Harkonnen =
	{
		easy =
		{
			{ "combat_tank_h", "trike", "quad", "quad" },
			{ "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf" },
			{ "sardaukar", "sardaukar", "trooper", "trike", "missile_tank", "missile_tank" },
			{ "trike", "trike", "trike", "trike", "trike" },
			{ "combat_tank_h", "combat_tank_h", "combat_tank_h", "devastator" },
			{ "devastator", "combat_tank_h", "missile_tank", "missile_tank" },
			{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar" }
		},
		normal =
		{
			{ "combat_tank_h", "combat_tank_h", "trike", "trike", "quad", "quad" },
			{ "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf" },
			{ "sardaukar", "sardaukar", "sardaukar", "trooper", "trooper", "trike", "trike", "missile_tank", "missile_tank" },
			{ "trike", "trike", "trike", "trike", "trike", "trike" },
			{ "combat_tank_h", "combat_tank_h", "combat_tank_h", "combat_tank_h", "devastator" },
			{ "devastator", "combat_tank_h", "combat_tank_h", "missile_tank", "missile_tank", "missile_tank" },
			{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar" }
		},
		hard =
		{
			{ "combat_tank_h", "combat_tank_h", "combat_tank_h", "trike", "trike", "quad", "quad", "quad" },
			{ "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf" },
			{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "trooper", "trooper", "trike", "trike", "trike", "missile_tank", "missile_tank", "missile_tank" },
			{ "trike", "trike", "trike", "trike", "trike", "trike", "trike" },
			{ "combat_tank_h", "combat_tank_h", "combat_tank_h", "combat_tank_h", "combat_tank_h", "devastator", "devastator" },
			{ "devastator", "devastator", "combat_tank_h", "combat_tank_h", "missile_tank", "missile_tank", "missile_tank", "missile_tank" },
			{ "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar", "sardaukar" }
		}
	},
	Ordos =
	{
		easy =
		{
			{ "combat_tank_o", "raider", "quad", "quad" },
			{ "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf" },
			{ "stealth_raider", "stealth_raider", "trooper", "raider", "missile_tank", "missile_tank" },
			{ "raider", "raider", "raider", "raider", "raider" },
			{ "combat_tank_o", "combat_tank_o", "combat_tank_o", "deviator" },
			{ "deviator", "combat_tank_o", "missile_tank", "missile_tank" },
			{ "stealth_raider", "stealth_raider", "stealth_raider", "stealth_raider", "stealth_raider", "stealth_raider" }
		},
		normal =
		{
			{ "combat_tank_o", "combat_tank_o", "raider", "raider", "quad", "quad" },
			{ "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf" },
			{ "stealth_raider", "stealth_raider", "stealth_raider", "trooper", "trooper", "raider", "raider", "missile_tank", "missile_tank" },
			{ "raider", "raider", "raider", "raider" },
			{ "combat_tank_o", "combat_tank_o", "combat_tank_o", "combat_tank_o", "deviator" },
			{ "deviator", "combat_tank_o", "combat_tank_o", "missile_tank", "missile_tank", "missile_tank" },
			{ "stealth_raider", "stealth_raider", "stealth_raider", "stealth_raider", "stealth_raider", "stealth_raider", "stealth_raider", "stealth_raider" }
		},
		hard =
		{
			{ "combat_tank_o", "combat_tank_o", "combat_tank_o", "raider", "raider", "quad", "quad", "quad" },
			{ "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf" },
			{ "stealth_raider", "stealth_raider", "stealth_raider", "stealth_raider", "trooper", "trooper", "raider", "raider", "raider", "missile_tank", "missile_tank", "missile_tank" },
			{ "raider", "raider", "raider", "raider", "raider", "raider" },
			{ "combat_tank_o", "combat_tank_o", "combat_tank_o", "combat_tank_o", "combat_tank_o", "deviator", "deviator" },
			{ "deviator", "deviator", "combat_tank_o", "combat_tank_o", "combat_tank_o", "missile_tank", "missile_tank", "missile_tank", "missile_tank" },
			{ "stealth_raider", "stealth_raider", "stealth_raider", "stealth_raider", "stealth_raider", "stealth_raider", "stealth_raider", "stealth_raider", "stealth_raider", "stealth_raider" }
		}
	},
	Smugglers =
	{
		easy =
		{
			{ "combat_tank_s", "raider", "raider", "quad", "quad" },
			{ "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf" },
			{ "raider", "raider", "raider", "raider", "trooper", "trooper", "raider", "missile_tank", "missile_tank" },
			{ "raider", "raider", "raider", "raider", "raider" },
			{ "combat_tank_s", "combat_tank_s", "combat_tank_s", "combat_tank_s", "combat_tank_s" },
			{ "combat_tank_s", "combat_tank_s", "missile_tank", "missile_tank", "missile_tank" },
			{ "raider", "raider", "raider", "raider", "raider", "raider", "raider" }
		},
		normal =
		{
			{ "combat_tank_s", "raider", "quad", "quad" },
			{ "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf" },
			{ "raider", "raider", "raider", "trooper", "raider", "missile_tank", "missile_tank" },
			{ "raider", "raider", "raider", "raider" },
			{ "combat_tank_s", "combat_tank_s", "combat_tank_s", "combat_tank_s" },
			{ "combat_tank_s", "combat_tank_s", "missile_tank", "missile_tank" },
			{ "raider", "raider", "raider", "raider", "raider", "raider" }
		},
		hard =
		{
			{ "combat_tank_s", "raider", "quad" },
			{ "light_inf", "light_inf", "light_inf", "light_inf", "light_inf", "light_inf" },
			{ "raider", "raider", "trooper", "raider", "missile_tank" },
			{ "raider", "raider", "raider" },
			{ "combat_tank_s", "combat_tank_s", "combat_tank_s" },
			{ "combat_tank_s", "combat_tank_s", "missile_tank" },
			{ "raider", "raider", "raider", "raider", "raider" }
		}
	}
}

ReinforcementDelays = {
	easy = { DateTime.Seconds(8), DateTime.Seconds(40), DateTime.Seconds(80), DateTime.Seconds(140), DateTime.Seconds(222), DateTime.Seconds(300), DateTime.Seconds(380), DateTime.Seconds(450) },
	normal = { DateTime.Seconds(16), DateTime.Seconds(35), DateTime.Seconds(70), DateTime.Seconds(125), DateTime.Seconds(211), DateTime.Seconds(280), DateTime.Seconds(360), DateTime.Seconds(425) },
	hard = { DateTime.Seconds(24), DateTime.Seconds(30), DateTime.Seconds(60), DateTime.Seconds(110), DateTime.Seconds(200), DateTime.Seconds(270), DateTime.Seconds(340), DateTime.Seconds(400) }
}

FrigateWaypoints = { FrigateEntry.Location, FrigateRally.Location }

MissionTimer = { }
MissionTimer["easy"] = DateTime.Minutes(20)
MissionTimer["normal"] = DateTime.Minutes(35)
MissionTimer["hard"] = DateTime.Minutes(50)

DialougePlayed = false

IdleHunt = function(unit) if not unit.IsDead then Trigger.OnIdle(unit, unit.Hunt) end end

IXInfiltrated = {
	Atreides = false,
	Harkonnen = false,
	Ordos = false
}

GoToChronoSphere = function(unit)
	Trigger.OnIdle(unit, function()
		unit.Move(CPos.New(125, 70))
		unit.Destroy()
	end)
end

CheckIfIXKilledBeforeInfiltration = function(house, ix)
	Trigger.OnKilled(ix, function()
		if IXInfiltrated[house.Name] == false then
			player.MarkFailedObjective(InfiltrateIXLabs)
		end
	end)
end

SetIXInfiltrated = function(house, ix)
	Trigger.OnInfiltrated(ix, function()
		if IXInfiltrated[house.Name] == false then
			IXInfiltrated[house.Name] = true
			Media.DisplayMessage("".. house.Name .." Ix Research Center has been infiltated.", "EVA")
		end
	end)
end

AllIXInfiltated = function()
	if IXInfiltrated["Atreides"] and IXInfiltrated["Harkonnen"] and IXInfiltrated["Ordos"] then
		player.MarkCompletedObjective(InfiltrateIXLabs)

		if DialougePlayed == false then
			DialougePlayed = true

			Trigger.AfterDelay(DateTime.Seconds(4), function()
				Media.DisplayMessage("Good, now you can get your materials.", "Smuggler Leader")
				
				local units = Reinforcements.ReinforceWithTransport(smuggler, "frigate.reinforce", Cargos, FrigateWaypoints, { FrigateWaypoints[1] })[2]
				Utils.Do(units, GoToChronoSphere)
			end)

			Trigger.AfterDelay(DateTime.Seconds(15), function()
				Media.DisplayMessage("What the heck do you think you are doing Smugglers? We found your spy.", "Ordos Mentat")
				Trigger.AfterDelay(DateTime.Seconds(4), function()
					Media.DisplayMessage("We found a spy in our IX Lab too. Smugglers what is going on?", "Harkonnen Mentat")
					Trigger.AfterDelay(DateTime.Seconds(4), function()
						Media.DisplayMessage("Ditto. Also who are those guys, we didn't even notice fighting each other.", "Atreides Mentat")
						Trigger.AfterDelay(DateTime.Seconds(4), function()
							Media.DisplayMessage("Nothing important guys.", "Smuggler Leader")
							Trigger.AfterDelay(DateTime.Seconds(4), function()
								Media.DisplayMessage("Do you really think we'll belive that?", "Harkonnen Mentat")
								ActivateSmugglerAI()
								Trigger.AfterDelay(DateTime.Seconds(4), function()
									Media.DisplayMessage("The Harkonnen are now hostile!", "EVA")
									Media.DisplayMessage("The Ordos are now hostile!", "EVA")

									AttackLocations["Harkonnen"] = { AConyard.Location, OConyard.Location, ChronoSphere.Location, SOutpost.Location, SStarport.Location, SBarracks.Location }
									AttackLocations["Ordos"] = { AConyard.Location, HConyard.Location, ChronoSphere.Location, SOutpost.Location, SStarport.Location, SBarracks.Location }
									Trigger.AfterDelay(DateTime.Seconds(4), function()
										Media.DisplayMessage("Do whatever you want idiots, but this spy is staying with us!", "Atreides Mentat")
										Trigger.AfterDelay(DateTime.Seconds(8), function()
											Media.DisplayMessage("You should guard the ChronoSphere till i repair it, commander.", "Einstein")
											Trigger.AfterDelay(DateTime.Seconds(4), function()
												Media.DisplayMessage("We are gonna help with the fight, don't worry.", "Smuggler Leader")
												SendReinforcements()
											end)
										end)
									end)
								end)
							end)
						end)
					end)
				end)
			end)
		end
	end
end

InitialiseTimer = function()
	if ticked > 0 then
		UserInterface.SetMissionText("ChronoSphere will be repaired in " .. Utils.FormatTime(ticked), TimerColor)
		ticked = ticked - 1
	elseif ticked == 0 then
		FinishTimer()
		ticked = ticked - 1
	end
end

FinishTimer = function()
	for i = 0, 5, 1 do
		local c = TimerColor
		if i % 2 == 0 then
			c = HSLColor.White
		end

		Trigger.AfterDelay(DateTime.Seconds(i), function()
			UserInterface.SetMissionText("ChronoSphere is repaired. Get ready for the time shift!", c)
			player.MarkCompletedObjective(DefendTheChronosphere)
		end)
	end
	Trigger.AfterDelay(DateTime.Seconds(6), function() UserInterface.SetMissionText("") end)
end

GivePlayerCarryall = function()
	Trigger.AfterDelay(CarryallTimer[Difficulty], function()
		Reinforcements.Reinforce(player, Carryall, CarryallPath)
		Media.DisplayMessage("You can have this Carryall to help you get credits quicker.", "Smuggler Leader")
	end)
end

ChronoSphereIsDead = function()
	Trigger.OnKilledOrCaptured(ChronoSphere, function()
		player.MarkFailedObjective(DefendTheChronosphere)
	end)
end

RadarDomeIsDead = function()
	Trigger.OnRemovedFromWorld(AllRadar, function()
		DomeNoLongerExists = true
	end)
end

SendReinforcement = function(house, transport, unit_number, entry, rally)
	local units = Reinforcements.ReinforceWithTransport(house, transport, Reinforcementses[house.Name][Difficulty][unit_number], {entry.Location, rally.Location}, { entry.Location })[2]
	Utils.Do(units, IdleHunt)
end

SendReinforcements = function()
	Trigger.AfterDelay(ReinforcementDelays[Difficulty][1], function()
		SendReinforcement(smuggler, "carryall.reinforce", 1, EntryPoint4, RallyPoint4)
		SendReinforcement(smuggler, "carryall.reinforce", 2, EntryPoint2, RallyPoint2)
	end)
	Trigger.AfterDelay(ReinforcementDelays[Difficulty][2], function()
		SendReinforcement(harkonnen, "carryall.reinforce", 1, EntryPoint1, RallyPoint1)
		SendReinforcement(ordos, "carryall.reinforce", 1, EntryPoint6, RallyPoint6)
	end)
	Trigger.AfterDelay(ReinforcementDelays[Difficulty][3], function()
		SendReinforcement(harkonnen, "carryall.reinforce", 2, EntryPoint3, RallyPoint3)
		SendReinforcement(ordos, "carryall.reinforce", 2, EntryPoint5, RallyPoint5)
	end)
	Trigger.AfterDelay(ReinforcementDelays[Difficulty][4], function()
		SendReinforcement(smuggler, "carryall.reinforce", 3, EntryPoint8, RallyPoint8)
		SendReinforcement(harkonnen, "carryall.reinforce", 3, EntryPoint6, RallyPoint6)
		SendReinforcement(ordos, "carryall.reinforce", 3, EntryPoint4, RallyPoint4)
	end)
	Trigger.AfterDelay(ReinforcementDelays[Difficulty][5], function()
		SendReinforcement(smuggler, "carryall.reinforce", 4, EntryPoint9, RallyPoint9)
		SendReinforcement(harkonnen, "carryall.reinforce", 4, EntryPoint4, RallyPoint4)
		SendReinforcement(ordos, "carryall.reinforce", 4, EntryPoint7, RallyPoint7)
	end)
	Trigger.AfterDelay(ReinforcementDelays[Difficulty][6], function()
		SendReinforcement(smuggler, "carryall.reinforce", 5, EntryPoint9, RallyPoint9)
		SendReinforcement(harkonnen, "carryall.reinforce", 5, EntryPoint6, RallyPoint6)
		SendReinforcement(ordos, "carryall.reinforce", 5, EntryPoint1, RallyPoint1)
	end)
	Trigger.AfterDelay(ReinforcementDelays[Difficulty][7], function()
		SendReinforcement(smuggler, "carryall.reinforce", 6, EntryPoint1, RallyPoint1)
		SendReinforcement(harkonnen, "carryall.reinforce", 6, EntryPoint3, RallyPoint3)
		SendReinforcement(ordos, "carryall.reinforce", 6, EntryPoint2, RallyPoint2)
	end)
	Trigger.AfterDelay(ReinforcementDelays[Difficulty][8], function()
		SendReinforcement(smuggler, "carryall.reinforce", 7, EntryPoint8, RallyPoint8)
		SendReinforcement(harkonnen, "carryall.reinforce", 7, EntryPoint2, RallyPoint2)
		SendReinforcement(ordos, "carryall.reinforce", 7, EntryPoint4, RallyPoint4)
		
		SendReinforcements() -- loop, lasy to code enough units for the rest of the game
	end)
end

Tick = function()
	AllIXInfiltated()

	if IXInfiltrated["Atreides"] and IXInfiltrated["Harkonnen"] and IXInfiltrated["Ordos"] then
		Trigger.AfterDelay(DateTime.Seconds(4), function()
			InitialiseTimer()
		end)
	end
	
	Spies = player.GetActorsByType("spy")
	
	if #Spies < 3 and DomeNoLongerExists then
		player.MarkFailedObjective(InfiltrateIXLabs)
	end
end

WorldLoaded = function()
	atreides = Player.GetPlayer("Atreides")
	harkonnen = Player.GetPlayer("Harkonnen")
	ordos = Player.GetPlayer("Ordos")
	smuggler = Player.GetPlayer("Smugglers")
	soviets = Player.GetPlayer("USSR")
	player = Player.GetPlayer("Allies")
	
	Difficulty = Map.LobbyOption("difficulty")
	ticked = MissionTimer[Difficulty]
	
	InitObjectives()
	ChronoSphereIsDead()
	RadarDomeIsDead()
	
	GivePlayerCarryall()

	Camera.Position = ChronoSphere.CenterPosition
	
	SetIXInfiltrated(atreides, AResearch)
	SetIXInfiltrated(harkonnen, HResearch)
	SetIXInfiltrated(ordos, OResearch)
	
	CheckIfIXKilledBeforeInfiltration(atreides, AResearch)
	CheckIfIXKilledBeforeInfiltration(harkonnen, HResearch)
	CheckIfIXKilledBeforeInfiltration(ordos, OResearch)
	
	Trigger.AfterDelay(0, ActivateAI)

	atreides.Resources = 15000
	harkonnen.Resources = 15000
	ordos.Resources = 15000

	TimerColor = player.Color

	Utils.Do(Utils.Take(4, Upgrades), function(upgrade)
		Actor.Create(upgrade, true, { Owner = atreides })
		Actor.Create(upgrade, true, { Owner = harkonnen })
		Actor.Create(upgrade, true, { Owner = ordos })
		Actor.Create(upgrade, true, { Owner = smuggler })
	end)
	Actor.Create(Upgrades[5], true, { Owner = atreides })
end

InitObjectives = function()
	Trigger.OnObjectiveAdded(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "New " .. string.lower(p.GetObjectiveType(id)) .. " objective")
	end)
	
	SovV2.Attack(ChronoSphere)

	InfiltrateIXLabs = player.AddPrimaryObjective("Infiltrate all 3 Ix Research Centres.")
	DefendTheChronosphere = player.AddPrimaryObjective("Keep the ChronoSphere intact.")
	KillAtreidesH = harkonnen.AddPrimaryObjective("Destroy all Atreides forces.")
	KillAtreidesO = ordos.AddPrimaryObjective("Destroy all Atreides forces.")
	KillHarkonnenA = atreides.AddPrimaryObjective("Destroy all Harkonnen forces.")
	KillHarkonnenO = ordos.AddPrimaryObjective("Destroy all Harkonnen forces.")
	KillOrdosA = atreides.AddPrimaryObjective("Destroy all Ordos forces.")
	KillOrdosH = harkonnen.AddPrimaryObjective("Destroy all Ordos forces.")

	Trigger.OnObjectiveCompleted(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective completed")
	end)
	Trigger.OnObjectiveFailed(player, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective failed")
	end)

	Trigger.OnPlayerLost(player, function()
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			Media.PlaySpeechNotification(player, "Lose")
		end)
	end)
	Trigger.OnPlayerWon(player, function()
		Trigger.AfterDelay(DateTime.Seconds(1), function()
			Media.PlaySpeechNotification(player, "Win")
		end)
	end)
end
