ToHarvest = 3500
HarkonnenReinforcements = {
	{"light_inf","light_inf","light_inf","light_inf"},
	{"quad","trooper", "trooper"},
	{"combat_tank_h"},
	{"engineer"}
	}
Percentage={0,0,0}
harvesterDropped = false
SupportLocations={}
T_charge={DateTime.Seconds(40),DateTime.Seconds(90),DateTime.Seconds(175)}

Tick = function()
	--spice-meter:
	if atreides.IsLocalPlayer or harkonnen.IsLocalPlayer
	then
		UserInterface.SetMissionText("Stored resources: " .. atreides.Resources .. "/" .. ToHarvest, atreides.Color)
	end
	
	--spectator candy
	local T_current=DateTime.GameTime
	Percentage[1] = math.min((T_current-T_reset[1] )/ T_charge[1],1)
	Percentage[2] = math.min((T_current-T_reset[2] )/ T_charge[2],1)
	Percentage[3] = math.min((T_current-T_reset[3] )/ T_charge[3],1)
	if not atreides.IsLocalPlayer and not harkonnen.IsLocalPlayer
	then
		UserInterface.SetMissionText(
		string.format('Atreides Resources  %4i/%4i                       Harkonnen Reinforcements:  Light %3i%%  |  Medium %3i%%  |  Heavy %3i%%',atreides.Resources,ToHarvest,Percentage[1]*100,Percentage[2]*100,Percentage[3]*100), HSLColor.Red)
	end
	
	--atreides victory?
	if atreides.Resources >= ToHarvest
		then atreides.MarkCompletedObjective(GatherSpice)
	end
	
	--harkonnen victory?
	--harvester killed check (add Trigger after harv arrives):
	if not harvesterDropped
		then
			local tmp = Map.ActorsInBox(Map.TopLeft, Map.BottomRight, 
				function(actor)
					if actor.Type=="harvester_a"
						then 
							harvesterDropped = true
							Trigger.OnAllRemovedFromWorld({actor}, 
								function()
									harkonnen.MarkCompletedObjective(StopHarvestOperations)
								end
							)
							return actor
					else return actor
					end
				end
			)		
	end
	--needed for harkonnen airdrop powers
	for iter, act in pairs(harkonnen.GetActors()) 
	do 
		if act.Type=="waypoint_dummy_1" and noDuplicate(act,SupportLocations) 
		then 
			dropHarkonnen(act.Location,1)
			table.insert(SupportLocations, act)
		elseif act.Type=="waypoint_dummy_2" and noDuplicate(act,SupportLocations) 
		then 
			dropHarkonnen(act.Location,2)
			table.insert(SupportLocations, act)
		elseif act.Type=="waypoint_dummy_3" and noDuplicate(act,SupportLocations)
		then 
			dropHarkonnen(act.Location,3)
			table.insert(SupportLocations, act)		
		end
	end
	
	--silo storage insufficient check:
	if atreides.ResourceCapacity < ToHarvest and atreides.ResourceCapacity ~= 0
		then harkonnen.MarkCompletedObjective(StopHarvestOperations)
	end	
end

function noDuplicate(actor, actorlist)
  for _, value in pairs(actorlist) do
    if value == actor then
      return false
    end
  end
  return true
end

function dropHarkonnen(location,squad)
	--Carryall reinforcements
	local path = {EntryPoint.Location,location}
	local units = Reinforcements.ReinforceWithTransport(harkonnen, "carryall", HarkonnenReinforcements[squad], path, {path[2], path[1]})
	--reset spectator candy timer
	T_reset[squad] = DateTime.GameTime
end

WorldLoaded = function()
	--time
	T_reset = {DateTime.GameTime,DateTime.GameTime,DateTime.GameTime,DateTime.GameTime}

	--players:
	harkonnen = Player.GetPlayer("Multi1")
	atreides = Player.GetPlayer("Multi0")

	
	--buildings:
	refinery = Actor29
	barracks = Actor26
	silos = {Actor24, Actor25, Actor27}
	damageBuildings()
	
	--units
	dropHarkonnen(ReinforceLeft.Location,4) 
	Actor.Create("trike_a", true, { Owner = atreides, Location = CPos.New(8,9) })
	Actor.Create("trike_a", true, { Owner = atreides, Location = CPos.New(14,6) })
	Actor.Create("harvester_a", true, { Owner = atreides, Location = CPos.New(16,12) })
	
	--obectives:
	if atreides.IsLocalPlayer 
	then
		Media.DisplayMessage("Harvest SPICE in this area.\n You have ONE HARVESTER to complete your mission, DO NOT LOSE it!\nAlso keep an eye on your SILOS, harkonnen forces are in the area.\n--Good luck! ","Your Mission",HSLColor.Blue)
	elseif harkonnen.IsLocalPlayer 
	then
		Media.DisplayMessage("Keep the atreides scum from harvesting enough spice.\nDESTROY their HARVESTER, REFIENRY or SILOS to stop them!\nThe Duke will send you reinforcements, but you should NOT make him regret his aid!","Your Mission",HSLColor.Red)
	else
			Media.DisplayMessage("Harvest SPICE in this area.\nWe send you one HARVESTER to complete your mission, DO NOT LOSE it!\nAlso keep an eye on your SILOS, harkonnen forces are in the area.\n--Good luck!\n\n.","    Atreides Mission",HSLColor.Blue)
			Media.DisplayMessage("Keep the atreides scum from harvesting enough spice.\nDESTROY their HARVESTER, REFIENRY or SILOS to stop them!\nThe Duke will send you reinforcements, but you should NOT make him regret his aid!","Harkonnen Mission.",HSLColor.Red)
			
	end

	GatherSpice = atreides.AddPrimaryObjective("Harvest " .. tostring(ToHarvest) .. " Solaris worth of Spice.")
	StopHarvestOperations = harkonnen.AddPrimaryObjective("Stop the Atreides from storing enough Spice.")
	Trigger.OnObjectiveCompleted(atreides, 
		function(p, id)
			Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective completed") 
		end
	)
	Trigger.OnPlayerWon(atreides, 
		function() 
			Trigger.AfterDelay(DateTime.Seconds(1), 
				function() 
					Media.PlaySpeechNotification(atreides, "Win") 
				end
			)
		end
	)
	--harkonnen victory (refinery killed):
	Trigger.OnAllRemovedFromWorld({refinery}, 
		function()
			harkonnen.MarkCompletedObjective(StopHarvestOperations)
		end
	)
	--prevents resource loss by silo destroyed
	for iter,silo in pairs(silos) 
		do 	
		Trigger.OnKilledOrCaptured(silo,
			function()
				Trigger.AfterDelay(DateTime.Seconds(0.1),
					function() 
						atreides.Resources = atreides.Resources*(1+2000/atreides.ResourceCapacity)
					end
				)
			end
		)
	end
	
end

damageBuildings = function()
	refinery.Health = 1.*refinery.MaxHealth 
	barracks.Health = 0.7*barracks.MaxHealth 
	for iter,silo in pairs(silos) 
		do silo.Health = 1.*silo.MaxHealth 
	end
end