-----------------------------------------------------------------------------------------------------------------------
------------------ LUA SCRIPTS FOR MISSION CONTROL AND AI IMPLEMENTATION
---------------------- by lovalmidas
-----------------------------------------------------------------------------------------------------------------------
-- UI DISPLAY LUA  VERSION 1.001 - 2017.03.22.0
-- #
------ Contains:  
---------- TickShowInfo() 
---------- AI Team calculations
-------------- AIGroupInfo(string str, Player cty, string actorgroupname)
-------------- AIGroupSurvivor(Player cty, string actorgroupname)

function TickShowInfo()
  AddDebugString("TickShowInfo() called") 
  
  -- Disable during debug
  if bdebug then return end
  
  -- Disable if missionDisplayPlayer is not defined
  if missionDisplayPlayer == nil then return end
  
  local str = ""
  
  -- Objectives Display
  if missionDisplayObjectives and #missionObjectiveIDs > 0 then 
    Utils.Do(missionObjectiveIDs, function(id)
      if MissionPlayer.GetObjectiveType(id) ~= "Primary" then return end
      if str == "" then
        str = "\nObjective"..((#missionObjectiveIDs > 1) and "s" or "")..": \n     "..str..MissionPlayer.GetObjectiveType(id)..":  "..MissionPlayer.GetObjectiveDescription(id)
      else
        str = "\n"..str.."\n     "..MissionPlayer.GetObjectiveType(id)..":  "..MissionPlayer.GetObjectiveDescription(id)
      end
      if missionObjectiveFlavourText[id] ~= nil then str = str.." ("..missionObjectiveFlavourText[id]..")" end
    end)
  
    Utils.Do(missionObjectiveIDs, function(id)
      if MissionPlayer.GetObjectiveType(id) == "Primary" then return end
      if str == "" then
        str = "\nObjective"..((#missionObjectiveIDs > 1) and "s" or "")..": \n     "..str..MissionPlayer.GetObjectiveType(id)..":  "..MissionPlayer.GetObjectiveDescription(id)
      else
        str = "\n"..str.."\n     "..MissionPlayer.GetObjectiveType(id)..":  "..MissionPlayer.GetObjectiveDescription(id)
      end
      if missionObjectiveFlavourText[id] ~= nil then str = str.." ("..missionObjectiveFlavourText[id]..")" end
    end)
  
    str = "\n"..str.."\n"
  end
 
  -- Divider
  if missionDisplayResource or missionDisplayProduction or missionDisplayAITeams or missionDisplayAICustomTeams then
    -- for 120 characters max length without shifting the textbox
    str = str .."________________________________________________________________________________________________________________________\n".. missionDisplayPlayer.Name .." Player Information" 
  end
    
  -- Resources Display
	if missionDisplayResource then 
		local gnumproc = #FindOwnedActorType(missionDisplayPlayer, "proc")
		local gnumharv = #missionDisplayPlayer.GetActorsByType("harv") --FindOwnedActorType(cty, "harv")
    
		str = "\n".. str .."\n  Resources: ".. (missionDisplayPlayer.Cash + missionDisplayPlayer.Resources) .." / ".. gnumproc .." Refiner"..( (gnumproc > 1) and "ies" or "y" ).." / ".. gnumharv .." Ore Truck".. ((gnumharv > 1) and "s" or "")
  end
  
  -- Production Display (AI only)
 	if missionDisplayProduction then 
		local str_factory = ""
    local str_queue = ""

		Utils.Do(ActiveProductionTable, function(t)
      if string.len(str_factory) > 120 then 
        str_factory = str_factory .. (string.sub(str_queue, -3) == "..." and "" or " ...")
        return
      end
			if t.factory.Owner == missionDisplayPlayer and t.progress > 0 then
				local intprog = (t.progress - t.progress % 1000) / 1000
        str_factory = (str_factory == "" and "  " or str_factory.." ").. GetName(t.curr_production) .."(".. intprog .."%) "
			end
		end)
  
    Utils.Do(PendingTypesForProduction[missionDisplayPlayer.Name], function(ptp)
      if string.len(str_queue) > 120 then 
        str_queue = str_queue .. (string.sub(str_queue, -3) == "..." and "" or " ...")
        return
      end
      str_queue = str_queue .. (str_queue == "" and "Queue:    " or ", ") .. GetName(ptp.type)
		end)
		    
		if str_factory ~= "" then
			str = "\n\n\n".. str .."\n\nProducing:\n".. str_factory.."\n"..str_queue
		else
			str = "\n\n\n".. str .."\n\nNot producing anything.\n\n"..str_queue
		end
  end
  
  -- AI Team Display
 	if missionDisplayAITeams then    
    if type(AIGroups[missionDisplayPlayer.Name]) == "table" then
      str = "\n\n\n"..str.."\n\n"..(missionDisplayAICustomTeams and "Advanced" or "Basic").." AI Teams: \n"
      str = AIGroupInfo(str, missionDisplayPlayer, "Pool")
      str = AIGroupInfo(str, missionDisplayPlayer, "Hunt")
      str = AIGroupInfo(str, missionDisplayPlayer, "Defence")
      str = AIGroupInfo(str, missionDisplayPlayer, "DefenceEscort")  
      
      local totaltroopsinteams = 0
      local str2 = ""
      for actorgroupname,actortable in pairs(AIGroups[missionDisplayPlayer.Name]) do 
        if not (actorgroupname == "Pool" or actorgroupname == "Hunt" or actorgroupname == "Defence" or actorgroupname == "DefenceEscort") then
          if missionDisplayAICustomTeams then
            local str3 = str2
            str2 = AIGroupInfo(str2, missionDisplayPlayer, actorgroupname)
            if str3 ~= str2 then str = "\n" .. str end
          end
          totaltroopsinteams = totaltroopsinteams + AIGroupSurvivor(missionDisplayPlayer, actorgroupname)
        end
      end
      
      str = str.."  In Active Taskforce: "..totaltroopsinteams.."  "
      str = str..str2
    end
    
		--str = "\n".. str .."\n\n".. str_message
	end

	UserInterface.SetMissionText(str, missionDisplayPlayer.Color)
end


function AIGroupInfo (str, cty, actorgroupname)
  AddDebugString("AIGroupInfo() called") 
  local statusstr = ""
  if AIGroups[cty.Name] == nil then return str end
  
  local AIGroup = AIGroups[cty.Name][actorgroupname]

  if AIGroup.Status == nil then return str
  elseif AIGroup.Status== -3 then statusstr =   "Returning to Pool" 
  elseif AIGroup.Status == -2 then statusstr =   "On Hold" 
  elseif AIGroup.Status == -1 then statusstr =   "Populating" 
  --elseif AIGroup.Status == 0 then statusstr =   "N/A" 
  elseif AIGroup.Status > 0 then 
    local status = math.modf(AIGroup.Status)
    local functionname = AIGroup.Functions[status] and (AIGroup.Functions[status].Name or " ") or " "
    statusstr =     "Executing Script #"..status..": "..functionname
    
  end
  
  if (statusstr ~= "" and statusstr ~= nil) or (actorgroupname == "Pool" or actorgroupname == "Hunt" or actorgroupname == "Defence" or actorgroupname == "DefenceEscort") then
    local statussurvivor = 0
    local statusgroup = ""
    if AIGroup.Actors ~= nil then
      Utils.Do(AIGroup.Actors, function(a)
          if not a.IsDead then 
            statussurvivor = statussurvivor + 1 
            statusgroup = statusgroup .. " " .. a.Type --GetName(a.Type)
          end
      end)
    end
    
    if AIGroup.PendingTypes ~= nil and #AIGroup.PendingTypes > 0 then
      statusstr = statusstr.. " ("
      local characters = 60
      
      Utils.Do(AIGroup.PendingTypes, function(atype)
        if characters < 0 then 
          statusstr = statusstr.. (string.sub(statusstr, -3) == "..." and "" or " ...")
          return 
        end
        statusstr = statusstr..((characters == 60) and "" or ", ")..GetName(atype)
        characters = characters - string.len(GetName(atype))
      end)
      statusstr = statusstr.. ")"
    end    
    --if statussurvivor ~= 0 or (actorgroupname == "Pool" or actorgroupname == "Hunt" or actorgroupname == "Defence" or actorgroupname == "DefenceEscort") then
      if (actorgroupname == "Pool" or actorgroupname == "Hunt" or actorgroupname == "Defence" or actorgroupname == "DefenceEscort") then
        return str.."  "..actorgroupname..": "..statussurvivor.."  "--.. statusgroup
      else
        return str.."\n  ["..actorgroupname.."]  Units: "..statussurvivor.." / "..#AIGroup.TeamTypes..", "..statusstr.."   "--.. statusgroup
      end
    --end
  end
  return str
end

function AIGroupSurvivor (cty, actorgroupname)
  AddDebugString("AIGroupSurvivor() called") 
  if AIGroups[cty.Name] == nil then return 0 end
  
  local AIGroup = AIGroups[cty.Name][actorgroupname]
  if AIGroup.Status == nil then return 0 end
  
  if not (actorgroupname == "Pool" or actorgroupname == "Hunt" or actorgroupname == "Defence" or actorgroupname == "DefenceEscort") then
    local statussurvivor = 0
    if AIGroup.Actors ~= nil then
      Utils.Do(AIGroup.Actors, function(a)
          if not a.IsDead then 
            statussurvivor = statussurvivor + 1 
          end
      end)
    end
    return statussurvivor
  end
end



function AddDebugString(str)
  
  if bdebug then
    local i = 50
    if i > #DebugStrings then i = #DebugStrings end
    while i >= 1 do
      DebugStrings[i+1] = DebugStrings[i]
      i = i - 1
    end
    debugfnnumber = debugfnnumber + 1
    DebugStrings[1] = "Tick "..missiontick..":"..debugfnnumber..":  "..str
    DebugShowInfo() 
  end
end

function DebugShowInfo()
  
  local str = ""
  for i = 1, #DebugStrings do
    str = "\n"..str.."\n"..DebugStrings[i]
  end
    
  str = "________________________________________________________________________________________________________________________\n".. str
  UserInterface.SetMissionText(str, HSLColor.White)
end