-----------------------------------------------------------------------------------------------------------------------
------------------ LUA SCRIPTS FOR MISSION CONTROL AND AI IMPLEMENTATION
---------------------- by lovalmidas
-----------------------------------------------------------------------------------------------------------------------
-- REINFORCEMENTS LUA  VERSION 1.001 - 2017.03.22.0
-- #13
------ Contains:  
---------- CPosRectangleArray() 
---------- Reinforcement functions
-------------- CreateUnitReinforcements (Player player, int i, int closeenough, int delay, bool cyclic, bool waitforgroup)
-------------- CreateAircraftReinforcements (Player player, int i, int closeenough, int checkdelay, bool cyclic)
-------------- CreateTransportReinforcements (Player player, int i, int closeenough, int delay, bool cyclic, bool waitforgroup)
-------------- CreateParadropReinforcements (Player player, int i, int closeenough, int delay, bool cyclic, bool waitforgroup)


-- function to return a rectangular array of cells
function CPosRectangleArray (left, top, right, bottom)
  local cposarray = { }
  for i = left, right do
    for j = top, bottom  do
      table.insert (cposarray, CPos.New(i,j))
    end
  end
  return cposarray
end


function CreateUnitReinforcements (player, i, closeenough, delay, cyclic, waitforgroup)
  AddDebugString("User CreateUnitReinforcements( player = ".. player.Name ..", i = " ..i..")")

  if closeenough == nil then closeenough = 3 end
  if delay == nil then delay = 25 end
  if cyclic == nil then cyclic = false end

  if player == MissionPlayer then Media.PlaySpeechNotification(player, "ReinforcementsArrived") end

	local units = Reinforcements.Reinforce( player, 
                                          UnitReinforcements[player.Name][i].Units, 
                                          UnitReinforcements[player.Name][i].Spawn)
   
	Utils.Do(units, function(unit)
    AddActorToRegistry(unit)
    waitforgroup = waitforgroup and units or false
    GroundAttackMove(unit, UnitReinforcements[player.Name][i].Path, closeenough, delay, cyclic, waitforgroup)
  end)
end


function CreateAircraftReinforcements (player, i, closeenough, checkdelay, cyclic)
  AddDebugString("User CreateAircraftReinforcements( player = ".. player.Name ..", i = " ..i..")")

  if closeenough == nil then closeenough = 3 end
  if delay == nil then delay = 25 end
  if cyclic == nil then cyclic = false end

  if player == MissionPlayer then Media.PlaySpeechNotification(player, "ReinforcementsArrived") end

	local units = Reinforcements.Reinforce( player, 
                                          AircraftReinforcements[player.Name][i].Units, 
                                          AircraftReinforcements[player.Name][i].Spawn)
   
	Utils.Do(units, function(unit)
    AddActorToRegistry(unit)
    AircraftAttackMove(unit, AircraftReinforcements[player.Name][i].Path, closeenough, checkdelay, cyclic)
  end)
end


function CreateTransportReinforcements (player, i, closeenough, delay, cyclic, waitforgroup)
  AddDebugString("User CreateTransportReinforcements( player = ".. player.Name ..", i = " ..i..")")

  if closeenough == nil then closeenough = 3 end
  if delay == nil then delay = 25 end
  if cyclic == nil then cyclic = false end

  if player == MissionPlayer then Media.PlaySpeechNotification(player, "ReinforcementsArrived") end
  
	local units = Reinforcements.ReinforceWithTransport(player, 
                                                      TransportReinforcements[player.Name][i].Transport, 
                                                      TransportReinforcements[player.Name][i].Units, 
                                                      TransportReinforcements[player.Name][i].Spawn,
                                                      { TransportReinforcements[player.Name][i].Spawn[1] })[2]
  
	Utils.Do(units, function(unit)
    AddActorToRegistry(unit)
    waitforgroup = waitforgroup and units or false
    GroundAttackMove(unit, TransportReinforcements[player.Name][i].Path, closeenough, delay, cyclic, waitforgroup)
  end)
end


function CreateParadropReinforcements (player, i, closeenough, delay, cyclic, waitforgroup)
  AddDebugString("User CreateParadropReinforcements( player = ".. player.Name ..", i = " ..i..")")

  if closeenough == nil then closeenough = 3 end
  if delay == nil then delay = 25 end
  if cyclic == nil then cyclic = false end

  if player == MissionPlayer then Media.PlaySpeechNotification(player, "ReinforcementsArrived") end
  
	local lz = ParadropReinforcements[player.Name][i].Spawn[1]
    local start = Map.CenterOfCell(Map.RandomEdgeCell()) + WVec.New(0, 0, Actor.CruiseAltitude("badr"))
    local transport = Actor.Create("badr", true, { CenterPosition = start, Owner = player, Facing = (Map.CenterOfCell(lz) - start).Facing })
	local units = ParadropReinforcements[player.Name][i].Units
	
    Utils.Do(units, function(type)
      local unit = Actor.Create(type, false, { Owner = player })
      Trigger.OnAddedToWorld(unit, function(a)
        AddActorToRegistry(a)
        waitforgroup = waitforgroup and units or false
        GroundAttackMove(a, ParadropReinforcements[player.Name][i].Path, closeenough, delay, cyclic, waitforgroup)
      end)
      transport.LoadPassenger(unit)
    end)

    transport.Paradrop(lz)
end
