-----------------------------------------------------------------------------------------------------------------------
------------------ LUA SCRIPTS FOR MISSION CONTROL AND AI IMPLEMENTATION
---------------------- by lovalmidas
-----------------------------------------------------------------------------------------------------------------------
-- AI TEAMS LUA  VERSION 1.001 - 2017.03.22.0
-- #12
------ Contains:  
---------- AITeamControl() 
---------- AIReservedTeamControl()
---------- AIReservedDefence()
---------- 
---------- Utility functions
-------------- AddActorToPool(Actor actor)
-------------- GrabActorFromPool(string actortype,string playername, table targettable) 
-------------- TransferActorToActorGroup(Actor actor, table sourcetable, table targettable)
---------- Actor command functions used by reserved teams 
-------------- HuntingPath(Actor[] units, string playername)
-------------- AircraftAttackMove(Actor a, CPos[] path, int closeenough, int checkdelay, bool cyclic)
-------------- AircraftMove(Actor a, CPos[] path, int closeenough, int checkdelay, bool cyclic)
-------------- AircraftReloadRefresh(Actor a, CPos[] path, int closeenough, int checkdelay, int i, bool cyclic)
-------------- AircraftMoveRefresh(Actor a, CPos[] path, int closeenough, int checkdelay, int i, bool cyclic)
-------------- AircraftReloadRefresh(Actor a, CPos[] path, int closeenough, int checkdelay, int i, bool cyclic)
-------------- AircraftAttackRefresh(Actor a, CPos[] path, int closeenough, int checkdelay, bool cyclic)
-------------- GroundAttackMove(Actor a, CPos[] path, int closeenough, int checkdelay, bool cyclic, Actor[] or false waitforgroup, bool noattack))
-------------- ForceHunt(Actor a)
-------------- ForceAttack(Actor a, Actor target)
-------------- ForceGuard(Actor a, Actor target)

-- Collection of functions for governing AI teams --

------------------------------------------------------------------------------------
-------- MAIN FUNCTION TO ATTACH TO WorldLoaded()
function InitialiseAITeams ()
  AddDebugString("InitialiseAITeams() called")

  Utils.Do(HouseGroups.All, function(bot)
  
    -- In case AITeams has not been initialized for the player
    AITeams[bot.Name] = AITeams[bot.Name] or {}
    AIFunctions[bot.Name] = AIFunctions[bot.Name] or {}
    AIConditions[bot.Name] = AIConditions[bot.Name] or {}   
    
    PendingTypesForProduction[bot.Name] = PendingTypesForProduction[bot.Name] or { }    
    AIGroups[bot.Name] = AIGroups[bot.Name] or {}
    
    AIGroups[bot.Name].Pool = { Actors = {}, TeamTypes = {}, PendingTypes = {}, Functions = {}, Status = 0 }
    AIGroups[bot.Name].Hunt = { Actors = {}, TeamTypes = {}, PendingTypes = {}, Functions = {}, Status = 0 }
    AIGroups[bot.Name].Defence = { Actors = {}, TeamTypes = {}, PendingTypes = {}, Functions = {}, Status = 0 }
    AIGroups[bot.Name].DefenceEscort = { Actors = {}, TeamTypes = {}, PendingTypes = {}, Functions = {}, Status = 0 }        
  end)
end

------------------------------------------------------------------------------------
------ Main assignment control ATTACHED TO Tick()
function AITeamControl ()
  AddDebugString("AITeamControl() called")
  
  for playername,aiteamgroup in pairs(AITeams) do 
    Utils.Shuffle(aiteamgroup)
    for actorgroupname,actors in pairs(aiteamgroup) do 
      if actorgroupname == nil or actorgroupname == "Pool" or actorgroupname == "Hunt" or actorgroupname == "Defence" or actorgroupname == "DefenceEscort" then 
      else
        AITeams[playername][actorgroupname] = AITeams[playername][actorgroupname] or { }
        AIFunctions[playername][actorgroupname] = AIFunctions[playername][actorgroupname] or { }
        AIConditions[playername][actorgroupname] = AIConditions[playername][actorgroupname] or { }        
        AIGroups[playername][actorgroupname] = AIGroups[playername][actorgroupname] or {  Actors = {}, 
                                                                                          TeamTypes = {}, 
                                                                                          PendingTypes = {}, 
                                                                                          Functions = {}, 
                                                                                          Status = 0, 
                                                                                          Playername = playername, 
                                                                                          Actorgroupname = actorgroupname }
        
        AISingleTeamControl (playername, actorgroupname)
      end
    end
  end
end
      
function AISingleTeamControl (playername, actorgroupname)
  AddDebugString("AISingleTeamControl("..playername..", "..actorgroupname..") called")

  local AIGroup = AIGroups[playername][actorgroupname]

  if AIGroup.Status == nil then UpdateAIGroupStatus(playername, actorgroupname, 0) end
  
  ---- (0) Default, inactive
  if AIGroup.Status == 0 then
    -- check conditions
    local conditionset = AIGroup.Conditions
    local conditionmet = true
    
    if conditionset ~= nil then -- if conditions are not specified, assume always met.
      conditionset.ArgumentTable = conditionset.ArgumentTable or { Dummy = "dummy" }
      if type(conditionset.Function) == "function" then
        conditionset.ArgumentTable.PlayerName = playername
        conditionset.ArgumentTable.ActorGroupName = actorgroupname
        if conditionset.Function(conditionset.ArgumentTable) ~= true then -- check condition
          conditionmet = false
        end
      else
        -- malformed inputs should be treated as failed condition
        if conditionset.Function ~= nil then conditionmet = false end
      end
    end 
    
    -- check if I can build this team
    if conditionmet == true and AITeamCheckPrerequisite(playername, AIGroup.TeamTypes) then
      UpdateAIGroupStatus(playername, actorgroupname, -1)
    else
      -- Refresh the teams (in case the team composition had been changed
      UpdateAIGroupStatus(playername, actorgroupname, 0)      
    end
  end 


  ---- (-1) Activated, gathering actors from pool, this grabs for every team...
  if AIGroup.Status == -1 then
    local i = 1
    for _,v in pairs(PendingTypesForProduction[playername]) do
      if GrabActorFromPool(v.type, playername, v.aigroup.Actors) then       
        RemoveOnceFromList(v.aigroup.PendingTypes, v.type)
        RemoveOnceFromList(PendingTypesForProduction[playername], v)
      else
        --check if I can still build this team
        if not AITeamCheckPrerequisite(playername, v.aigroup.PendingTypes) then
          UpdateAIGroupStatus(playername, v.aigroup.Actorgroupname, -3)
          break
        end
      end
    end
    
    -- Filled
    if #AIGroup.PendingTypes == 0 then 
      UpdateAIGroupStatus(playername, actorgroupname, 1)
    end 
  end
  
  
  
  --if AIGroup.Status == -1 then
  --  local i = 1
  --  while i <= tablelength(AIGroup.PendingTypes) do
  --    if GrabActorFromPool(AIGroup.PendingTypes[i], playername, AIGroup.Actors) then
  --      --RemoveOnceFromList(AIGroup.PendingTypes, actor.Type)
  --      --RemoveOnceFromList(PendingTypesForProduction[playername], { type = actor.Type, aigroup = AIGroup })
  --      table.remove(AIGroup.PendingTypes, i)
  --    else
  --      --check if I can still build this team
  --      if not AITeamCheckPrerequisite(playername, AIGroup.PendingTypes) then
  --        UpdateAIGroupStatus(playername, actorgroupname, -3)
  --        i = tablelength(AIGroup.PendingTypes) + 1 -- end loop
  --      else
  --        i = i + 1
  --      end
  --    end
  --  end
    
  --  -- Filled
  --  if #AIGroup.PendingTypes == 0 then 
  --    UpdateAIGroupStatus(playername, actorgroupname, 1)
  --  end 
  --end
  
  ---- (-3) Disband, return all to Pool
  if AIGroup.Status == -3 then 
    Utils.Do(AIGroup.Actors, function(actor) 
      if not actor.IsDead then 
        actor.Stop()
        table.insert (AIGroups[playername]["Pool"].Actors, actor) 
      end 
    end)
    AIGroup.Actors = { }
    UpdateAIGroupStatus(playername, actorgroupname, 0)
  end
  
  ---- (Positive integer) Execute Function  
  if AIGroup.Status == math.modf(AIGroup.Status) and AIGroup.Status > 0 then 
    if AIGroup.Functions ~= nil then
      local functionset = AIGroup.Functions[AIGroup.Status]
      UpdateAIGroupStatus(playername, actorgroupname, AIGroup.Status + 0.5)
      if functionset ~= nil then 
        functionset.ArgumentTable = functionset.ArgumentTable or { Dummy = "dummy" }
        if type(functionset.ArgumentTable) == "table" and type(functionset.Function) == "function" then
          --clear current orders 
          Utils.Do(AIGroup.Actors, function(a) if not a.IsDead then a.Stop() end end)
          
          functionset.ArgumentTable.Actors = AIGroup.Actors
          functionset.ArgumentTable.PlayerName = playername
          functionset.ArgumentTable.ActorGroupName = actorgroupname
          functionset.ArgumentTable.StatusOnSuccess = math.modf(AIGroup.Status) + 1
          functionset.Function(functionset.ArgumentTable) -- execute function
        else
          UpdateAIGroupStatus(playername, actorgroupname, -3)
        end
      else -- Lst function completed and nothing to do: disband
        UpdateAIGroupStatus(playername, actorgroupname, -3)
      end
    else -- Nothing to do: disband
      UpdateAIGroupStatus(playername, actorgroupname, -3)
    end
  end
  
  ---- (Positive non-integer) Executing Function in progress  
  if AIGroup.Status > 0 then
    local AllDead = true
    Utils.Do(AIGroups[playername][actorgroupname].Actors, function(actor) if not actor.IsDead then AllDead = false end end)
    if AllDead then
      AIGroups[playername][actorgroupname].Actors = { }
      UpdateAIGroupStatus(playername, actorgroupname, 0)
    end          
  end
  
  Trigger.AfterDelay(Utils.RandomInteger(missionAITeamControlDelay.low, missionAITeamControlDelay.high), function() 
    AISingleTeamControl (playername, actorgroupname) 
  end)
end


function UpdateAIGroupStatus(playername,actorgroupname, newstatus)
  AddDebugString("UpdateAIGroupStatus("..playername..","..actorgroupname..","..newstatus..") called")
  
  local AIGroup = AIGroups[playername][actorgroupname]
  AIGroup.Status = newstatus
  
  --special logic for activation of certain statuses
  if newstatus == -1 then -- I am ready to fill the group!
    for _,t in pairs(AIGroup.TeamTypes) do
      table.insert(AIGroup.PendingTypes, t)
      table.insert(PendingTypesForProduction[playername], { type = t, aigroup = AIGroup }) 
    end
  elseif newstatus == -3 then 
    Utils.Do(AIGroup.Actors, function(actor) 
      if not actor.IsDead then 
        actor.Stop()
        table.insert (AIGroups[playername]["Pool"].Actors, actor) 
      end 
    end)
    AIGroup.Actors = { }
    UpdateAIGroupStatus(playername, actorgroupname, 0)
  elseif newstatus == 0 then -- Perform update of teams and functions if status is changed to 0
    AIGroup.TeamTypes = clone(AITeams[playername][actorgroupname]) 
    AIGroup.Functions = clone(AIFunctions[playername][actorgroupname])
    AIGroup.Conditions = clone(AIConditions[playername][actorgroupname])
    AIGroup.PendingTypes = { }
    
    for i = 1,#PendingTypesForProduction[playername] do
      if PendingTypesForProduction[playername][i] ~= nil and PendingTypesForProduction[playername][i].aigroup == AIGroup then
        RemoveOnceFromList(PendingTypesForProduction[playername], PendingTypesForProduction[playername][i])
      else 
        i = i + 1 
      end
    end
  elseif newstatus > 0 then -- Flush pending types (needed due to defence teams taking and returning actors with impunity
    AIGroup.PendingTypes = { }
    for i = 1,#PendingTypesForProduction[playername] do
      if PendingTypesForProduction[playername][i] ~= nil and PendingTypesForProduction[playername][i].aigroup == AIGroup then
        RemoveOnceFromList(PendingTypesForProduction[playername], PendingTypesForProduction[playername][i])
      else 
        i = i + 1 
      end
    end    
  end
  return
end

function AITeamCheckPrerequisite (playername, table) -- return true if pass
  AddDebugString("AITeamCheckPrerequisite("..playername..", "..#table.." in table) called")

  local apts = Utils.Where(ActiveProductionTable, function(apt)
    return apt.factory.Owner.Name == playername
  end)

  if apts == nil then return false end

  local result = true
  local alreadychecked = {} -- record for things already checked to reduce processing time

  Utils.Do(table, function(k)
    if result == false then return end
    if alreadychecked[k] then return end

    local result2 = false
    local aptalreadychecked = {}
    
    Utils.Do(apts, function(apt)
      if aptalreadychecked[apt.factory.Type] then return end
      if apt.types == nil then  -- ConYards do not define types.
        aptalreadychecked[apt.factory.Type] = true
        return 
      end
      Utils.Do(apt.types, function(tt)
        if tt.type == k then
          if CheckPrerequisites(apt.factory.Owner, tt.prereq) then 
            result2 = true 
          end
          alreadychecked[k] = true
          aptalreadychecked[apt.factory.Type] = true
        end
      end)
    end)
    result = result2
  end)

  return result

end


function AIReservedTeamControl ()
  AddDebugString("AIReservedTeamControl() called")
  ------ Reserved Logic: Hunt if Pool exceeds PooltoHuntThreshold
  for playername,_ in pairs(AIGroups) do 
    PooltoHuntThreshold[playername] = PooltoHuntThreshold[playername] or 10
    AISingleReservedTeamControl (playername)
  end
end
  
function AISingleReservedTeamControl (playername) 
  local PoolGroup = AIGroups[playername]["Pool"]
  local HuntGroup = AIGroups[playername]["Hunt"]
  if #PoolGroup.Actors > PooltoHuntThreshold[playername] then
    -- Set hunting action
    --HuntingPath(PoolGroup.Actors, playername)
    --Utils.Do(PoolGroup.Actors, function(a) if not a.IsDead then a.Kill() end end)
    Utils.Do(PoolGroup.Actors, function(a) ForceHunt(a) end)
    
    HuntGroup.Actors = HuntGroup.Actors or { }
    
    -- transfer to Hunt group
    Utils.Do(PoolGroup.Actors, function(actor) table.insert (HuntGroup.Actors, actor) end)
    
    --clear Pool
    PoolGroup.Actors = { }
  end
  
  Trigger.AfterDelay(Utils.RandomInteger(missionAIReservedTeamControlDelay.low, missionAIReservedTeamControlDelay.high), function() 
    AISingleReservedTeamControl (playername) 
  end)
end


function AIReservedDefence (playername, attacker)
  AddDebugString("AIReservedDefence() called")

  if attacker.IsDead then return end

  local defenders = 2 -- to customize?
  local allylist = { Houses[playername].Player }
  if AllyDefendToProtect then allylist = Houses[playername].Allies end
  
  -- include allies
  Utils.Do(allylist, function(ally)   
    local allyname = ally.Name
    local PoolGroup = AIGroups[allyname]["Pool"]
    local DefGroup = AIGroups[allyname]["Defence"]

    ------ Reserved Logic: Send Pool to Defence if a Protect unit or Structure gets attacked.
    for _,actor in ipairs(PoolGroup.Actors) do
    
    --Utils.Do(PoolGroup.Actors, function(actor) 
      if defenders == 0 then return end
      if not actor.IsInWorld then return end
      --if not IsPartOfGrouping(actor.Type, "Protectors") then return end
      if actor.IsDead then
        RemoveFromList(PoolGroup.Actors, actor)
        return
      end
      
      if not actor.CanTarget(attacker) then return end
      
      defenders = defenders - 1
      local currposition = actor.Location
      actor.Stop()
      actor.Guard(attacker)
      Trigger.OnKilled(attacker, function() -- the attacker is dead
        if not actor.IsDead then
          table.insert (PoolGroup.Actors, actor)
          actor.Stop()
          actor.Move(currposition, 3) -- return to former position
        end
        RemoveFromList(DefGroup.Actors, actor)        
      end)      
      table.insert (DefGroup.Actors, actor)
      RemoveFromList(PoolGroup.Actors, actor)
    end
    
  if defenders == 0 then return end
    for actorgroupname,_ in pairs(AITeams[allyname]) do 
      if actorgroupname == "Pool" or actorgroupname == "Hunt" or actorgroupname == "Defence" or actorgroupname == "DefenceEscort" then 
      else
        local AIGroup = AIGroups[allyname][actorgroupname]      
        -- check status
        if AIGroup.Status == -1 or AIGroup.Status == -2 then
          
          Utils.Do(AIGroup.Actors, function(actor) 
            if defenders == 0 then return end
            if not IsPartOfGrouping(actor.Type, "Protectors") then return end
            if actor.IsDead then
              RemoveFromList(AIGroup.Actors, actor)
              return
            end
            
            if not actor.CanTarget(attacker) then return end
            
            defenders = defenders - 1
            local currposition = actor.Location
            actor.Stop()
            actor.Guard(attacker)
            Trigger.OnKilled(attacker, function() -- the attacker is dead
              -- if the team is executing its script by then, leave them be.
              --if AIGroup.Status == -1 or AIGroup.Status == -2 then
                if not actor.IsDead then
                  if AIGroup.Status == -1 or AIGroup.Status == -2 then
                    table.insert (AIGroup.Actors, actor)
                  else
                    -- Return to Pool
                    table.insert (PoolGroup.Actors, actor)
                  end
                  actor.Stop()
                  actor.Move(currposition, 3) -- return to former position
                end
              RemoveFromList (DefGroup.Actors, actor)
              --end
            end)
            Trigger.OnKilled(actor, function() -- the actor is dead, pay respects and kindly ask for rebuild
              -- if attacker is dead, the function above as already fired
              if not attacker.IsDead then
                -- rebuild
                table.insert (AIGroup.PendingTypes, actor.Type)
                table.insert (PendingTypesForProduction[playername], { type = actor.Type, aigroup = AIGroup })
                RemoveFromList (DefGroup.Actors, actor)
              end
            end)            
            table.insert (DefGroup.Actors, actor)
            RemoveFromList(AIGroup.Actors, actor)
          end) 
        end
      end
    end
  end)
end


-- Pool functions
function AddActorToPool(actor) 
  AddDebugString("AddActorToPool(actor of type"..actor.Type..") called") 

  -- exempt units:
  if IsPartOfGrouping(actor.Type, "Harvesters") then return end
  
  -- special logic for dog and aircraft
  if IsPartOfGrouping(actor.Type, "AttackAnythingOnBuild") then actor.Stance = "AttackAnything" end
  
  -- setup tables
  AIGroups[actor.Owner.Name] = AIGroups[actor.Owner.Name] or { }
  AIGroups[actor.Owner.Name].Pool = AIGroups[actor.Owner.Name].Pool or { }
  
  -- Add to pool
  table.insert(AIGroups[actor.Owner.Name].Pool.Actors, actor) 
end


function GrabActorFromPool (actortype, playername, targettable) -- return true if successful
  AddDebugString("GrabActorFromPool("..actortype..", "..playername..") called")
  
  local PoolGroupActors = AIGroups[playername].Pool.Actors
  for k,v in pairs(PoolGroupActors) do
    if v.Type == actortype then 
      targettable = targettable or { }
      local actor = PoolGroupActors[k]
      table.insert(targettable, actor)
      PoolGroupActors[k] = nil 
      return true
    end
  end 
  return false
end


-- Actor commands
function HuntingPath (units, playername)
  AddDebugString("HuntingPath("..#units.." units, player = "..playername..") called")
  
  local currentwaypoint = Utils.Random(AIHuntInitialWaypoints[playername])
  if currentwaypoint == nil then currentwaypoint = Utils.Random(Waypoints) end
  local path = { } 
  table.insert(path, currentwaypoint.Location)
  local str = ""
  for i = 1, 20 do
    -- Long string lags the game
    --str = str.. "  ("..currentwaypoint.Location.X..","..currentwaypoint.Location.Y..") " end
    local nextwaypointset = GetNextWaypointSet(currentwaypoint)
    if #nextwaypointset == 1 then currentwaypoint = nextwaypointset[1]
    elseif #nextwaypointset > 1 then
      
      --RemoveFromList(nextwaypointset, currentwaypoint)
      for k,v in pairs(nextwaypointset) do
        if v.Location.X == currentwaypoint.Location.X and v.Location.Y == currentwaypoint.Location.Y then 
          nextwaypointset[k] = nil 
        end
      end    
      currentwaypoint = Utils.Random(nextwaypointset)
    else currentwaypoint = Utils.Random(Waypoints)
    end
    table.insert(path, currentwaypoint.Location)
  end
  
  Utils.Do(units, function(unit)
    if unit.IsDead then return end
    if not unit.IsInWorld then return end
    if IsPartOfGrouping (unit.Type, "AircraftUnits") then 
      AircraftAttackMove(unit, path, 8, 100, true)
    else    
      GroundAttackMove(unit, path, 4, 50, true)
    end
  end)
end

function AircraftAttackMove (a, path, closeenough, checkdelay, cyclic)  
  AddDebugString("AircraftAttackMove() called")
	if a.IsDead then return end
  if not a.IsInWorld then return end
 
  local i = 1
  local exwaypoints = { } -- for expanded waypoints
  
  for j = 1,#path do
    if closeenough > 1 then
      for cl = 1, closeenough do
        if cl > 1 then	-- ignore first expansion
          exwaypoints[j] = Utils.ExpandFootprint({path[j]}, false)
        end
      end
    else
      exwaypoints[j] = { path[j] }		
    end
  end
 
  if a.AmmoCount() == 0 then
    a.Stop()
    a.ReturnToBase()
    AircraftReloadRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
  else
    a.Stop()
    a.AttackMove(path[i], closeenough)
    AircraftAttackRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
  end
end

function AircraftMove (a, path, closeenough, checkdelay, cyclic)
  AddDebugString("AircraftMove() called")
	if a.IsDead then return end
  --if not a.IsInWorld then return end
 
  local i = 1
  local exwaypoints = { } -- for expanded waypoints
  
  for j = 1,#path do
    if closeenough > 1 then
      for cl = 1, closeenough do
        if cl > 1 then	-- ignore first expansion
          exwaypoints[j] = Utils.ExpandFootprint({path[j]}, false)
        end
      end
    else
      exwaypoints[j] = { path[j] }		
    end
  end
 
    a.Stop()
    a.Move(path[i], closeenough)
    AircraftMoveRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
end

function AircraftReloadRefresh (a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
  AddDebugString("AircraftReloadRefresh() called")
  Trigger.AfterDelay(checkdelay * 10, function()
    if a.IsDead then return end
    --if not a.IsInWorld then return end
    if a.AmmoCount() == 0 then    
      -- why are you not loading?
      a.Stop()
      a.AttackMove(path[i], closeenough)    
      --AircraftAttackRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
      --I give up on you, just don't jam the airfield / helipad
      AircraftReloadRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
    elseif a.AmmoCount() ~= a.MaximumAmmoCount() then
      AircraftReloadRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
    else
      a.Stop()
      a.AttackMove(path[i], closeenough)
      AircraftAttackRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
    end 
  end)
end

function AircraftMoveRefresh (a, path, closeenough, checkdelay, exwaypoints, i, cyclic)  
  AddDebugString("AircraftMoveRefresh() called")
  Trigger.AfterDelay(checkdelay, function()
    if a.IsDead then return end
    local reachdest = false
    --Utils.Do(exwaypoints[i], function(wp)
    --  if a.Location == wp then reachdest = true end
    --end)
    
    --if reachdest then 
      i = i + 1
      if i > #path then
        if cyclic then 
          i = 1
        else
          return
        end
      end
    --end
    
    a.Stop()
    a.Move(path[i], closeenough)
    AircraftMoveRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
  end)
end

function AircraftAttackRefresh (a, path, closeenough, checkdelay, exwaypoints, i, cyclic)  
  AddDebugString("AircraftAttackRefresh() called")
  Trigger.AfterDelay(checkdelay, function()
    if a.IsDead then return end
    local reachdest = false
    --Utils.Do(exwaypoints[i], function(wp)
    --  if a.Location == wp then reachdest = true end
    --end)
    
    --if reachdest then 
      i = i + 1
      if i > #path then
        if cyclic then 
          i = 1
        else
          return
        end
      end
    --end
    
    if a.AmmoCount() == 0 then
      a.Stop()
      a.ReturnToBase()
      AircraftReloadRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
    else
      a.Stop()
      a.AttackMove(path[i], closeenough)
      AircraftAttackRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
    end
  end)
end

function GroundAttackMove (a, path, closeenough, delay, cyclic, waitforgroup, noattack) -- waitforgroup: Actor[] or false, noattack: use move instead of attack
  AddDebugString("GroundAttackMove() called")
	if a.IsDead then return end
  
  local i = 1
  local stop = false
  local exwaypoints = { } -- for expanded waypoints
  
  for j = 1,#path do
    if closeenough > 1 then
      for cl = 1, closeenough do
        if cl > 1 then	-- ignore first expansion
          exwaypoints[j] = Utils.ExpandFootprint({path[j]}, false)
        end
      end
    else
      exwaypoints[j] = { path[j] }		
    end
  end
  
  if not a.IsDead then
    a.Scatter()
    Trigger.OnIdle(a, function()
      if stop then
        return
      end

      local reachdest = false
      Utils.Do(exwaypoints[i], function(wp)
        if a.Location == wp then reachdest = true end
      end)
      
      if reachdest then 
        local bool = false
        if waitforgroup then
          bool = Utils.All(waitforgroup, function(actor)
            if actor.IsDead then return true end
            return actor.IsIdle
          end)
        else
          bool = a.IsDead or a.IsIdle
        end
        if bool then
          stop = true
          i = i + 1
          if i > #path then
            if cyclic then 
              i = 1
            else
              return
            end
          end

          Trigger.AfterDelay(delay, function() stop = false end)
        end
      else
        if noattack or not a.HasProperty("AttackMove") then
          a.Move(path[i], closeenough)
        else
          a.AttackMove(path[i], closeenough)
        end
        Trigger.AfterDelay(delay, function() if not a.IsDead then a.Stop() end end)
      end
    end)
  end
end


-- Simple hunts. WARNING: Aircraft cannot use Hunt()!
function ForceHunt (a)
  AddDebugString("ForceHunt("..a.Type..") called")

  if a.IsDead or not a.IsInWorld then return end

  -- Aircraft Hunt will crash the game even in pcall mode (won't crash lua)
  if not IsPartOfGrouping(a.Type,"AircraftUnits") then -- Because they have Aircraft instead of Mobile trait
    Trigger.OnIdle(a, function(a)
      if a.IsInWorld then
        a.Hunt()
      end
    end)
  else
    local enemies = Utils.Where(Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(a) return true end), 
      function(e) return not a.Owner.IsAlliedWith(e.Owner) and e.HasProperty("Health") and a.CanTarget(e) end)
    local target = Utils.Random(enemies)
    if a.HasProperty("Guard") then
      if not a.IsDead then 
        if a.IsInWorld then
          a.Guard(target)
        end
      end
    end    
    
    Trigger.AfterDelay(DateTime.Seconds(10), function() ForceHunt(a) end)
  end

      -- aircraft fares badly with OnIdle...
  
--  local enemies = { }
--  Utils.Do(ActorRegistry, function(actorset)
--    Utils.Do(actorset, function(actor)
      
--      if a.CanTarget(actor) then
--        if actor.HasProperty("Health") then
--          if a.Owner.IsAlliedWith(actor.Owner) then
--            table.insert(enemies, actor)
--          end
--        end
--      end
      
--    end)
--  end)
  
--  local target = Utils.Random(enemies)
--  if a.HasProperty("Guard") then
  --Trigger.OnIdle(a, function()
--    if not a.IsDead then 
--      if a.IsInWorld then
--        a.Guard(target)
--      end
--    end
--    --end)
--  end
  
--  Trigger.AfterDelay(DateTime.Seconds(10), function() ForceHunt(a) end)
  --)
end

function ForceAttack (a, target) -- returns true if order is made successfully
  AddDebugString("ForceAttack() called")
  local success = false
  --if a.HasProperty("Attack") then
  if not a.IsDead and not target.IsDead then 
    if a.IsInWorld and target.IsInWorld then
      if a.CanTarget(target) then 
        a.Stop()
        a.Attack(target, true, true) 
        success = true
      end
    end
  end
  --end

  return success
end

function ForceGuard (a, target) -- returns true if order is made successfully
  AddDebugString("ForceGuard() called")
  local success = false
  if a.HasProperty("Guard") then
    Trigger.OnIdle(a, function()
      if not a.IsDead and not target.IsDead then 
        if a.IsInWorld and target.IsInWorld then
          a.Stop()
          a.Guard(target) 
          success = true
        end
      end
    end)
  end

  return success
end

	

