-----------------------------------------------------------------------------------------------------------------------
------------------ LUA SCRIPTS FOR MISSION CONTROL AND AI IMPLEMENTATION
---------------------- by lovalmidas
-----------------------------------------------------------------------------------------------------------------------
-- AI SCRIPT FUNCTIONS LUA  VERSION 1.001 - 2017.03.22.0
-- #11
------ Contains:  
---------- AI script function utilities to communicate with AI teams
-------------- UpdateSurvivors(table ArgumentTable)
-------------- ApplyStatusOnSuccess(table ArgumentTable)
-------------- ApplyStatusOnDefeat(table ArgumentTable)
---------- Script Function repository
-------------- ScriptFn_AircraftCompatibleAttackMovementPath(table ArgumentTable)     ~ aircraft compatible
-------------- ScriptFn_AircraftCompatibleMovementPath(table ArgumentTable)           ~ aircraft compatible
-------------- ScriptFn_AttackMovementPath(table ArgumentTable)                       -> if aircraft present, fire ScriptFn_AircraftCompatibleAttackMovementPath instead
-------------- ScriptFn_MovementPath(table ArgumentTable)                             -> if aircraft present, fire ScriptFn_AircraftCompatibleMovementPath instead
-------------- ScriptFn_Wait(table ArgumentTable)                                     ~ aircraft compatible
-------------- ScriptFn_Hunt(table ArgumentTable)                                     X aircraft incompatible: aircraft does not respond ( to test again with amended ForceHunt())
-------------- ScriptFn_AttackActor(table ArgumentTable)                              X aircraft incompatible: aircraft does not respond. Can be used to attack friendlies as well.
-------------- ScriptFn_GuardActor(table ArgumentTable)                               ~ aircraft compatible. Guard 'works' on enemy units as well.
-------------- ScriptFn_LoadInTransport(table ArgumentTable)                          
-------------- ScriptFn_UnloadAllTransports(table ArgumentTable)                      WIP
-------------- ScriptFn_Deploy(table ArgumentTable)                                   WIP
-------------- ScriptFn_Infiltrate(table ArgumentTable)                               WIP
-------------- ScriptFn_Capture(table ArgumentTable)                                  WIP




------ AIFunctions[playername][actorgroupname][status] = { Function, ArgumentTable }
--
-- ArgumentTable elements:
------ Actors (auto: AIActorGroup[playername][actorgroupname])
------ PlayerName (auto: playername)
------ ActorGroupName (auto: actorgroupname)
------ StatusOnSuccess (auto: status + 1)
------ Any other function defined by user in ArgumentTable

function UpdateSurvivors (ArgumentTable) -- returns ArgumentTable with updated ArgumentTable.Actors
  
  if type(ArgumentTable) ~= "table" then return { } end

  local SurvivingActors = { }
  Utils.Do(ArgumentTable.Actors, function(unit)
    if unit.IsDead then return end
    if not unit.IsInWorld then return end
    table.insert(SurvivingActors, unit)
  end)

  ArgumentTable.Actors = SurvivingActors
  AIGroups[ArgumentTable.PlayerName][ArgumentTable.ActorGroupName].Actors = SurvivingActors

  return ArgumentTable
end

function ApplyStatusOnSuccess (ArgumentTable)
  ArgumentTable = UpdateSurvivors(ArgumentTable)  
  Utils.Do(ArgumentTable.Actors, function(unit)
    Trigger.ClearAll(unit)
  end)
  AIGroups[ArgumentTable.PlayerName][ArgumentTable.ActorGroupName].Status = ArgumentTable.StatusOnSuccess
end


function ApplyStatusOnDefeat (ArgumentTable)
  ArgumentTable = UpdateSurvivors(ArgumentTable)
  Utils.Do(ArgumentTable.Actors, function(unit)
    Trigger.ClearAll(unit)
  end)
  AIGroups[ArgumentTable.PlayerName][ArgumentTable.ActorGroupName].Status = -3 -- Disband
end


function ScriptFn_AircraftCompatibleAttackMovementPath (ArgumentTable) -- Use the same behaviour as used by the Hunt AI team, except you define the path instead.
-- ArgumentTable parameters required: CPos[] Path, int CloseEnough = 3, int Delay = 25 (in ticks), bool Cyclic = false
-- Termination function! There will be no ApplyStatusOnSuccess
  AddDebugString("Script Function ScriptFn_AircraftCompatibleAttackMovementPath() called by ".. ArgumentTable.PlayerName .."." .. ArgumentTable.ActorGroupName)
  
  ArgumentTable = UpdateSurvivors(ArgumentTable)
  if ArgumentTable.Path == nil then return end
  if ArgumentTable.CloseEnough == nil then ArgumentTable.CloseEnough = 3 end
  if ArgumentTable.Delay == nil then ArgumentTable.Delay = 25 end
  if ArgumentTable.Cyclic == nil then ArgumentTable.Cyclic = true end

  if #ArgumentTable.Actors == 0 then 
    ApplyStatusOnDefeat(ArgumentTable)
    return
  end
  Trigger.OnAllKilled(ArgumentTable.Actors, function() ApplyStatusOnDefeat(ArgumentTable) end)

  Utils.Do(ArgumentTable.Actors, function(unit)
    if unit.IsDead then return end
    if not unit.IsInWorld then return end
    
    -- Air units have different logic due to limitations from having different Traits.
    if IsPartOfGrouping (unit.Type, "AircraftUnits") then 
      AircraftAttackMove(unit, ArgumentTable.Path, ArgumentTable.CloseEnough, ArgumentTable.Delay, ArgumentTable.Cyclic)
    else    
      GroundAttackMove(unit, ArgumentTable.Path, ArgumentTable.CloseEnough, ArgumentTable.Delay, ArgumentTable.Cyclic)
    end
  end)
end


function ScriptFn_AircraftCompatibleMovementPath (ArgumentTable)
-- ArgumentTable parameters required: CPos[] Path, int CloseEnough = 3, int Delay = 25 (in ticks), bool Cyclic = false
-- Termination function! There will be no ApplyStatusOnSuccess
  AddDebugString("Script Function ScriptFn_AircraftCompatibleMovementPath() called by ".. ArgumentTable.PlayerName .."." .. ArgumentTable.ActorGroupName)
  
  ArgumentTable = UpdateSurvivors(ArgumentTable)
  if ArgumentTable.Path == nil then return end
  if ArgumentTable.CloseEnough == nil then ArgumentTable.CloseEnough = 3 end
  if ArgumentTable.Delay == nil then ArgumentTable.Delay = 25 end
  if ArgumentTable.Cyclic == nil then ArgumentTable.Cyclic = true end

  if #ArgumentTable.Actors == 0 then 
    ApplyStatusOnDefeat(ArgumentTable)
    return
  end
  Trigger.OnAllKilled(ArgumentTable.Actors, function() ApplyStatusOnDefeat(ArgumentTable) end)

  Utils.Do(ArgumentTable.Actors, function(unit)
    if unit.IsDead then return end
    if not unit.IsInWorld then return end
    
    -- Air units have different logic due to limitations from having different Traits.
    if IsPartOfGrouping (unit.Type, "AircraftUnits") then 
      AircraftMove(unit, ArgumentTable.Path, ArgumentTable.CloseEnough, ArgumentTable.Delay, ArgumentTable.Cyclic)
    else    
      GroundMove(unit, ArgumentTable.Path, ArgumentTable.CloseEnough, ArgumentTable.Delay, ArgumentTable.Cyclic)
    end
  end)
end


function ScriptFn_AttackMovementPath (ArgumentTable)
-- ArgumentTable parameters required: CPos[] Path, int CloseEnough = 3, int Delay = 25 (in ticks), bool Cyclic = false, bool WaitForGroup
-- Not applicable for aircraft!
  AddDebugString("Script Function AttackMovementPath() called by ".. ArgumentTable.PlayerName .."." .. ArgumentTable.ActorGroupName)

  -- if aircraft detected, use ScriptFn_AircraftCompatibleAttackMovementPath instead
  local hasAircraft = false
  Utils.Do(ArgumentTable.Actors, function(unit)
    if IsPartOfGrouping (unit.Type, "AircraftUnits") then 
      hasAircraft = true
    end 
  end)

  if hasAircraft then
    ScriptFn_AircraftCompatibleAttackMovementPath (ArgumentTable) -- there is at least one aircraft, change function
  else
    ArgumentTable = UpdateSurvivors(ArgumentTable)
    if ArgumentTable.Path == nil then return end
    if ArgumentTable.CloseEnough == nil then ArgumentTable.CloseEnough = 3 end
    if ArgumentTable.Delay == nil then ArgumentTable.Delay = 25 end
    if ArgumentTable.Cyclic == nil then ArgumentTable.Cyclic = false end

    if #ArgumentTable.Actors == 0 then 
      ApplyStatusOnDefeat(ArgumentTable)
      return
    end
    Trigger.OnAllKilled(ArgumentTable.Actors, function() ApplyStatusOnDefeat(ArgumentTable) end)

    Utils.Do(ArgumentTable.Actors, function(unit)
      if unit.IsDead then return end
      if not unit.IsInWorld then return end
    
      local i = 1
      local stop = false
      local exwaypoints = { } -- for expanded waypoints
    
      for j = 1,#ArgumentTable.Path do
        if ArgumentTable.CloseEnough > 1 then
          for cl = 1, ArgumentTable.CloseEnough do
            if cl > 1 then	-- ignore first expansion
              exwaypoints[j] = Utils.ExpandFootprint({ArgumentTable.Path[j]}, false)
            end
          end
        else
          exwaypoints[j] = { ArgumentTable.Path[j] }		
        end
      end
      
      if not unit.IsDead then
        Trigger.OnIdle(unit, function()
          if stop then
            return
          end

          local reachdest = false
          Utils.Do(exwaypoints[i], function(wp)
            if unit.Location == wp then reachdest = true end
          end)
          
          if reachdest then 
            local bool = false
            if ArgumentTable.WaitForGroup then
              bool = Utils.All(ArgumentTable.Actors, function(actor)
                if actor.IsDead then return true end
                return actor.IsIdle
              end)
            else
              bool = unit.IsDead or unit.IsIdle
            end         
            if bool then
              stop = true
              i = i + 1
              if i > #ArgumentTable.Path then
                if ArgumentTable.Cyclic then 
                  i = 1
                else
                  ApplyStatusOnSuccess(ArgumentTable)
                end
              end

              Trigger.AfterDelay(ArgumentTable.Delay, function() stop = false end)
            end
          else
            unit.AttackMove(ArgumentTable.Path[i], ArgumentTable.CloseEnough)
          end
        end)
      end
    end)
  end
end


function ScriptFn_MovementPath (ArgumentTable)
-- ArgumentTable parameters required: CPos[] Path, int CloseEnough = 3, int Delay = 25 (in ticks), bool Cyclic = false, bool WaitForGroup
-- Not applicable for aircraft!
  AddDebugString("Script Function MovementPath() called by ".. ArgumentTable.PlayerName .."." .. ArgumentTable.ActorGroupName)

  ArgumentTable = UpdateSurvivors(ArgumentTable)
  if ArgumentTable.Path == nil then return end
  if ArgumentTable.CloseEnough == nil then ArgumentTable.CloseEnough = 3 end
  if ArgumentTable.Delay == nil then ArgumentTable.Delay = 25 end
  if ArgumentTable.Cyclic == nil then ArgumentTable.Cyclic = false end

  -- if aircraft detected, use ScriptFn_AircraftCompatibleMovementPath instead
  local hasAircraft = false
  Utils.Do(ArgumentTable.Actors, function(unit)
    if IsPartOfGrouping (unit.Type, "AircraftUnits") then 
      hasAircraft = true
    end 
  end)

  if hasAircraft then
    ScriptFn_AircraftCompatibleMovementPath (ArgumentTable)
  else
    if #ArgumentTable.Actors == 0 then 
      ApplyStatusOnDefeat(ArgumentTable)
      return
    end
    Trigger.OnAllKilled(ArgumentTable.Actors, function() ApplyStatusOnDefeat(ArgumentTable) end)

    Utils.Do(ArgumentTable.Actors, function(unit)
      if unit.IsDead then return end
      if not unit.IsInWorld then return end
      
      local i = 1
      local stop = false
      local exwaypoints = { } -- for expanded waypoints
      
      for j = 1,#ArgumentTable.Path do
        if ArgumentTable.CloseEnough > 1 then
          for cl = 1, ArgumentTable.CloseEnough do
            if cl > 1 then	-- ignore first expansion
              exwaypoints[j] = Utils.ExpandFootprint({ArgumentTable.Path[j]}, false)
            end
          end
        else
          exwaypoints[j] = { ArgumentTable.Path[j] }		
        end
      end
      
      if not unit.IsDead then
        Trigger.OnIdle(unit, function()
          if stop then
            return
          end

          local reachdest = false
          Utils.Do(exwaypoints[i], function(wp)
            if unit.Location == wp then reachdest = true end
          end)
          
          if reachdest then 
            local bool = false
            if ArgumentTable.WaitForGroup then
              bool = Utils.All(ArgumentTable.Actors, function(actor)
                if actor.IsDead then return true end
                return actor.IsIdle
              end)
            else
              bool = unit.IsDead or unit.IsIdle
            end          
            if bool then
              stop = true
              i = i + 1
              if i > #ArgumentTable.Path then
                if ArgumentTable.Cyclic then 
                  i = 1
                else
                  ApplyStatusOnSuccess(ArgumentTable)
                end
              end

              Trigger.AfterDelay(ArgumentTable.Delay, function() stop = false end)
            end
          else
            unit.Move(ArgumentTable.Path[i], ArgumentTable.CloseEnough)
          end
        end)
      end
    end)
  end
end


function ScriptFn_Wait (ArgumentTable)
-- ArgumentTable parameters required: int Delay = 25 (in ticks) or function Condition that returns bool.
  AddDebugString("Script Function ScriptFn_Wait() called by ".. ArgumentTable.PlayerName .."." .. ArgumentTable.ActorGroupName)
  
  ArgumentTable = UpdateSurvivors(ArgumentTable)
  if ArgumentTable.Delay == nil then ArgumentTable.Delay = 25 end

  if #ArgumentTable.Actors == 0 then 
    ApplyStatusOnDefeat(ArgumentTable)
    return
  end
  Trigger.OnAllKilled(ArgumentTable.Actors, function() ApplyStatusOnDefeat(ArgumentTable) end)

  Utils.Do(ArgumentTable.Actors, function(unit)
    if unit.IsDead then return end
    if not unit.IsInWorld then return end
    
    unit.Wait(ArgumentTable.Delay)    
  end)

  -- if a condition is not specified, complete after Delay
  if ArgumentTable.Condition ~= false then
    ApplyStatusOnSuccess(ArgumentTable)
  else
    Trigger.AfterDelay(ArgumentTable.Delay, ScriptFn_Wait(ArgumentTable))
  end
end


function ScriptFn_Hunt (ArgumentTable)
-- ArgumentTable parameters required: none
-- Termination function! There will be no ApplyStatusOnSuccess
  AddDebugString("Script Function ScriptFn_Hunt() called by ".. ArgumentTable.PlayerName .."." .. ArgumentTable.ActorGroupName)
  
  ArgumentTable = UpdateSurvivors(ArgumentTable)

  if #ArgumentTable.Actors == 0 then 
    ApplyStatusOnDefeat(ArgumentTable)
    return
  end
  Trigger.OnAllKilled(ArgumentTable.Actors, function() ApplyStatusOnDefeat(ArgumentTable) end)

  Utils.Do(ArgumentTable.Actors, function(unit)
    if unit.IsDead then return end
    if not unit.IsInWorld then return end
    
    ForceHunt(unit)  
  end)
end

function ScriptFn_AttackActor (ArgumentTable)
-- ArgumentTable parameters required: Actor Target.
  AddDebugString("Script Function ScriptFn_AttackActor() called by ".. ArgumentTable.PlayerName .."." .. ArgumentTable.ActorGroupName)
  
  ArgumentTable = UpdateSurvivors(ArgumentTable)

  if #ArgumentTable.Actors == 0 then 
    ApplyStatusOnDefeat(ArgumentTable)
    return
  end
  Trigger.OnAllKilled(ArgumentTable.Actors, function() ApplyStatusOnDefeat(ArgumentTable) end)

  if ArgumentTable.Target == nil or ArgumentTable.Target.IsDead then 
    ApplyStatusOnSuccess(ArgumentTable) 
    return
  end
  
  Utils.Do(ArgumentTable.Actors, function(unit)
    if unit.IsDead then return end
    if not unit.IsInWorld then return end
    
    ForceAttack(unit, ArgumentTable.Target)
  end)
  Trigger.OnKilled(ArgumentTable.Target, function() -- target destroyed, PLEASE DO NOT ATTACH TO UNIT WITHOUT SCRIPTTRIGGER TRAIT
    ApplyStatusOnSuccess(ArgumentTable)
  end)
end


function ScriptFn_GuardActor (ArgumentTable)
-- ArgumentTable parameters required: Actor Target
  AddDebugString("Script Function ScriptFn_GuardActor() called by ".. ArgumentTable.PlayerName .."." .. ArgumentTable.ActorGroupName)
  
  ArgumentTable = UpdateSurvivors(ArgumentTable)

  if #ArgumentTable.Actors == 0 then 
    ApplyStatusOnDefeat(ArgumentTable)
    return
  end
  Trigger.OnAllKilled(ArgumentTable.Actors, function() ApplyStatusOnDefeat(ArgumentTable) end)

  if ArgumentTable.Target == nil or ArgumentTable.Target.IsDead then 
    ApplyStatusOnSuccess(ArgumentTable) 
    return
  end

  Utils.Do(ArgumentTable.Actors, function(unit)
    if unit.IsDead then return end
    if not unit.IsInWorld then return end
    
    ForceGuard(unit, ArgumentTable.Target)
  end)
  Trigger.OnKilled(ArgumentTable.Target, function() -- treat as 'success' if the target of the guard is destroyed.
    ApplyStatusOnSuccess(ArgumentTable)
  end)
end


function ScriptFn_LoadInTransport (ArgumentTable)
-- ArgumentTable parameters required: Actor TargetType, bool ApplySuccessIfFail = true
-- ArgumentTable parameters optional: Actor[] PassengerTypes. If not present, script will take everyone in the team except TargetType 
-- ApplySuccessIfFail determines whether ApplyStatusOnSuccess is called if load is successful. If false, call ApplyStatusOnDefeat instead.

  ArgumentTable = UpdateSurvivors(ArgumentTable)

  if #ArgumentTable.Actors == 0 then 
    ApplyStatusOnDefeat(ArgumentTable)
    return
  end
  Trigger.OnAllKilled(ArgumentTable.Actors, function() ApplyStatusOnDefeat(ArgumentTable) end)

  
  
  
    
    
  
  
  
  
end