
function PreSetupManualOverride ()
  AddDebugString("PreSetupManualOverride() called")
    
  CameraSets = 
  { 
    { DefaultCameraPosition }
  }

  ------ Player settings -------------------------------------------------------------
    -- InitialCash = the player's initial cash, defaults to 0
    
    -- Bot controls only
    --    BuildTimeMultiplier (default, Structures, Defences, Infantry, Units, Aircraft, Ships), defaults to default, which defaults to 1
    --    CostMultipliers (default, Structures, Defences, Infantry, Units, Aircraft, Ships), defaults to default, which defaults to 1

  -- Human players
  DefaultInitialCash = 0

  -- Soviet Bots
  if Map.LobbyOption("difficulty") == "Hard" then
    AIInitialCash = 25000
    AIBuildTimeMultiplier = { default = 0.8, Ships = 0.9, Aircraft = 0.9, Infantry = 0.9 }
    AICostMultiplier = { default = 0.8 }
  elseif Map.LobbyOption("difficulty") == "Normal" then
    AIInitialCash = 12500
    AIBuildTimeMultiplier = { default = 0.95 }
    AICostMultiplier = { default = 0.9 }
  else
    AIInitialCash = 8000
    AIBuildTimeMultiplier = { default = 1 }
    AICostMultiplier = { default = 1 }
  end

  ------------------------------------------------------------------------------------
  ------ Base settings ---------------------------------------------------------------
    -- IncludeExistingBuildingsInBaseNodes = whether existing buildings should be included in the base node count
    -- ExcludeExistingBuildingWithStringOverride = (string) if the actor's name contains this string, override to exclude the building from the base node list
    
  IncludeExistingBuildingsInBaseNodes = true
  InitialBaseNodes = {
    -- id = name of this entry (for debug, or specific selection only)
    -- owner = the player
    -- type = the actor type
    -- pos = position as { x, y } coordinates 

    -- Example
    -- { id = "A01", owner = Houses["Germany"].Player, type = "powr", pos = { x = 10, y = 12} },
  }
   
  ------------------------------------------------------------------------------------
  ------ AI settings -----------------------------------------------------------------
  AIMaintainExcessPower = 75
  AIStructureHPRepair = 0.9
  AIUnitHPPursuit = 0.9
  AIHarvestersPerRefinery = 2.5
  AILowCashThreshold = 20000
  AIEmergencyCashThreshold = 3500


  PooltoHuntThreshold = { -- Send all units in Pool to the Hunting group if the number of units surpass this threshold
    ["USSR"] = 25,
    ["Turkey"] = 25,
    ["Ukraine"] = 25,
    ["France"] = 25,
    ["England"] = 25,
    ["Germany"] = 25,
  } 

end


function PostSetupManualOverride ()
  AddDebugString("PostSetupManualOverride() called")
  
  missionDisplayPlayer = Player.GetPlayer("Germany") 
  --bdebug = true

end


AIActivated = false
function TickManualOverride()
  
  --local speed = 10
	--local t = (missiontick + 45) % (360 * speed) * (math.pi / 180) / speed;
  --Camera.Position = InitialPosition.CenterPosition + WVec.New(19200 * math.sin(t), 20480 * math.cos(t), 0)
  
  ------------------------------------------------------------------------------------
  ------ AI Team settings ------------------------------------------------------------
  ----------- Define all actor groups and their routes here
  ----------- IMPORTANT: References to lua functions should be placed in PostSetupManualOverride and not as part of initializing global variables.

  -- Teams will be declared by AITeams[player.Name][groupname], filled by AIGroups[player.Name][groupname].Actors over the course of the game, and governed by the AI in AIGroups[player.Name][groupname].Status to perform functions in AIGroups[player.Name][groupname].Functions
  ------ Groups:
  ----------- 
  ----------- [Reserved names, do not touch]
  ----------- Pool                Pool for newly-built and unassigned units. Game will ignore any 'Pool' groupname
  ----------- Defender            Used to counter threats against the enemy when a structure / harvester is under attack (onDamaged). Directly attacks the attacker, then return to base
  ----------- DefenderEscort      WIP
  ----------- Hunt                Used when Pool reaches a certain critical mass.
  ----------- 
  ------ All others can be custom-named.      
  ----------- 
  ------ All Groups will follow the commands given by AIFunctions[player.Name][groupname] , except for the reserved groups which will have their own routes.
  
  if missiontick % 1001 == 0 then -- don't refresh every tick, waste of time
    SetupAITeams()
  end
end



