GetNextWaypointSet = function(waypoint)
  if waypoint == SovRouteTop then return { WaypointAlliesTop, SovRouteBotMid } end
  if waypoint == SovRouteTopMid then return { WaypointAlliesTop, SovRouteBot, SovRouteTopMidMidAll } end
  if waypoint == SovRouteTopMidMidSov then return { SovRouteTopMidMidAll, SovRouteBotMidMidAll, SovRouteBotMidMidSov, SovRouteTopMid } end
  if waypoint == SovRouteBotMidMidSov then return { SovRouteTopMidMidAll, SovRouteBotMidMidAll, SovRouteTopMidMidSov, SovRouteBotMid } end
  if waypoint == SovRouteTopMidMidAll then return { WaypointAlliesMid, SovRouteBotMidMidAll, SovRouteTopMid } end
  if waypoint == SovRouteBotMidMidAll then return { WaypointAlliesMid, SovRouteTopMidMidAll, SovRouteBotMid } end
  if waypoint == SovRouteBotMid then return { WaypointAlliesBot, SovRouteBot, SovRouteBotMidMidAll } end
  if waypoint == SovRouteBot then return { WaypointAlliesBot, SovRouteBotMid } end
  if waypoint == WaypointAlliesTop then return { WaypointAlliesMid, WaypointAlliesBot } end
  if waypoint == WaypointAlliesMid then return { WaypointAlliesTop, WaypointAlliesBot } end
  if waypoint == WaypointAlliesBot then return { WaypointAlliesTop, WaypointAlliesMid } end
  
  if waypoint == AllRouteTop then return { WaypointSovietTop, AllRouteBotMid } end
  if waypoint == AllRouteTopMid then return { WaypointSovietTop, AllRouteBot, AllRouteTopMidMidAll } end
  if waypoint == AllRouteTopMidMidSov then return { WaypointSovietMid, AllRouteBotMidMidSov, AllRouteTopMid } end
  if waypoint == AllRouteBotMidMidSov then return { WaypointSovietMid, AllRouteTopMidMidSov, AllRouteBotMid } end
  if waypoint == AllRouteTopMidMidAll then return { AllRouteTopMidMidSov, AllRouteBotMidMidSov, AllRouteBotMidMidAll, AllRouteTopMid } end
  if waypoint == AllRouteBotMidMidAll then return { AllRouteTopMidMidSov, AllRouteBotMidMidSov, AllRouteTopMidMidAll, AllRouteBotMid } end
  if waypoint == AllRouteBotMid then return { WaypointSovietBot, AllRouteBot, AllRouteBotMidMidAll } end
  if waypoint == AllRouteBot then return { WaypointSovietBot, AllRouteBotMid } end
  if waypoint == WaypointSovietTop then return { WaypointSovietMid, WaypointSovietBot } end
  if waypoint == WaypointSovietMid then return { WaypointSovietTop, WaypointSovietBot } end
  if waypoint == WaypointSovietBot then return { WaypointSovietTop, WaypointSovietMid } end 
  
  return Waypoints
end

AIHuntInitialWaypoints = {
  ["USSR"] = {SovRouteTopMidMidSov, SovRouteBotMidMidSov},
  ["Turkey"] = {SovRouteBot, SovRouteBotMid},
  ["Ukraine"] = {SovRouteTop, SovRouteTopMid},
  ["France"] = {AllRouteBot, AllRouteBotMid},
  ["England"] = {AllRouteTop, AllRouteTopMid},
  ["Germany"] = {AllRouteTopMidMidAll, AllRouteBotMidMidAll},
}


SovietSmallInfantryTeams = { 
  -- Small groups (~$500 per team)
  { "e1", "e1", "e1", "e1", "e1" },   -- 5 e1 $500
  { "e2", "e2", "e2" },               -- 4 e2 $480
  { "e1", "e1", "dog" },              -- 2 e1 1 dog $400
  { "e2", "e2", "dog" },              -- 2 e2 1 dog $520
  { "e3", "e3" },                     -- 2 e3 $600
  { "e4", "e4" },                     -- 2 e4 $600
  { "dog", "dog", "e1" },              -- 1 e1 2 dog $500
}

SovietMediumInfantryTeams = { 
  -- Medium groups (~$1000 per team)
  { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },     -- 10 e1 $1000
  { "e2", "e2", "e2", "e2", "e2", "e2" },                             -- 6 e2 $960
  { "e1", "e1", "e1", "e1", "e2", "e2", "e2", "e2" },                 -- 4 e1 4 e2 $1040
  { "e1", "e1", "e1", "e1", "e3", "e3" },                             -- 4 e1 2 e3 $1000
  { "e3", "e3", "e3", "e3" },                                         -- 4 e3 $1200
  { "e1", "e1", "e1", "e1", "e4", "e4" },                             -- 4 e1 2 e4 $1000
  { "e4", "e4", "e4", "e4" },                                         -- 4 e4 $1200
  { "e3", "e3", "e4", "e4" },                                         -- 2 e3 2 e4 $1200
  { "dog", "dog", "dog", "e2", "e2" },                                -- 2 e2 3 dog $920
  { "dog", "dog", "dog", "e1", "e1", "e1" },                          -- 3 e1 3 dog $900
  -- Add high tech (~$1000-$1500 per team)
  { "shok", "shok", "shok" },                                         -- 3 shok $1200
  { "e1", "e1", "e1", "e1", "shok", "shok" },                         -- 4 e1 2 shok $1200
  { "e2", "e2", "e2", "shok", "shok" },                               -- 3 e2 2 shok $1280
  { "e3", "e3", "shok", "shok" },                                     -- 2 e3 2 shok $1400
  { "e4", "e4", "shok", "shok" },                                     -- 2 e4 2 shok $1400
}

SovietLargeInfantryTeams = { 
  -- Large groups (~$2000 per team)
  { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },                                   -- 15 e1 $1500
  { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },     -- 20 e1 $2000
  { "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2", "e2" },                                                     -- 12 e2 $1920
  { "e1", "e1", "e1", "e1", "e2", "e2", "e2", "e2", "e1", "e1", "e1", "e1", "e2", "e2", "e2", "e2" },                             -- 8 e1 8 e2 $2080
  { "e1", "e1", "e1", "e1", "e3", "e3", "e1", "e1", "e1", "e1", "e3", "e3" },                                                     -- 8 e1 4 e3 $2000
  { "e3", "e3", "e3", "e3", "e3", "e3", "e3" },                                                                                   -- 7 e3 $2100
  { "e1", "e1", "e1", "e1", "e4", "e4", "e1", "e1", "e1", "e1", "e4", "e4" },                                                     -- 8 e1 4 e4 $2000
  { "e4", "e4", "e4", "e4", "e4", "e4", "e4" },                                                                                   -- 7 e4 $2100
  { "e3", "e3", "e4", "e4", "e3", "e3", "e4" },                                                                                   -- 4 e3 3 e4 $2100
  -- Add high tech (~$2000-$2500 per team)
  { "shok", "shok", "shok", "shok", "shok", "shok" },                                                                             -- 6 shok $2400
  { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "shok", "shok", "shok" },                                                     -- 8 e1 3 shok $2000
  { "e2", "e2", "e2", "e2", "e2", "shok", "shok", "shok" },                                                                       -- 5 e2 3 shok $2000
  { "e3", "e3", "e3", "e3", "shok", "shok", "shok" },                                                                             -- 4 e3 3 shok $2400
  { "e4", "e4", "e4", "e4", "shok", "shok", "shok" },                                                                             -- 4 e4 3 shok $2400
  -- Super Expensive (>$3000 per team)  
  { "shok", "shok", "shok", "shok", "shok", "shok", "shok", "shok", "shok", "shok" },                                             -- 10 shok $4000
}

SovietSmallUnitTeams = { 
  -- Small groups (~$1000 per team)
  { "ftrk", "ftrk" },                 -- 2 ftrk $1200
  { "3tnk" },                         -- 1 3tnk $1150
  { "v2rl" },                         -- 1 v2rl $900
}

SovietMediumUnitTeams = { 
  -- Medium groups (~$2000 per team)
  { "ftrk", "ftrk", "ftrk" },                 -- 4 ftrk $1800
  { "3tnk", "ftrk", "ftrk" },                 -- 1 3tnk 2 ftrk $2350
  { "3tnk", "3tnk" },                         -- 2 3tnk $2300
  { "v2rl", "v2rl" },                         -- 2 v2rl $1800
  { "v2rl", "v2rl", "v2rl" },                 -- 3 v2rl $2700
  { "3tnk", "v2rl" },                         -- 1 3tnk 1 v2rl $2050  
  -- Add high tech (~$2500-$3000 per team)
  { "4tnk" },                                 -- 1 4tnk $2000
  { "4tnk", "v2rl" },                         -- 2 3tnk $2900
  { "4tnk", "3tnk" },                         -- 2 3tnk $3150
  { "ttnk", "ttnk" },                         -- 2 ttnk $2700
}

SovietLargeUnitTeams = { -- avoid large groups to avoid clumping! 4 units max
  -- Large groups (~$3000 per team)
  { "ftrk", "ftrk", "ftrk", "ftrk" },         -- 4 ftrk $2400
  { "3tnk", "3tnk", "ftrk", "ftrk" },         -- 2 3tnk 2 ftrk $3500
  { "3tnk", "3tnk", "3tnk", "3tnk" },         -- 4 3tnk $4600
  { "v2rl", "v2rl", "ftrk", "ftrk" },         -- 2 ftrk 2 v2rl $3000
  { "v2rl", "v2rl", "3tnk", "3tnk" },         -- 2 3tnk 2 v2rl $4100
  { "v2rl", "v2rl", "v2rl", "v2rl" },         -- 4 v2rl $3600
  -- Add high tech (~$$4000 per team)
  { "4tnk", "3tnk", "3tnk" },                 -- 1 4tnk 2 3tnk $4300
  { "4tnk", "v2rl", "v2rl" },                 -- 1 4tnk 2 v2rl $3800
  { "4tnk", "4tnk" },                         -- 2 4tnk $4000
  { "4tnk", "ttnk", "ttnk" },                 -- 1 4tnk 2 ttnk $4700
  { "ttnk", "ttnk", "ttnk" },                 -- 3 ttnk $4050
  -- Super Expensive (>$5000 per team)  
  { "4tnk", "3tnk", "3tnk", "3tnk" },         -- 4 3tnk $4600
  { "4tnk", "4tnk", "4tnk" },                 -- 4 4tnk $6000
  { "ttnk", "ttnk", "ttnk", "ttnk" },         -- 4 ttnk $5400
  { "4tnk", "4tnk", "v2rl", "v2rl" },         -- 2 4tnk 2 v2rl $5800
  { "4tnk", "4tnk", "4tnk", "4tnk" },         -- 4 4tnk $8000 (!)
}

SovietHarvesterHunters = { 
  { "e3", "e3", "e3", "e3" },
  { "3tnk", "3tnk" },
  { "ttnk", "ttnk" },
  { "4tnk", "ttnk" },
  { "shok", "shok", "shok" },
}

SovietAirTeamGroups = { 
  { "yak" },
  { "mig" },
  { "yak", "yak" },
  { "mig", "mig" }
}

AlliedSmallInfantryTeams = { 
  -- Small groups (~$500 per team)
  { "e1", "e1", "e1", "e1", "e1" },   -- 5 e1 $500
  { "e1", "e1", "e3" },               -- 2 e1 1 e3 $500
  { "e3", "e3" },                     -- 2 e3 $600
}

AlliedMediumInfantryTeams = { 
  -- Medium groups (~$1000 per team)
  { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },     -- 10 e1 $1000
  { "e1", "e1", "e1", "e1", "e3", "e3" },                             -- 4 e1 2 e3 $1000
  { "e3", "e3", "e3", "e3" },                                         -- 4 e3 $1200
  { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "medi" },         -- 8 e1 1 medi $1000
  { "e3", "e3", "e3", "medi" },                                       -- 3 e3 1 medi $1100
  -- Add high tech (~$1000-$1500 per team)
  { "e7" },                                                           -- 1 tany $1200 -- Do not replicate
}

AlliedLargeInfantryTeams = { 
  -- Large groups (~$2000 per team)
  { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },                                   -- 15 e1 $1500
  { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1" },     -- 20 e1 $2000
  { "e1", "e1", "e1", "e1", "e3", "e3", "e1", "e1", "e1", "e1", "e3", "e3" },                                                     -- 8 e1 4 e3 $2000
  { "e3", "e3", "e3", "e3", "e3", "e3", "e3" },                                                                                   -- 7 e3 $2100
  
  { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "medi" },                                       -- 13 e1 1 medi $1500
  { "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "e1", "medi" },         -- 18 e1 1 medi $2000
  { "e1", "e1", "e1", "e1", "e3", "e3", "e1", "e1", "medi", "e3", "e3" },                                                         -- 6 e1 4 e3 1 medi $2000
  { "e3", "e3", "e3", "e3", "e3", "e3", "medi" },                                                                                 -- 6 e3 1 medi $2000
}

AlliedSmallUnitTeams = { 
  -- Small groups (~$1000 per team)
  { "jeep", "jeep" },                 -- 2 jeep $300
  { "1tnk" },                         -- 1 1tnk $700
  { "1tnk", "1tnk" },                 -- 2 1tnk $1400  
  { "1tnk", "jeep" },                 -- 1 1tnk 1 jeep $850  
  { "arty" },                         -- 1 arty $600
  { "arty", "arty" },                 -- 2 arty $1200  
  { "2tnk" },                         -- 1 2tnk $850
  { "2tnk", "jeep" },                 -- 1 2tnk 1 jeep $1000  
}

AlliedMediumUnitTeams = { 
  -- Medium groups (~$2000 per team)
  { "jeep", "jeep", "jeep" },                 -- 3 jeep $450
  { "jeep", "jeep", "jeep", "jeep" },         -- 4 jeep $600
  { "2tnk", "1tnk", "1tnk" },                 -- 1 2tnk 2 1tnk $2250
  { "2tnk", "2tnk" },                         -- 2 2tnk $1700
  { "arty", "arty", "arty" },                 -- 3 arty $1800
  { "1tnk", "1tnk", "1tnk" },                 -- 3 1tnk $2100
  { "jeep", "jeep", "arty", "arty" },         -- 2 jeep 2 arty $1500
  { "2tnk", "arty", "arty" },                 -- 1 2tnk 2 arty $2050  
  -- Add high tech (~$2500-$3000 per team)
  { "stnk" },                                 -- 1 stnk $1350
  { "stnk", "stnk" },                         -- 2 stnk $2700
  { "ctnk" },                                 -- 1 ctnk $1350
  { "ctnk", "ctnk" },                         -- 2 ctnk $2700
}

AlliedLargeUnitTeams = { -- avoid large groups to avoid clumping! 4 units max
  -- Large groups (~$3000 per team)
  { "1tnk", "1tnk", "1tnk", "1tnk" },         -- 4 1tnk $2800
  { "2tnk", "2tnk", "1tnk", "1tnk" },         -- 2 2tnk 2 1tnk $3100
  { "2tnk", "2tnk", "2tnk" },                 -- 3 2tnk $2550
  { "2tnk", "2tnk", "2tnk", "2tnk" },         -- 4 2tnk $3400
  { "arty", "arty", "1tnk", "1tnk" },         -- 2 1tnk 2 arty $2600
  { "arty", "arty", "3tnk", "3tnk" },         -- 2 2tnk 2 arty $2900
  { "arty", "arty", "arty", "arty" },         -- 4 arty $2400
  -- Add high tech (~$$4000 per team)
  { "stnk", "2tnk", "2tnk" },                 -- 1 stnk 2 2tnk $3050
  { "stnk", "arty", "arty" },                 -- 1 stnk 2 arty $2550
  { "stnk", "stnk", "stnk" },                 -- 2 stnk $4050
  { "ctnk", "2tnk", "2tnk" },                 -- 1 ctnk 2 2tnk $3050
  { "ctnk", "arty", "arty" },                 -- 1 ctnk 2 arty $2550
  { "ctnk", "ctnk", "ctnk" },                 -- 3 ctnk $4050
  -- Super Expensive (>$5000 per team)  
  { "stnk", "stnk", "stnk", "stnk" },         -- 4 stnk $5400
  { "ctnk", "ctnk", "ctnk", "ctnk" },         -- 4 ctnk $5400
}

AlliedHarvesterHunters = { 
  { "e3", "e3", "e3", "e3" },
  { "1tnk", "1tnk", "1tnk" },
  { "2tnk", "2tnk" },
  { "2tnk", "e3", "e3", "e3" },
  { "1tnk", "1tnk", "e3", "e3" },
  { "stnk", "stnk" },
}

AlliedAirTeamGroups = { 
  { "hind" },
  { "heli" },
  { "hind", "hind" },
  { "hind", "heli" },
  { "heli", "heli" }
}


Waypoints = {
  SovRouteTopMidMidSov,
  SovRouteBotMidMidSov, 
  AllRouteTopMidMidAll, 
  AllRouteBotMidMidAll
}  



function SetupAITeams()
  Utils.Do(HouseGroups.SovietBots, function (sovietbot)

    AITeams[sovietbot.Name] = {}
    AITeams[sovietbot.Name]["Infantry Team S 1"] = Utils.Random(SovietSmallInfantryTeams)
    AITeams[sovietbot.Name]["Infantry Team M 1"] = Utils.Random(SovietMediumInfantryTeams)
    AITeams[sovietbot.Name]["Infantry Team L 1"] = Utils.Random(SovietLargeInfantryTeams)
    AITeams[sovietbot.Name]["Vehicles Team S 1"] = Utils.Random(SovietSmallUnitTeams)
    AITeams[sovietbot.Name]["Vehicles Team M 1"] = Utils.Random(SovietMediumUnitTeams)
    AITeams[sovietbot.Name]["Vehicles Team L 1"] = Utils.Random(SovietLargeUnitTeams)
    AITeams[sovietbot.Name]["Harvester Hunts 1"] = Utils.Random(SovietHarvesterHunters)
    AITeams[sovietbot.Name]["Air Attack Team 1"] = Utils.Random(SovietAirTeamGroups)
    
    AIConditions[sovietbot.Name] = {}
    AIConditions[sovietbot.Name]["Infantry Team S 1"] = { Function = ConditionCheck, ArgumentTable = {MaxConcurrentTeams = 5, MaxMoney = 6000} }
    AIConditions[sovietbot.Name]["Infantry Team M 1"] = { Function = ConditionCheck, ArgumentTable = {MaxConcurrentTeams = 4} }
    AIConditions[sovietbot.Name]["Infantry Team L 1"] = { Function = ConditionCheck, ArgumentTable = {MaxConcurrentTeams = 2} }
    AIConditions[sovietbot.Name]["Vehicles Team S 1"] = { Function = ConditionCheck, ArgumentTable = {MaxConcurrentTeams = 5, MaxMoney = 6000} }
    AIConditions[sovietbot.Name]["Vehicles Team M 1"] = { Function = ConditionCheck, ArgumentTable = {MaxConcurrentTeams = 4} }
    AIConditions[sovietbot.Name]["Vehicles Team L 1"] = { Function = ConditionCheck, ArgumentTable = {MaxConcurrentTeams = 2} }
    AIConditions[sovietbot.Name]["Harvester Hunts 1"] = { Function = ConditionCheck, ArgumentTable = {MaxConcurrentTeams = 4} }
    AIConditions[sovietbot.Name]["Air Attack Team 1"] = { Function = ConditionCheck, ArgumentTable = {MaxConcurrentTeams = 4} }
    
    local enemyfactories = Utils.Where(Map.ActorsInWorld, function(a) return IsPartOfGrouping(a.Type, "Factories") and not sovietbot.IsAlliedWith(a.Owner) end)

    AIFunctions[sovietbot.Name] = {}
    AIFunctions[sovietbot.Name]["Infantry Team S 1"] = { { Name = "Hunt", Function = ScriptFn_Hunt }}
    AIFunctions[sovietbot.Name]["Infantry Team M 1"] = { { Name = "Attack Move", Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath(sovietbot.Name, 10) }}}
    AIFunctions[sovietbot.Name]["Infantry Team L 1"] = { 
      { Name = "Guard", Function = ScriptFn_GuardActor, ArgumentTable = {Target = #enemyfactories > 0 and Utils.Random(enemyfactories) or nil }},
      { Name = "Hunt", Function = ScriptFn_Hunt }
    }
    
    AIFunctions[sovietbot.Name]["Vehicles Team S 1"] = { { Name = "Hunt", Function = ScriptFn_Hunt }}
    AIFunctions[sovietbot.Name]["Vehicles Team M 1"] = { { Name = "Attack Move", Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath(sovietbot.Name, 10) }}}
    AIFunctions[sovietbot.Name]["Vehicles Team L 1"] = { 
      { Name = "Guard", Function = ScriptFn_GuardActor, ArgumentTable = {Target = #enemyfactories > 0 and Utils.Random(enemyfactories) or nil }},
      { Name = "Hunt", Function = ScriptFn_Hunt }
    }
    
    local enemyharvesters = Utils.Where(Map.ActorsInWorld, function(a) return IsPartOfGrouping(a.Type, "Harvesters") and not sovietbot.IsAlliedWith(a.Owner) end)
    
    AIFunctions[sovietbot.Name]["Harvester Hunts 1"] = { 
      { Name = "Guard", Function = ScriptFn_GuardActor, ArgumentTable = {Target = #enemyharvesters > 0 and Utils.Random(enemyharvesters) or nil }},
      { Name = "Hunt", Function = ScriptFn_Hunt }
    }
    AIFunctions[sovietbot.Name]["Air Attack Team 1"] = { { Name = "Attack Move", Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath(sovietbot.Name, 15), Delay = DateTime.Seconds(7) }}}
    
    
    AITeams[sovietbot.Name]["Infantry Team S 2"] = Utils.Random(SovietSmallInfantryTeams)
    AITeams[sovietbot.Name]["Infantry Team M 2"] = Utils.Random(SovietMediumInfantryTeams)
    AITeams[sovietbot.Name]["Infantry Team L 2"] = Utils.Random(SovietLargeInfantryTeams)
    AITeams[sovietbot.Name]["Vehicles Team S 2"] = Utils.Random(SovietSmallUnitTeams)
    AITeams[sovietbot.Name]["Vehicles Team M 2"] = Utils.Random(SovietMediumUnitTeams)
    AITeams[sovietbot.Name]["Vehicles Team L 2"] = Utils.Random(SovietLargeUnitTeams)
    AITeams[sovietbot.Name]["Harvester Hunts 2"] = Utils.Random(SovietHarvesterHunters)
    AITeams[sovietbot.Name]["Air Attack Team 2"] = Utils.Random(SovietAirTeamGroups)
    AIConditions[sovietbot.Name]["Infantry Team S 2"] = AIConditions[sovietbot.Name]["Infantry Team S 1"]
    AIConditions[sovietbot.Name]["Infantry Team M 2"] = AIConditions[sovietbot.Name]["Infantry Team M 1"]
    AIConditions[sovietbot.Name]["Infantry Team L 2"] = AIConditions[sovietbot.Name]["Infantry Team L 1"]
    AIConditions[sovietbot.Name]["Vehicles Team S 2"] = AIConditions[sovietbot.Name]["Vehicles Team S 1"]
    AIConditions[sovietbot.Name]["Vehicles Team M 2"] = AIConditions[sovietbot.Name]["Vehicles Team M 1"]
    AIConditions[sovietbot.Name]["Vehicles Team L 2"] = AIConditions[sovietbot.Name]["Vehicles Team L 1"]
    AIConditions[sovietbot.Name]["Harvester Hunts 2"] = AIConditions[sovietbot.Name]["Harvester Hunts 1"]
    AIConditions[sovietbot.Name]["Air Attack Team 2"] = AIConditions[sovietbot.Name]["Air Attack Team 1"]      
    AIFunctions[sovietbot.Name]["Infantry Team S 2"] = AIFunctions[sovietbot.Name]["Infantry Team S 1"]
    AIFunctions[sovietbot.Name]["Infantry Team M 2"] = AIFunctions[sovietbot.Name]["Infantry Team M 1"]
    AIFunctions[sovietbot.Name]["Infantry Team L 2"] = AIFunctions[sovietbot.Name]["Infantry Team L 1"]
    AIFunctions[sovietbot.Name]["Vehicles Team S 2"] = AIFunctions[sovietbot.Name]["Vehicles Team S 1"]
    AIFunctions[sovietbot.Name]["Vehicles Team M 2"] = AIFunctions[sovietbot.Name]["Vehicles Team M 1"]
    AIFunctions[sovietbot.Name]["Vehicles Team L 2"] = AIFunctions[sovietbot.Name]["Vehicles Team L 1"]
    AIFunctions[sovietbot.Name]["Harvester Hunts 2"] = AIFunctions[sovietbot.Name]["Harvester Hunts 1"]
    AIFunctions[sovietbot.Name]["Air Attack Team 2"] = AIFunctions[sovietbot.Name]["Air Attack Team 1"]
    
    
  end)

  Utils.Do(HouseGroups.AlliedBots, function (alliedbot)

    AITeams[alliedbot.Name] = {}
    AITeams[alliedbot.Name]["Infantry Team S 1"] = Utils.Random(AlliedSmallInfantryTeams)
    AITeams[alliedbot.Name]["Infantry Team M 1"] = Utils.Random(AlliedMediumInfantryTeams)
    AITeams[alliedbot.Name]["Infantry Team L 1"] = Utils.Random(AlliedLargeInfantryTeams)
    AITeams[alliedbot.Name]["Vehicles Team S 1"] = Utils.Random(AlliedSmallUnitTeams)
    AITeams[alliedbot.Name]["Vehicles Team M 1"] = Utils.Random(AlliedMediumUnitTeams)
    AITeams[alliedbot.Name]["Vehicles Team L 1"] = Utils.Random(AlliedLargeUnitTeams)
    AITeams[alliedbot.Name]["Harvester Hunts 1"] = Utils.Random(AlliedHarvesterHunters)
    AITeams[alliedbot.Name]["Air Attack Team 1"] = Utils.Random(AlliedAirTeamGroups)
    
    AIConditions[alliedbot.Name] = {}
    AIConditions[alliedbot.Name]["Infantry Team S 1"] = { Function = ConditionCheck, ArgumentTable = {MaxConcurrentTeams = 5, MaxMoney = 6000} }
    AIConditions[alliedbot.Name]["Infantry Team M 1"] = { Function = ConditionCheck, ArgumentTable = {MaxConcurrentTeams = 4} }
    AIConditions[alliedbot.Name]["Infantry Team L 1"] = { Function = ConditionCheck, ArgumentTable = {MaxConcurrentTeams = 2} }
    AIConditions[alliedbot.Name]["Vehicles Team S 1"] = { Function = ConditionCheck, ArgumentTable = {MaxConcurrentTeams = 5, MaxMoney = 6000} }
    AIConditions[alliedbot.Name]["Vehicles Team M 1"] = { Function = ConditionCheck, ArgumentTable = {MaxConcurrentTeams = 4} }
    AIConditions[alliedbot.Name]["Vehicles Team L 1"] = { Function = ConditionCheck, ArgumentTable = {MaxConcurrentTeams = 2} }
    AIConditions[alliedbot.Name]["Harvester Hunts 1"] = { Function = ConditionCheck, ArgumentTable = {MaxConcurrentTeams = 4} }
    AIConditions[alliedbot.Name]["Air Attack Team 1"] = { Function = ConditionCheck, ArgumentTable = {MaxConcurrentTeams = 4} }

    local enemyfactories = Utils.Where(Map.ActorsInWorld, function(a) return IsPartOfGrouping(a.Type, "Factories") and not alliedbot.IsAlliedWith(a.Owner) end)

    AIFunctions[alliedbot.Name] = {}
    AIFunctions[alliedbot.Name]["Infantry Team S 1"] = { { Name = "Hunt", Function = ScriptFn_Hunt }}
    AIFunctions[alliedbot.Name]["Infantry Team M 1"] = { { Name = "Attack Move", Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath(alliedbot.Name, 10) }}}
    AIFunctions[alliedbot.Name]["Infantry Team L 1"] = { 
      { Name = "Guard", Function = ScriptFn_GuardActor, ArgumentTable = {Target = #enemyfactories > 0 and Utils.Random(enemyfactories) or nil }},
      { Name = "Hunt", Function = ScriptFn_Hunt }
    }
    
    AIFunctions[alliedbot.Name]["Vehicles Team S 1"] = { { Name = "Hunt", Function = ScriptFn_Hunt }}
    AIFunctions[alliedbot.Name]["Vehicles Team M 1"] = { { Name = "Attack Move", Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath(alliedbot.Name, 10) }}}
    AIFunctions[alliedbot.Name]["Vehicles Team L 1"] = { 
      { Name = "Guard", Function = ScriptFn_GuardActor, ArgumentTable = {Target = #enemyfactories > 0 and Utils.Random(enemyfactories) or nil }},
      { Name = "Hunt", Function = ScriptFn_Hunt }
    }
    
    local enemyharvesters = Utils.Where(Map.ActorsInWorld, function(a) return IsPartOfGrouping(a.Type, "Harvesters") and not alliedbot.IsAlliedWith(a.Owner) end)
    
    AIFunctions[alliedbot.Name]["Harvester Hunts 1"] = { 
      { Name = "Guard", Function = ScriptFn_GuardActor, ArgumentTable = {Target = #enemyharvesters > 0 and Utils.Random(enemyharvesters) or nil }},
      { Name = "Hunt", Function = ScriptFn_Hunt }
    }
    AIFunctions[alliedbot.Name]["Air Attack Team 1"] = { { Name = "Attack Move", Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath(alliedbot.Name, 15), Delay = DateTime.Seconds(7) }}}
    
    
    AITeams[alliedbot.Name]["Infantry Team S 2"] = Utils.Random(AlliedSmallInfantryTeams)
    AITeams[alliedbot.Name]["Infantry Team M 2"] = Utils.Random(AlliedMediumInfantryTeams)
    AITeams[alliedbot.Name]["Infantry Team L 2"] = Utils.Random(AlliedLargeInfantryTeams)
    AITeams[alliedbot.Name]["Vehicles Team S 2"] = Utils.Random(AlliedSmallUnitTeams)
    AITeams[alliedbot.Name]["Vehicles Team M 2"] = Utils.Random(AlliedMediumUnitTeams)
    AITeams[alliedbot.Name]["Vehicles Team L 2"] = Utils.Random(AlliedLargeUnitTeams)
    AITeams[alliedbot.Name]["Harvester Hunts 2"] = Utils.Random(AlliedHarvesterHunters)
    AITeams[alliedbot.Name]["Air Attack Team 2"] = Utils.Random(AlliedAirTeamGroups)
    AIConditions[alliedbot.Name]["Infantry Team S 2"] = AIConditions[alliedbot.Name]["Infantry Team S 1"]
    AIConditions[alliedbot.Name]["Infantry Team M 2"] = AIConditions[alliedbot.Name]["Infantry Team M 1"]
    AIConditions[alliedbot.Name]["Infantry Team L 2"] = AIConditions[alliedbot.Name]["Infantry Team L 1"]
    AIConditions[alliedbot.Name]["Vehicles Team S 2"] = AIConditions[alliedbot.Name]["Vehicles Team S 1"]
    AIConditions[alliedbot.Name]["Vehicles Team M 2"] = AIConditions[alliedbot.Name]["Vehicles Team M 1"]
    AIConditions[alliedbot.Name]["Vehicles Team L 2"] = AIConditions[alliedbot.Name]["Vehicles Team L 1"]
    AIConditions[alliedbot.Name]["Harvester Hunts 2"] = AIConditions[alliedbot.Name]["Harvester Hunts 1"]
    AIConditions[alliedbot.Name]["Air Attack Team 2"] = AIConditions[alliedbot.Name]["Air Attack Team 1"]      
    AIFunctions[alliedbot.Name]["Infantry Team S 2"] = AIFunctions[alliedbot.Name]["Infantry Team S 1"]
    AIFunctions[alliedbot.Name]["Infantry Team M 2"] = AIFunctions[alliedbot.Name]["Infantry Team M 1"]
    AIFunctions[alliedbot.Name]["Infantry Team L 2"] = AIFunctions[alliedbot.Name]["Infantry Team L 1"]
    AIFunctions[alliedbot.Name]["Vehicles Team S 2"] = AIFunctions[alliedbot.Name]["Vehicles Team S 1"]
    AIFunctions[alliedbot.Name]["Vehicles Team M 2"] = AIFunctions[alliedbot.Name]["Vehicles Team M 1"]
    AIFunctions[alliedbot.Name]["Vehicles Team L 2"] = AIFunctions[alliedbot.Name]["Vehicles Team L 1"]
    AIFunctions[alliedbot.Name]["Harvester Hunts 2"] = AIFunctions[alliedbot.Name]["Harvester Hunts 1"]
    AIFunctions[alliedbot.Name]["Air Attack Team 2"] = AIFunctions[alliedbot.Name]["Air Attack Team 1"]
  end)
end


function ConditionCheck (ArgumentTable) -- returns bool
  -- MaxConcurrentTeams:  Pass check only if the number of active and procuring teams is less than this number
  -- MaxMoney:  Pass check if player has less than this amount of resources
  -- MinMoney:  Pass check if player has more than this amount of resources
    
  if Player.GetPlayer(ArgumentTable.PlayerName) == nil then return false end
  
  -- check concurrent teams  
  if ArgumentTable.MaxConcurrentTeams ~= nil and #Utils.Where(AIGroups[ArgumentTable.PlayerName], function(aigroup) return aigroup.Status ~= 0 end) >= ArgumentTable.MaxConcurrentTeams then return false end
  
  local p = Player.GetPlayer(ArgumentTable.PlayerName)
  if ArgumentTable.MaxMoney ~= nil and p.Resources + p.Cash > ArgumentTable.MaxMoney then return false end
  if ArgumentTable.MinMoney ~= nil and p.Resources + p.Cash < ArgumentTable.MinMoney then return false end
  
  
  return true
  
end



function GeneratePath (playername, iterations) -- returns CPos[]
  --AddDebugString("GeneratePath("..playername..", "..iterations.." iterations) called")
  
  local result = {}
  local actors = {}
  table.insert(actors, Utils.Random(AIHuntInitialWaypoints[playername]))
  
  for i = 1, iterations do
    table.insert(actors, Utils.Random(GetNextWaypointSet(actors[#actors])))
  end
  
  -- convert actors into locations
  for i = 1, #actors do
    result[i] = actors[i].Location
  end
  
  return result
end

