-----------------------------------------------------------------------------------------------------------------------
------------------ LUA SCRIPTS FOR MISSION CONTROL AND AI IMPLEMENTATION
---------------------- by lovalmidas
-----------------------------------------------------------------------------------------------------------------------
-- SETUP PLAYERS LUA  VERSION 1.001 - 2017.03.22.0
-- #3
------ Contains:  
---------- InitialisePlayers() attached to WorldLoaded()
---------- Player initialization and table set up
-------------- SetupPlayers()
---------- Applying table settings to world Player
-------------- ApplyPlayerSettings()
---------- Getting values from table settings 
-------------- GetPlayerSettings(Player player, string settingname)
-------------- GetBuildTimeMultiplier(Player player, string category)
-------------- GetCostMultiplier(Player player, string category)


-------- MAIN FUNCTION TO ATTACH TO WorldLoaded()
function InitialisePlayers ()
  AddDebugString("InitialisePlayers()")  

  SetupPlayers()   
  ApplyPlayerSettings()
  
end

  
function SetupPlayers ()
  AddDebugString("SetupPlayers()")  
  
  -- Fill the House table
  ------ Houses[Player.Name] = table:
  ----------- Player = the Player
  ----------- InitialCash = Player's initial cash
  ----------- BuildTimeMultipliers = (AI) Multiplier to BuildTime (default, Structures, Defences, Infantry, Units, Aircraft, Ships)
  ----------- CostMultipliers = (AI) Multiplier to Cost (default, Structures, Defences, Infantry, Units, Aircraft, Ships)
  ----------- StructurePriority = (AI) AI-assigned priority for structure production
  
  
  Utils.Do( HouseGroups.Active, function(player) 
      Houses[player.Name] = { }
      Houses[player.Name].Player = player
      Houses[player.Name].InitialCash = DefaultInitialCash
      
      Houses[player.Name].Allies = Player.GetPlayers(function(p) return (not p.IsLocalPlayer and not p.IsNonCombatant and p.IsAlliedWith(player)) end)
      Utils.Shuffle(Houses[player.Name].Allies)
      RemoveFromList(Houses[player.Name].Allies, player)
      table.insert(Houses[player.Name].Allies, 1, player)
    end
  )
  -- Bots
  Utils.Do( HouseGroups.Bots, function(bot) 
      if Houses[bot.Name] == nil then 
        Houses[bot.Name] = { } 
        Houses[bot.Name].Player = bot
      end
      if AIInitialCash then Houses[bot.Name].InitialCash = AIInitialCash end
      Houses[bot.Name].BuildTimeMultipliers = AIBuildTimeMultiplier
      Houses[bot.Name].CostMultipliers = AICostMultiplier
      
      -- Bot behaviour
      Houses[bot.Name].AIMaintainExcessPower = AIMaintainExcessPower
      Houses[bot.Name].AIStructureHPRepair = AIStructureHPRepair
      Houses[bot.Name].AIUnitHPPursuit = AIUnitHPPursuit
      Houses[bot.Name].AIHarvestersPerRefinery = AIHarvestersPerRefinery
      Houses[bot.Name].AILowCashThreshold = AILowCashThreshold
      Houses[bot.Name].AIEmergencyCashThreshold = AIEmergencyCashThreshold
    end
  )

  Utils.Do( HouseGroups.All, function(player) 
      ActorRegistry[player.Name] = { } 
    end
  )
  
end

function ApplyPlayerSettings ()
  AddDebugString("ApplyPlayerSettings()")  
  
  -- Apply Cash
  Utils.Do(HouseGroups["Active"], function(house) house.Cash = GetPlayerSettings(house, "InitialCash") end)
  
end
-----------------------------------------------------------------------------------------------------------------------
-- Player settings
function GetPlayerSettings (player, settingname)
  AddDebugString("GetPlayerSettings()")

  if Houses == nil then 
    Media.Debug("WARNING: Function GetPlayerSettings() invoked with empty Houses array!")
    return nil
  end
  
  if player == nil then 
    Media.Debug("WARNING: Function GetPlayerSettings() invoked with empty parameter player!")
    return nil
  end  
  
  if settingname == nil then 
    Media.Debug("WARNING: Function GetPlayerSettings() invoked with empty parameter firstsettingtype!")
    return nil
  end 
  
  if Houses[player.Name] == nil then
    Media.Debug("WARNING: Function GetPlayerSettings() invoked with empty Houses table for player "..player.Name.."!")
    return nil
  end     
    
  if Houses[player.Name][settingname] ~= nil then
    return Houses[player.Name][settingname]
  end
  return nil
end

function GetBuildTimeMultiplier (player, category)
  AddDebugString("GetBuildTimeMultiplier()") 
  
  local tbl = GetPlayerSettings(player, "BuildTimeMultipliers")
  if type(tbl) == "table" then 
    if tbl[category] ~= nil then return tbl[category] end
    if tbl.default ~= nil then return tbl.default end
    return 1
  else 
    return 1 
  end
end  
  
function GetCostMultiplier (player, category) 
  AddDebugString("GetBuildTimeMultiplier()") 
  
  local tbl = GetPlayerSettings(player, "CostMultipliers")
  if type(tbl) == "table" then 
    if tbl[category] ~= nil then return tbl[category] end
    if tbl.default ~= nil then return tbl.default end
    return 1
  else 
    return 1 
  end
end






