-----------------------------------------------------------------------------------------------------------------------
------------------ LUA SCRIPTS FOR MISSION CONTROL AND AI IMPLEMENTATION
---------------------- by lovalmidas
-----------------------------------------------------------------------------------------------------------------------
-- SETUP BASES LUA  VERSION 1.001 - 2017.03.22.0
-- #5
------ Contains:  
---------- InitialiseBases() 
---------- Base node initialization
-------------- SetupInitialNodes()
-------------- SetupMapBaseNodes()
-------------- ImportBaseNode(table basenode)
---------- Base center calculation from nodes
-------------- SetupBaseCenters()
-------------- ArrangeBaseNodes()
---------- Search utility  
-------------- FindBaseNode(Player player, string type)

-------- MAIN FUNCTION TO ATTACH TO WorldLoaded()
function InitialiseBases ()
  AddDebugString("InitialiseBases() called") 
  SetupInitialNodes()
  SetupMapBaseNodes() 
  DeleteBaseNodeActors()
  SetupBaseCenters() 
  ArrangeBaseNodes()
end

function SetupInitialNodes ()
  AddDebugString("SetupInitialNodes() called")  

  Utils.Do(InitialBaseNodes, function(bn) ImportBaseNode(bn) end)
end


function SetupMapBaseNodes ()
  AddDebugString("SetupMapBaseNodes() called")  

	local enumbb = #BaseNodes -- already added through InitialBaseNodes
	Utils.Do(Map.NamedActors, function(actor)
    if actor.IsDead then return end
		local cty = actor.Owner
    local actortype = actor.Type
    local importactor = actor
    
    -- Delete structures belonging to player_(BaseNode) and check information to be used as base node of player
    local ctyname = cty.Name
    if ctyname ~= nil then 
      if string.sub(ctyname, #ctyname - #BaseNodePlayerSuffix + 1, -1) == BaseNodePlayerSuffix then
        local newctyname = string.sub(ctyname, 1, #ctyname - #BaseNodePlayerSuffix)
        actor.Destroy() -- Remove actor
        importactor = nil -- actor no longer exists on map

        if Player.GetPlayer(newctyname) == nil then return end
        RemoveFromList (HouseGroups.Active, cty)
        RemoveFromList (HouseGroups.Humans, cty)
        RemoveFromList (HouseGroups.Bots, cty)
        RemoveFromList (HouseGroups.AlliedBots, cty)
        RemoveFromList (HouseGroups.SovietBots, cty)
        RemoveFromList (HouseGroups.FriendlyBots, cty)
        RemoveFromList (HouseGroups.EnemyBots, cty)   
        
        cty = Player.GetPlayer(newctyname)
      end
    end
    
    -- Import base node
		local mb = GetBuildingfromMasterList(actortype, cty.Name)
		if mb ~= nil then		
			if importactor ~= nil then ExistingBuildings[#ExistingBuildings + 1] = actor end
			
      if IncludeExistingBuildingsInBaseNodes or importactor == nil then -- player_(BaseNode) overrides IncludeExistingBuildingsInBaseNodes setting
        ImportBaseNode( 
          { 
            id = "Node ".. (#BaseNodes - enumbb + 1), --id is not used, for debug reference only
            type = actortype, 
            owner = cty, 
            mapactor = importactor, 
            pos = { x = actor.Location.X , y = actor.Location.Y },
          } 
        )
      end
		end
	end)
end

-- Remove all BaseNode spawns and units. Because Free Unit harvesters could not be deleted using SetupMapBaseNodes()
function DeleteBaseNodeActors ()
  AddDebugString("DeleteBaseNodeActors() called")  

  Trigger.AfterDelay(0, function()
    Utils.Do(Map.ActorsInBox(Map.TopLeft, Map.BottomRight, function(a) return true end), function(a) -- DO NOT TOUCH THIS PART, apparently actorsinworld include players??
      if a.IsDead then return end
      local oldctyname = a.Owner.Name
      if string.sub(oldctyname, #oldctyname - #BaseNodePlayerSuffix + 1, -1) == BaseNodePlayerSuffix then  
        local newctyname = string.sub(oldctyname, 1, #oldctyname - #BaseNodePlayerSuffix)
        
        if Player.GetPlayer(newctyname) ~= nil then 
          if a.HasProperty("Destroy") then 
            a.Stop()
            a.Destroy() 
          end
          RemoveFromList (HouseGroups.Active, a.Owner)
          RemoveFromList (HouseGroups.Humans, a.Owner)
          RemoveFromList (HouseGroups.Bots, a.Owner)
          RemoveFromList (HouseGroups.AlliedBots, a.Owner)
          RemoveFromList (HouseGroups.SovietBots, a.Owner)
          RemoveFromList (HouseGroups.FriendlyBots, a.Owner)
          RemoveFromList (HouseGroups.EnemyBots, a.Owner)    
        end
      end
    end)
  end)
end

function SetupBaseCenters ()
  AddDebugString("SetupBaseCenters() called")  

  local basenodetype = { }
  local basenodeprecedence = {
    fact = 1,
    weap = 2,
    proc = 3,
    atek = 4,
    stek = 5,
    dome = 6,
    fix = 7,
    afld = 8,
    hpad = 9,
    barr = 10,
    tent = 11
  }
  
  
  Utils.Do(BaseNodes, function(b)
    if b.type == nil then return end
		if basenodeprecedence[b.type] == nil then return end
    if basenodeprecedence[b.type] >= (basenodetype[b.owner.Name] or 9999) then return end
    
    basenodetype[b.owner.Name] = basenodeprecedence[b.type]
    BaseCenters[b.owner.Name] = b.pos
	end)  

end

function ArrangeBaseNodes () -- arrange by proximity to BaseCenter
  AddDebugString("ArrangeBaseNodes() called")  

	local BaseHoldingList = { }
	local i = 0
	local x_dist
  local y_dist
  
	for j = 1,#BaseNodes do 	
		--table.insert(BaseHoldingList, BaseNodes[j])	
    
    local cty = BaseNodes[j].owner
    if BaseCenters[cty.Name] ~= nil then
      x_dist = BaseNodes[j].pos.x - BaseCenters[cty.Name].x
      y_dist = BaseNodes[j].pos.y - BaseCenters[cty.Name].y
    else
      x_dist = BaseNodes[j].pos.x
      y_dist = BaseNodes[j].pos.y
    end
    
    BaseNodes[j].x_dist = x_dist
    BaseNodes[j].y_dist = y_dist
		BaseNodes[j].dist = x_dist * x_dist + y_dist * y_dist
		BaseNodes[j].initrank = j
	end

  for k,v in pairs(BaseNodes) do
      v.name = k --Store the key in an entry called "name"
      table.insert(BaseHoldingList, v)
  end
  table.sort(BaseHoldingList, function(a,b) return a.dist < b.dist end)
  BaseNodes = BaseHoldingList

	Utils.Do(BaseNodes, function(mb)
		if mb.mapactor ~= nil then 
			Trigger.OnKilled(mb.mapactor, function(a, _) 
				mb.mapactor = nil
        RemoveFromList (ExistingBuildings, a)
			end) 
		end
	end)
end

 
function ImportBaseNode (basenode)
  AddDebugString("ImportBaseNode("..basenode.owner.Name..", "..basenode.type..") called")  

  if basenode.owner == nil then return end
  local mb = GetBuildingfromMasterList(basenode.type, basenode.owner.Name)
  if mb ~= nil then
    table.insert(BaseNodes, 
    {
      id = basenode.id, -- not really needed, used to identify nodes in debug
      owner = basenode.owner,
      side = basenode.owner.Faction,
      type = basenode.type,
      pos = basenode.pos,
      mapactor = basenode.mapactor, -- for initial base nodes it is nil
      
      curr_factory = nil, -- current factory producing it. Ensures other ConYards do not produce it as well
      
      priority = mb.priority,
      power = mb.power,
      prereq = mb.prereq,
      cost = mb.cost or Actor.Cost(basenode.type),
      buildtime = mb.buildtime or Actor.BuildTime(basenode.type),
      toprotect = mb.toprotect,
      zone = mb.zone,
    })
  end
end
  
function FindBaseNode (cty, t) -- cty = player, t = type (building only), returns basenode table entry
  AddDebugString("FindBaseNode(cty = "..cty.Name..", t = "..t..") called")  

	local result = nil
  Utils.Do(BaseNodes, function(b)
		if b.owner == cty and b.type == t then
			result = b
      return
		end
	end)
	return result
end
  



