-----------------------------------------------------------------------------------------------------------------------
------------------ LUA SCRIPTS FOR MISSION CONTROL AND AI IMPLEMENTATION
---------------------- by lovalmidas
-----------------------------------------------------------------------------------------------------------------------
-- ACTOR REGISTRY LUA  VERSION 1.001 - 2017.03.22.0
-- #4
------ Contains:  
---------- InitialiseActors() 
---------- Player initialization and table set up
-------------- PopulateActorRegistry()
-------------- AddActorToRegistry(Actor actor)
---------- Use of the registry  
-------------- FindOwnedActorTypes(Player player, string[] types)
-------------- FindOwnedActorType(Player player, string type)

-------- MAIN FUNCTION TO ATTACH TO WorldLoaded()
function InitialiseActors ()
  PopulateActorRegistry()
end

function PopulateActorRegistry ()
  AddDebugString("PopulateActorRegistry()") 

  Utils.Do(Map.NamedActors, function(actor)
    if actor.IsDead then return end
    AddActorToRegistry(actor)
    
    if IsPartOfGrouping(actor.Type, "ToProtect") then
      -- TO DO: Set up call to attack attacker, and set to triggers for produced units, reinforced units and pre-placed units/structures
      Trigger.OnDamaged(actor, function(self, attacker)
        if not self.Owner.IsAlliedWith(attacker.Owner) then
          AIReservedDefence(self.Owner.Name, attacker)
        end
      end)
    end
  end)
end
      
function AddActorToRegistry (actor) -- Actor actor
  AddDebugString("AddActorToRegistry()")

  --local ownername = actor.Owner.Name
  local actortype = actor.Type
  
  -- Initialise table if not already existing
  ActorRegistry[actortype] = ActorRegistry[actortype] or { }
  
  -- Add actor to registry
  table.insert(ActorRegistry[actortype], actor)
  
  -- Add Triggers to handle removal 
  xpcall( 
    function() 
      Trigger.OnRemovedFromWorld(actor, function(a,_)
        RemoveFromList(ActorRegistry[actortype], a)
      end)
    end
    ,
    function()
      -- Types without ScriptTrigger trait will return error if we attempt to add a map trigger to it. 
      NoTriggerActorTypes[actortype] = true
    end
  )
end

function FindOwnedActorTypes (player, actortypes) -- returns Actor[] if actors are found. Otherwise returns an empty table.
  --AddDebugString("FindOwnedActorTypes( player = "..player.Name..", "..#actortypes.." types )") 
  
  if ActorRegistry == nil then return {} end
  
  local result = { }
  Utils.Do(actortypes, function(atype) 
      result = tablemerge(result, FindOwnedActorType (player, atype))
  end)

  return result
end


function FindOwnedActorType (player, actortype) -- returns Actor[] if actors are found. Otherwise returns an empty table.
  --AddDebugString("FindOwnedActorType( player = "..player.Name..", actortype = "..actortype.." )") 
  
  if ActorRegistry == nil then return {} end
  if type(ActorRegistry[actortype]) ~= "table" then return {} end
  
  if player then --player is defined
    if NoTriggerActorTypes[actortype] then 
      return Utils.Where(Map.ActorsInWorld, function(self) return self.Owner == player and self.Type == actortype end)
    else
      return Utils.Where(ActorRegistry[actortype], function(self) return self.Owner == player end)
    end
  else --no defined player: search for all players
    if NoTriggerActorTypes[actortype] then 
      return Utils.Where(Map.ActorsInWorld, function(self) return self.Type == actortype end)
    else
      return ActorRegistry[actortype]
    end
  end
  return { }
end
