-----------------------------------------------------------------------------------------------------------------------
------------------ LUA SCRIPTS FOR MISSION CONTROL AND AI IMPLEMENTATION
---------------------- by lovalmidas
-----------------------------------------------------------------------------------------------------------------------
-- AI PRODUCTION UNIT LUA  VERSION 1.001 - 2017.03.22.0
-- #9
------ Contains:  
---------- SetupProductionBuilding(Actor actor, string tab) 
---------- SetupFactories(int i)
---------- MakeProductionTypes(string t, string s, string tab)
---------- UnitProduction (ActiveProductionTable productiontable)


------------------------------------------------------------------------------------
------ Unit production activation by factory creation
function SetupProductionBuilding (actor)
  AddDebugString("SetupProductionBuilding("..actor.Owner.Name..", "..actor.Type..") called")
  
	if IsPartOfGrouping(actor.Type, "ConstructionYards") then return end
  local productiontable = { factory = actor, 
                            activated = true, 
                            tab = GetFactoryTab(actor.Type), 
                            types = MakeProductionTypes(actor.Type, actor.Owner.Name), 
                            curr_production = "", 
                            progress = 0, 
                            table = nil, 
                            storedvalue = nil, 
                            returntotable = false }
  
	table.insert(ActiveProductionTable, productiontable)
  local newfactory = #ActiveProductionTable
  SetupFactories(productiontable)
	UnitProduction(productiontable)
end

------------------------------------------------------------------------------------
------ Factory setup for passing units to AI control
function SetupFactories (productiontable) -- use nil to activate all. Use nil only in the beginning!
  AddDebugString("SetupFactories("..(productiontable and productiontable.factory.Owner.Name..","..productiontable.factory.Type or "")..") called")

  local apts
	if productiontable == nil then
    apts = Utils.Where(ActiveProductionTable, function(apt) 
        return  IsPartOfGrouping(apt.factory.Type, "InfantryFactories") or
                IsPartOfGrouping(apt.factory.Type, "UnitFactories") or
                IsPartOfGrouping(apt.factory.Type, "AircraftFactories") or
                IsPartOfGrouping(apt.factory.Type, "NavalFactories")                 
      end)
  else
    apts = { productiontable }
  end
    
  Utils.Do(apts, function(apt)
    if not apt.factory.IsDead then
      Trigger.OnProduction(apt.factory, function(_, a)
        AddActorToRegistry(a)
        
        if IsPartOfGrouping(a.Type, "AttackAnythingOnBuild") then
          if a.HasProperty("Stance") then a.Stance = "AttackAnything" end
        end
        
        -- is a different table defined for the actor?
        if apt.aigroup then
          table.insert(apt.aigroup.Actors, a) 
          RemoveOnceFromList(apt.aigroup.PendingTypes, a.Type)
          
          -- is it fully filled?
          if #apt.aigroup.PendingTypes == 0 then 
            UpdateAIGroupStatus(apt.aigroup.Playername, apt.aigroup.Actorgroupname, 1)
          end 
        else
          AddActorToPool(a) 
        end
      
        -- trigger: defensive teams
        if apt.toprotect == true or (apt.toprotect == nil and IsPartOfGrouping(apt.type, "ToProtect")) then
          -- TO DO: Set up call to attack attacker, and set to triggers for produced units, reinforced units and pre-placed units/structures
          Trigger.OnDamaged(a, function(self, attacker)
            if not self.Owner.IsAlliedWith(attacker.Owner) then
              AIReservedDefence(self.Owner.Name, attacker)
            end
          end)
        end
      end)
    end
  end)
end

------------------------------------------------------------------------------------
------ Populate list from MasterTable
function MakeProductionTypes (t, s) -- t = factory type, s = owner/side name
  AddDebugString("MakeProductionTypes("..t..","..s..") called")

	local ProduceList = { }
  
  local tab = GetFactoryTab(t)
  if tab ~= nil then 
    Utils.Do(MasterTable.Production[tab], function(mu)
      Utils.Do(mu.side, function(ms)
        if mu.factory == t and ms == s and mu.weight > 0 then table.insert(ProduceList, mu) end
      end)
    end)

    if Player.GetPlayer(s) ~= nil then 
      Utils.Do(MasterTable.Production[tab], function(mu)
        Utils.Do(mu.side, function(ms)
          if mu.factory == t and ms == Player.GetPlayer(s).Faction and mu.weight > 0 then table.insert(ProduceList, mu) end
        end)
      end)
    end    
  end

	return ProduceList
end

------------------------------------------------------------------------------------
------ Cyclic unit production
function UnitProduction (productiontable)
  AddDebugString("UnitProduction("..productiontable.factory.Owner.Name..","..productiontable.factory.Type..") called")

	if productiontable.factory.IsDead then  
    RemoveFromList(ActiveProductionTable, productiontable)
		return
	end
  
	if IsPartOfGrouping(productiontable.factory.Type, "ConstructionYards") then return end --different handling for Construction Yards
	if #productiontable.types > 0 and productiontable.activated and (QueuePerFactory or not productiontable.factory.HasProperty("IsPrimaryBuilding") or productiontable.factory.IsPrimaryBuilding) then
		
    local numproc = #FindOwnedActorTypes(productiontable.factory.Owner, MasterTable.Groupings.Refineries)
		local numharv = #productiontable.factory.Owner.GetActorsByType("harv") 
    --FindOwnedActorType(factory.Owner, "harv") does not work as it does not account for free units from refinery
         
    -- Build Harvester override
		local validunitList = { }
    local listfromAIGroups = true
		if numharv < numproc * Houses[productiontable.factory.Owner.Name].AIHarvestersPerRefinery and IsPartOfGrouping(productiontable.factory.Type, "HarvesterFactories") then
      listfromAIGroups = false
			validunitList = { { type = MasterTable.Groupings.Harvesters[1], factory = productiontable.factory.Type, side = { productiontable.factory.Owner.Name }, toprotect = true } } 
		else
      if productiontable.factory.Owner.Cash + productiontable.factory.Owner.Resources > Houses[productiontable.factory.Owner.Name].AIEmergencyCashThreshold then
        local aifilllist = { }
        -- check AITeam lists to fill 
        
        if type(PendingTypesForProduction[productiontable.factory.Owner.Name]) == "table" and PendingTypesForProduction[productiontable.factory.Owner.Name] ~= nil then
          Utils.Do(PendingTypesForProduction[productiontable.factory.Owner.Name], function(pendingtype)
            Utils.Do(productiontable.types, function(tt)
              if pendingtype.type == tt.type then 
                local tt2 = clone(tt)
                tt2.aigroup = pendingtype.aigroup
                tt2.self = pendingtype
                table.insert(aifilllist, tt2) 
              end
            end)
          end)          
        end
                
        if #aifilllist == 0 then 
          listfromAIGroups = false
          if productiontable.factory.Owner.Cash + productiontable.factory.Owner.Resources > Houses[productiontable.factory.Owner.Name].AILowCashThreshold then aifilllist = productiontable.types end
        end 
        -- Check prereqs
        Utils.Do(aifilllist, function(tt)
          if CheckPrerequisites(productiontable.factory.Owner, tt.prereq) then 
            for i = 1, tt.weight do validunitList[#validunitList + 1] = tt end
          end
        end)
      end
    end

    if #validunitList > 0 then
      local actorproduced = validunitList[Utils.RandomInteger(1, #validunitList + 1)]

      -- apply multipliers
      if actorproduced.buildtime == nil then actorproduced.buildtime = Actor.BuildTime(actorproduced.type) end
      if actorproduced.cost == nil then actorproduced.cost = Actor.Cost(actorproduced.type) end
      
      local buildtime = actorproduced.buildtime * GetBuildTimeMultiplier(productiontable.factory.Owner, productiontable.tab) --* Utils.Random({0.98,0.99,1,1.01,1.02})
      local cost = actorproduced.cost * GetCostMultiplier(productiontable.factory.Owner, productiontable.tab)

      -- remove entry from AIGroups table if referenced there
      if listfromAIGroups then
        productiontable.aigroup = actorproduced.aigroup
        productiontable.returntotable = true
        productiontable.table = PendingTypesForProduction[productiontable.factory.Owner.Name]
        productiontable.storedvalue = clone(actorproduced.self)
        RemoveOnceFromList(PendingTypesForProduction[productiontable.factory.Owner.Name], actorproduced.self)
      else
        productiontable.aigroup = nil
        productiontable.returntotable = false
        productiontable.table = nil
        productiontable.storedvalue = nil
      end

      productiontable.curr_production = actorproduced.type
      BuildActor(actorproduced, productiontable, buildtime, cost)
      return
    end
	end
  
  -- periodic recheck
	Trigger.AfterDelay(Utils.RandomInteger(200, 1250), function() UnitProduction(productiontable) end)
end	
------------------------------------------------------------------------------------

------------------------------------------------------------------------------------
------ AI unit evaluation to set unit priority (To be implemented) 


