-----------------------------------------------------------------------------------------------------------------------
------------------ LUA SCRIPTS FOR MISSION CONTROL AND AI IMPLEMENTATION
---------------------- by lovalmidas
-----------------------------------------------------------------------------------------------------------------------
-- AI PRODUCTION BASE LUA  VERSION 1.001 - 2017.03.22.0
-- #10
------ Contains:  
---------- SetupConYards() 
---------- ActivateConYard(Actor yard)
---------- PrepBaseProduction(Actor yard, string tab)
---------- BaseProduction (ActiveProductionTable subtable productiontable)
---------- EvaluateAIBaseBehaviour (Player ctb, string tab)
---------- CheckandSetStructurePriority (Player ctb, string tab, string priority)
---------- GetStructurePriority (Player player)
---------- SetStructurePriority (Player player, string newpriority)



-- Collection of functions for governing AI base production --

-------- MAIN FUNCTION TO ATTACH TO SetupAI ActivateAI()
function SetupConYards ()
  AddDebugString("SetupConYards() called")  
  Utils.Do(HouseGroups.Active, function(bot) 
    local yardlist = Utils.Where(Map.ActorsInWorld, function(a) return a.Owner == bot and IsPartOfGrouping(a.Type, "ConstructionYards") end)
    Utils.Do(yardlist, function(yard)
      
      existingapt = Utils.Where(ActiveProductionTable, function(apt) return apt.factory == yard end) -- already active?
      if #existingapt == 0 then 
        ActivateConYard(yard)
        return
      else
        Utils.Do(existingapt, function(exapt) 
          if exapt.activated == false then exapt.activated = true end
        end)
      end
    end)
  end)
end


------------------------------------------------------------------------------------
------ Base production activation by ConYard
function ActivateConYard (yard)
  AddDebugString("ActivateConYard() called") 

  if SplitConYardTab then
    PrepBaseProduction(yard, "Structures")
    PrepBaseProduction(yard, "Defences")
  else
    PrepBaseProduction(yard, "ConstructionYard")
  end
end


------------------------------------------------------------------------------------
------ Register tabs
function PrepBaseProduction (yard, tab) -- yard
  AddDebugString("PrepBaseProduction("..yard.Owner.Name..", "..tab..") called")
  
  local productiontable = nil
  Utils.Do(ActiveProductionTable, function(apt)
    if apt.factory == yard and apt.tab == tab then productiontable = apt end
  end)
  if productiontable == nil then -- if not already added
    productiontable = { factory = yard, 
                        activated = true, 
                        tab = tab, 
                        curr_production = "", 
                        progress = 0, 
                        table = nil, 
                        storedvalue = nil, 
                        returntotable = false } 
    table.insert(ActiveProductionTable, productiontable)
  end
  
  BaseProduction(productiontable)
end

------------------------------------------------------------------------------------
------ Cyclic base production
function BaseProduction (productiontable) -- yard
  AddDebugString("BaseProduction("..productiontable.factory.Owner.Name..") called")  

	if productiontable.factory.IsDead then  
    RemoveFromList(ActiveProductionTable, productiontable)
		return
	end

  if productiontable.activated and (QueuePerFactory or not productiontable.factory.HasProperty("IsPrimaryBuilding") or productiontable.factory.IsPrimaryBuilding) then
    -- Evaluate build priority
    local h = productiontable.factory.Owner
    EvaluateAIBaseBehaviour(h, productiontable.tab)
    local h_priority = GetStructurePriority(h)
    
    -- Check prereqs
    local validstructures = { }
    Utils.Do(BaseNodes, function(tt)
      if tt.mapactor ~= nil or tt.curr_factory then return end
      if CheckPrerequisites(tt.owner, tt.prereq) then
        table.insert(validstructures, tt)
      end
    end)
    
    for i,v in ipairs(validstructures) do
      if v.mapactor == nil and v.owner == h and (h_priority == nil or v.priority == h_priority) then			
        -- apply multipliers
        local buildtime = v.buildtime * GetBuildTimeMultiplier(h, v.tab)
        local cost = v.cost * GetCostMultiplier(h, v.tab)
        
        productiontable.curr_production = v.type
        v.curr_factory = productiontable.factory
        BuildActor(v, productiontable, buildtime, cost)
        return
      end
    end
  end

	-- periodic recheck
	Trigger.AfterDelay(Utils.RandomInteger(200, 1250), function() BaseProduction(productiontable) end)
end



------------------------------------------------------------------------------------

------------------------------------------------------------------------------------
------ AI Base evaluation to set building priority
function EvaluateAIBaseBehaviour (cty, tab)
  AddDebugString("EvaluateAIBaseBehaviour(Player = "..cty.Name..", Tab = "..tab..") called")
  
	local baselist = { }
	local prioritylist = { }
  
	-- populate lists (Figure out a more efficient way to handle this)
	Utils.Do(ExistingBuildings, function(actor)
    if actor.Owner == cty then
      table.insert(baselist, actor)
      local mb = GetBuildingfromMasterList(actor.Type, cty.Name)
      if mb ~= nil then		
        if mb.priority ~= nil then
          if prioritylist[mb.priority] == nil then prioritylist[mb.priority] = { } end
          table.insert(prioritylist[mb.priority], actor)
        end
      end
    end  
	end)

	-- check for power		
	if cty.PowerProvided - cty.PowerDrained < Houses[cty.Name].AIMaintainExcessPower then
		if CheckandSetStructurePriority(cty, tab, "power") then return end
	end
	
	-- check for economy
	if prioritylist["economy"] == nil or #prioritylist["economy"] < PriorityFractions["economy"] * #baselist then 
		if CheckandSetStructurePriority(cty, tab, "economy") then return end
	end	
  
  if cty.Cash + cty.Resources < Houses[cty.Name].AIEmergencyCashThreshold then
    SetStructurePriority(cty, "economy")
    return
  end

	-- check for production	
	if prioritylist["production"] == nil or #prioritylist["production"] < PriorityFractions["production"] * #baselist then 
		if CheckandSetStructurePriority(cty, tab, "production") then return end
	end	
	
	-- check for tech
	if prioritylist["tech"] == nil or #prioritylist["tech"] < PriorityFractions["tech"] * #baselist then 
		if CheckandSetStructurePriority(cty, tab, "tech") then return end
	end	
	
  -- check for defence
  if prioritylist["defence"] == nil or #prioritylist["defence"] < PriorityFractions["defence"] * #baselist then 
		if CheckandSetStructurePriority(cty, tab, "defence") then return end
	end	
  
	SetStructurePriority(cty, nil)	
end

function CheckandSetStructurePriority (cty, tab, priority) --returns true if priority has been set
  AddDebugString("CheckandSetStructurePriority(Player = "..cty.Name..", Tab = "..tab..", Priority = "..priority..") called")  

	local priorityset = false
	Utils.Do(BaseNodes, function(mb)
      
    -- TO DO: CHECK FOR PREREQUISITES    
		if mb.owner == cty and mb.priority == priority and (not SplitConYardTab or mb.tab == tab) and mb.mapactor == nil and mb.curr_factory == nil then
      if CheckPrerequisites(mb.owner, mb.prereq) then
        SetStructurePriority(cty, priority)
        priorityset = true
        return
      end
		end
	end)
	return priorityset
end

function GetStructurePriority (player)
  AddDebugString("GetStructurePriority(Player = "..player.Name..") called")  
 	local str = nil
  if Houses[player.Name] ~= nil then str = Houses[player.Name].StructurePriority end
	
  return str
end

function SetStructurePriority (player, newpriority)
  AddDebugString("SetStructurePriority(Player = "..player.Name..", Priority = "..(newpriority or "")..") called")  
  if Houses[player.Name] == nil then Houses[player.Name] = { } end
  Houses[player.Name].StructurePriority = newpriority
end




------------------------------------------------------------------------------------

