-----------------------------------------------------------------------------------------------------------------------
------------------ LUA SCRIPTS FOR MISSION CONTROL AND AI IMPLEMENTATION
---------------------- by lovalmidas
-----------------------------------------------------------------------------------------------------------------------
-- UI DISPLAY LUA  VERSION 1.0
-- #
------ Contains:  
---------- TickShowInfo() 
---------- AI Team calculations
-------------- AIGroupInfo(string str, Player cty, string actorgroupname)
-------------- AIGroupSurvivor(Player cty, string actorgroupname)

function TickShowInfo()
  AddDebugString("TickShowInfo() called") 
  
  -- Disable during debug
  if bdebug then return end
  
  -- Disable if missionDisplayPlayer is not defined
  if missionDisplayPlayer == nil then return end
  
  local str = ""
  
  -- Objectives Display
  if missionDisplayObjectives and #missionObjectiveIDs > 0 then 
    Utils.Do(missionObjectiveIDs, function(id)
      if MissionPlayer.GetObjectiveType(id) ~= "Primary" then return end
      if str == "" then
        str = "\nObjective"..((#missionObjectiveIDs > 1) and "s" or "")..": \n     "..str..MissionPlayer.GetObjectiveType(id)..":  "..MissionPlayer.GetObjectiveDescription(id)
      else
        str = "\n"..str.."\n     "..MissionPlayer.GetObjectiveType(id)..":  "..MissionPlayer.GetObjectiveDescription(id)
      end
      if missionObjectiveFlavourText[id] ~= nil then str = str.." ("..missionObjectiveFlavourText[id]..")" end
    end)
  
    Utils.Do(missionObjectiveIDs, function(id)
      if MissionPlayer.GetObjectiveType(id) == "Primary" then return end
      if str == "" then
        str = "\nObjective"..((#missionObjectiveIDs > 1) and "s" or "")..": \n     "..str..MissionPlayer.GetObjectiveType(id)..":  "..MissionPlayer.GetObjectiveDescription(id)
      else
        str = "\n"..str.."\n     "..MissionPlayer.GetObjectiveType(id)..":  "..MissionPlayer.GetObjectiveDescription(id)
      end
      if missionObjectiveFlavourText[id] ~= nil then str = str.." ("..missionObjectiveFlavourText[id]..")" end
    end)
  
    str = "\n"..str.."\n"
  end
 
  -- Divider
  if missionDisplayResource or missionDisplayProduction or missionDisplayAITeams or missionDisplayAICustomTeams then
    -- for 120 characters max length without shifting the textbox
    str = str .."________________________________________________________________________________________________________________________\n".. missionDisplayPlayer.Name .." Player Information" 
  end
    
  -- Resources Display
	if missionDisplayResource then 
		local gnumproc = #FindOwnedActorType(missionDisplayPlayer, "proc")
		local gnumharv = #missionDisplayPlayer.GetActorsByType("harv") --FindOwnedActorType(cty, "harv")
    
		str = "\n".. str .."\n  Resources: ".. (missionDisplayPlayer.Cash + missionDisplayPlayer.Resources) .." / ".. gnumproc .." Refiner"..( (gnumproc > 1) and "ies" or "y" ).." / ".. gnumharv .." Ore Truck".. ((gnumharv > 1) and "s" or "")
  end
  
  -- Production Display (AI only)
 	if missionDisplayProduction then 
		local str_factory = ""

		Utils.Do(ActiveProductionTable, function(t)
			if t.factory.Owner == missionDisplayPlayer and t.progress > 0 then
				local intprog = (t.progress - t.progress % 1000) / 1000
				if str_factory == "" then--t.factory.Type == "fact" then
					str_factory = "  ".. GetName(t.curr_production) .."(".. intprog .."%) ".. str_factory
				else
					str_factory = str_factory .." ".. GetName(t.curr_production) .."(".. intprog .."%) "
				end
			end
		end)
		
		if str_factory ~= "" then
			str = "\n\n".. str .."\n\nProducing: \n".. str_factory
		else
			str = "\n\n".. str .."\n\nNot producing anything.\n"
		end
  end
  
  -- AI Team Display
 	if missionDisplayAITeams then    
    if type(AIActorGroups[missionDisplayPlayer.Name]) == "table" then
      str = "\n\n\n"..str.."\n\n"..(missionDisplayAICustomTeams and "Advanced" or "Basic").." AI Teams: \n"
      str = AIGroupInfo(str, missionDisplayPlayer, "Pool")
      str = AIGroupInfo(str, missionDisplayPlayer, "Hunt")
      str = AIGroupInfo(str, missionDisplayPlayer, "Defence")
      str = AIGroupInfo(str, missionDisplayPlayer, "DefenceEscort")  
      
      local totaltroopsinteams = 0
      local str2 = ""
      for actorgroupname,actors in pairs(AIActorGroups[missionDisplayPlayer.Name]) do 
        if not (actorgroupname == "Pool" or actorgroupname == "Hunt" or actorgroupname == "Defence" or actorgroupname == "DefenceEscort") then
          if missionDisplayAICustomTeams then
            local str3 = str2
            str2 = AIGroupInfo(str2, missionDisplayPlayer, actorgroupname)
            if str3 ~= str2 then str = "\n" .. str end
          end
          totaltroopsinteams = totaltroopsinteams + AIGroupSurvivor(missionDisplayPlayer, actorgroupname)
        end
      end
      
      str = str.."  In Active Taskforce: "..totaltroopsinteams.."  "
      str = str..str2
    end
    
		--str = "\n".. str .."\n\n".. str_message
	end

	UserInterface.SetMissionText(str, missionDisplayPlayer.Color)
end


function AIGroupInfo (str, cty, actorgroupname)
  AddDebugString("AIGroupInfo() called") 
  local statusstr = ""
  if AIGroupStatus[cty.Name] == nil then return str
  elseif AIGroupStatus[cty.Name][actorgroupname] == nil then return str
  elseif AIGroupStatus[cty.Name][actorgroupname] == -3 then statusstr =   "Returning to Pool" 
  elseif AIGroupStatus[cty.Name][actorgroupname] == -2 then statusstr =   "On Hold" 
  elseif AIGroupStatus[cty.Name][actorgroupname] == -1 then statusstr =   "Populating" 
  elseif AIGroupStatus[cty.Name][actorgroupname] > 0 then statusstr =     "Executing Script #"..math.modf(AIGroupStatus[cty.Name][actorgroupname])
  end
  
  if (statusstr ~= "" and statusstr ~= nil) or (actorgroupname == "Pool" or actorgroupname == "Hunt" or actorgroupname == "Defence" or actorgroupname == "DefenceEscort") then
    local statussurvivor = 0
    local statusgroup = ""
    if AIActorGroups[cty.Name][actorgroupname] ~= nil then
      Utils.Do(AIActorGroups[cty.Name][actorgroupname], function(a)
          if not a.IsDead then 
            statussurvivor = statussurvivor + 1 
            statusgroup = statusgroup .. " " .. a.Type --GetName(a.Type)
          end
      end)
    end
    
    if statussurvivor ~= 0 or (actorgroupname == "Pool" or actorgroupname == "Hunt" or actorgroupname == "Defence" or actorgroupname == "DefenceEscort") then
      if (actorgroupname == "Pool" or actorgroupname == "Hunt" or actorgroupname == "Defence" or actorgroupname == "DefenceEscort") then
        return str.."  "..actorgroupname..": "..statussurvivor.."  "--.. statusgroup
      else
        return str.."\n  ["..actorgroupname.."]  Units: "..statussurvivor.." / "..#AITeamClone[cty.Name][actorgroupname]..", "..statusstr.."   "--.. statusgroup
      end
    end
  end
  return str
end

function AIGroupSurvivor (cty, actorgroupname)
  AddDebugString("AIGroupSurvivor() called") 
  if AIGroupStatus[cty.Name] == nil then return 0
  elseif AIGroupStatus[cty.Name][actorgroupname] == nil then return 0
  end
  
  if not (actorgroupname == "Pool" or actorgroupname == "Hunt" or actorgroupname == "Defence" or actorgroupname == "DefenceEscort") then
    local statussurvivor = 0
    if AIActorGroups[cty.Name][actorgroupname] ~= nil then
      Utils.Do(AIActorGroups[cty.Name][actorgroupname], function(a)
          if not a.IsDead then 
            statussurvivor = statussurvivor + 1 
          end
      end)
    end
    return statussurvivor
  end
end



function AddDebugString(str)
  
  if bdebug then
    local i = 50
    if i > #DebugStrings then i = #DebugStrings end
    while i >= 1 do
      DebugStrings[i+1] = DebugStrings[i]
      i = i - 1
    end
    debugfnnumber = debugfnnumber + 1
    DebugStrings[1] = "Tick "..missiontick..":"..debugfnnumber..":  "..str
    DebugShowInfo() 
  end
end

function DebugShowInfo()
  
  local str = ""
  for i = 1, #DebugStrings do
    str = "\n"..str.."\n"..DebugStrings[i]
  end
    
  str = "________________________________________________________________________________________________________________________\n".. str
  UserInterface.SetMissionText(str, HSLColor.White)
end