-----------------------------------------------------------------------------------------------------------------------
------------------ LUA SCRIPTS FOR MISSION CONTROL AND AI IMPLEMENTATION
---------------------- by lovalmidas
-----------------------------------------------------------------------------------------------------------------------
-- SETUP AI LUA  VERSION 1.0
-- #6
------ Contains:  
---------- InitialiseAI() 
---------- AI initialization and table set up
-------------- SetupMapUnits()
-------------- ActivateAI()
---------- AI utilities
-------------- HouseStructureRepair(Player player, double n)
-------------- SingleStructureRepair(Actor actor, double n)

-------- MAIN FUNCTION TO ATTACH TO WorldLoaded()
function InitialiseAI ()
  AddDebugString("InitialiseAI() called")  
  SetupMapUnits() --called earlier to prevent AI units from moving out of position
  ActivateAI()
end

------------------------------------------------------------------------------------------------------------------
-- Initial unit setup
function SetupMapUnits ()
  AddDebugString("SetupMapUnits() called")  

	Utils.Do(Map.NamedActors, function(a) --use namedactors to apply change only on pre-placed units.
    if a.IsDead then return end
    -- Act only on Bots
    Utils.Do(HouseGroups.Bots, function (bot)
      if a.Owner == bot then
        if a.Type == "dog" then
          a.Stance = "AttackAnything"
        elseif a.HasProperty("Stance") then
          a.Stance = "Defend"
          -- attack persistent attackers
          if a.HasProperty("AttackMove") and a.HasProperty("Health") then
            pcall( -- Why doesn't everyone have ScriptTriggers trait?!? 
              Trigger.OnDamaged(a, function(b)
                if b.Health < Houses[bot.Name].AIUnitHPPursuit * b.MaxHealth then
                  b.Stance = "AttackAnything"
                end
              end)
            )
          end
        end
      end
    end)

			
    -- convert all walls to neutral
    if (a.Type == "brik" or a.Type == "cycl" or a.Type == "fenc" or a.Type == "sbag") and a.Owner ~= NeutralPlayer then
      a.Owner = NeutralPlayer
    end 
	end)
end


function ActivateAI ()
  AddDebugString("ActivateAI() called") 
  
  -- Activate existing ConYards
  SetupConYards()
  
  -- Activate structure repair for bots
	Utils.Do(HouseGroups.Bots, function(bot) HouseStructureRepair(bot, Houses[bot.Name].AIStructureHPRepair) end)
	
  -- Activate production structures
  local productionactors = Utils.Where(Map.ActorsInWorld, function(actor) return not actor.IsDead and Utils.Any(HouseGroups.Bots, function (bot) 
return actor.Owner == bot end) and GetFactoryTab(actor.Type) ~= nil end)
  Utils.Do(productionactors, function(actor)
    SetupProductionBuilding(actor, GetFactoryTab(actor.Type))
	end)
end



-- All houses to repair structures
function HouseStructureRepair (cty,n) -- cty is house, n is the fraction of health to start repairing
  AddDebugString("HouseStructureRepair("..cty.Name..","..n..") called")  

	Utils.Do(Map.ActorsInWorld, function(actor)
    if actor.IsDead then return end
		if actor.Owner == cty then SingleStructureRepair(actor,n) end
	end)
end
	
 -- trigger repair structure
function SingleStructureRepair (actor,n) -- cty is house, n is the fraction of health to start repairing
  AddDebugString("SingleStructureRepair("..actor.Owner.Name..","..actor.Type..","..n..") called") 

  if actor.IsDead then return end
  if actor.HasProperty("StartBuildingRepairs") then -- ensure the actor can be repaired
    pcall( -- Why doesn't everyone have ScriptTriggers trait?!? 
      Trigger.OnDamaged(actor, function(building)
        if building.HasProperty("StartBuildingRepairs") and building.Health < n * building.MaxHealth then
          building.StartBuildingRepairs()
        end
      end)
    )
  end
end

