-----------------------------------------------------------------------------------------------------------------------
------------------ LUA SCRIPTS FOR MISSION CONTROL AND AI IMPLEMENTATION
---------------------- by lovalmidas
-----------------------------------------------------------------------------------------------------------------------
-- #MASTER TABLES LUA  VERSION 1.0
-- #U00
------ Contains: 

-- Master Table for building and unit lists
---- Production
------ Infantry / Units / Ships / Aircraft
---------- type                 = the actortype
---------- factory              = the actortype of factory producing it, defaults to nil
---------- prereq               = array of actortypes of prerequisites needed, defaults to nil
---------- side                 = array of sides/factions that will produce it. Can accept "allies", "soviets", and individual Player.Names, defaults to nil
---------- weight               = production weight given in the production selection. Defaults to 1
---------- cost                 = cost override. Defaults to Actor.Cost(type)
---------- buildtime            = buildtime override. Defaults to Actor.BuildTime(type)
---------- toprotect            = whether an attack on this actor will trigger the creation of a Defence team
---------- 
---------- anti-infantry        = To be implemented
---------- anti-armor           = To be implemented
---------- anti-structure       = To be implemented
----------
------ Structures / Defences
---------- type                 = the actortype
---------- priority             = a category for the struture for AI consideration. Defaults to nil
---------- prereq               = array of actortypes of prerequisites needed, defaults to nil
---------- side                 = array of sides/factions that will produce it. Can accept "allies", "soviets", and individual Player.Names, defaults to nil
---------- cost                 = cost override for AI production. Defaults to Actor.Cost(type)
---------- buildtime            = buildtime override for AI production. Defaults to Actor.BuildTime(type)
---------- toprotect            = whether an attack on this actor will trigger the creation of a Defence team
---------- 
---------- anti-infantry        = To be implemented
---------- anti-armor           = To be implemented
---------- anti-structure       = To be implemented
----------
---- Names
---------- type = name          Use GetName(type) to derive the name from the MasterTable
----------
---- Groupings
---------- (groupname)          = variant[], mostly string[]. Use IsPartOfGrouping(type, groupname) to determine if it is part of this group.



-----------------------------------------------------------------------------------------------------------------------
-- MasterTable.Production

GenerateMasterTable = function()
  MasterTable.Production["Infantry"] =
  {
    -- Allied units
    { type = "e1", factory = "tent", prereq = {}, side = { "allies" }, weight = 6 }, 
    { type = "e3", factory = "tent", prereq = {}, side = { "allies" }, weight = 4 }, 
    { type = "medi", factory = "tent", prereq = {}, side = { "allies" }, weight = 1 },   
    -- Soviet units
    { type = "e1", factory = "barr", prereq = {}, side = { "soviet" }, weight = 6 }, 
    { type = "e2", factory = "barr", prereq = {}, side = { "soviet" }, weight = 3 }, 
    { type = "e3", factory = "barr", prereq = {}, side = { "soviet" }, weight = 3 }, 
    { type = "e4", factory = "barr", prereq = {"dome"}, side = { "soviet" }, weight = 2 }, 
    { type = "shok", factory = "barr", prereq = {"stek","tsla"}, side = { "soviet" }, weight = 1 }, 
    { type = "dog", factory = "kenn", prereq = {}, side = { "soviet" }, weight = 1 }, 
  }

  MasterTable.Production["Units"] =
  {
    --{ type = "harv", factory = "weap", prereq = {"proc"}, side = { "allies", "soviet" }, weight = 0, toprotect = true }, 
    -- Allied units
    { type = "jeep", factory = "weap", prereq = {}, side = { "allies" }, weight = 4 }, 
    { type = "1tnk", factory = "weap", prereq = {}, side = { "allies" }, weight = 4 },
    { type = "2tnk", factory = "weap", prereq = {"fix"}, side = { "allies" }, weight = 6 },
    { type = "arty", factory = "weap", prereq = {"dome"}, side = { "allies" }, weight = 6 }, 
    { type = "stnk", factory = "weap", prereq = {"atek"}, side = { "allies" }, weight = 8 },     
    -- Soviet units
    { type = "ftrk", factory = "weap", prereq = {}, side = { "soviet" }, weight = 4 }, 
    { type = "3tnk", factory = "weap", prereq = {"fix"}, side = { "soviet" }, weight = 4 },
    { type = "v2rl", factory = "weap", prereq = {"dome"}, side = { "soviet" }, weight = 6 },
    { type = "ttnk", factory = "weap", prereq = {"stek","tsla"}, side = { "soviet" }, weight = 8 },
    { type = "4tnk", factory = "weap", prereq = {"stek"}, side = { "soviet" }, weight = 8 },
  }

  MasterTable.Production["Aircraft"] =
  {
    -- Allied units
    { type = "hind", factory = "hpad", prereq = {}, side = { "allies" },  weight = 2 }, 
    { type = "heli", factory = "hpad", prereq = {"atek"}, side = { "allies" }, weight = 3 }, 
    -- Soviet units
    { type = "yak", factory = "afld", prereq = {}, side = { "soviet" }, weight = 2 },  
    { type = "mig", factory = "afld", prereq = {"stek"}, side = { "soviet" }, weight = 3 }, 
  }

  MasterTable.Production["Ships"] =
  {
        -- Allied units
    { type = "pt", factory = "syrd", prereq = {}, side = { "allies" },  weight = 2 }, 
    { type = "dd", factory = "syrd", prereq = {"dome"}, side = { "allies" }, weight = 3 }, 
    -- Soviet units
    { type = "ss", factory = "spen", prereq = {}, side = { "soviet" }, weight = 2 },  
  }

  MasterTable.Production["Structures"] = 
  {
    -- Unbuildable
    { type = "fact", priority = "nobuild", prereq = {"nobuild"}, side = { "allies", "soviet" }, toprotect = true },
    
    -- Common structures
    { type = "powr", priority = "power", prereq = {}, side = { "allies", "soviet" }, toprotect = true },
    { type = "proc", priority = "economy", prereq = {"powr"}, side = { "allies", "soviet" }, toprotect = true },
    { type = "weap", priority = "production", prereq = {"proc"}, side = { "allies", "soviet" }, toprotect = true },
    { type = "silo", priority = "", prereq = {"proc"}, side = { "allies", "soviet" } },
    { type = "fix", priority = "tech", prereq = {"weap"}, side = { "allies", "soviet" }, toprotect = true },
    { type = "dome", priority = "tech", prereq = {"proc"}, side = { "allies", "soviet" }, toprotect = true },
    { type = "apwr", priority = "power", prereq = {"dome"}, side = { "allies", "soviet" }, toprotect = true },
   
    -- Allied structures
    { type = "tent", priority = "production", prereq = {"powr"}, side = { "allies" }, toprotect = true },
    { type = "hpad", priority = "production", prereq = {"tent"}, side = { "allies" }, toprotect = true },
    { type = "atek", priority = "tech", prereq = {"dome"}, side = { "allies" }, toprotect = true },
    { type = "syrd", priority = "production", prereq = {"powr"}, side = { "allies" }, toprotect = true },

    -- Soviet structures
    { type = "barr", priority = "production", prereq = {"powr"}, side = { "soviet" }, toprotect = true },
    { type = "kenn", priority = "production", prereq = {"powr"}, side = { "soviet" }, toprotect = true },
    { type = "afld", priority = "production", prereq = {"dome"}, side = { "soviet" }, toprotect = true },
    { type = "stek", priority = "tech", prereq = {"dome"}, side = { "soviet" }, toprotect = true },
    { type = "spen", priority = "production", prereq = {"powr"}, side = { "soviet" }, toprotect = true }
  }

  MasterTable.Production["Defences"] = 
  {
    -- Unbuildable
    { type = "pdox", priority = "tech", prereq = {"nobuild"}, side = { "allies" }, toprotect = true },
    { type = "iron", priority = "tech", prereq = {"nobuild"}, side = { "soviet" }, toprotect = true },
    { type = "gap", priority = "", prereq = {"nobuild"}, side = { "allies" } },
    { type = "mslo", priority = "tech", prereq = {"nobuild"}, side = { "allies", "soviet" }, toprotect = true },
    
    -- Allied structures
    { type = "pbox", priority = "defence", prereq = {"tent"}, side = { "allies" } },
    { type = "gun", priority = "defence", prereq = {"tent"}, side = { "allies" } },
    { type = "hbox", priority = "defence", prereq = {"tent"}, side = { "allies" } },
    { type = "agun", priority = "defence", prereq = {"tent"}, side = { "allies" } },
    
    -- Soviet structures
    { type = "ftur", priority = "defence", prereq = {"barr"}, side = { "soviet" } },
    { type = "tsla", priority = "defence", prereq = {"weap"}, side = { "soviet" } },
    { type = "sam", priority = "defence", prereq = {"weap"}, side = { "soviet" } }
  }

  -- For queue per factory 
  MasterTable.Production.ConstructionYard = { } 
  for k,v in pairs(MasterTable.Production.Structures) do MasterTable.Production.ConstructionYard[k] = v end
  for k,v in pairs(MasterTable.Production.Defences) do MasterTable.Production.ConstructionYard[k] = v end
end

function GetTabbedProductionfromMasterList (t, s, tab) -- t = building type, s = player or side name
  AddDebugString("GetTabbedProductionfromMasterList("..t..", "..s..", "..tab..") called")  

  for _,v in ipairs(MasterTable.Production[tab]) do
    local sd = Set (v.side)
    if v.type == t and sd[side] == s then
      v.tab = tab
      return v
    end
  end
  
  -- s is not a Faction name, refer to the Faction
  if Player.GetPlayer(s) ~= nil then 
    return GetTabbedProductionfromMasterList(t, Player.GetPlayer(s).Faction, tab)
  end
  
  return nil
end

function GetInfantryfromMasterList (t, s) -- t = building type, s = player or side name
  AddDebugString("GetInfantryfromMasterList("..t..", "..s..") called")  
  for _,v in ipairs(MasterTable.Production.Infantry) do
    local sd = Set (v.side)
    if v.type == t and sd[side] == s then
      v.tab = "Infantry"
      return v
    end
  end
  
  -- s is not a Faction name, refer to the Faction
  if Player.GetPlayer(s) ~= nil then 
    return GetInfantryfromMasterList(t, Player.GetPlayer(s).Faction)
  end
  
  return nil
end

function GetUnitsfromMasterList (t, s) -- t = building type, s = player or side name
  AddDebugString("GetUnitsfromMasterList("..t..", "..s..") called")  
  for _,v in ipairs(MasterTable.Production.Units) do
    local sd = Set (v.side)
    if v.type == t and sd[side] == s then
      v.tab = "Units"
      return v
    end
  end
  
  -- s is not a Faction name, refer to the Faction
  if Player.GetPlayer(s) ~= nil then 
    return GetUnitsfromMasterList(t, Player.GetPlayer(s).Faction)
  end
  
  return nil
end

function GetShipsfromMasterList (t, s) -- t = building type, s = player or side name
  AddDebugString("GetShipsfromMasterList("..t..", "..s..") called")  
  for _,v in ipairs(MasterTable.Production.Ships) do
    local sd = Set (v.side)
    if v.type == t and sd[side] == s then
      v.tab = "Ships"
      return v
    end
  end
  
  -- s is not a Faction name, refer to the Faction
  if Player.GetPlayer(s) ~= nil then 
    return GetShipsfromMasterList(t, Player.GetPlayer(s).Faction)
  end
  
  return nil
end

function GetAircraftfromMasterList (t, s) -- t = building type, s = player or side name
  AddDebugString("GetAircraftfromMasterList("..t..", "..s..") called")  
  for _,v in ipairs(MasterTable.Production.Aircraft) do
    local sd = Set (v.side)
    if v.type == t and sd[side] == s then
      v.tab = "Aircraft"
      return v
    end
  end
  
  -- s is not a Faction name, refer to the Faction
  if Player.GetPlayer(s) ~= nil then 
    return GetAircraftfromMasterList(t, Player.GetPlayer(s).Faction)
  end
  
  return nil
end

function GetBuildingfromMasterList (t, s) -- t = building type, s = player or side name
  --AddDebugString("GetBuildingfromMasterList("..t..", "..s..") called")  
  return GetStructuresfromMasterList(t, s) or GetDefencesfromMasterList(t, s)
end

function GetStructuresfromMasterList (t, s) -- t = building type, s = player or side name
  --AddDebugString("GetStructuresfromMasterList("..t..", "..s..") called")  
	for _,v in ipairs(MasterTable.Production.Structures) do
    local sd = Set(v.side)
		if v.type == t and sd[s] then
      v.tab = "Structures"
			return v
		end
	end
  
  -- s is not a Faction name, refer to the Faction
  if Player.GetPlayer(s) ~= nil then 
    return GetStructuresfromMasterList(t, Player.GetPlayer(s).Faction)
  end
  
  return nil
end


function GetDefencesfromMasterList (t, s) -- t = building type, s = player or side name
  --AddDebugString("GetDefencesfromMasterList("..t..", "..s..") called")  
  for _,v in ipairs(MasterTable.Production.Defences) do
    local sd = Set(v.side)
		if v.type == t and sd[s] then
      v.tab = "Defences"
			return v
		end
	end
  
  -- s is not a Faction name, refer to the Faction
  if Player.GetPlayer(s) ~= nil then 
    return GetDefencesfromMasterList(t, Player.GetPlayer(s).Faction)
  end
  
  return nil
end

-----------------------------------------------------------------------------------------------------------------------
-- MasterTable.Names
MasterTable.Names = 
{
	-- Tanks
	["1tnk"] = "Light Tank",
	["2tnk"] = "Medium Tank",
	["3tnk"] = "Heavy Tank",
	["4tnk"] = "Mammoth Tank",
	["apc"]  = "APC",
	["v2rl"] = "V2 Rocket Launcher",
	["arty"] = "Artillery",
	["jeep"] = "Ranger",
	["harv"] = "Ore Truck",
	["mcv"] = "Mobile Construction Vehicle",
	["mnly.ap"] = "Minelayer",
	["mnly.at"] = "Minelayer",
	["truk"] = "Supply Truck",
	["dtrk"] = "Demolition Truck",
	["mgg"] = "Mobile Gap Generator",
	["mrj"] = "Mobile Radar Jammer",
	["ttnk"] = "Tesla Tank",
	["ftrk"] = "Mobile Flak",
	["ctnk"] = "Chrono Tank",
	["qtnk"] = "MAD Tank",
	["stnk"] = "Phase Transport",

	-- Infantry
	["e1"] = "Rifle Infantry",
	["e2"] = "Grenadier",
	["e3"] = "Rocket Soldier",
	["e4"] = "Flamethrower",
	["e5"] = "",
	["e6"] = "",
	["e7"] = "Agent Tanya",
  ["medi"] = "Medic",
	["shok"] = "Shock Trooper",
	["dog"] = "Dog",

	-- Ships
	["pt"] = "Gunboat",
	["dd"] = "Destroyer",
	["ss"] = "Submarine",
	["ca"] = "Cruiser",
	["lst"] = "Naval Transport",
	
	-- Aircraft
	["yak"] = "Yak Attack Plane",
	["mig"] = "MIG Fighter",
	["tran"] = "Transport Helicopter",
	["hind"] = "Hind",
	["heli"] = "Longbow",
	
	-- Structures
	["fact"] = "Construction Yard",
	["powr"] = "Power Plant",
	["apwr"] = "Advanced Power Plant",
	["proc"] = "Ore Refinery",
	["silo"] = "Ore Silo",
	["barr"] = "Soviet Barracks",
	["tent"] = "Allied Barracks",
	["weap"] = "War Factory",
	["fix"] = "Service Depot",
	["dome"] = "Radar Dome",
	["atek"] = "Allied Tech Center",
	["stek"] = "Soviet Tech Center",
	["ftur"] = "Flame Tower",
	["tsla"] = "Tesla Coil",
	["sam"] = "SAM Site",
	["pbox"] = "Pillbox",
	["hbox"] = "Camo Pillbox",
	["gun"] = "Gun Turret",
	["agun"] = "AA Gun",
	["hpad"] = "Helipad",
	["afld"] = "Airfield",
	["kenn"] = "Kennel"

}

-- Gets true name from type
function GetName (stype)
  AddDebugString("GetName("..stype..") called")  
  return MasterTable.Names[stype] or stype
end


-----------------------------------------------------------------------------------------------------------------------
-- MasterTable.Groupings
MasterTable.Groupings = {
  ConstructionYards = { "fact" },
  Factories = { "kenn", "barr", "tent", "weap", "hpad", "afld", "spen", "syrd" },
  Refineries = { "proc" },
  Harvesters = { "harv" },
  ToProtect = { "harv", "fact", "powr", "proc", "weap", "fix", "dome", "apwr", "tent", "hpad", "atek", "syrd", "barr", "kenn", "afld", "stek", "spen", "pdox", "iron", "mslo" },
  --HarvesterFactories = { "weap" },
  AirUnits = { "tran", "hind", "heli", "yak", "mig" }, -- Amphibious zone
  NavalUnits = { "ss", "pt", "dd", "ca", "lst" }, -- Water zone 
}

function IsPartOfGrouping (stype, groupname)
  local result = false
  Utils.Do(MasterTable.Groupings[groupname], function(element)
    if element == stype then result = true end
  end)
  return result
end


