-----------------------------------------------------------------------------------------------------------------------
------------------ LUA SCRIPTS FOR MISSION CONTROL AND AI IMPLEMENTATION
---------------------- by lovalmidas
-----------------------------------------------------------------------------------------------------------------------
-- #INCLUDE LUA  VERSION 1.0
-- #1
------ Contains:  
---------- (as comments) Yaml setup requirements to not cause a game error
---------- All Global declarations
---------- Global initializations to default values 
---------- no functions here

------ Full lua bundle:
---------- #0 LUA UTILITIES               : Generic lua functions
---------- #1 #INCLUDE LUA                : This file
---------- #2 MAIN LUA                    : Main function calls for the world
---------- #3 SETUP PLAYERS LUA           : Initialization of players for AI use
---------- #4 ACTOR REGISTRY LUA          : Initialization of actors for AI use
---------- #5 SETUP BASES LUA             : Initialization of base nodes for AI use
---------- #6 SETUP AI LUA                : Initialization of AI
---------- #7 ECONOMY LUA                 : Economy-based functions
---------- #8 AI PRODUCTION GENERAL LUA   : AI production functions
---------- #9 AI PRODUCTION BASES LUA     : AI production functions for bases
---------- #10 AI PRODUCTION UNITS LUA    : AI production functions for factory units
---------- #11 AI SCRIPT FUNCTIONS LUA    : Script functions for AI teams
---------- #12 AI TEAMS LUA               : AI team management
---------- #13 REINFORCEMENTS LUA         : AI reinforcement functions
---------- #14 UI DISPLAY LUA             : Manages the mission text display for UI purposes.

---------- #U00 MASTER TABLES LUA         : 'Master' tables with mod specific rules. AI will use the master table for its 'rules' definitions.
----------


-----------------------------------------------------------------------------------------------------------------------
-- YAML setup requirements
------ All map players defined in map.yaml should have a well-defined Faction. ("soviet" or "allies")
------ Lua script files to be arranged in the order shown on the bundle list above

-----------------------------------------------------------------------------------------------------------------------
-- Debug mode activation switch
bdebug = false
debugfnnumber = 0
DebugStrings = { } -- string[], populated by the script

-----------------------------------------------------------------------------------------------------------------------
-- Main.lua: Timer counters
------ Tick tracker
missiontick = 0 -- Reference this to determine the current tic

------ Time (in seconds) before activating production AI. Can be re-set in user defined function PostSetupManualOverride()
missionAIDelaySeconds = 4

AIActivated = false

------ Time (in ticks) control for calling AI team control functions 
missionAITeamControlDelay = { low = 150, high = 350 } -- table { int low, int high }. Tick interval for subsequent AISingleTeamControl
missionAIReservedTeamControlDelay = { low = 750, high = 1250 } -- table { int low, int high }. Tick interval for subsequent AISingleReservedTeamControl


------ Camera for reveal purposes. Insert camera Actors here, to be referenced by Main -> ToggleReveal()
CameraSets = { } -- Actor[]
InitialPosition = DefaultCameraPosition -- Actor, where the initial camera should be set up. Nil to disable

-----------------------------------------------------------------------------------------------------------------------
-- SetupPlayers.lua： Global Players
------ Default players who should exist in every map, regardless of their name
MissionPlayer = Player.GetPlayers(function(p) return p.IsLocalPlayer end)[1]
NeutralPlayer = Player.GetPlayers(function(p) return p.IsNonCombatant end)[1]

------ Default player groupings. 
------ Note that Allied and Soviet bot groups are not sorted according to whether they are friendly/enemy to the player. 
------ Nor is Friendly/Enemy bots sorted according to whether they are allied or soviet
HouseGroups = { }
HouseGroups.All = Player.GetPlayers(function(p) return true end)
HouseGroups.Active = Player.GetPlayers(function(p) return not p.IsNonCombatant end)
HouseGroups.Humans = Player.GetPlayers(function(p) return (p.IsLocalPlayer and not p.IsNonCombatant) end) 
HouseGroups.Bots = Player.GetPlayers(function(p) return (not p.IsLocalPlayer and not p.IsNonCombatant) end) 
HouseGroups.AlliedBots = Player.GetPlayers(function(p) return (p.Faction == "allies" and not p.IsLocalPlayer and not p.IsNonCombatant) end)
HouseGroups.SovietBots = Player.GetPlayers(function(p) return (p.Faction == "soviet" and not p.IsLocalPlayer and not p.IsNonCombatant) end)
HouseGroups.FriendlyBots = Player.GetPlayers(function(p) return (p.IsAlliedWith(MissionPlayer) and not p.IsLocalPlayer and not p.IsNonCombatant) end)
HouseGroups.EnemyBots = Player.GetPlayers(function(p) return (p.IsAlliedWith(MissionPlayer) and not p.IsLocalPlayer and not p.IsNonCombatant) end)

------- Houses, to avoid confusion with 'Player'
------- Definition: Houses[player.Name] = { Player Player, int InitialCash, float[] BuildTimeMultipliers, float[] CostMultipliers }
Houses = { } -- declare root as table
------- Perform actual initialisation in SetupPlayers.lua


-----------------------------------------------------------------------------------------------------------------------
-- SetupPlayers.lua： Global Player Settings
------ Human players (Multipliers cannot be applied to human players)
DefaultInitialCash = 0

------ Non-human players
  --    BuildTimeMultiplier: double[] {default, Structures, Defences, Infantry, Units, Aircraft, Ships}. Defaults to default, which defaults to 1
  --    CostMultipliers: double[] {default, Structures, Defences, Infantry, Units, Aircraft, Ships}. Defaults to default, which defaults to 1
AIInitialCash = 0
AIBuildTimeMultiplier = { default = 1 }
AICostMultiplier = { default = 1 }

-- Global settings to be inherited by all bots. For tweaking of values for individual AI, amend Houses[bot.Name][theSettingsToAmend] after map initialization
--AIMaintainExcessPower = 75 -- Used for AI evaluation of base production. Prioritises production that matches priority "power" if excess power falls below this valuse. 
--AIStructureHPRepair = 0.9 -- for pre-placed structures and structures produced by AI production. If HP falls below this fraction of full HP after taking damage, begin repair.
--AIUnitHPPursuit = 0.9 -- for pre-placed mobile actors only. Change stance to "AttackAnything" if HP falls below this fraction of full HP after taking damage.
--AIHarvestersPerRefinery = 3 -- Used for AI unit production from War Factory. Will override havester from factory if AI Harvester to refinery falls below this level.
--AILowCashThreshold = 5000 -- AI will strictly produce units for AI teams only if resources fall below this value.
--AIEmergencyCashThreshold = 2500 -- AI will strictly produce only Ore Refineries and Ore Trucksw for AI teams only if resources fall below this value.

AIMaintainExcessPower = 75
AIStructureHPRepair = 0.9
AIUnitHPPursuit = 0.9
AIHarvestersPerRefinery = 2.5
AILowCashThreshold = 22000
AIEmergencyCashThreshold = 3500

-----------------------------------------------------------------------------------------------------------------------
-- ActorRegistry.lua： Global
-------- DO NOT AMEND
-------- Registry of map actors - sorted as ActorRegistry[actortype] as actor[]. Used for quicker prerequisite checks. 
-- ActorRegistry is used as ActorRegistry[actortype] containing Actor[] all actors of Type actortype
-- This is to reduce the need to call the API to retrieve all map actors during prerequisite checks
-- Another check is used for ownership check, as ownership may change over the course of gameplay

ActorRegistry = { } -- Registry of actors created by map initialisation, AI production and reinforcements. Attached with a OnKilled trigger to remove them from the registry.
NoTriggerActorTypes = { } -- List of Types that do not have the ScriptTrigger trait, hence returning an error if a map trigger is connected to them. Perform manual map-wide checks on these.


-----------------------------------------------------------------------------------------------------------------------
-- SetupBases.lua： Global
-- Global declarations
BaseNodes = { } -- Actor[]. Populated by script. DO NOT AMEND. Use InitialBaseNodes to include base nodes not defined on the map.
ExistingBuildings = { } -- Actor[]. Populated by script. DO NOT AMEND
IncludeExistingBuildingsInBaseNodes = true -- Boolean. Do we include pre-placed structures as part of the base nodes?
BaseCenters = { } -- CPos[]. Auto-generated if not defined. Initialized as BaseCenter[player.name] = CPos.
InitialBaseNodes = { } -- Table value. Entries will be appended to your list of base nodes. Apply as a global initialization before map initialization. 
BaseNodePlayerSuffix = "_BaseNodes" -- String. Player with Name having this suffix will have its objects removed and its structures added to Player (without suffix) as base nodes for AI production.


-----------------------------------------------------------------------------------------------------------------------
-- SetupAI.lua： Global


-----------------------------------------------------------------------------------------------------------------------
-- Economy.lua： Global


-----------------------------------------------------------------------------------------------------------------------
-- AIProductionGeneral.lua： Global
-- Global declarations
QueuePerFactory = true -- Set to toggle whether each factory should have its own queue. Only Primary buildings will produce this value is false.
SplitConYardTab = false -- set true to split the conyard queue to Structures and Defences tabqueues
ActiveProductionTable = { }	-- Autogenerated for AI production. DO NOT AMEND. { Actor factory = nil, string tab = "", bool activated = false, string[] types = nil, curr_production = nil, progress = 0 }
BuildTick = 5 -- int. Intervals in ticks to update 'build' progress.
ProductionResolution = 100000 -- int. Cash and buildtime progress will be counted in this many units. Use a large enough number todisplay percentages accurately


-----------------------------------------------------------------------------------------------------------------------
-- AIProductionBase.lua： Global
-- Global declarations
---- PriorityFractions: Fraction of buildings in base desired by AI. Getting below this percentage will trigger AI to set priority for it, if not overwritten by other considerations.
PriorityFractions = { economy = 0.1, production = 0.2, tech = 0.1, defence = 0.25 }


-----------------------------------------------------------------------------------------------------------------------
-- AIScriptFunctions.lua： Global


-----------------------------------------------------------------------------------------------------------------------
-- AITeams.lua： Global
AITeams = { }
AIFunctions = { }
------ AIGroupToFillStatus[player.Name][groupname] = actortype[]
---------- actortype indicates actortypes needed to fill the group. 
---------- Initialised from AITeams[player.Name][groupname]
---------- Depopulated by transfer of an actor with actortype into the group.
---------- Populated with actor is killed or removed from map.
---------- Always blank for reserved groups (Pool, Defender, DefenderEscort, Hunt)
AIGroupToFillStatus = { }

------ AIGroupStatus[player.Name][groupname] = actor[] 
---------- list of actors in the group
AIActorGroups = { }

------ AIGroupStatus[player.Name][groupname] = value
---------- 0: Inactive / default for empty group. If last unit of AIActorGroups is killed, value will be set to 0.
---------- Any integer above 0: Units of AIActorGroups shall commit the functions in AI[player.Name][groupname][value]
---------- Any integer + 0.5: Units of AIActorGroups are busy executing the functions in 
---------- -1: Acquiring actors from Pool. 
---------- -2: Frozen, team on standby, not acquiring actors from Pool
---------- -3: Disband, move actors back to Pool. Set to 0 when done.
AIGroupStatus = { }

------ Cloned sets so that using TickManualOverride will not affect the process.
AITeamClone = { }
AIFunctionClone = { }



-----------------------------------------------------------------------------------------------------------------------
-- Reinforcements.lua： Global
  UnitReinforcements = { }
  AircraftReinforcements = { }
  TransportReinforcements = { }
  ParadropReinforcements = { }


-----------------------------------------------------------------------------------------------------------------------
-- ???.lua： Global





-----------------------------------------------------------------------------------------------------------------------
-- UIDisplay.lua: 
missionDisplayPlayer = MissionPlayer -- Which player should be displayed? Default to this
missionObjectiveIDs = { } -- Storage table for mission IDs. DO NOT AMEND RECKLESSLY
missionObjectiveFlavourText = { } -- Add to the mission objectives in the UI display. Key is the Objective ID. <Objective_Type>: <Objective_Description> (<FlavourText>)

------ What to display?
missionDisplayObjectives = true -- Objectives for the MissionPlayer, regardless of missionDisplayPlayer
missionDisplayResource = true -- Resources, Refinery and Ore Truck count for missionDisplayPlayer
missionDisplayProduction = true -- Display production handled by AIProductionGeneral.lua for missionDisplayPlayer. Note: ignores Build() and any other production outside the mentioned lua.
missionDisplayAITeams = true -- Display basic AI teams count for missionDisplayPlayer.
missionDisplayAICustomTeams = true -- Display custom AI teams count and status for missionDisplayPlayer.


-----------------------------------------------------------------------------------------------------------------------
-- MasterTables.lua: 
MasterTable = { } -- Initialization of this table. DO NOT AMEND!
MasterTable.Production = { } -- Initialization of this table. Configure in MasterTables.lua
MasterTable.Names = { } -- Initialization of this table. Configure in MasterTables.lua
MasterTable.Groupings = { } -- Initialization of this table. Configure in MasterTables.lua

