-----------------------------------------------------------------------------------------------------------------------
------------------ LUA SCRIPTS FOR MISSION CONTROL AND AI IMPLEMENTATION
---------------------- by lovalmidas
-----------------------------------------------------------------------------------------------------------------------
-- AI PRODUCTION GENERAL LUA  VERSION 1.0
-- #8
------ Contains:  
---------- BuildActor(Mastertable.Production[tab] subtable actorproduced, ActiveProductionTable subtable productiontable, double buildtime, double cost) 
---------- CancelBuild(ActiveProductionTable subtable productiontable, double cost)
---------- GetFactoryTab(string ty)
---------- CheckPrerequisites (Player owner, string[] prereqlist)

------------------------------------------------------------------------------------
------ Building / Training in progress
function BuildActor (actorproduced, productiontable, buildtime, cost)
  --AddDebugString("BuildActor("..actorproduced.type..", "..productiontable.factory.Owner.Name..", buildtime = "..buildtime..", cost"..cost..", progress = "..productiontable.progress..") called") 
  
  --if productiontable.activated then
    if productiontable.curr_production ~= "" then
      
      -- Cancel production if factory is dead
      if productiontable.factory.IsDead then
        CancelBuild(productiontable, cost)
        return
      end
      
      local expense = cost * BuildTick / buildtime
      if AddMoney(productiontable.factory.Owner, -expense) then
        productiontable.progress = productiontable.progress + ProductionResolution * BuildTick / buildtime
      end
      
      if productiontable.progress >= ProductionResolution then
        FinalizeActor(actorproduced, productiontable, cost)
        return
      end
    end    
	--end
  Trigger.AfterDelay(BuildTick, function() BuildActor(actorproduced, productiontable, buildtime, cost) end)
end
	
function CancelBuild (productiontable, cost)
  AddDebugString("CancelBuild("..productiontable.curr_production..", "..productiontable.factory.Owner.Name.." for "..cost..") called") 
  -- refund
  AddMoney(productiontable.factory.Owner, cost * productiontable.progress / ProductionResolution)
  
  -- remove production
  productiontable.curr_production = ""
  productiontable.progress = 0
  
  if productiontable.factory.IsDead then  
    RemoveFromList(ActiveProductionTable, productiontable)
		return
	else
    -- AI reconsider production
    Trigger.AfterDelay(BuildTick, function() 
      if IsPartOfGrouping(productiontable.factory.Type, "ConstructionYards") then
        BaseProduction(productiontable)
      else
        UnitProduction(productiontable)
      end
    end)
  end
end

------------------------------------------------------------------------------------
------ Building / Training complete
function FinalizeActor (actorproduced, productiontable, cost)
  AddDebugString("FinalizeActor("..actorproduced.type..", "..productiontable.factory.Owner.Name..") called") 

  if productiontable.factory.IsDead then 
    CancelBuild(productiontable, cost)
    return 
  end
    
  if IsPartOfGrouping(productiontable.factory.Type, "ConstructionYards") then
    -- Building construction
    local actor = Actor.Create(actorproduced.type, true, { Owner = productiontable.factory.Owner, Location = CPos.New(actorproduced.pos.x, actorproduced.pos.y) })
        
    actorproduced.mapactor = actor -- make base node 'occupied'
    ExistingBuildings[#ExistingBuildings + 1] = actor
    AddActorToRegistry(actor)
    
    -- unit factories
    if GetFactoryTab(actor.Type) ~= nil then SetupProductionBuilding(actor) end

    -- trigger: repair
    SingleStructureRepair(actor, Houses[actor.Owner.Name].AIStructureHPRepair) -- AI repair
    
    -- trigger: remove from registries if killed, and make the base node available again
    Trigger.OnRemovedFromWorld(actor, function(a, _) 
      actorproduced.mapactor = nil 
      RemoveFromList(ExistingBuildings, a)
    end)
    
    -- trigger: activate defensive teams if a protected building is damaged
    if actorproduced.toprotect == true or (actorproduced.toprotect == nil and IsPartOfGrouping(actorproduced.type, "ToProtect")) then
      -- TO DO: Set up call to attack attacker, and set to triggers for produced units, reinforced units and pre-placed units/structures
      Trigger.OnDamaged(actor, function(self, attacker)
        if not self.Owner.IsAlliedWith(attacker.Owner) then
          AIReservedDefence(self.Owner.Name, attacker)
        end
      end)
    end
    
    -- Perform excess refund and begin next build
    productiontable.progress = productiontable.progress - ProductionResolution
    CancelBuild(productiontable, cost)
  else
    -- Unit Production
    productiontable.factory.Produce(actorproduced.type) 
    -- OnProduction trigger on factory handles the registry and function attachments to the actor
    
    -- Perform excess refund and begin next build
    productiontable.progress = productiontable.progress - ProductionResolution
    CancelBuild(productiontable, cost)
  end
end


function GetFactoryTab (ty)
  AddDebugString("GetFactoryTab("..ty..") called")  
    
  if ty == "barr" or ty == "kenn" or ty == "tent" then return "Infantry"
  elseif ty == "weap" then return "Units"
  elseif ty == "hpad" or ty == "afld" then return "Aircraft"
  elseif ty == "syrd" or ty == "spen" then return "Ships"
  elseif ty == "fact" then return "ConstructionYard"
  else return nil
  end
  
end

function CheckPrerequisites (owner, prereqlist)
  --AddDebugString("CheckPrerequisites(Player = "..owner.Name..","..#prereqlist.." items) called") 
  
  local meetsprereq = true
  if #prereqlist > 0 then
    Utils.Do(prereqlist, function(prerequisite)
      local tbl = FindOwnedActorType(owner, prerequisite)
      if #tbl == 0 then meetsprereq = false end
    end)
  end
  return meetsprereq
end

