-----------------------------------------------------------------------------------------------------------------------
------------------ LUA SCRIPTS FOR MISSION CONTROL AND AI IMPLEMENTATION
---------------------- by lovalmidas
-- GENERIC LUA FUNCTIONS  VERSION 1.0
-- #0
------ Contains:  
---------- Non-specific Lua functions used by the main scripts for otherwise mundane tasks.
-----------------------------------------------------------------------------------------------------------------------
function Set (list) -- used to find the existence of certain values in a table by converting a value into a key with value = true
  local set = {}
  for _, l in ipairs(list) do set[l] = true end
  return set
end

-----------------------------------------------------------------------------------------------------------------------
function RemoveFromList (list, element)	-- Removes all instances of an element from a table list. Returns true if successful
	local i = 1
  local success = false 
  
	while i <= #list do
		if list[i] == element then
			table.remove(list, i)
      success = true
		else
			i = i + 1
		end
	end
  return success
end

-----------------------------------------------------------------------------------------------------------------------
function RemoveOnceFromList (list, element)	-- Removes the first instance of an element from a table list. Returns true if successful
	local i = 1
	while i <= #list do
		if list[i] == element then
			table.remove(list, i)
      return true
		else
			i = i + 1
		end
	end
  return false
end

-----------------------------------------------------------------------------------------------------------------------
function clone (t) -- deep-copy a table -- Metatable not implement as OpenRA does not use Lua 5.2.
    if type(t) ~= "table" then return t end
    --local meta = getmetatable(t)
    local target = {}
    for k, v in pairs(t) do
        if type(v) == "table" then
            target[k] = clone(v)
        else
            target[k] = v
        end
    end
    --setmetatable(target, meta)
    return target
end

function tablemerge(t1, t2)
    for k, v in pairs(t2) do
        if (type(v) == "table") and (type(t1[k] or false) == "table") then
            tablemerge(t1[k], t2[k])
        else
            t1[k] = v
        end
    end
    return t1
end

-----------------------------------------------------------------------------------------------------------------------
function tablelength (t) -- obtain the size of a table with generic keys.
  local count = 0
  for _ in pairs(t) do count = count + 1 end
  return count
end

-----------------------------------------------------------------------------------------------------------------------
function ConvertToDateTime(n) -- convert game ticks to date time. (May be replaced with the API call equivalent)
-- 1 second = 25 ticks
  if n < 0 then return nil end
  local seconds = math.modf(n / 25) % 60
  local minutes = math.modf(math.modf(n / 25) / 60) % 60
  local hours = math.modf(math.modf(math.modf(n / 25) / 60) / 60) % 60

  if seconds < 10 then seconds = "0"..seconds end
  if hours > 0 then if minutes < 10 then minutes = "0"..minutes end end

  return (hours == 0 and "" or hours..":") .. minutes .. ":" .. seconds
end

