---------------------- GLOBAL OVERRIDES --------------------------------------------
---- To override individual players use the ManualOverride function

CameraSets = 
{ 
	{ DefaultCameraPosition }
}


------ Player settings -------------------------------------------------------------
  -- InitialCash = the player's initial cash, defaults to 0
  
  -- Bot controls only
  --    BuildTimeMultiplier (default, Structures, Defences, Infantry, Units, Aircraft, Ships), defaults to default, which defaults to 1
  --    CostMultipliers (default, Structures, Defences, Infantry, Units, Aircraft, Ships), defaults to default, which defaults to 1

-- Human players
DefaultInitialCash = 4000

-- Soviet Bots
if Map.LobbyOption("difficulty") == "Hard" then
  AIInitialCash = 25000
  AIBuildTimeMultiplier = { default = 0.8, Ships = 0.9, Aircraft = 0.9, Infantry = 0.9 }
  AICostMultiplier = { default = 0.8 }
elseif Map.LobbyOption("difficulty") == "Normal" then
  AIInitialCash = 12500
  AIBuildTimeMultiplier = { default = 0.95 }
  AICostMultiplier = { default = 0.9 }
else
  AIInitialCash = 8000
  AIBuildTimeMultiplier = { default = 1 }
  AICostMultiplier = { default = 1 }
end

------------------------------------------------------------------------------------
------ Base settings ---------------------------------------------------------------
  -- IncludeExistingBuildingsInBaseNodes = whether existing buildings should be included in the base node count
  -- ExcludeExistingBuildingWithStringOverride = (string) if the actor's name contains this string, override to exclude the building from the base node list
  
IncludeExistingBuildingsInBaseNodes = true
InitialBaseNodes = {
  -- id = name of this entry (for debug, or specific selection only)
  -- owner = the player
  -- type = the actor type
  -- pos = position as { x, y } coordinates 

  -- Example
  -- { id = "A01", owner = Houses["Germany"].Player, type = "powr", pos = { x = 10, y = 12} },
}
 
------------------------------------------------------------------------------------
------ AI settings -----------------------------------------------------------------
AIMaintainExcessPower = 75
AIStructureHPRepair = 0.9
AIUnitHPPursuit = 0.9
AIHarvestersPerRefinery = 2
AILowCashThreshold = 25000
AIEmergencyCashThreshold = 3500


PooltoHuntThreshold = { -- Send all units in Pool to the Hunting group if the number of units surpass this threshold
  ["USSR"] = 25,
  ["Turkey"] = 25,
  ["Ukraine"] = 25,
  ["France"] = 25,
  ["England"] = 25,
  ["Germany"] = 25,
} 

GetNextWaypointSet = function(waypoint)
  if waypoint == SovRouteTop then return { WaypointAlliesTop, SovRouteBotMid } end
  if waypoint == SovRouteTopMid then return { WaypointAlliesTop, SovRouteBot, SovRouteTopMidMidAll } end
  if waypoint == SovRouteTopMidMidSov then return { SovRouteTopMidMidAll, SovRouteBotMidMidAll, SovRouteBotMidMidSov, SovRouteTopMid } end
  if waypoint == SovRouteBotMidMidSov then return { SovRouteTopMidMidAll, SovRouteBotMidMidAll, SovRouteTopMidMidSov, SovRouteBotMid } end
  if waypoint == SovRouteTopMidMidAll then return { WaypointAlliesMid, SovRouteBotMidMidAll, SovRouteTopMid } end
  if waypoint == SovRouteBotMidMidAll then return { WaypointAlliesMid, SovRouteTopMidMidAll, SovRouteBotMid } end
  if waypoint == SovRouteBotMid then return { WaypointAlliesBot, SovRouteBot, SovRouteBotMidMidAll } end
  if waypoint == SovRouteBot then return { WaypointAlliesBot, SovRouteBotMid } end
  if waypoint == WaypointAlliesTop then return { WaypointAlliesMid, WaypointAlliesBot } end
  if waypoint == WaypointAlliesMid then return { WaypointAlliesTop, WaypointAlliesBot } end
  if waypoint == WaypointAlliesBot then return { WaypointAlliesTop, WaypointAlliesMid } end
  
  if waypoint == AllRouteTop then return { WaypointSovietTop, AllRouteBotMid } end
  if waypoint == AllRouteTopMid then return { WaypointSovietTop, AllRouteBot, AllRouteTopMidMidAll } end
  if waypoint == AllRouteTopMidMidSov then return { WaypointSovietMid, AllRouteBotMidMidSov, AllRouteTopMid } end
  if waypoint == AllRouteBotMidMidSov then return { WaypointSovietMid, AllRouteTopMidMidSov, AllRouteBotMid } end
  if waypoint == AllRouteTopMidMidAll then return { AllRouteTopMidMidSov, AllRouteBotMidMidSov, AllRouteBotMidMidAll, AllRouteTopMid } end
  if waypoint == AllRouteBotMidMidAll then return { AllRouteTopMidMidSov, AllRouteBotMidMidSov, AllRouteTopMidMidAll, AllRouteBotMid } end
  if waypoint == AllRouteBotMid then return { WaypointSovietBot, AllRouteBot, AllRouteBotMidMidAll } end
  if waypoint == AllRouteBot then return { WaypointSovietBot, AllRouteBotMid } end
  if waypoint == WaypointSovietTop then return { WaypointSovietMid, WaypointSovietBot } end
  if waypoint == WaypointSovietMid then return { WaypointSovietTop, WaypointSovietBot } end
  if waypoint == WaypointSovietBot then return { WaypointSovietTop, WaypointSovietMid } end 
  
  return Waypoints
end

AIHuntInitialWaypoints = {
  ["USSR"] = {SovRouteTopMidMidSov, SovRouteBotMidMidSov},
  ["Turkey"] = {SovRouteBot, SovRouteBotMid},
  ["Ukraine"] = {SovRouteTop, SovRouteTopMid},
  ["France"] = {AllRouteBot, AllRouteBotMid},
  ["England"] = {AllRouteTop, AllRouteTopMid},
  ["Germany"] = {AllRouteTopMidMidAll, AllRouteBotMidMidAll},
}

--should standardize this soon...
SovietTeamGroups = { 
  SovietTeam1 = { "e1", "e1", "e1", "e1", "e1" },
  SovietTeam2 = { "3tnk", "3tnk", "v2rl" },
  SovietTeam3 = { "e1", "e1", "e2", "e2", "e2", "3tnk" },
  SovietTeam4 = { "e4", "e4", "e4" },
  SovietTeam5 = { "e2", "e2", "e2", "e2", "e2", "e2", "e4", "e4" },
  SovietTeam6 = { "e1", "e1", "e2", "e2", "e2" },
  SovietTeam7 = { "dog", "dog" },
  SovietTeam8 = { "e2", "e2", "e2", "e4", "e4" },
  SovietTeam9 = { "e2", "e2", "e2", "e1", "e1" }, 
  SovietTeam10 = { "dog", "dog", "dog", "e1", "e1" },
  SovietTeam11 = { "ftrk", "ftrk" },
  SovietTeam12 = { "e1", "e1", "e1", "e2", "e2", "ftrk" },
  SovietTeam13 = { "e4", "e4", "ftrk", "ftrk" },
  SovietTeam14 = { "3tnk", "ftrk", "ftrk" },
  SovietTeam15 = { "v2rl", "v2rl", "ftrk", "ftrk" },
  SovietTeam16 = { "3tnk", "3tnk", "3tnk", "3tnk" },
  SovietTeam17 = { "e1", "e1", "e1", "e1", "v2rl", "v2rl" },
  SovietTeam18 = { "v2rl", "v2rl", "v2rl" }
}

SovietAirTeamGroups = { 
  SovietAirTeam1 = { "yak" },
  SovietAirTeam2 = { "mig" },
  SovietAirTeam3 = { "yak", "yak" },
  SovietAirTeam4 = { "mig", "mig" }
}

AlliedTeamGroups = { 
  AlliedTeam1 = { "e1", "e1", "e1", "e1", "e1" },
  AlliedTeam2 = { "2tnk", "2tnk", "arty" },
  AlliedTeam3 = { "e1", "e1", "e1", "e1", "e1", "jeep" },
  AlliedTeam4 = { "jeep", "jeep", "jeep" },
  AlliedTeam5 = { "1tnk", "1tnk", "1tnk", "1tnk" },
  AlliedTeam6 = { "e1", "e1", "e3", "e3", "e3" },
  AlliedTeam7 = { "e1", "e1", "e1", "e1", "e1", "e1" , "medi" },
  AlliedTeam8 = { "e1", "e1", "e1", "e3", "e3" },
  AlliedTeam9 = { "e3", "e3", "e3", "e3", "e3", "e3" , "medi" }, 
  AlliedTeam10 = { "jeep", "jeep", "1tnk", "e3", "e3" },
  AlliedTeam11 = { "jeep", "jeep" },
  AlliedTeam12 = { "e1", "e1", "e1", "e1", "e1", "jeep" },
  AlliedTeam13 = { "e3", "e3", "jeep", "jeep" },
  AlliedTeam14 = { "2tnk", "jeep", "jeep" },
  AlliedTeam15 = { "arty", "arty", "jeep", "jeep" },
  AlliedTeam16 = { "2tnk", "2tnk", "2tnk", "2tnk" },
  AlliedTeam17 = { "e1", "e1", "e1", "e1", "arty", "arty" },
  AlliedTeam18 = { "arty", "arty", "arty" }
}

AlliedAirTeamGroups = { 
  AlliedAirTeam1 = { "hind" },
  AlliedAirTeam2 = { "heli" },
  AlliedAirTeam3 = { "hind", "hind" },
  AlliedAirTeam4 = { "heli", "heli" }
}


Waypoints = {
  SovRouteTopMidMidSov,
  SovRouteBotMidMidSov, 
  AllRouteTopMidMidAll, 
  AllRouteBotMidMidAll
}  



function PostSetupManualOverride ()
  AddDebugString("PostSetupManualOverride() called")
  
  missionDisplayPlayer = Player.GetPlayer("Germany") 
  --bdebug = true

end



AIActivated = false
function TickManualOverride()
  
  if missiontick == DateTime.Seconds(45) then AIActivated = true end

  ------------------------------------------------------------------------------------
  ------ AI Team settings ------------------------------------------------------------
  ----------- Define all actor groups and their routes here
  ----------- IMPORTANT: References to lua functions should be placed in PostSetupManualOverride and not as part of initializing global variables.

  -- Teams will be declared by AITeams[player.Name][groupname], filled by AIActorGroups over the course of the game, and governed by the AI in AIGroupStatus to perform functions in AIFunctions
  ------ Groups in ActorGroups[player.Name]:
  ----------- 
  ----------- [Reserved names, do not touch]
  ----------- Pool                Pool for newly-built and unassigned units. Game will ignore any 'Pool' groupname
  ----------- Defender            Used to counter threats against the enemy when a structure / harvester is under attack (onDamaged). Directly attacks the attacker, then return to base
  ----------- DefenderEscort      Same as Defender but patrols towards the attacker zone instead of chasing the attacker.
  ----------- Hunt                Used when Pool reaches a certain critical mass.
  ----------- 
  ------ All others can be custom-named. The following may be used.
  ----------- Attack_x            Attacking      
  ----------- Patrol_x            Patrol
  ----------- Reinforcement_x     Reinforcement (if included in transport, only apply to the units after disembarkment)
  ----------- Aircraft_Attack_x   Attacking (Aircraft)
  ----------- Aircraft_Patrol_x   Patrol (Aircraft)
  ----------- Navy_Attack_x       Attacking (Navy)
  ----------- Navy_Patrol_x       Patrol (Navy)
  ----------- MCV                 Special MCV stuff (not for this mission though)
  ----------- Custom names        
  ----------- 
  ------ All Groups will follow the commands given by AIFunctions[player.Name][groupname] , except for the reserved groups which will have their own routes.
  
  if missiontick % 1001 == 0 then -- don't refresh every tick, waste of time

    AITeams["USSR"] = 
    {       
      ["USSR Attack Slot 1"] = Utils.Random(SovietTeamGroups),
      ["USSR Attack Slot 2"] = Utils.Random(SovietTeamGroups),
      ["USSR Attack Slot 3"] = Utils.Random(SovietTeamGroups),
      ["USSR Attack Slot 4"] = Utils.Random(SovietTeamGroups),
      ["USSR Attack Slot 5"] = Utils.Random(SovietTeamGroups),
      ["USSR Attack Slot 6"] = Utils.Random(SovietTeamGroups),
      ["USSR Air Attack Slot 1"] = Utils.Random(SovietAirTeamGroups),
      ["USSR Air Attack Slot 2"] = Utils.Random(SovietAirTeamGroups),
    }

    AITeams["Turkey"] = 
    {       
      ["Turkey Attack Slot 1"] = Utils.Random(SovietTeamGroups),
      ["Turkey Attack Slot 2"] = Utils.Random(SovietTeamGroups),
      ["Turkey Attack Slot 3"] = Utils.Random(SovietTeamGroups),
      ["Turkey Attack Slot 4"] = Utils.Random(SovietTeamGroups),
      ["Turkey Attack Slot 5"] = Utils.Random(SovietTeamGroups),
      ["Turkey Attack Slot 6"] = Utils.Random(SovietTeamGroups),
      ["Turkey Air Attack Slot 1"] = Utils.Random(SovietAirTeamGroups),
      ["Turkey Air Attack Slot 2"] = Utils.Random(SovietAirTeamGroups),
    }

    AITeams["Ukraine"] = 
    {       
      ["Ukraine Attack Slot 1"] = Utils.Random(SovietTeamGroups),
      ["Ukraine Attack Slot 2"] = Utils.Random(SovietTeamGroups),
      ["Ukraine Attack Slot 3"] = Utils.Random(SovietTeamGroups),
      ["Ukraine Attack Slot 4"] = Utils.Random(SovietTeamGroups),
      ["Ukraine Attack Slot 5"] = Utils.Random(SovietTeamGroups),
      ["Ukraine Attack Slot 6"] = Utils.Random(SovietTeamGroups),
      ["Ukraine Air Attack Slot 1"] = Utils.Random(SovietAirTeamGroups),
      ["Ukraine Air Attack Slot 2"] = Utils.Random(SovietAirTeamGroups),
    }

    AITeams["England"] = 
    {       
      ["England Attack Slot 1"] = Utils.Random(AlliedTeamGroups),
      ["England Attack Slot 2"] = Utils.Random(AlliedTeamGroups),
      ["England Attack Slot 3"] = Utils.Random(AlliedTeamGroups),
      ["England Attack Slot 4"] = Utils.Random(AlliedTeamGroups),
      ["England Attack Slot 5"] = Utils.Random(AlliedTeamGroups),
      ["England Attack Slot 6"] = Utils.Random(AlliedTeamGroups),
      ["England Air Attack Slot 1"] = Utils.Random(AlliedAirTeamGroups),
      ["England Air Attack Slot 2"] = Utils.Random(AlliedAirTeamGroups),
    }

    AITeams["Germany"] = 
    {       
      ["Germany Attack Slot 1"] = Utils.Random(AlliedTeamGroups),
      ["Germany Attack Slot 2"] = Utils.Random(AlliedTeamGroups),
      ["Germany Attack Slot 3"] = Utils.Random(AlliedTeamGroups),
      ["Germany Attack Slot 4"] = Utils.Random(AlliedTeamGroups),
      ["Germany Attack Slot 5"] = Utils.Random(AlliedTeamGroups),
      ["Germany Attack Slot 6"] = Utils.Random(AlliedTeamGroups),
      ["Germany Air Attack Slot 1"] = Utils.Random(AlliedAirTeamGroups),
      ["Germany Air Attack Slot 2"] = Utils.Random(AlliedAirTeamGroups),
    }

    AITeams["France"] = 
    {       
      ["France Attack Slot 1"] = Utils.Random(AlliedTeamGroups),
      ["France Attack Slot 2"] = Utils.Random(AlliedTeamGroups),
      ["France Attack Slot 3"] = Utils.Random(AlliedTeamGroups),
      ["France Attack Slot 4"] = Utils.Random(AlliedTeamGroups),
      ["France Attack Slot 5"] = Utils.Random(AlliedTeamGroups),
      ["France Attack Slot 6"] = Utils.Random(AlliedTeamGroups),
      ["France Air Attack Slot 1"] = Utils.Random(AlliedAirTeamGroups),
      ["France Air Attack Slot 2"] = Utils.Random(AlliedAirTeamGroups),
    }
    

    AIFunctions["USSR"] = 
    {       
      ["USSR Attack Slot 1"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("USSR", 10) }}},
      ["USSR Attack Slot 2"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("USSR", 10) }}},
      ["USSR Attack Slot 3"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("USSR", 10) }}},
      ["USSR Attack Slot 4"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("USSR", 10) }}},
      ["USSR Attack Slot 5"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("USSR", 10) }}},
      ["USSR Attack Slot 6"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("USSR", 10) }}},
      ["USSR Air Attack Slot 1"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("USSR", 20), Delay = DateTime.Seconds(7) }}},
      ["USSR Air Attack Slot 2"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("USSR", 20), Delay = DateTime.Seconds(7) }}},
    }
    
    AIFunctions["Ukraine"] = 
    {       
      ["Ukraine Attack Slot 1"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("Ukraine", 10) }}},
      ["Ukraine Attack Slot 2"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("Ukraine", 10) }}},
      ["Ukraine Attack Slot 3"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("Ukraine", 10) }}},
      ["Ukraine Attack Slot 4"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("Ukraine", 10) }}},
      ["Ukraine Attack Slot 5"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("Ukraine", 10) }}},
      ["Ukraine Attack Slot 6"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("Ukraine", 10) }}},
      ["Ukraine Air Attack Slot 1"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("Ukraine", 20), Delay = DateTime.Seconds(7) }}},
      ["Ukraine Air Attack Slot 2"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("Ukraine", 20), Delay = DateTime.Seconds(7) }}},
    }
    
    AIFunctions["Turkey"] = 
    {       
      ["Turkey Attack Slot 1"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("Turkey", 10) }}},
      ["Turkey Attack Slot 2"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("Turkey", 10) }}},
      ["Turkey Attack Slot 3"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("Turkey", 10) }}},
      ["Turkey Attack Slot 4"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("Turkey", 10) }}},
      ["Turkey Attack Slot 5"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("Turkey", 10) }}},
      ["Turkey Attack Slot 6"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("Turkey", 10) }}},
      ["Turkey Air Attack Slot 1"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("Turkey", 20), Delay = DateTime.Seconds(7) }}},
      ["Turkey Air Attack Slot 2"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("Turkey", 20), Delay = DateTime.Seconds(7) }}},
    }
    
    AIFunctions["England"] = 
    {       
      ["England Attack Slot 1"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("England", 10) }}},
      ["England Attack Slot 2"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("England", 10) }}},
      ["England Attack Slot 3"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("England", 10) }}},
      ["England Attack Slot 4"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("England", 10) }}},
      ["England Attack Slot 5"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("England", 10) }}},
      ["England Attack Slot 6"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("England", 10) }}},
      ["England Air Attack Slot 1"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("England", 20), Delay = DateTime.Seconds(7) }}},
      ["England Air Attack Slot 2"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("England", 20), Delay = DateTime.Seconds(7) }}},
    }
    
    AIFunctions["Germany"] = 
    {       
      ["Germany Attack Slot 1"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("Germany", 10) }}},
      ["Germany Attack Slot 2"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("Germany", 10) }}},
      ["Germany Attack Slot 3"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("Germany", 10) }}},
      ["Germany Attack Slot 4"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("Germany", 10) }}},
      ["Germany Attack Slot 5"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("Germany", 10) }}},
      ["Germany Attack Slot 6"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("Germany", 10) }}},
      ["Germany Air Attack Slot 1"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("Germany", 20), Delay = DateTime.Seconds(7) }}},
      ["Germany Air Attack Slot 2"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("Germany", 20), Delay = DateTime.Seconds(7) }}},
    }
    
    AIFunctions["France"] = 
    {       
      ["France Attack Slot 1"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("France", 10) }}},
      ["France Attack Slot 2"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("France", 10) }}},
      ["France Attack Slot 3"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("France", 10) }}},
      ["France Attack Slot 4"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("France", 10) }}},
      ["France Attack Slot 5"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("France", 10) }}},
      ["France Attack Slot 6"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("France", 10) }}},
      ["France Air Attack Slot 1"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("France", 20), Delay = DateTime.Seconds(7) }}},
      ["France Air Attack Slot 2"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = GeneratePath("France", 20), Delay = DateTime.Seconds(7) }}},
    }
  end
end


function GeneratePath (playername, iterations) -- returns CPos[]
  --AddDebugString("GeneratePath("..playername..", "..iterations.." iterations) called")
  
  local result = {}
  local actors = {}
  table.insert(actors, Utils.Random(AIHuntInitialWaypoints[playername]))
  
  for i = 1, iterations do
    table.insert(actors, Utils.Random(GetNextWaypointSet(actors[#actors])))
  end
  
  -- convert actors into locations
  for i = 1, #actors do
    result[i] = actors[i].Location
  end
  
  return result
end

