-----------------------------------------------------------------------------------------------------------------------
------------------ LUA SCRIPTS FOR MISSION CONTROL AND AI IMPLEMENTATION
---------------------- by lovalmidas 
-----------------------------------------------------------------------------------------------------------------------
-- MAIN LUA  VERSION 1.0
-- Preceded by #INCLUDE LUA
-- #2
------ Contains:  
---------- Global initializations used in this file
---------- WorldLoaded() -- Mission initialisation
---------- Tick() -- runs every tick ('frame'-like state in the game, there are 25 ticks per in-game second)
---------- InitialiseObjectives() -- called from WorldLoaded()

function Tick ()
  
  debugfnnumber = 0
  
  -- AI team activation and control
  if AIActivated then
    if AITeamControl then 
      AITeamControl() 
      AITeamControl = nil
    end
    
    if AIReservedTeamControl then 
      AIReservedTeamControl() 
      AIReservedTeamControl = nil
    end
  end
  
  if bdebug then 	
    DebugShowInfo()
  else
    TickShowInfo(missionDisplayPlayer)
  end
  
  
  -- User Entry
  if TickManualOverride then TickManualOverride() end
    
  -- Update Tick
  missiontick = missiontick + 1
end


function WorldLoaded ()
  GenerateMasterTable()
  InitialisePlayers()
  InitialiseActors()
  InitialiseBases()
  InitialiseObjectives()
  
  Trigger.AfterDelay(DateTime.Seconds(missionAIDelaySeconds), function() 
    InitialiseAI()
	end)
  
	if InitialPosition ~= nil then Camera.Position = InitialPosition.CenterPosition end
  
  -- User Entry
  if PrepareReinforcements then PrepareReinforcements() end
  if PostSetupManualOverride then PostSetupManualOverride() end
	--Debug stuff here
end

function InitialiseObjectives ()
	Trigger.OnObjectiveAdded(MissionPlayer, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "New " .. string.lower(p.GetObjectiveType(id)) .. " objective")
    --if p.GetObjectiveType(id) == "Primary" then 
    table.insert(missionObjectiveIDs, id) 
    --end
	end)
	Trigger.OnObjectiveCompleted(MissionPlayer, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective completed")
    RemoveFromList(missionObjectiveIDs, id)
	end)
	Trigger.OnObjectiveFailed(MissionPlayer, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective failed")
    if p.GetObjectiveType(id) ~= "Primary" then 
      RemoveFromList(missionObjectiveIDs, id)
    end
    missionObjectiveFlavourText[id] = "FAILED"
	end)
	Trigger.OnPlayerLost(MissionPlayer, function()
		Media.PlaySpeechNotification(MissionPlayer, "MissionFailed")
	end)
	Trigger.OnPlayerWon(MissionPlayer, function()
		Media.PlaySpeechNotification(MissionPlayer, "MissionAccomplished")
	end)
end


function ToggleReveal(n, bl) -- to be moved to somewhere else
	Utils.Do(CameraSets[n], function(a)
		if bl then
			if MissionPlayer ~= nil then a.Owner = MissionPlayer end 
		else
			if NeutralPlayer ~= nil then a.Owner = NeutralPlayer end 
		end
	end)
end

