-----------------------------------------------------------------------------------------------------------------------
------------------ LUA SCRIPTS FOR MISSION CONTROL AND AI IMPLEMENTATION
---------------------- by lovalmidas
-----------------------------------------------------------------------------------------------------------------------
-- AI TEAMS LUA  VERSION 1.0
-- #12
------ Contains:  
---------- AITeamControl() 
---------- AIReservedTeamControl()
---------- AIReservedDefence()
---------- 
---------- Utility functions
-------------- AddActorToPool(Actor actor)
-------------- GrabActorFromPool(string actortype,string playername, table targettable) 
-------------- TransferActorToActorGroup(Actor actor, table sourcetable, table targettable)
---------- Actor command functions used by reserved teams 
-------------- HuntingPath(Actor[] units, string playername)
-------------- AircraftAttackMove(Actor a, CPos[] path, int closeenough, int checkdelay, bool cyclic)
-------------- AircraftMove(Actor a, CPos[] path, int closeenough, int checkdelay, bool cyclic)
-------------- AircraftReloadRefresh(Actor a, CPos[] path, int closeenough, int checkdelay, int i, bool cyclic)
-------------- AircraftMoveRefresh(Actor a, CPos[] path, int closeenough, int checkdelay, int i, bool cyclic)
-------------- AircraftReloadRefresh(Actor a, CPos[] path, int closeenough, int checkdelay, int i, bool cyclic)
-------------- AircraftAttackRefresh(Actor a, CPos[] path, int closeenough, int checkdelay, bool cyclic)
-------------- GroundAttackMove(Actor a, CPos[] path, int closeenough, int checkdelay, bool cyclic, Actor[] or false waitforgroup, bool noattack))
-------------- ForceHunt(Actor a)
-------------- ForceAttack(Actor a, Actor target)
-------------- ForceGuard(Actor a, Actor target)

-- Collection of functions for governing AI teams --


------------------------------------------------------------------------------------
------ Main assignment control ATTACHED TO Tick()
function AITeamControl ()
  AddDebugString("AITeamControl() called")
  
  for playername,aiteamgroup in pairs(AITeams) do 
    
    AITeams[playername] = AITeams[playername] or { Pool = {},Hunt = {},Defence = {}, DefenceEscort = {} }
    AITeamClone[playername] = AITeamClone[playername] or AITeams[playername]
    
    AIFunctions[playername] = AIFunctions[playername] or { Pool = {},Hunt = {},Defence = {}, DefenceEscort = {}}
    AIFunctionClone[playername] = AIFunctionClone[playername] or AIFunctions[playername]
    
    AIActorGroups[playername] = AIActorGroups[playername] or { Pool = {},Hunt = {},Defence = {}, DefenceEscort = {} }
    AIGroupStatus[playername] = AIGroupStatus[playername] or { Pool = 0,Hunt = 0,Defence = 0, DefenceEscort = 0 }
    AIGroupToFillStatus[playername] = AIGroupToFillStatus[playername] or { Pool = {},Hunt = {},Defence = {}, DefenceEscort = {}}
    
    Utils.Shuffle(aiteamgroup)
    for actorgroupname,actors in pairs(aiteamgroup) do 
      if actorgroupname == "Pool" or actorgroupname == "Hunt" or actorgroupname == "Defence" or actorgroupname == "DefenceEscort" then 
      else
        AITeams[playername][actorgroupname] = AITeams[playername][actorgroupname] or { }
        AIFunctions[playername][actorgroupname] = AIFunctions[playername][actorgroupname] or { }
        
        AIActorGroups[playername][actorgroupname] = AIActorGroups[playername][actorgroupname] or { }
        AIGroupToFillStatus[playername][actorgroupname] = AIGroupToFillStatus[playername][actorgroupname] or { }
      
        AISingleTeamControl (playername, actorgroupname)
      end
    end
  end
end
      
function AISingleTeamControl (playername, actorgroupname)
  AddDebugString("AISingleTeamControl("..playername..", "..actorgroupname..") called")

  AITeamClone[playername][actorgroupname] = AITeamClone[playername][actorgroupname] or AITeams[playername][actorgroupname]
  AIFunctionClone[playername][actorgroupname] = AIFunctionClone[playername][actorgroupname] or AIFunctions[playername][actorgroupname]

  local status = AIGroupStatus[playername][actorgroupname]
  if status == nil then status = -99 end
  
  if status == -99 then -- test
    status = UpdateAIGroupStatus(playername, actorgroupname, 0)
  end 

  if status == 0 then -- default, inactive
    --check if I can build this team
    if AITeamCheckPrerequisite(playername, AITeamClone[playername][actorgroupname]) then
      status = UpdateAIGroupStatus(playername, actorgroupname, -1)
    end
  end 

  if status == -1 then -- Summon from pool
    local i = 1
    while i <= tablelength(AIGroupToFillStatus[playername][actorgroupname]) do

      if GrabActorFromPool(AIGroupToFillStatus[playername][actorgroupname][i], playername, AIActorGroups[playername][actorgroupname]) then
        table.remove(AIGroupToFillStatus[playername][actorgroupname], i)
      else
        --check if I can still build this team
        if not AITeamCheckPrerequisite(playername, AIGroupToFillStatus[playername][actorgroupname]) then
          status = UpdateAIGroupStatus(playername, actorgroupname, -3)
          i = tablelength(AIGroupToFillStatus[playername][actorgroupname]) + 1
        else
          i = i + 1
        end
      end
    end
    -- Filled
    if #AIGroupToFillStatus[playername][actorgroupname] == 0 then 
      status = UpdateAIGroupStatus(playername, actorgroupname, 1)
    end 
    
  elseif status == -3 then -- Disband, return all to Pool
    Utils.Do(AIActorGroups[playername][actorgroupname], function(actor) 
      if not actor.IsDead then 
        actor.Stop()
        table.insert (AIActorGroups[playername]["Pool"], actor) 
      end 
    end)
    AIActorGroups[playername][actorgroupname] = { }
    AIGroupToFillStatus[playername][actorgroupname] = clone(AITeamClone[playername][actorgroupname])
    status = UpdateAIGroupStatus(playername, actorgroupname, 0)

  elseif status == math.modf(status) and status > 0 then -- execute function[x]
    if AIFunctionClone[playername][actorgroupname] ~= nil then
      local functionset = AIFunctions[playername][actorgroupname][status]
      status = UpdateAIGroupStatus(playername, actorgroupname, status + 0.5)
      if functionset ~= nil then 
        functionset.ArgumentTable = functionset.ArgumentTable or { }
        if type(functionset.ArgumentTable) == "table" and type(functionset.Function) == "function" then
          functionset.ArgumentTable.Actors = AIActorGroups[playername][actorgroupname]
          functionset.ArgumentTable.PlayerName = playername
          functionset.ArgumentTable.ActorGroupName = actorgroupname
          functionset.ArgumentTable.StatusOnSuccess = math.modf(status) + 1
          functionset.Function(functionset.ArgumentTable) -- execute function
        else
          status = UpdateAIGroupStatus(playername, actorgroupname, -3)
        end
      else -- Nothing to do: disband
        status = UpdateAIGroupStatus(playername, actorgroupname, -3)
      end
    else -- Nothing to do: disband
      status = UpdateAIGroupStatus(playername, actorgroupname, -3)
    end
    
  elseif status > 0 then -- in process, but revert to status 0 if units are wiped out
    local AllDead = true
    Utils.Do(AIActorGroups[playername][actorgroupname], function(actor) if not actor.IsDead then AllDead = false end end)
    if AllDead then
      AIActorGroups[playername][actorgroupname] = { }
      status = UpdateAIGroupStatus(playername, actorgroupname, 0)
    end          
  end
  
  Trigger.AfterDelay(Utils.RandomInteger(missionAITeamControlDelay.low, missionAITeamControlDelay.high), function() 
    AISingleTeamControl (playername, actorgroupname) 
  end)
end


function UpdateAIGroupStatus(playername, actorgroupname, newstatus) -- returns new status to update on the main function as well
  AddDebugString("UpdateAIGroupStatus("..playername..","..actorgroupname..","..newstatus..") called")
  
  AIGroupStatus[playername][actorgroupname] = newstatus
  
  --special logic for activation of certain statuses
  if newstatus == -1 then -- I am ready to fill the group!
    AIGroupToFillStatus[playername][actorgroupname] = clone(AITeamClone[playername][actorgroupname]) 
  elseif newstatus == 0 then -- Perform update of teams and functions if status is changed to 0
    AITeamClone[playername][actorgroupname] = clone(AITeams[playername][actorgroupname]) 
    AIFunctionClone[playername][actorgroupname] = clone(AIFunctions[playername][actorgroupname]) 
  end
  return newstatus
end

function AITeamCheckPrerequisite (playername, table) -- return true if pass
  AddDebugString("AITeamCheckPrerequisite("..playername..", "..#table.." in table) called")

  local result = true
  local alreadychecked = {} -- record for things already checked to reduce processing time

  Utils.Do(table, function(k)
    if alreadychecked[k] then return end
      
    local apts = Utils.Where(ActiveProductionTable, function(apt)
      return apt.factory.Owner.Name == playername
    end)
    
    if apts ~= nil then
      local aptalreadychecked = {}
      
      Utils.Do(apts, function(apt)
        if aptalreadychecked[apt.factory.Type] then return end
        if apt.types == nil then return end -- ConYards do not define types.
        Utils.Do(apt.types, function(tt)
          if tt.type == k then
            if not CheckPrerequisites(apt.factory.Owner, tt.prereq) then 
              result = false 
            end
            alreadychecked[k] = true
            aptalreadychecked[apt.factory.Type] = true
          end
        end)
      end)
    end
  end)
  
  return result
end


function AIReservedTeamControl ()
  AddDebugString("AIReservedTeamControl() called")
  
  ------ Reserved Logic: Hunt if Pool exceeds PooltoHuntThreshold
  for playername,actorgroup in pairs(AIActorGroups) do 
    PooltoHuntThreshold[playername] = PooltoHuntThreshold[playername] or 10
    AISingleReservedTeamControl (playername)
  end
end
  
function AISingleReservedTeamControl (playername) 
    if #AIActorGroups[playername]["Pool"] > PooltoHuntThreshold[playername] then
      HuntingPath(AIActorGroups[playername]["Pool"], playername)
      AIActorGroups[playername]["Hunt"] = AIActorGroups[playername]["Hunt"] or { }
      Utils.Do(AIActorGroups[playername]["Pool"], function(actor) table.insert (AIActorGroups[playername]["Hunt"], actor) end)
      AIActorGroups[playername]["Pool"] = { }
    end
    
    Trigger.AfterDelay(Utils.RandomInteger(missionAIReservedTeamControlDelay.low, missionAIReservedTeamControlDelay.high), function() 
      AISingleReservedTeamControl (playername) 
    end)
  
end

function AIReservedDefence (playername, attacker)
  AddDebugString("AIReservedDefence() called")

  if attacker.IsDead then return end

  local defenders = 2

  ------ Reserved Logic: Send Pool to Defence and DefenceEscort if a Protect unit or Structure gets attacked.
  Utils.Do(AIActorGroups[playername]["Pool"], function(actor) 
    if defenders == 0 then return end
    if IsPartOfGrouping(actor.Type, "AirUnits") or IsPartOfGrouping(actor.Type, "NavalUnits") then return end
    if actor.IsDead then
      RemoveFromList(AIActorGroups[playername]["Pool"], actor)
      return
    end
    
    if not actor.CanTarget(attacker) then return end
    
    defenders = defenders - 1
    local currposition = actor.Location
    actor.Stop()
    actor.Guard(attacker)
    Trigger.OnKilled(attacker, function() -- the attacker is dead
      if not actor.IsDead then
        table.insert (AIActorGroups[playername]["Pool"], actor)
        actor.Stop()
        actor.Move(currposition, 3) -- return to former position
      end
      RemoveFromList(AIActorGroups[playername]["Defence"], actor)        
    end)      
    table.insert (AIActorGroups[playername]["Defence"], actor)
    RemoveFromList(AIActorGroups[playername]["Pool"], actor)
  end)  
  
end


-- Pool functions
function AddActorToPool(actor) 
  AddDebugString("AddActorToPool(actor of type"..actor.Type..") called") 

  -- exempt units:
  if actor.Type == "harv" then return end
  
  -- special logic for dog and aircraft
  if actor.Type == "dog" or actor.Type == "yak" or actor.Type == "mig" or actor.Type == "hind" or actor.Type == "heli" then actor.Stance = "AttackAnything" end
  
  -- setup tables
  AIActorGroups[actor.Owner.Name] = AIActorGroups[actor.Owner.Name] or { }
  AIActorGroups[actor.Owner.Name].Pool = AIActorGroups[actor.Owner.Name].Pool or { }
  
  -- Add to pool
  table.insert(AIActorGroups[actor.Owner.Name].Pool, actor) 
end


function GrabActorFromPool (actortype, playername, targettable) -- return true if successful
  AddDebugString("GrabActorFromPool("..actortype..", "..playername..") called")
  
  for k,v in pairs(AIActorGroups[playername]["Pool"]) do
    if v.Type == actortype then 
      targettable = targettable or { }
      local actor = AIActorGroups[playername]["Pool"][k]
      targettable[#targettable + 1] = actor
      AIActorGroups[playername]["Pool"][k] = nil 
      --TransferActorToActorGroup(v, AIActorGroups[playername]["Pool"], targettable) 
      return true
    end
  end 
  return false
end

function TransferActorToActorGroup (actor, sourcetable, targettable)
  AddDebugString("TransferActorToActorGroup("..actor.Type..") called")

  for k,v in pairs(sourcetable) do
    if v == actor then 
      targettable = targetable or { }
      table.insert (targettable, actor)
      sourcetable[k] = nil 
      return
    end
  end 
end


-- Actor commands
function HuntingPath (units, playername)
  AddDebugString("HuntingPath("..#units.." units, player = "..playername..") called")
  
  local currentwaypoint = Utils.Random(AIHuntInitialWaypoints[playername])
  if currentwaypoint == nil then currentwaypoint = Utils.Random(Waypoints) end
  local path = { } 
  table.insert(path, currentwaypoint.Location)
  local str = ""
  for i = 1, 50 do
    -- Long string lags the game
    --str = str.. "  ("..currentwaypoint.Location.X..","..currentwaypoint.Location.Y..") " end
    local nextwaypointset = GetNextWaypointSet(currentwaypoint)
    if #nextwaypointset == 1 then currentwaypoint = nextwaypointset[1]
    elseif #nextwaypointset > 1 then
      
      --RemoveFromList(nextwaypointset, currentwaypoint)
      for k,v in pairs(nextwaypointset) do
        if v.Location.X == currentwaypoint.Location.X and v.Location.Y == currentwaypoint.Location.Y then 
          nextwaypointset[k] = nil 
        end
      end    
      currentwaypoint = Utils.Random(nextwaypointset)
    else currentwaypoint = Utils.Random(Waypoints)
    end
    table.insert(path, currentwaypoint.Location)
  end
  
  Utils.Do(units, function(unit)
    if unit.IsDead then return end
    if not unit.IsInWorld then return end
    if unit.Type == "yak" or unit.Type == "mig" or unit.Type == "hind" or unit.Type == "heli" or unit.Type == "tran" then 
      AircraftAttackMove(unit, path, 8, 100, true)
    else    
      GroundAttackMove(unit, path, 4, 50, true)
    end
  end)
end

function AircraftAttackMove (a, path, closeenough, checkdelay, cyclic)  
  AddDebugString("AircraftAttackMove() called")
	if a.IsDead then return end
  if not a.IsInWorld then return end
 
  local i = 1
  local exwaypoints = { } -- for expanded waypoints
  
  for j = 1,#path do
    if closeenough > 1 then
      for cl = 1, closeenough do
        if cl > 1 then	-- ignore first expansion
          exwaypoints[j] = Utils.ExpandFootprint({path[j]}, false)
        end
      end
    else
      exwaypoints[j] = { path[j] }		
    end
  end
 
  if a.AmmoCount() == 0 then
    a.Stop()
    a.ReturnToBase()
    AircraftReloadRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
  else
    a.Stop()
    a.AttackMove(path[i], closeenough)
    AircraftAttackRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
  end
end

function AircraftMove (a, path, closeenough, checkdelay, cyclic)
  AddDebugString("AircraftMove() called")
	if a.IsDead then return end
  --if not a.IsInWorld then return end
 
  local i = 1
  local exwaypoints = { } -- for expanded waypoints
  
  for j = 1,#path do
    if closeenough > 1 then
      for cl = 1, closeenough do
        if cl > 1 then	-- ignore first expansion
          exwaypoints[j] = Utils.ExpandFootprint({path[j]}, false)
        end
      end
    else
      exwaypoints[j] = { path[j] }		
    end
  end
 
    a.Stop()
    a.Move(path[i], closeenough)
    AircraftMoveRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
end

function AircraftReloadRefresh (a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
  AddDebugString("AircraftReloadRefresh() called")
  Trigger.AfterDelay(checkdelay * 10, function()
    if a.IsDead then return end
    --if not a.IsInWorld then return end
    if a.AmmoCount() == 0 then    
      -- why are you not loading?
      a.Stop()
      a.AttackMove(path[i], closeenough)    
      --AircraftAttackRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
      --I give up on you, just don't jam the airfield / helipad
      AircraftReloadRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
    elseif a.AmmoCount() ~= a.MaximumAmmoCount() then
      AircraftReloadRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
    else
      a.Stop()
      a.AttackMove(path[i], closeenough)
      AircraftAttackRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
    end 
  end)
end

function AircraftMoveRefresh (a, path, closeenough, checkdelay, exwaypoints, i, cyclic)  
  AddDebugString("AircraftMoveRefresh() called")
  Trigger.AfterDelay(checkdelay, function()
    if a.IsDead then return end
    local reachdest = false
    --Utils.Do(exwaypoints[i], function(wp)
    --  if a.Location == wp then reachdest = true end
    --end)
    
    --if reachdest then 
      i = i + 1
      if i > #path then
        if cyclic then 
          i = 1
        else
          return
        end
      end
    --end
    
    a.Stop()
    a.Move(path[i], closeenough)
    AircraftMoveRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
  end)
end

function AircraftAttackRefresh (a, path, closeenough, checkdelay, exwaypoints, i, cyclic)  
  AddDebugString("AircraftAttackRefresh() called")
  Trigger.AfterDelay(checkdelay, function()
    if a.IsDead then return end
    local reachdest = false
    --Utils.Do(exwaypoints[i], function(wp)
    --  if a.Location == wp then reachdest = true end
    --end)
    
    --if reachdest then 
      i = i + 1
      if i > #path then
        if cyclic then 
          i = 1
        else
          return
        end
      end
    --end
    
    if a.AmmoCount() == 0 then
      a.Stop()
      a.ReturnToBase()
      AircraftReloadRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
    else
      a.Stop()
      a.AttackMove(path[i], closeenough)
      AircraftAttackRefresh(a, path, closeenough, checkdelay, exwaypoints, i, cyclic)
    end
  end)
end

function GroundAttackMove (a, path, closeenough, delay, cyclic, waitforgroup, noattack) -- waitforgroup: Actor[] or false, noattack: use move instead of attack
  AddDebugString("GroundAttackMove() called")
	if a.IsDead then return end
  
  local i = 1
  local stop = false
  local exwaypoints = { } -- for expanded waypoints
  
  for j = 1,#path do
    if closeenough > 1 then
      for cl = 1, closeenough do
        if cl > 1 then	-- ignore first expansion
          exwaypoints[j] = Utils.ExpandFootprint({path[j]}, false)
        end
      end
    else
      exwaypoints[j] = { path[j] }		
    end
  end
  
  if not a.IsDead then
    a.Scatter()
    Trigger.OnIdle(a, function()
      if stop then
        return
      end

      local reachdest = false
      Utils.Do(exwaypoints[i], function(wp)
        if a.Location == wp then reachdest = true end
      end)
      
      if reachdest then 
        local bool = false
        if waitforgroup then
          bool = Utils.All(waitforgroup, function(actor)
            if actor.IsDead then return true end
            return actor.IsIdle
          end)
        else
          bool = a.IsDead or a.IsIdle
        end
        if bool then
          stop = true
          i = i + 1
          if i > #path then
            if cyclic then 
              i = 1
            else
              return
            end
          end

          Trigger.AfterDelay(delay, function() stop = false end)
        end
      else
        if noattack or not a.HasProperty("AttackMove") then
          a.Move(path[i], closeenough)
        else
          a.AttackMove(path[i], closeenough)
        end
        Trigger.AfterDelay(delay, function() if not a.IsDead then a.Stop() end end)
      end
    end)
  end
end


-- Simple hunts. WARNING: Aircraft cannot use Hunt()!
function ForceHunt (a)
  AddDebugString("ForceHunt() called")
  xpcall( -- WHY DO AIRCRAFT LIKE TO SCREW WITH THE HUNT COMMAND?!
    function() 
      if a.HasProperty("Hunt") then
        Trigger.OnIdle(a, function(a)
          if not a.IsDead then 
            if a.IsInWorld then
              a.Hunt()
            end
          end
        end)
      end
    end
  ,
    pcall( -- not going to bother about ScriptTrigger deficiencies now...
      function() 
        -- aircraft fares badly with OnIdle...
        local enemies = Utils.Where(Map.ActorsInWorld, function(self) return not a.IsAlliedWith(self.Owner) and self.HasProperty("Health") and a.CanTarget(self) end)
        local target = Utils.Random(enemies)
        if a.HasProperty("Attack") then
          if not a.IsDead then 
            if a.IsInWorld then
              a.Attack(target)
            end
          end
        end
        
        Trigger.AfterDelay(DateTime.Seconds(5), ForceHunt(a))
      end
    )
  )
end

function ForceAttack (a, target) -- returns true if order is made successfully
  AddDebugString("ForceAttack() called")
  local success = false
  pcall( -- not going to bother about ScriptTrigger deficiencies now...
    function() 
      --if a.HasProperty("Attack") then
        if not a.IsDead and not target.IsDead then 
          if a.IsInWorld and target.IsInWorld then
            if a.CanTarget(target) then 
              a.Stop()
              a.Attack(target, true, true) 
              success = true
            end
          end
        end
      --end
    end
  )
  return success
end

function ForceGuard (a, target) -- returns true if order is made successfully
  AddDebugString("ForceGuard() called")
  local success = false
  pcall( -- not going to bother about ScriptTrigger deficiencies now...
    function() 
      if a.HasProperty("Guard") then
        if not a.IsDead and not target.IsDead then 
          if a.IsInWorld and target.IsInWorld then
            a.Stop()
            a.Guard(target) 
            success = true
          end
        end
      end
    end
  )
  return success
end

	

