-----------------------------------------------------------------------------------------------------------------------
------------------ LUA SCRIPTS FOR MISSION CONTROL AND AI IMPLEMENTATION
---------------------- by lovalmidas
-----------------------------------------------------------------------------------------------------------------------
-- AI PRODUCTION UNIT LUA  VERSION 1.0
-- #9
------ Contains:  
---------- SetupProductionBuilding(Actor actor, string tab) 
---------- SetupFactories(int i)
---------- MakeProductionTypes(string t, string s, string tab)
---------- UnitProduction (ActiveProductionTable productiontable)


------------------------------------------------------------------------------------
------ Unit production activation by factory creation
function SetupProductionBuilding (actor)
  AddDebugString("SetupProductionBuilding("..actor.Owner.Name..", "..actor.Type..") called")
  
	if IsPartOfGrouping(actor.Type, "ConstructionYards") then return end
  local productiontable = { factory = actor, 
                            activated = true, 
                            tab = GetFactoryTab(actor.Type), 
                            types = MakeProductionTypes(actor.Type, actor.Owner.Name), 
                            curr_production = "", 
                            progress = 0}
  
	table.insert(ActiveProductionTable, productiontable)
  local newfactory = #ActiveProductionTable
  SetupFactories(productiontable)
	UnitProduction(productiontable)
end

------------------------------------------------------------------------------------
------ Factory setup for passing units to AI control
function SetupFactories (productiontable) -- use nil to activate all. Use nil only in the beginning!
  AddDebugString("SetupFactories("..(productiontable and productiontable.factory.Owner.Name..","..productiontable.factory.Type or "")..") called")

  local apts
	if productiontable == nil then
    apts = Utils.Where(ActiveProductionTable, function(apt) return apt.factory.Type ~= "fact" end)
  else
    apts = { productiontable }
  end
    
  Utils.Do(apts, function(apt)
    if not apt.factory.IsDead then
      Trigger.OnProduction(apt.factory, function(_, a)
        AddActorToRegistry(a)
        AddActorToPool(a) 
        
        -- trigger: defensive teams
        if apt.toprotect == true or (apt.toprotect == nil and IsPartOfGrouping(apt.type, "ToProtect")) then
          -- TO DO: Set up call to attack attacker, and set to triggers for produced units, reinforced units and pre-placed units/structures
          Trigger.OnDamaged(a, function(self, attacker)
            if not self.Owner.IsAlliedWith(attacker.Owner) then
              AIReservedDefence(self.Owner.Name, attacker)
            end
          end)
        end
      end)
    end
  end)
end

------------------------------------------------------------------------------------
------ Populate list from MasterTable
function MakeProductionTypes (t, s) -- t = factory type, s = owner/side name
  AddDebugString("MakeProductionTypes("..t..","..s..") called")

	local ProduceList = { }
  
  local tab = GetFactoryTab(t)
  if tab ~= nil then 
    Utils.Do(MasterTable.Production[tab], function(mu)
      Utils.Do(mu.side, function(ms)
        if mu.factory == t and ms == s and mu.weight > 0 then table.insert(ProduceList, mu) end
      end)
    end)

    if Player.GetPlayer(s) ~= nil then 
      Utils.Do(MasterTable.Production[tab], function(mu)
        Utils.Do(mu.side, function(ms)
          if mu.factory == t and ms == Player.GetPlayer(s).Faction and mu.weight > 0 then table.insert(ProduceList, mu) end
        end)
      end)
    end    
  end

	return ProduceList
end

------------------------------------------------------------------------------------
------ Cyclic unit production
function UnitProduction (productiontable)
  AddDebugString("UnitProduction("..productiontable.factory.Owner.Name..","..productiontable.factory.Type..") called")

	if productiontable.factory.IsDead then  
    RemoveFromList(ActiveProductionTable, productiontable)
		return
	end
  
	if IsPartOfGrouping(productiontable.factory.Type, "ConstructionYards") then return end --different handling for Construction Yards
	if #productiontable.types > 0 and productiontable.activated and (QueuePerFactory or productiontable.factory.IsPrimaryBuilding) then
		
    local numproc = #FindOwnedActorTypes(productiontable.factory.Owner, MasterTable.Groupings.Refineries)
		local numharv = #productiontable.factory.Owner.GetActorsByType("harv") --FindOwnedActorType(factory.Owner, "harv") does not work as it does not account for free units from refinery
         
    -- Build Harvester override
		local validunitList = { }
		if numharv < numproc * Houses[productiontable.factory.Owner.Name].AIHarvestersPerRefinery and productiontable.factory.Type == "weap" then
			validunitList = { { type = "harv", factory = "weap", side = { productiontable.factory.Owner.Name }, toprotect = true } } 
		else
      if productiontable.factory.Owner.Cash + productiontable.factory.Owner.Resources > Houses[productiontable.factory.Owner.Name].AIEmergencyCashThreshold then
        local aifilllist = { }
        -- check AITeam lists to fill 
        if type(AIGroupToFillStatus) == "table" and AIGroupToFillStatus[productiontable.factory.Owner.Name] ~= nil then
          Utils.Do(AIGroupToFillStatus[productiontable.factory.Owner.Name], function(actornamegroup) 
            Utils.Do(actornamegroup, function(actortype)
              Utils.Do(productiontable.types, function(tt)
                  if actortype == tt.type then table.insert(aifilllist, tt) end
              end)
            end)
          end)
        end
                
        if #aifilllist == 0 then 
          if productiontable.factory.Owner.Cash + productiontable.factory.Owner.Resources > Houses[productiontable.factory.Owner.Name].AILowCashThreshold then aifilllist = productiontable.types end
        end 
        -- Check prereqs
        Utils.Do(aifilllist, function(tt)
          if CheckPrerequisites(productiontable.factory.Owner, tt.prereq) then 
            for i = 1, tt.weight do validunitList[#validunitList + 1] = tt end
          end
        end)
      end
    end

    if #validunitList > 0 then
      local actorproduced = validunitList[Utils.RandomInteger(1, #validunitList + 1)]
      local unitType = actorproduced.type

      -- apply multipliers
      if actorproduced.buildtime == nil then actorproduced.buildtime = Actor.BuildTime(actorproduced.type) end
      if actorproduced.cost == nil then actorproduced.cost = Actor.Cost(actorproduced.type) end
      
      local buildtime = actorproduced.buildtime * GetBuildTimeMultiplier(productiontable.factory.Owner, productiontable.tab) --* Utils.Random({0.98,0.99,1,1.01,1.02})
      local cost = actorproduced.cost * GetCostMultiplier(productiontable.factory.Owner, productiontable.tab)

      productiontable.curr_production = actorproduced.type
      BuildActor(actorproduced, productiontable, buildtime, cost)
      return
    end
	end
  
  -- periodic recheck
	Trigger.AfterDelay(Utils.RandomInteger(200, 1250), function() UnitProduction(productiontable) end)
end	
------------------------------------------------------------------------------------

------------------------------------------------------------------------------------
------ AI unit evaluation to set unit priority (To be implemented) 


