
-- function to return a rectangular array of cells
function CPosRectangleArray (left, top, right, bottom)
  local cposarray = { }
  for i = left, right do
    for j = top, bottom  do
      table.insert (cposarray, CPos.New(i,j))
    end
  end
  return cposarray
end

--Cell Triggers
--None


function PrepareReinforcements()
  UnitReinforcements = {}
  UnitReinforcements[MissionPlayer.Name] = {
    --{ Units = { }, Spawn = { } , Path = { } },
    { Units = { "pt", "pt", "pt" }, Spawn = { waypoint0.Location } , Path = { waypoint1.Location } },
  }

  UnitReinforcements["USSR"] = {
    -- USSR initial response
    { Units = { "e3", "e3", "e3", "e2", "e2", "e2" }, Spawn = { Actor74.Location + CVec.New(0,1) } , Path = { waypoint10.Location, waypoint4.Location, waypoint27.Location } },
    -- Subs 
    { Units = { "ss", "ss", "ss" }, Spawn = { waypoint19.Location } , Path = { waypoint13.Location, waypoint14.Location, waypoint20.Location, waypoint42.Location } },
  }
  
  UnitReinforcements["BadGuy"] = {
    -- Initial response
    { Units = { "e1", "e1", "e1", "e2", "e2" }, Spawn = { Actor100.Location + CVec.New(0,1) } , Path = { waypoint25.Location } },
    { Units = { "v2rl" }, Spawn = { waypoint28.Location} , Path = { waypoint27.Location } },
  }

  AircraftReinforcements = { }
  AircraftReinforcements["USSR"] = {
    -- Aerial attackers
    { Units = { "mig", "mig" }, Spawn = { waypoint19.Location } , Path = { waypoint13.Location, waypoint20.Location, waypoint27.Location } },
    { Units = { "mig", "mig" }, Spawn = { waypoint19.Location } , Path = { waypoint51.Location, waypoint20.Location, waypoint27.Location } },
    { Units = { "mig", "mig" }, Spawn = { waypoint19.Location } , Path = { waypoint27.Location, waypoint5.Location, waypoint27.Location } },
    { Units = { "mig", "mig" }, Spawn = { waypoint19.Location } , Path = { waypoint10.Location, waypoint42.Location, waypoint27.Location } },
  }
  
  TransportReinforcements = { }
  TransportReinforcements[MissionPlayer.Name] = {
  --{ Transport = , Units = { }, Spawn = { }, Path = { } },
    { Transport = "lst", Units = { "mcv", "jeep", "2tnk", "2tnk" }, Spawn = { waypoint0.Location, waypoint1.Location, waypoint34.Location }, Path = { waypoint25.Location } },
    { Transport = "lst", Units = { "e1", "e1", "e1", "jeep", "2tnk" }, Spawn = { waypoint0.Location, waypoint1.Location, waypoint34.Location }, Path = { waypoint25.Location } },
  }
  
  TransportReinforcements["USSR"] = {
    -- USSR initial response
    { Transport = "lst", Units = { "e1", "e1", "e2", "e2", "e2" }, Spawn = { waypoint24.Location, waypoint2.Location }, Path = { waypoint27.Location, waypoint25.Location } },
    { Transport = "lst", Units = { "e2", "e2", "e2", "e2", "3tnk" }, Spawn = { waypoint24.Location, waypoint42.Location, waypoint1.Location, waypoint34.Location }, Path = { waypoint27.Location, waypoint25.Location } },
    { Transport = "lst", Units = { "e4", "e4", "e4", "3tnk" }, Spawn = { waypoint19.Location, waypoint18.Location }, Path = { waypoint28.Location, waypoint51.Location, waypoint27.Location } },
    { Transport = "lst", Units = { "3tnk", "3tnk", "3tnk", "v2rl", "v2rl" }, Spawn = { waypoint19.Location, waypoint18.Location }, Path = { waypoint28.Location, waypoint51.Location, waypoint27.Location } },
  }
  
  ParadropReinforcements = { }
  ParadropReinforcements["USSR"] = {
    { Units = { "e1", "e1", "e2", "e2", "e2" }, Spawn = { waypoint27.Location }, Path = { waypoint27.Location, waypoint25.Location } },
  }

  -- Player reinforcements 
  Trigger.AfterDelay(DateTime.Seconds(1), function() CreateTransportReinforcements(MissionPlayer, 1) end)
  Trigger.AfterDelay(DateTime.Seconds(50), function() CreateTransportReinforcements(MissionPlayer, 2) end)

  Trigger.AfterDelay(DateTime.Seconds(100), function() CreateParadropReinforcements(Player.GetPlayer("USSR"), 1) end)

  Trigger.AfterDelay(DateTime.Seconds(4), function() CreateUnitReinforcements(Player.GetPlayer("BadGuy"), 1, 3, 302, true, true) end)
  Trigger.AfterDelay(DateTime.Seconds(20), function() CreateUnitReinforcements(Player.GetPlayer("USSR"), 1, 3, 302, true, true) end)
  Trigger.AfterDelay(DateTime.Seconds(10), function() CreateUnitReinforcements(Player.GetPlayer("BadGuy"), 2, 3, 302, true, true) end)

  Trigger.AfterDelay(DateTime.Minutes(8), function() CreateTransportReinforcements(Player.GetPlayer("USSR"), 1) end)
  Trigger.AfterDelay(DateTime.Minutes(9) + DateTime.Seconds(20), function() CreateTransportReinforcements(Player.GetPlayer("USSR"), 3) end)
  Trigger.AfterDelay(DateTime.Minutes(10), function() CreateTransportReinforcements(Player.GetPlayer("USSR"), 2) end)

  if Map.LobbyOption("difficulty") == "Mental" then
    Trigger.AfterDelay(DateTime.Minutes(3), function() CreateTransportReinforcements(Player.GetPlayer("USSR"), 2) end)
    Trigger.AfterDelay(DateTime.Minutes(6), function() CreateTransportReinforcements(Player.GetPlayer("USSR"), 3) end)
    Trigger.AfterDelay(DateTime.Minutes(10) + DateTime.Seconds(15), function() CreateTransportReinforcements(Player.GetPlayer("USSR"), 4) end)
  end
  
  if Map.LobbyOption("difficulty") ~= "Easy" then
    Trigger.AfterDelay(DateTime.Minutes(4), function() CreateTransportReinforcements(Player.GetPlayer("USSR"), 1) end)
  end
  
  PrepareReinforcementsRepeat()
end
  
  
function PrepareReinforcementsRepeat ()
  
  -- MIG
  Trigger.AfterDelay(DateTime.Seconds(250), function() CreateAircraftReinforcements(Player.GetPlayer("USSR"), Utils.RandomInteger(1,4), 3, DateTime.Seconds(10), true) end)
  Trigger.AfterDelay(DateTime.Seconds(300), function() CreateUnitReinforcements(Player.GetPlayer("USSR"), 2, 3, 302, true) end)

  if Map.LobbyOption("difficulty") == "Mental" then
    Trigger.AfterDelay(DateTime.Seconds(125), function() CreateAircraftReinforcements(Player.GetPlayer("USSR"), Utils.RandomInteger(1,4), 3, DateTime.Seconds(10), true) end)
  end
  
  Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(240,500)), PrepareReinforcementsRepeat)
end


function CreateUnitReinforcements (player, i, closeenough, delay, cyclic, waitforgroup) -- waitforgroup 

  if closeenough == nil then closeenough = 3 end
  if delay == nil then delay = 25 end
  if cyclic == nil then cyclic = false end

	Media.Debug("Creating "..player.Name.." Reinforcements #" .. i)
  if player == MissionPlayer then Media.PlaySpeechNotification(player, "ReinforcementsArrived") end

	local units = Reinforcements.Reinforce( player, 
                                          UnitReinforcements[player.Name][i].Units, 
                                          UnitReinforcements[player.Name][i].Spawn)
   
	Utils.Do(units, function(unit)
    if waitforgroup then
      GroundAttack(unit, UnitReinforcements[player.Name][i].Path, closeenough, delay, cyclic, units)
    else
      GroundAttack(unit, UnitReinforcements[player.Name][i].Path, closeenough, delay, cyclic)
    end
  end)
end


function CreateAircraftReinforcements (player, i, closeenough, checkdelay, cyclic)

  if closeenough == nil then closeenough = 3 end
  if delay == nil then delay = 25 end
  if cyclic == nil then cyclic = false end

	Media.Debug("Creating "..player.Name.." Aircraft Reinforcements #" .. i)
  if player == MissionPlayer then Media.PlaySpeechNotification(player, "ReinforcementsArrived") end

	local units = Reinforcements.Reinforce( player, 
                                          AircraftReinforcements[player.Name][i].Units, 
                                          AircraftReinforcements[player.Name][i].Spawn)
   
	Utils.Do(units, function(unit)
    AircraftAttack(unit, AircraftReinforcements[player.Name][i].Path, closeenough, checkdelay, cyclic)
  end)
end


function CreateTransportReinforcements (player, i, closeenough, delay, cyclic, waitforgroup)
  if bdebug then UserInterface.SetMissionText("User CreateTransportReinforcements( player = ".. player.Name ..", i = " ..i..") at "..missiontick, MissionPlayer.Color) end

  if closeenough == nil then closeenough = 3 end
  if delay == nil then delay = 25 end
  if cyclic == nil then cyclic = false end

	Media.Debug("Creating "..player.Name.." Transport Reinforcements #" .. i)
  if player == MissionPlayer then Media.PlaySpeechNotification(player, "ReinforcementsArrived") end
  
	local units = Reinforcements.ReinforceWithTransport(player, 
                                                      TransportReinforcements[player.Name][i].Transport, 
                                                      TransportReinforcements[player.Name][i].Units, 
                                                      TransportReinforcements[player.Name][i].Spawn,
                                                      { TransportReinforcements[player.Name][i].Spawn[1] })[2]
  
	Utils.Do(units, function(unit)
    if waitforgroup then
      GroundAttack(unit, TransportReinforcements[player.Name][i].Path, closeenough, delay, cyclic, units)
    else
      GroundAttack(unit, TransportReinforcements[player.Name][i].Path, closeenough, delay, cyclic)
    end
  end)
end


function CreateParadropReinforcements (player, i, closeenough, delay, cyclic, waitforgroup)

  if closeenough == nil then closeenough = 3 end
  if delay == nil then delay = 25 end
  if cyclic == nil then cyclic = false end

	Media.Debug("Creating "..player.Name.." Paradrop Reinforcements #" .. i)
  if player == MissionPlayer then Media.PlaySpeechNotification(player, "ReinforcementsArrived") end
  
	local lz = ParadropReinforcements[player.Name][i].Spawn[1]
    local start = Map.CenterOfCell(Map.RandomEdgeCell()) + WVec.New(0, 0, Actor.CruiseAltitude("badr"))
    local transport = Actor.Create("badr", true, { CenterPosition = start, Owner = player, Facing = (Map.CenterOfCell(lz) - start).Facing })
	local units = ParadropReinforcements[player.Name][i].Units
	
    Utils.Do(units, function(type)
      local unit = Actor.Create(type, false, { Owner = player })
      Trigger.OnAddedToWorld(unit, function(a)
        if waitforgroup then
          GroundAttack(a, TransportReinforcements[player.Name][i].Path, closeenough, delay, cyclic, units)
        else
          GroundAttack(a, TransportReinforcements[player.Name][i].Path, closeenough, delay, cyclic)
        end
      end)
      transport.LoadPassenger(unit)
    end)

    transport.Paradrop(lz)
    
end
