missionDisplayObjectives = true
missionDisplayResource = false
missionDisplayProduction = false
missionDisplayAITeams = false
missionDisplayAICustomTeams = false

function TickShowInfo(cty)
  
  -- Disable during debug
  if bdebug then return end
  if cty == nil then return end
  local str = ""
  if missionDisplayObjectives and #missionObjectiveIDs > 0 then 
    Utils.Do(missionObjectiveIDs, function(id)
      if MissionPlayer.GetObjectiveType(id) ~= "Primary" then return end
      if str == "" then
        str = "\nObjective"..((#missionObjectiveIDs > 1) and "s" or "")..": \n     "..str..MissionPlayer.GetObjectiveType(id)..":  "..MissionPlayer.GetObjectiveDescription(id)
      else
        str = "\n"..str.."\n     "..MissionPlayer.GetObjectiveType(id)..":  "..MissionPlayer.GetObjectiveDescription(id)
      end
      if missionObjectiveFlavourText[id] ~= nil then str = str.." ("..missionObjectiveFlavourText[id]..")" end
    end)
  
    Utils.Do(missionObjectiveIDs, function(id)
      if MissionPlayer.GetObjectiveType(id) == "Primary" then return end
      if str == "" then
        str = "\nObjective"..((#missionObjectiveIDs > 1) and "s" or "")..": \n     "..str..MissionPlayer.GetObjectiveType(id)..":  "..MissionPlayer.GetObjectiveDescription(id)
      else
        str = "\n"..str.."\n     "..MissionPlayer.GetObjectiveType(id)..":  "..MissionPlayer.GetObjectiveDescription(id)
      end
      if missionObjectiveFlavourText[id] ~= nil then str = str.." ("..missionObjectiveFlavourText[id]..")" end
    end)
  
    str = "\n"..str.."\n"
  end
  	-- wacky messages
--	if randommsgallowed then
--		if str_tick < 0 or str_switch ~= cty.Name then
--		
--			local randommsgselect = Utils.RandomInteger(1,#randommsgcodelist)
--			MessageCall(cty.Faction, randommsgcodelist[randommsgselect] , 0)
--			
--			if ticked > -300 then
--				randommsgcodelist[randommsgselect] = Utils.Random({0,0,0,0,0,0,0,0,0,1,4,4})
--			else
--				randommsgcodelist[randommsgselect] = Utils.Random({0,0,0,0,0,0,0,0,1,2,2,4})			
--			end
--			
--			if str_switch ~= cty.Name then
--				str_tick = Utils.RandomInteger(1, str_tick_init)
--			else
--				str_tick = str_tick_init
--			end
--			str_switch = cty.Name
--		else
--			str_tick = str_tick - 1
--		end
--	end
	
  if missionDisplayResource or missionDisplayProduction or missionDisplayAITeams or missionDisplayAICustomTeams then
    str = str .."_________________________________________________________________________________________________________\n".. cty.Name .." Player Information" 
  end
    
	if missionDisplayResource then 
		local gnumproc = FindOwnedActorType(cty, "proc")
		local gnumharv = #cty.GetActorsByType("harv") --FindOwnedActorType(cty, "harv")
    
    -- for 120 characters max length without shifting the textbox

		str = "\n".. str .."\n  Resources: ".. (cty.Cash + cty.Resources) .." / ".. gnumproc .." Refiner"..( (gnumproc > 1) and "ies" or "y" ).." / ".. gnumharv .." Ore Truck".. ((gnumharv > 1) and "s" or "")
		
		if TransferText[cty.Name] ~= "" and TransferText[cty.Name] ~= nil then
			str = str .."  (".. TransferText[cty.Name] ..")"
		end
  end
  
 	if missionDisplayProduction then 
		local str_factory = ""

		Utils.Do(ActiveProductionTable, function(t)
			if t.factory.Owner == cty and t.progress > 0 then
				local intprog = (t.progress - t.progress % 1000) / 1000
				if str_factory == "" then--t.factory.Type == "fact" then
					str_factory = "  ".. GetName(t.curr_production) .."(".. intprog .."%) ".. str_factory
				else
					str_factory = str_factory .." ".. GetName(t.curr_production) .."(".. intprog .."%) "
				end
			end
		end)
		
		if str_factory ~= "" then
			str = "\n\n".. str .."\n\nProducing: \n".. str_factory
		else
			str = "\n\n".. str .."\n\nNot producing anything.\n"
		end
  end
  
 	if missionDisplayAITeams then    
    if type(AIActorGroups[cty.Name]) == "table" then
      str = "\n\n\n"..str.."\n\n"..(missionDisplayAICustomTeams and "Advanced" or "Basic").." AI Teams: \n"
      str = AIGroupInfo(str, cty, "Pool")
      str = AIGroupInfo(str, cty, "Hunt")
      str = AIGroupInfo(str, cty, "Defense")
      str = AIGroupInfo(str, cty, "DefenseEscort")  
      
      local totaltroopsinteams = 0
      local str2 = ""
      for actorgroupname,actors in pairs(AIActorGroups[cty.Name]) do 
        if not (actorgroupname == "Pool" or actorgroupname == "Hunt" or actorgroupname == "Defense" or actorgroupname == "DefenseEscort") then
          if missionDisplayAICustomTeams then
            local str3 = str2
            str2 = AIGroupInfo(str2, cty, actorgroupname)
            if str3 ~= str2 then str = "\n" .. str end
          end
          totaltroopsinteams = totaltroopsinteams + AIGroupSurvivor(cty, actorgroupname)
        end
      end
      
      str = str.."  In Active Taskforce: "..totaltroopsinteams.."  "
      str = str..str2
    end
    
		--str = "\n".. str .."\n\n".. str_message
	end

	UserInterface.SetMissionText(str, cty.Color)
end


function AIGroupInfo (str, cty, actorgroupname)
  local statusstr = ""
  if AIGroupStatus[cty.Name] == nil then return str
  elseif AIGroupStatus[cty.Name][actorgroupname] == nil then return str
  elseif AIGroupStatus[cty.Name][actorgroupname] == -3 then statusstr =   "Returning to Pool" 
  elseif AIGroupStatus[cty.Name][actorgroupname] == -2 then statusstr =   "On Hold" 
  elseif AIGroupStatus[cty.Name][actorgroupname] == -1 then statusstr =   "Populating" 
  elseif AIGroupStatus[cty.Name][actorgroupname] > 0 then statusstr =     "Executing Script" 
  end
  
  if (statusstr ~= "" and statusstr ~= nil) or (actorgroupname == "Pool" or actorgroupname == "Hunt" or actorgroupname == "Defense" or actorgroupname == "DefenseEscort") then
    local statussurvivor = 0
    local statusgroup = ""
    if AIActorGroups[cty.Name][actorgroupname] ~= nil then
      Utils.Do(AIActorGroups[cty.Name][actorgroupname], function(a)
          if not a.IsDead then 
            statussurvivor = statussurvivor + 1 
            statusgroup = statusgroup .. " " .. a.Type --GetName(a.Type)
          end
      end)
    end
    
    if statussurvivor ~= 0 or (actorgroupname == "Pool" or actorgroupname == "Hunt" or actorgroupname == "Defense" or actorgroupname == "DefenseEscort") then
      if (actorgroupname == "Pool" or actorgroupname == "Hunt" or actorgroupname == "Defense" or actorgroupname == "DefenseEscort") then
        return str.."  "..actorgroupname..": "..statussurvivor.."  "--.. statusgroup
      else
        return str.."\n  ["..actorgroupname.."]  Units: "..statussurvivor.." / "..#AITeamClone[cty.Name][actorgroupname]..", "..statusstr.."   "--.. statusgroup
      end
    end
  end
  return str
end

function AIGroupSurvivor (cty, actorgroupname)
  if AIGroupStatus[cty.Name] == nil then return 0
  elseif AIGroupStatus[cty.Name][actorgroupname] == nil then return 0
  end
  
  if not (actorgroupname == "Pool" or actorgroupname == "Hunt" or actorgroupname == "Defense" or actorgroupname == "DefenseEscort") then
    local statussurvivor = 0
    if AIActorGroups[cty.Name][actorgroupname] ~= nil then
      Utils.Do(AIActorGroups[cty.Name][actorgroupname], function(a)
          if not a.IsDead then 
            statussurvivor = statussurvivor + 1 
          end
      end)
    end
    return statussurvivor
  end
end

