-- Collection of functions for governing AI base production --
FactoryQueue = true
TabQueue = false -- set true to split the conyard queue to Structures and Defenses tabqueues

ActiveProductionTable = { }	--{ factory = nil, types = nil, curr_production = nil, curr_progress = 0 }



------------------------------------------------------------------------------------
------ Building / Training in progress
function BuildActor (actorproduced, owner, factory, productiontable, tab, buildtime, cost)
  --if bdebug then UserInterface.SetMissionText("BuildActor() called at tick "..missiontick, MissionPlayer.Color) end  
  
  --if bdebug then UserInterface.SetMissionText(factory.Owner.Name .." building ".. actorproduced.type.. ", buildtime "..buildtime..", cost "..cost..", progress "..((productiontable.progress - productiontable.progress % 1000) / 1000), HSLColor.Yellow) end

	local tick = 5
	productiontable.curr_production = actorproduced.type
	
	-- refund
	if factory.IsDead then
		AddMoney(factory.Owner, cost * productiontable.progress / 100000)
		productiontable.curr_production = ""
		productiontable.progress = 0
		return
	end
	
	local expense = actorproduced.cost * tick / buildtime
	if AddMoney(factory.Owner, -expense) then
		productiontable.progress = productiontable.progress + 100000 * tick / buildtime
	end
	
	if productiontable.progress >= 100000 then
    --Refund extra progress
    AddMoney(factory.Owner, cost * (productiontable.progress - 100000) / 100000)
		FinalizeActor(actorproduced, owner, factory, productiontable, tab)
		productiontable.curr_production = ""
		productiontable.progress = 0
	else
		Trigger.AfterDelay(tick, function() BuildActor(actorproduced, owner, factory, productiontable, tab, buildtime, cost) end)
	end
	
end
	

------------------------------------------------------------------------------------
------ Building / Training complete
function FinalizeActor (actorproduced, owner, factory, productiontable, tab)
  --if bdebug then UserInterface.SetMissionText("FinalizeActor() called at tick "..missiontick, MissionPlayer.Color) end  
  
	--Finished construction
  if factory.IsDead then
    return
  end
  
  if factory.Type == "fact" then
    -- Building construction
    local actor = Actor.Create(actorproduced.type, true, { Owner = owner, Location = CPos.New(actorproduced.pos.x, actorproduced.pos.y) })
        
    Media.Debug("Structure completed for ".. actorproduced.owner.Name ..": [".. actorproduced.id .."] ".. GetName(actorproduced.type) .." at (".. actorproduced.pos.x ..",".. actorproduced.pos.y ..")")
    actorproduced.mapactor = actor
    ExistingBuildings[#ExistingBuildings + 1] = actor
    AddActorToRegistry(actor)

    if GetFactoryTab(actor.Type) ~= nil then SetupProductionBuilding(actor, GetFactoryTab(actor.Type)) end

    Trigger.OnKilled(actor, function(a, _) 
      actorproduced.mapactor = nil 
      RemoveFromList(ExistingBuildings, a)
    end)
  
    SingleStructureRepair(actor,AIStructureHPRepair)
    
    Trigger.AfterDelay(5, function() BaseProduction(factory, tab) end)
  else
    -- Unit Production
    Media.Debug("Unit completed for ".. factory.Owner.Name ..": ".. GetName(actorproduced.type))
    factory.Produce(actorproduced.type)
    factory.CallFunc(function() UnitProduction(productiontable, tab) end)
  end
end


function GetFactoryTab (ty)
  if bdebug then UserInterface.SetMissionText("GetFactoryTab() called at tick "..missiontick, MissionPlayer.Color) end  
    
  if ty == "barr" or ty == "kenn" or ty == "tent" then return "Infantry"
  elseif ty == "weap" then return "Units"
  elseif ty == "hpad" or ty == "afld" then return "Aircraft"
  elseif ty == "syrd" or ty == "spen" then return "Ships"
  elseif ty == "fact" then return "ConstructionYard"
  else return nil
  end
  
end

function CheckPrerequisites (owner, prereqlist)
  if bdebug then UserInterface.SetMissionText("CheckPrerequisites() called at tick "..missiontick, MissionPlayer.Color) end  
  
  local meetsprereq = true
  if #prereqlist > 0 then
    Utils.Do(prereqlist, function(prerequisite)
      if FindOwnedActorType(owner, prerequisite) == 0 then meetsprereq = false end
    end)
  end
  return meetsprereq
end

function FindOwnedActorType (player, actortype) -- returns the number of actors in map
  if bdebug then UserInterface.SetMissionText("FindOwnedActorType( player = "..player.Name..", actortype = "..actortype.." ) called at tick "..missiontick, MissionPlayer.Color) end  
	
  if ActorRegistry[player.Name] == nil then return 0 end
  if ActorRegistry[player.Name][actortype] == nil then return 0 end
  return #ActorRegistry[player.Name][actortype] or 0
  
  --local actor = nil
  --Utils.Do(ExistingBuildings, function(a)
	--	if a.Owner == player and a.Type == actortype then
	--		actor = a
  --    return
	--	end
	--end)
	--return actor
  
  --return cty.GetActorsByType(t)
end