---------------------- GLOBAL OVERRIDES --------------------------------------------
---- To override individual players use the ManualOverride function

------ Player settings -------------------------------------------------------------
  -- InitialCash = the player's initial cash, defaults to 0
  
  -- Bot controls only
  --    BuildTimeMultiplier (default, Structures, Defences, Infantry, Units, Aircraft, Ships), defaults to default, which defaults to 1
  --    CostMultipliers (default, Structures, Defences, Infantry, Units, Aircraft, Ships), defaults to default, which defaults to 1

-- Human players
DefaultInitialCash = 4000

-- Soviet Bots
if Map.LobbyOption("difficulty") == "Hard" then
  SovietBotInitialCash = 12500
  SovietBotBuildTimeMultiplier = { default = 0.9 }
  SovietBotCostMultiplier = { default = 0.9 }
elseif Map.LobbyOption("difficulty") == "Normal" then
  SovietBotInitialCash = 7500
  SovietBotBuildTimeMultiplier = { default = 1 }
  SovietBotCostMultiplier = { default = 1 }
else
  SovietBotInitialCash = 5500
  SovietBotBuildTimeMultiplier = { default = 1 }
  SovietBotCostMultiplier = { default = 1 }
end

------------------------------------------------------------------------------------
------ Base settings ---------------------------------------------------------------
  -- IncludeExistingBuildingsInBaseNodes = whether existing buildings should be included in the base node count
  -- ExcludeExistingBuildingWithStringOverride = (string) if the actor's name contains this string, override to exclude the building from the base node list
  
IncludeExistingBuildingsInBaseNodes = true
InitialBaseNodes = {
  -- id = name of this entry (for debug, or specific selection only)
  -- owner = the player
  -- type = the actor type
  -- pos = position as { x, y } coordinates 

  -- Example
  -- { id = "A01", owner = Houses["Germany"].Player, type = "powr", pos = { x = 10, y = 12} },
}
 
------------------------------------------------------------------------------------
------ AI settings -----------------------------------------------------------------
AIMaintainExcessPower = 101
AIStructureHPRepair = 0.9
AIUnitHPPursuit = 0.9
AIHarvestersPerRefinery = 3
AILowCashThreshold = 5000
AIEmergencyCashThreshold = 2500

if Map.LobbyOption("difficulty") == "Hard" then
  AIHarvestersPerRefinery = 2.5
  -- Prevent player farming harvester exploit
  Trigger.AfterDelay(DateTime.Minutes(10), function() AIHarvestersPerRefinery = 1.5 end)
else
  AIHarvestersPerRefinery = 1.5
end

PooltoHuntThreshold = { -- Send all units in Pool to the Hunting group if the number of units surpass this threshold
  ["BadGuy"] = 10,
  ["USSR"] = 25,
} 

GetNextWaypointSet = function(waypoint)
  if waypoint == waypoint3 then return { waypoint27, waypoint27, waypoint27, waypoint51 } end
  if waypoint == waypoint8 then return { waypoint27, waypoint27, waypoint27, waypoint5 } end
  if waypoint == waypoint5 then return { waypoint8, waypoint8, waypoint51 } end
  if waypoint == waypoint51 then return { waypoint3, waypoint5, waypoint4, waypoint10 } end
  if waypoint == waypoint4 then return { waypoint51, waypoint51, waypoint9, waypoint10 } end
  if waypoint == waypoint10 then return { waypoint4, waypoint9, waypoint51, waypoint51, waypoint26, waypoint11 } end
  if waypoint == waypoint26 then return { waypoint10 } end
  if waypoint == waypoint11 then return { waypoint28, waypoint10, waypoint10 } end
  if waypoint == waypoint28 then return { waypoint11 } end
  return Waypoints
end

AIHuntInitialWaypoints = {
  ["USSR"] = {waypoint11, waypoint10},
  ["BadGuy"] = {waypoint51},
}

--should standardize this soon...
SovietTeam1 = { "e1", "e1", "e1", "e1", "e1" }
SovietTeam2 = { "3tnk", "3tnk", "v2rl" }
SovietTeam3 = { "e1", "e1", "e2", "e2", "e2", "3tnk" }
SovietTeam4 = { "e4", "e4", "e4" }
SovietTeam5 = { "e2", "e2", "e2", "e2", "e2", "e2", "e4", "e4" }
SovietTeam6 = { "e1", "e1", "e2", "e2", "e2" } 
SovietTeam7 = { "dog", "dog" } 
SovietTeam8 = { "e2", "e2", "e2", "e4", "e4" } 
SovietTeam9 = { "e2", "e2", "e2", "e1", "e1" } 
SovietTeam10 = { "dog", "dog", "dog", "e1", "e1" } 
SovietTeam11 = { "ftrk", "ftrk" }
SovietTeam12 = { "e1", "e1", "e1", "e2", "e2", "ftrk" }
SovietTeam13 = { "e4", "e4", "ftrk", "ftrk" }
SovietTeam14 = { "3tnk", "ftrk", "ftrk" }
SovietTeam15 = { "v2rl", "v2rl", "ftrk", "ftrk" }
SovietTeam16 = { "3tnk", "3tnk", "3tnk", "3tnk" }
SovietTeam17 = { "e1", "e1", "e1", "e1", "v2rl", "v2rl" }
SovietTeam18 = { "v2rl", "v2rl", "v2rl" }

SovietTeamGroups = { SovietTeam1, SovietTeam2, SovietTeam3, SovietTeam4, SovietTeam5, SovietTeam6, SovietTeam7, SovietTeam8, SovietTeam9, SovietTeam10, SovietTeam11, SovietTeam12, SovietTeam13, SovietTeam14, SovietTeam15, SovietTeam16, SovietTeam17, SovietTeam18 }

SovietAirTeam1 = { "yak" }
SovietAirTeam2 = { "mig" }
SovietAirTeam3 = { "yak", "yak" }
SovietAirTeam4 = { "mig", "mig" }

SovietAirTeamGroups = { SovietAirTeam1, SovietAirTeam2, SovietAirTeam3, SovietAirTeam4 }


BadGuyTeam1 = { "e1", "e1", "e1", "e1", "e1" }
BadGuyTeam2 = { "e2", "e2" }
BadGuyTeam3 = { "e1", "e1", "e2", "e2", "e2" } 
BadGuyTeam4 = { "e4", "e4" }


BadGuyTeamGroups = { BadGuyTeam1, BadGuyTeam2, BadGuyTeam3, BadGuyTeam4 }


SovietRoute1 = {
  waypoint11.Location, 
  waypoint51.Location, 
  waypoint27.Location, 
}

SovietRoute2 = {
  waypoint11.Location, 
  waypoint51.Location, 
  waypoint5.Location, 
  waypoint8.Location, 
  waypoint27.Location 
}

SovietRoute3 = {
  waypoint11.Location, 
  waypoint9.Location, 
  waypoint27.Location 
}

SovietRoute4 = {
  waypoint11.Location, 
  waypoint26.Location, 
  waypoint27.Location, 
}

-- double weightage for the main routes
SovietRoutes = { SovietRoute1, SovietRoute2, SovietRoute3, SovietRoute4 }

DirectRoute1 = {
  waypoint3.Location, 
  waypoint27.Location, 
}

DirectRoute2 = {
  waypoint8.Location, 
  waypoint27.Location, 
}

DirectRoute3 = {
  waypoint5.Location, 
  waypoint27.Location, 
}

DirectRoute4 = {
  waypoint9.Location, 
  waypoint27.Location, 
}

DirectRoutes = { DirectRoute1, DirectRoute2, DirectRoute3, DirectRoute4 }


Waypoints = {
  waypoint3,
  waypoint8,
  waypoint5,
  waypoint51,
  waypoint4,
  waypoint10,
  waypoint26,
  waypoint11,
  waypoint28
}  



function PostSetupManualOverride ()
  if bdebug then UserInterface.SetMissionText("PostSetupManualOverride() called at tick "..missiontick, MissionPlayer.Color) end
  
  missionDisplayPlayer = MissionPlayer --Player.GetPlayer("USSR") -- 
  if Map.LobbyOption("difficulty") ~= "Easy" then Player.GetPlayer("BadGuy").Cash = AILowCashThreshold + 4000 end

end



AIActivated = false
function TickManualOverride()
  
  if missiontick == DateTime.Seconds(45) then AIActivated = true end

  -- mission settings
  if pObjDestroyPens then
    if MissionPlayer.HasNoRequiredUnits() then
      MissionPlayer.MarkFailedObjective(pObjDestroyPens)
      if not MissionPlayer.IsObjectiveCompleted(pObjCaptureRadar) then
        MissionPlayer.MarkFailedObjective(pObjCaptureRadar)
      end
    end
  end

  --AI cheats! Shame on me!
	--Utils.Do(HouseGroups.Bots, function(h)
	--	if h.Resources >= h.ResourceCapacity * 0.75 then
	--		h.Cash = h.Cash + h.Resources - h.ResourceCapacity * 0.25
	--		h.Resources = h.ResourceCapacity * 0.25
	--	end
  if AIActivated then
    if Map.LobbyOption("difficulty") == "Hard" then
      if missiontick % 10 == 0 then Player.GetPlayer("BadGuy").Cash = Player.GetPlayer("BadGuy").Cash + 1 end
    elseif Map.LobbyOption("difficulty") == "Normal" then
      if missiontick % 20 == 0 then Player.GetPlayer("BadGuy").Cash = Player.GetPlayer("BadGuy").Cash + 1 end      
    else
      if missiontick % 30 == 0 then Player.GetPlayer("BadGuy").Cash = Player.GetPlayer("BadGuy").Cash + 1 end      
    end 
  end
	--end)
  ------------------------------------------------------------------------------------
  ------ AI Team settings ------------------------------------------------------------
  ----------- Define all actor groups and their routes here
  ----------- IMPORTANT: References to lua functions should be placed in PostSetupManualOverride and not as part of initializing global variables.

  -- Teams will be declared by AITeams[player.Name][groupname], filled by AIActorGroups over the course of the game, and governed by the AI in AIGroupStatus to perform functions in AIFunctions
  ------ Groups in ActorGroups[player.Name]:
  ----------- 
  ----------- [Reserved names, do not touch]
  ----------- Pool                Pool for newly-built and unassigned units. Game will ignore any 'Pool' groupname
  ----------- Defender            Used to counter threats against the enemy when a structure / harvester is under attack (onDamaged). Directly attacks the attacker, then return to base
  ----------- DefenderEscort      Same as Defender but patrols towards the attacker zone instead of chasing the attacker.
  ----------- Hunt                Used when Pool reaches a certain critical mass.
  ----------- 
  ------ All others can be custom-named. The following may be used.
  ----------- Attack_x            Attacking      
  ----------- Patrol_x            Patrol
  ----------- Reinforcement_x     Reinforcement (if included in transport, only apply to the units after disembarkment)
  ----------- Aircraft_Attack_x   Attacking (Aircraft)
  ----------- Aircraft_Patrol_x   Patrol (Aircraft)
  ----------- Navy_Attack_x       Attacking (Navy)
  ----------- Navy_Patrol_x       Patrol (Navy)
  ----------- MCV                 Special MCV stuff (not for this mission though)
  ----------- Custom names        
  ----------- 
  ------ All Groups will follow the commands given by AIFunctions[player.Name][groupname] , except for the reserved groups which will have their own routes.
  
  if missiontick % 500 == 0 then -- don't refresh every tick, waste of time

    AITeams["USSR"] = 
    { 
      -- syntax: TeamName = { actortype, actortype, actortype, actortype, ... }, TeamName2...
      ["USSR Defend 29"] = Utils.Random({ { "e4", "e4" }, {"e2" , "e2" , "e2", "dog"}, {"ftrk", "ftrk"} , {"v2rl"} }),
      ["USSR Defend 30"] = {"3tnk"},
      ["USSR Defend 31"] = {"v2rl"},
      ["USSR Defend 32"] = {"3tnk"},
      ["USSR Defend 33"] = Utils.Random({ { "e4", "e4" }, {"e2" , "e2" , "e2", "dog"}, {"ftrk", "ftrk"} , {"v2rl"} }),
      ["USSR Hold 3"] = Utils.Random({ { "e1", "e1", "e1", "dog" }, {"e2" , "e2", "dog"}, {"ftrk", "ftrk"} , {"e1" , "e1" , "3tnk"} }),
      ["USSR Hold 4"] = Utils.Random({ { "e1", "e1", "e1", "dog" }, {"e2" , "e2", "dog"}, {"ftrk", "ftrk"} , {"e1" , "e1" , "3tnk"}, {"e1" , "e1" , "v2rl"} }),

      ["USSR Defend 99"] = Utils.Random({ {"e2", "e2", "e1", "e1", "dog"} , {"ftrk", "ftrk", "dog"} , {"3tnk", "dog"} }),
      ["USSR Patrol 9-26"] = { "e2", "e2", "e2", "4tnk" },
      
      ["USSR Attack Slot 1"] = Utils.Random(SovietTeamGroups),
      ["USSR Attack Slot 2"] = Utils.Random(SovietTeamGroups),
      ["USSR Attack Slot 3"] = Utils.Random(SovietTeamGroups),
      ["USSR Attack Slot 4"] = Utils.Random(SovietTeamGroups),
      ["USSR Air Attack Slot 1"] = Utils.Random(SovietAirTeamGroups),
      ["USSR Air Attack Slot 2"] = Utils.Random(SovietAirTeamGroups),
    }

    AITeams["BadGuy"] = 
    { 
      -- syntax: TeamName = { actortype, actortype, actortype, actortype, ... }, TeamName2...
      ["BadGuy Attack Slot 1"] = Utils.Random(BadGuyTeamGroups),
      ["BadGuy Attack Slot 2"] = Utils.Random(BadGuyTeamGroups),
      --["BadGuy Attack Slot 3"] = Utils.Random(BadGuyTeamGroups),
      --["BadGuy Attack Slot 4"] = Utils.Random(BadGuyTeamGroups),
    }

    AIFunctions["BadGuy"] = 
    { 
      -- syntax: TeamName = { Function = functionname, ArgumentTable = functionarguments (table) }, TeamName2...
      ["BadGuy Attack Slot 1"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(DirectRoutes) }}},
      ["BadGuy Attack Slot 2"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(DirectRoutes) }}},
      --["BadGuy Attack Slot 3"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
      --["BadGuy Attack Slot 4"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
    }

    AIFunctions["USSR"] = 
    { 
      -- syntax: TeamName = { Function = functionname, ArgumentTable = functionarguments (table) }, TeamName2...
      ["USSR Defend 29"] = { { Function = ScriptFn_MovementPath, ArgumentTable = {Path = { waypoint29.Location }, Cyclic = true }}},
      ["USSR Defend 30"] = { { Function = ScriptFn_MovementPath, ArgumentTable = {Path = { waypoint30.Location }, Cyclic = true }}},
      ["USSR Defend 31"] = { { Function = ScriptFn_MovementPath, ArgumentTable = {Path = { waypoint31.Location }, Cyclic = true }}},
      ["USSR Defend 32"] = { { Function = ScriptFn_MovementPath, ArgumentTable = {Path = { waypoint32.Location }, Cyclic = true }}},
      ["USSR Defend 33"] = { { Function = ScriptFn_MovementPath, ArgumentTable = {Path = { waypoint33.Location }, Cyclic = true }}},
      ["USSR Defend 3"] = { { Function = ScriptFn_MovementPath, ArgumentTable = {Path = { waypoint3.Location }, Cyclic = true }}},
      ["USSR Defend 4"] = { { Function = ScriptFn_MovementPath, ArgumentTable = {Path = { waypoint4.Location }, Cyclic = true }}},
      ["USSR Defend 99"] = { { Function = ScriptFn_MovementPath, ArgumentTable = {Path = { waypoint99.Location }, Cyclic = true }}},
      ["USSR Patrol 9-26"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = { waypoint9.Location, waypoint26.Location }, WaitForGroup = true, Cyclic = true }}},      
      ["USSR Attack Slot 1"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
      ["USSR Attack Slot 2"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
      ["USSR Attack Slot 3"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
      ["USSR Attack Slot 4"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
      ["USSR Air Attack Slot 1"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(DirectRoutes) }}},
      ["USSR Air Attack Slot 2"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(DirectRoutes) }}},
      --["USSR Attack Slot 5"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
      --["USSR Attack Slot 6"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
    }
  end
end





