-- Collection of functions for governing AI economy --

GiverThreshold = 2500  -- money above this will be given towards other players
TakerThreshold = 1500  -- the money to fill
TransferTrickle = 2 -- the money to transfer every tick
TransferParties = { }
TransferText = { }


function AddMoney (cty, money) -- use negative numbers for expenses, returns false if not enough money
  --if bdebug then UserInterface.SetMissionText("AddMoney() called at tick "..missiontick, MissionPlayer.Color) end  
  
	local totalcash = cty.Cash + cty.Resources
	if totalcash + money < 0 then
		return false
	end
	
	-- deduct from Resources, add to Cash
  if money < 0 then
    if cty.Resources + money < 0 then
      cty.Resources = 0
      cty.Cash = cty.Cash + money + cty.Resources 
    else
      cty.Resources = cty.Resources + money
    end
  else
    cty.Cash = cty.Cash + money
  end
	return true
end

function TransferMoneyManager ()
  if bdebug then UserInterface.SetMissionText("TransferMoneyManager() called at tick "..missiontick, MissionPlayer.Color) end  

	Utils.Do(AIHouses, function(h) TransferText[h.Name] = "" end) -- Refresh text
	TransferText[player.Name] = ""
	
	TransferParties = 
	{
		--{ giver = pl_ussr2, taker = pl_ussr },
	}
	
	Utils.Do(TransferParties, function(tp)
		-- player wait until he has obtained funds from base	
		if tp.giver.Cash + tp.giver.Resources > GiverThreshold and tp.taker.Cash + tp.taker.Resources < TakerThreshold then
			TransferMoney(tp.giver, tp.taker, TransferTrickle)
		end
	end)
	
end

function TransferMoney (giver, taker, money) -- 
  --if bdebug then UserInterface.SetMissionText("TransferMoney() called at tick "..missiontick, MissionPlayer.Color) end  

	-- take money from giver
	if giver.Resources - money < 0 then
		giver.Resources = 0
		giver.Cash = giver.Cash - money + giver.Resources 
	else
		giver.Resources = giver.Resources - money
	end
	
	-- give money to taker
	if taker.Resources + money < 0 then
		taker.Resources = 0
		taker.Cash = taker.Cash + money + taker.Resources 
	else
		taker.Resources = taker.Resources + money
	end	

	TransferText[giver.Name] = "Transferring money to ".. taker.Name
	TransferText[taker.Name] = "Receiving money from ".. giver.Name
	
end

