
-- function to return a rectangular array of cells
function CPosRectangleArray (left, top, right, bottom)
  local cposarray = { }
  for i = left, right do
    for j = top, bottom  do
      table.insert (cposarray, CPos.New(i,j))
    end
  end
  return cposarray
end

--Cell Triggers
OreFieldNorthEntrance = { CPos.New(24, 75), CPos.New(25, 75), CPos.New(26, 75), CPos.New(27, 75), 
                          CPos.New(24, 76), CPos.New(25, 76), CPos.New(26, 76), CPos.New(27, 76), 
                          CPos.New(36, 72), CPos.New(37, 72), CPos.New(38, 72), CPos.New(39, 72), 
                          CPos.New(37, 72), CPos.New(37, 73), CPos.New(38, 73), CPos.New(39, 73)}
OreFieldNorthEntranceSwitch = true

PlayerNorthEntrance = CPosRectangleArray(26, 81, 31, 82)
PlayerNorthEntranceSwitch = true

PlayerEastEntrance = CPosRectangleArray(46, 96, 47, 100)
PlayerEastEntranceSwitch = true

OreFieldEastEntrance = CPosRectangleArray( 65, 81, 66, 103) 
OreFieldEastEntranceSwitch = true


function PrepareReinforcements()
  UnitReinforcements = {}
  UnitReinforcements[MissionPlayer.Name] = {
    --{ Units = { }, Spawn = { } , Path = { } },
    { Units = { "mcv", "2tnk", "2tnk", "2tnk", "2tnk" }, Spawn = { waypoint1.Location } , Path = { waypoint28.Location } },
  }

  UnitReinforcements["USSR"] = {
    -- Player probe North
    { Units = { "e1", "e1", "e2" }, Spawn = { Actor290.Location + CVec.New(0,1) } , Path = { waypoint0.Location, waypoint16.Location, waypoint5.Location, waypoint6.Location } },
    -- Player probe East
    { Units = { "e1", "e1", "e2" }, Spawn = { Actor290.Location + CVec.New(0,1) } , Path = { waypoint39.Location, waypoint35.Location, waypoint3.Location } },
    -- Harass ore field N
    { Units = { "e2", "e2", "e2", "dog", "3tnk" }, Spawn = { waypoint30.Location } , Path = { waypoint7.Location, waypoint6.Location } },
    { Units = { "4tnk" }, Spawn = { waypoint30.Location } , Path = { waypoint7.Location, waypoint6.Location } },  
    -- Patrol ore field E
    { Units = { "e1", "e1", "e1", "e1", "4tnk" }, Spawn = { waypoint29.Location } , Path = { waypoint38.Location, waypoint12.Location, waypoint37.Location, waypoint9.Location } },
    { Units = { "3tnk", "3tnk", "e2", "e2", "e2" }, Spawn = { waypoint29.Location } , Path = { waypoint38.Location, waypoint12.Location, waypoint37.Location, waypoint9.Location } },
    { Units = { "ftrk", "ftrk", "v2rl", "e4", "e4" }, Spawn = { waypoint29.Location } , Path = { waypoint38.Location, waypoint12.Location, waypoint37.Location, waypoint9.Location } },
    
    -- Attack Routes  
    { Units = { "ftrk", "ftrk", "e1", "e1", "e1" }, Spawn = { waypoint29.Location } , Path = { waypoint34.Location, waypoint35.Location, waypoint3.Location, waypoint28.Location } },
    { Units = { "3tnk", "e2", "e2", "v2rl" }, Spawn = { waypoint29.Location } , Path = { waypoint34.Location, waypoint37.Location, waypoint3.Location, waypoint28.Location } },
    
    { Units = { "4tnk" }, Spawn = { waypoint29.Location } , Path = { waypoint34.Location, waypoint37.Location, waypoint3.Location, waypoint28.Location } },
    
    { Units = { "e4", "e4", "e4", "e4", "e4", "e4" }, Spawn = { waypoint29.Location } , Path = { waypoint34.Location, waypoint35.Location, waypoint3.Location, waypoint28.Location } },
    { Units = { "3tnk", "3tnk", "v2rl", "v2rl", "v2rl", "v2rl" }, Spawn = { waypoint29.Location } , Path = { waypoint34.Location, waypoint35.Location, waypoint3.Location, waypoint28.Location } },
  }
  
  UnitReinforcements["BadGuy"] = {
    { Units = { "truk" }, Spawn = { waypoint17.Location } , Path = { waypoint8.Location, waypoint16.Location, waypoint35.Location, waypoint37.Location, waypoint38.Location, waypoint17.Location} },  
  }

  TransportReinforcements = { }

  -- Player reinforcements
  Trigger.AfterDelay(DateTime.Seconds(1), function() CreateUnitReinforcements(MissionPlayer, 1) end)
  Trigger.AfterDelay(DateTime.Seconds(1), function() CreateUnitReinforcements(Player.GetPlayer("BadGuy"), 1, 3, 302, true) end)

  -- Player N entrance
  Trigger.OnEnteredFootprint(PlayerNorthEntrance, function(actor)
    if actor.Owner == MissionPlayer and PlayerNorthEntranceSwitch then
      if not Actor290.IsDead then
        Trigger.AfterDelay(DateTime.Seconds(1), function() CreateUnitReinforcements(Player.GetPlayer("USSR"), 1, 3, 302, true, true) end)
      end
      PlayerNorthEntranceSwitch = false
    end
  end)

  -- Player E entrance
  Trigger.OnEnteredFootprint(PlayerEastEntrance, function(actor)
    if actor.Owner == MissionPlayer and PlayerEastEntranceSwitch then
      if not Actor290.IsDead then
        Trigger.AfterDelay(DateTime.Seconds(1), function() CreateUnitReinforcements(Player.GetPlayer("USSR"), 2, 3, 302, true, true) end)
      end
      PlayerEastEntranceSwitch = false
    end
  end)
 
  -- North Ore field
  Trigger.OnEnteredFootprint(OreFieldNorthEntrance, function(actor)
    if actor.Owner == MissionPlayer and OreFieldNorthEntranceSwitch then
      Trigger.AfterDelay(DateTime.Seconds(1), function() CreateUnitReinforcements(Player.GetPlayer("USSR"), 3, 3, 302, true, true) end)
      if Map.LobbyOption("difficulty") == "Mental" then 
        Trigger.AfterDelay(DateTime.Seconds(5), function() CreateUnitReinforcements(Player.GetPlayer("USSR"), 4, 3, 302, false) end) 
      end      
      OreFieldNorthEntranceSwitch = false
    end
  end) 
  
  -- East Ore field
  Trigger.OnEnteredFootprint(OreFieldEastEntrance, function(actor)
    if actor.Owner == MissionPlayer and OreFieldEastEntranceSwitch then
      Trigger.AfterDelay(DateTime.Seconds(1), function() CreateUnitReinforcements(Player.GetPlayer("USSR"), 5, 3, 302, true, true) end)
      if Map.LobbyOption("difficulty") ~= "Easy" then 
        Trigger.AfterDelay(DateTime.Seconds(5), function() CreateUnitReinforcements(Player.GetPlayer("USSR"), 6, 3, 302, false) end) 
      end 
      
      if Map.LobbyOption("difficulty") == "Mental" then 
        Trigger.AfterDelay(DateTime.Seconds(15), function() CreateUnitReinforcements(Player.GetPlayer("USSR"), 7, 3, 302, false) end) 
      end     
      OreFieldEastEntranceSwitch = false
    end
  end) 
  
  Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(150,300)), CreateV2againstTrees) 
  
  PrepareReinforcementsRepeat()
end
  
  
function PrepareReinforcementsRepeat ()
  
  Trigger.AfterDelay(DateTime.Seconds(215), function() CreateUnitReinforcements(Player.GetPlayer("USSR"), 8, 3, 302, true) end)
  Trigger.AfterDelay(DateTime.Seconds(230), function() CreateUnitReinforcements(Player.GetPlayer("USSR"), 9, 3, 302, true) end)

  if Map.LobbyOption("difficulty") == "Mental" then
    Trigger.AfterDelay(DateTime.Seconds(265), function() CreateUnitReinforcements(Player.GetPlayer("USSR"), 11, 3, 302, true) end)
    Trigger.AfterDelay(DateTime.Seconds(260), function() CreateUnitReinforcements(Player.GetPlayer("USSR"), 12, 3, 302, true) end)
  end
  
  if Map.LobbyOption("difficulty") ~= "Easy" then
    Trigger.AfterDelay(DateTime.Seconds(240), function() CreateUnitReinforcements(Player.GetPlayer("USSR"), 10, 3, 302, true) end)
  end

  Trigger.AfterDelay(DateTime.Seconds(Utils.RandomInteger(240,500)), PrepareReinforcementsRepeat)
end



function CreateV2againstTrees() 
	Media.Debug("Creating V2 against Trees Reinforcements")
  local units = Reinforcements.Reinforce( Player.GetPlayer("USSR"), 
                                          { "v2rl" }, 
                                          { waypoint29.Location } )
                                        
  Utils.Do(units, function(unit)
    unit.Move(waypoint4.Location)
    unit.Attack(Actor509,true,true)
    --unit.Guard(Actor377)
  end)                                      
end

function CreateUnitReinforcements (player, i, closeenough, delay, cyclic, waitforgroup) -- waitforgroup 

  if closeenough == nil then closeenough = 3 end
  if delay == nil then delay = 25 end
  if cyclic == nil then cyclic = false end

	Media.Debug("Creating "..player.Name.." Reinforcements #" .. i)
  if player == MissionPlayer then Media.PlaySpeechNotification(player, "ReinforcementsArrived") end

	local units = Reinforcements.Reinforce( player, 
                                          UnitReinforcements[player.Name][i].Units, 
                                          UnitReinforcements[player.Name][i].Spawn)
   
	Utils.Do(units, function(unit)
    if waitforgroup then
      GroundAttack(unit, UnitReinforcements[player.Name][i].Path, closeenough, delay, cyclic, units)
    else
      GroundAttack(unit, UnitReinforcements[player.Name][i].Path, closeenough, delay, cyclic)
    end
  end)
end


function CreateTransportReinforcements (player, i, closeenough, delay, cyclic, waitforgroup)
  if bdebug then UserInterface.SetMissionText("User CreateTransportReinforcements( player = ".. player.Name ..", i = " ..i..") at "..missiontick, MissionPlayer.Color) end

  if closeenough == nil then closeenough = 3 end
  if delay == nil then delay = 25 end
  if cyclic == nil then cyclic = false end

	Media.Debug("Creating "..player.Name.." Transport Reinforcements #" .. i)
  if player == MissionPlayer then Media.PlaySpeechNotification(player, "ReinforcementsArrived") end
  
	local units = Reinforcements.ReinforceWithTransport(player, 
                                                      TransportReinforcements[player.Name][i].Transport, 
                                                      TransportReinforcements[player.Name][i].Units, 
                                                      TransportReinforcements[player.Name][i].Spawn,
                                                      { TransportReinforcements[player.Name][i].Spawn[1] })[2]
  
	Utils.Do(units, function(unit)
    if waitforgroup then
      GroundAttack(unit, TransportReinforcements[player.Name][i].Path, closeenough, delay, cyclic, units)
    else
      GroundAttack(unit, TransportReinforcements[player.Name][i].Path, closeenough, delay, cyclic)
    end
  end)
end

