-- Master Table for building and unit lists
---- Production
------ Infantry / Units / Ships / Aircraft
---------- type                 = the actortype
---------- factory              = the actortype of factory producing it, defaults to nil
---------- prereq               = array of actortypes of prerequisites needed, defaults to nil
---------- side                 = array of sides that will produce it. Can accept { "allies" }, "soviets", and individual Player.Names, defaults to nil
---------- weight               = production weight given in the production selection. Defaults to 1
---------- cost                 = cost override. Defaults to Actor.Cost(type)
---------- buildtime            = buildtime override. Defaults to Actor.BuildTime(type)
---------- 
---------- anti-infantry        = To be implemented
---------- anti-armor           = To be implemented
---------- anti-structure       = To be implemented
----------
------ Structures / Defenses
---------- type                 = the actortype
---------- priority             = a category for the struture for AI consideration. Defaults to nil
---------- power                = Power provision (written here since LUA cannot extract this value from the Game). Defaults to nil (taken to be 0)
---------- prereq               = array of actortypes of prerequisites needed, defaults to nil
---------- side                 = array of sides that will produce it. Can accept { "allies" }, "soviets", and individual Player.Names, defaults to nil
---------- cost                 = cost override. Defaults to Actor.Cost(type)
---------- buildtime            = buildtime override. Defaults to Actor.BuildTime(type)
---------- 
---------- anti-infantry        = To be implemented
---------- anti-armor           = To be implemented
---------- anti-structure       = To be implemented
----------
---- Names
---------- type = name          Use GetName(type) to derive the name from the MasterTable


MasterTable = { }
MasterTable["Production"] = { }

GenerateMasterTable = function()
  MasterTable.Production["Infantry"] =
  {
    -- Allied units
    { type = "e1", factory = "tent", prereq = {}, side = { "allies" }, weight = 6 }, 
    { type = "e3", factory = "tent", prereq = {}, side = { "allies" }, weight = 4 }, 
    { type = "medi", factory = "tent", prereq = {}, side = { "allies" }, weight = 1 },   
    -- Soviet units
    { type = "e1", factory = "barr", prereq = {}, side = { "soviet" }, weight = 6 }, 
    { type = "e2", factory = "barr", prereq = {}, side = { "soviet" }, weight = 3 }, 
    { type = "e3", factory = "barr", prereq = {}, side = { "soviet" }, weight = 3 }, 
    { type = "e4", factory = "barr", prereq = {"dome"}, side = { "soviet" }, weight = 2 }, 
    --{ type = "shok", factory = "barr", prereq = {"tsla"}, side = { "soviet" }, weight = 1 }, 
    { type = "dog", factory = "kenn", prereq = {}, side = { "soviet" }, weight = 1 }, 
  }

  MasterTable.Production["Units"] =
  {
    -- Allied units
    --{ type = "harv", factory = "weap", prereq = {"proc"}, side = { "allies" }, weight = 0 }, 
    { type = "jeep", factory = "weap", prereq = {}, side = { "allies" }, weight = 3 }, 
    { type = "arty", factory = "weap", prereq = {"dome"}, side = { "allies" }, weight = 3 }, 
    { type = "1tnk.german", factory = "weap", prereq = {}, side = { "allies" }, weight = 3 }, 
    { type = "2tnk.german", factory = "weap", prereq = {"fix"}, side = { "allies" }, weight = 4 }, 
      -- Soviet units
    --{ type = "harv", factory = "weap", prereq = {"proc"}, side = { "soviet" }, weight = 0 }, 
    { type = "ftrk", factory = "weap", prereq = {}, side = { "soviet" }, weight = 2 }, 
    { type = "3tnk", factory = "weap", prereq = {"fix"}, side = { "soviet" }, weight = 2 },
    { type = "v2rl", factory = "weap", prereq = {"dome"}, side = { "soviet" }, weight = 2 },
    --{ type = "ttnk", factory = "weap", prereq = {"stek","tsla"}, side = { "soviet" }, weight = 3 },
    { type = "4tnk", factory = "weap", prereq = {"stek","fix"}, side = { "soviet" }, weight = 3 },
  }

  MasterTable.Production["Aircraft"] =
  {
    -- Allied units
    { type = "hind", factory = "hpad", prereq = {}, side = { "allies" }, weight = 2 }, 
    { type = "heli", factory = "hpad", prereq = {"atek"}, side = { "allies" }, weight = 1 }, 
    -- Soviet units
    { type = "yak", factory = "afld", prereq = {}, side = { "soviet" }, weight = 2 },  
    { type = "mig", factory = "afld", prereq = {}, side = { "soviet" }, weight = 1 }  
  }

  MasterTable.Production["Ships"] =
  {
  }

  MasterTable.Production["Structures"] = 
  {
    -- Unbuildable
    { type = "fact", priority = "production", power = 0, prereq = {"nobuild"}, side = { "allies", "soviet" } },
    
    -- Common structures
    { type = "powr", priority = "power", power = 100, prereq = {}, side = { "allies", "soviet" } },
    { type = "proc", priority = "economy", power = -30, prereq = {"powr"}, side = { "allies", "soviet" } },
    { type = "weap", priority = "production", power = -40, prereq = {"proc"}, side = { "allies", "soviet" } },
    { type = "silo", priority = "", power = -10, prereq = {}, side = { "allies", "soviet" } },
    { type = "fix", priority = "tech", power = -40, prereq = {"weap"}, side = { "allies", "soviet" } },
    { type = "dome", priority = "tech", power = -40, prereq = {"proc"}, side = { "allies", "soviet" } },
    { type = "apwr", priority = "power", power = 200, prereq = {"dome"}, side = { "allies", "soviet" } },
   
    -- Allied structures
    { type = "tent", priority = "production", power = -30, prereq = {}, side = { "allies" } },
    { type = "hpad", priority = "production", power = -10, prereq = {"tent"}, side = { "allies" } },
    { type = "atek", priority = "tech", power = -200, prereq = {"dome"}, side = { "allies" } },
    { type = "syrd", priority = "production", power = -30, prereq = {"powr"}, side = { "allies" } },

    -- Soviet structures
    { type = "powr", priority = "power", power = 100, prereq = {}, side = { "soviet" } },
    { type = "barr", priority = "production", power = -30, prereq = {}, side = { "soviet" } },
    { type = "kenn", priority = "production", power = 0, prereq = {}, side = { "soviet" } },
    { type = "proc", priority = "economy", power = -40, prereq = {"powr"}, side = { "soviet" } },
    { type = "weap", priority = "production", power = -40, prereq = {"proc"}, side = { "soviet" } },
    { type = "afld", priority = "production", power = -30, prereq = {"dome"}, side = { "soviet" } },
    { type = "stek", priority = "tech", power = -40, prereq = {"dome"}, side = { "soviet" } },
    { type = "spen", priority = "production", power = -30, prereq = {"powr"}, side = { "soviet" } }
  }

  MasterTable.Production["Defenses"] = 
  {
    -- Unbuildable
    { type = "pdox", priority = "tech", power = -200, prereq = {"nobuild"}, side = { "allies" } },
    { type = "iron", priority = "tech", power = -200, prereq = {"nobuild"}, side = { "soviet" } },
    { type = "gap", priority = "", power = -60, prereq = {"nobuild"}, side = { "allies" } },
    { type = "mslo", priority = "tech", power = -150, prereq = {"nobuild"}, side = { "allies", "soviet" } },
    
    -- Allied structures
    { type = "pbox", priority = "defence", power = -15, prereq = {"tent"}, side = { "allies" } },
    { type = "gun", priority = "defence", power = -40, prereq = {"tent"}, side = { "allies" } },
    { type = "hbox", priority = "defence", power = -15, prereq = {"tent"}, side = { "allies" } },
    { type = "agun", priority = "defence", power = -60, prereq = {"tent"}, side = { "allies" } },
    
    -- Soviet structures
    { type = "ftur", priority = "defence", power = -30, prereq = {"barr"}, side = { "soviet" } },
    { type = "tsla", priority = "defence", power = -100, prereq = {"weap"}, side = { "soviet" } },
    { type = "sam", priority = "defence", power = -100, prereq = {"weap"}, side = { "soviet" } }
  }

  -- For queue per factory 
  MasterTable.Production.ConstructionYard = { } 
  for k,v in pairs(MasterTable.Production.Structures) do MasterTable.Production.ConstructionYard[k] = v end
  for k,v in pairs(MasterTable.Production.Defenses) do MasterTable.Production.ConstructionYard[k] = v end
  --for k,v in pairs(MasterTable.Production.Infantry) do if v.factory == "barr" or v.factory == "tent" then MasterTable.Production.Barracks[k] = v end end
end

function GetTabbedProductionfromMasterList (t, s, tab) -- t = building type, s = player or side name
  for _,v in ipairs(MasterTable.Production[tab]) do
    local sd = Set (v.side)
    if v.type == t and sd[side] == s then
      v.tab = "Infantry"
      return v
    end
  end
  
  -- s is not a Faction name, refer to the Faction
  if s ~= "allies" and s ~= "soviet" then 
    return GetTabbedProductionfromMasterList(t, s.Faction, tab)
  end
  
  return nil
end

function GetInfantryfromMasterList (t, s) -- t = building type, s = player or side name
  for _,v in ipairs(MasterTable.Production.Infantry) do
    local sd = Set (v.side)
    if v.type == t and sd[side] == s then
      v.tab = "Infantry"
      return v
    end
  end
  
  -- s is not a Faction name, refer to the Faction
  if s ~= "allies" and s ~= "soviet" then 
    return GetInfantryfromMasterList(t, s.Faction)
  end
  
  return nil
end

function GetUnitsfromMasterList (t, s) -- t = building type, s = player or side name
  for _,v in ipairs(MasterTable.Production.Units) do
    local sd = Set (v.side)
    if v.type == t and sd[side] == s then
      v.tab = "Units"
      return v
    end
  end
  
  -- s is not a Faction name, refer to the Faction
  if s ~= "allies" and s ~= "soviet" then 
    return GetUnitsfromMasterList(t, s.Faction)
  end
  
  return nil
end

function GetShipsfromMasterList (t, s) -- t = building type, s = player or side name
  for _,v in ipairs(MasterTable.Production.Ships) do
    local sd = Set (v.side)
    if v.type == t and sd[side] == s then
      v.tab = "Ships"
      return v
    end
  end
  
  -- s is not a Faction name, refer to the Faction
  if s ~= "allies" and s ~= "soviet" then 
    return GetShipsfromMasterList(t, s.Faction)
  end
  
  return nil
end

function GetAircraftfromMasterList (t, s) -- t = building type, s = player or side name
  for _,v in ipairs(MasterTable.Production.Aircraft) do
    local sd = Set (v.side)
    if v.type == t and sd[side] == s then
      v.tab = "Aircraft"
      return v
    end
  end
  
  -- s is not a Faction name, refer to the Faction
  if s ~= "allies" and s ~= "soviet" then 
    return GetAircraftfromMasterList(t, s.Faction)
  end
  
  return nil
end

function GetBuildingfromMasterList (t, s) -- t = building type, s = player or side name
  return GetStructuresfromMasterList(t, s) or GetDefensesfromMasterList(t, s)
end

function GetStructuresfromMasterList (t, s) -- t = building type, s = player or side name
	for _,v in ipairs(MasterTable.Production.Structures) do
    local sd = Set(v.side)
		if v.type == t and sd[s] then
      v.tab = "Structures"
			return v
		end
	end
  
  -- s is not a Faction name, refer to the Faction
  if s ~= "allies" and s ~= "soviet" then 
    return GetStructuresfromMasterList(t, s.Faction)
  end
  
  return nil
end


function GetDefensesfromMasterList (t, s) -- t = building type, s = player or side name
  for _,v in ipairs(MasterTable.Production.Defenses) do
    local sd = Set(v.side)
		if v.type == t and sd[s] then
      v.tab = "Defenses"
			return v
		end
	end
  
  -- s is not a Faction name, refer to the Faction
  if s ~= "allies" and s ~= "soviet" then 
    return GetDefensesfromMasterList(t, s.Faction)
  end
  
  return nil
end

MasterTable["Names"] = 
{
	-- Tanks
	["1tnk"] = "Light Tank",
	["2tnk"] = "Medium Tank",
	["1tnk.german"] = "German Light Tank", -- added for the mission
	["2tnk.german"] = "German Medium Tank", -- added for the mission
	["3tnk"] = "Heavy Tank",
	["4tnk"] = "Mammoth Tank",
	["apc"]  = "APC",
	["v2rl"] = "V2 Rocket Launcher",
	["arty"] = "Artillery",
	["jeep"] = "Ranger",
	["harv"] = "Ore Truck",
	["mcv"] = "Mobile Construction Vehicle",
	["mnly.ap"] = "Minelayer",
	["mnly.at"] = "Minelayer",
	["truk"] = "Supply Truck",
	["dtrk"] = "Demolition Truck",
	["mgg"] = "Mobile Gap Generator",
	["mrj"] = "Mobile Radar Jammer",
	["ttnk"] = "Tesla Tank",
	["ftrk"] = "Mobile Flak",
	["ctnk"] = "Chrono Tank",
	["qtnk"] = "MAD Tank",
	["stnk"] = "Phase Transport",

	-- Infantry
	["e1"] = "Rifle Infantry",
	["e2"] = "Grenadier",
	["e3"] = "Rocket Soldier",
	["e4"] = "Flamethrower",
	["e5"] = "",
	["e6"] = "",
	["e7"] = "Agent Tanya",
  ["medi"] = "Medic",
	["shok"] = "Shock Trooper",
	["dog"] = "Dog",

	-- Ships
	["pt"] = "Gunboat",
	["dd"] = "Destroyer",
	["sub"] = "Submarine",
	["ca"] = "Cruiser",
	["lst"] = "Naval Transport",
	
	-- Aircraft
	["yak"] = "Yak Attack Plane",
	["mig"] = "MIG Fighter",
	["tran"] = "Transport Helicopter",
	["hind"] = "Hind",
	["heli"] = "Longbow",
	
	-- Structures
	["fact"] = "Construction Yard",
	["powr"] = "Power Plant",
	["apwr"] = "Advanced Power Plant",
	["proc"] = "Ore Refinery",
	["barr"] = "Soviet Barracks",
	["tent"] = "Allied Barracks",
	["weap"] = "War Factory",
	["fix"] = "Service Depot",
	["dome"] = "Radar Dome",
	["atek"] = "Allied Tech Center",
	["stek"] = "Soviet Tech Center",
	["ftur"] = "Flame Tower",
	["tsla"] = "Tesla Coil",
	["sam"] = "SAM Site",
	["pbox"] = "Pillbox",
	["hbox"] = "Camo Pillbox",
	["gun"] = "Gun Turret",
	["agun"] = "AA Gun",
	["hpad"] = "Helipad",
	["afld"] = "Airfield",
	["kenn"] = "Kennel"

}

-- Gets true name from type
function GetName (stype)
  return MasterTable.Names[stype] or stype
end



