-- generic Lua functions

function Set (list)
  local set = {}
  for _, l in ipairs(list) do set[l] = true end
  return set
end


function RemoveFromList (list, element)	-- returns true if successful
	local i = 1
  local success = false 
  
	while i <= #list do
		if list[i] == element then
			table.remove(list, i)
      success = true
		else
			i = i + 1
		end
	end
  return success
end


function RemoveOnceFromList (list, element)	-- returns true if successful
	local i = 1
	while i <= #list do
		if list[i] == element then
			table.remove(list, i)
      return true
		else
			i = i + 1
		end
	end
  return false
end


function pairsByProperty(t, propertyname)
    local registry = {}

    for k, v in pairs(t) do
      --UserInterface.SetMissionText(v.dist, HSLColor.White)
        table.insert(registry, {k, v.dist})
    end

    table.sort(registry, function(a, b) return a[2] < b[2] end)

    local i = 0

    local iter = function()
        i = i + 1

        if (registry[i] ~= nil) then
            return registry[i][1], t[registry[i][1]]
        end

        return nil
    end

    return iter
end


function clone (t) -- deep-copy a table
    if type(t) ~= "table" then return t end
    --local meta = getmetatable(t)
    local target = {}
    for k, v in pairs(t) do
        if type(v) == "table" then
            target[k] = clone(v)
        else
            target[k] = v
        end
    end
    --setmetatable(target, meta)
    return target
end


function tablelength (t)
  local count = 0
  for _ in pairs(t) do count = count + 1 end
  return count
end


function ConvertToDateTime(n)
-- 1 second = 25 ticks
  if n < 0 then return nil end
  local seconds = math.modf(n / 25) % 60
  local minutes = math.modf(math.modf(n / 25) / 60) % 60
  local hours = math.modf(math.modf(math.modf(n / 25) / 60) / 60) % 60

  if seconds < 10 then seconds = "0"..seconds end
  if hours > 0 then if minutes < 10 then minutes = "0"..minutes end end

  return (hours == 0 and "" or hours..":") .. minutes .. ":" .. seconds
end

