---------------------- GLOBAL OVERRIDES --------------------------------------------
---- To override individual players use the ManualOverride function

------ Player settings -------------------------------------------------------------
  -- InitialCash = the player's initial cash, defaults to 0
  
  -- Bot controls only
  --    BuildTimeMultiplier (default, Structures, Defences, Infantry, Units, Aircraft, Ships), defaults to default, which defaults to 1
  --    CostMultipliers (default, Structures, Defences, Infantry, Units, Aircraft, Ships), defaults to default, which defaults to 1

-- Human players
DefaultInitialCash = 6500

-- Soviet Bots
if Map.LobbyOption("difficulty") == "Hard" then
  SovietBotInitialCash = 10000
  SovietBotBuildTimeMultiplier = { default = 0.9 }
  SovietBotCostMultiplier = { default = 0.9 }
elseif Map.LobbyOption("difficulty") == "Normal" then
  SovietBotInitialCash = 6000
  SovietBotBuildTimeMultiplier = { default = 1 }
  SovietBotCostMultiplier = { default = 1 }
else
  SovietBotInitialCash = 3500
  SovietBotBuildTimeMultiplier = { default = 1 }
  SovietBotCostMultiplier = { default = 1 }
end

------------------------------------------------------------------------------------
------ Base settings ---------------------------------------------------------------
  -- IncludeExistingBuildingsInBaseNodes = whether existing buildings should be included in the base node count
  -- ExcludeExistingBuildingWithStringOverride = (string) if the actor's name contains this string, override to exclude the building from the base node list
  
IncludeExistingBuildingsInBaseNodes = true
InitialBaseNodes = {
  -- id = name of this entry (for debug, or specific selection only)
  -- owner = the player
  -- type = the actor type
  -- pos = position as { x, y } coordinates 

  -- Example
  -- { id = "A01", owner = Houses["Germany"].Player, type = "powr", pos = { x = 10, y = 12} },
}
 
------------------------------------------------------------------------------------
------ AI settings -----------------------------------------------------------------
AIMaintainExcessPower = 101
AIStructureHPRepair = 0.9
AIUnitHPPursuit = 0.9
AIHarvestersPerRefinery = 3
AILowCashThreshold = 10000
AIEmergencyCashThreshold = 2500

if Map.LobbyOption("difficulty") == "Hard" then
  AIHarvestersPerRefinery = 4
  -- Prevent player farming harvester exploit
  Trigger.AfterDelay(DateTime.Minutes(10), function() AIHarvestersPerRefinery = 3 end)
elseif Map.LobbyOption("difficulty") == "Normal" then
  AIHarvestersPerRefinery = 3
else
  AIHarvestersPerRefinery = 2.5
end

PooltoHuntThreshold = { -- Send all units in Pool to the Hunting group if the number of units surpass this threshold
  ["BadGuy"] = 3,
  ["USSR"] = 15,
} 
if Map.LobbyOption("difficulty") == "Normal" then PooltoHuntThreshold["BadGuy"] = 4
elseif Map.LobbyOption("difficulty") == "Hard"  then PooltoHuntThreshold["BadGuy"] = 6
end

GetNextWaypointSet = function(waypoint)
  if waypoint == waypoint0 then return { waypoint16, waypoint16, waypoint6, waypoint4, waypoint8 } end
  if waypoint == waypoint3 then return { waypoint2, waypoint2, waypoint5, waypoint4, waypoint35, waypoint9 } end
  if waypoint == waypoint4 then return { waypoint16, waypoint16, waypoint39 , waypoint35, waypoint2, waypoint2 } end
  if waypoint == waypoint5 then return  { waypoint2, waypoint2, waypoint3, waypoint16, waypoint6 } end
  if waypoint == waypoint6 then return { waypoint7, waypoint5, waypoint16 } end
  if waypoint == waypoint7 then return { waypoint6 } end
  if waypoint == waypoint8 then return  { waypoint39, waypoint0 } end
  if waypoint == waypoint9 then return  { waypoint3, waypoint35, waypoint38, waypoint37 } end
  if waypoint == waypoint10 then return { waypoint38, waypoint35, waypoint39 } end
  if waypoint == waypoint11 then return { waypoint38, waypoint13, waypoint34 } end
  if waypoint == waypoint12 then return { waypoint34, waypoint38, waypoint37 } end
  if waypoint == waypoint13 then return { waypoint11, waypoint34 } end
  if waypoint == waypoint14 then return { waypoint15 } end
  if waypoint == waypoint15 then return { waypoint14 } end
  if waypoint == waypoint16 then return { waypoint0, waypoint4, waypoint5, waypoint5, waypoint6 } end
  if waypoint == waypoint17 then return { waypoint8, waypoint11 } end
  --if waypoint == waypoint18 then return {  } end
  if waypoint == waypoint19 then return { waypoint14, waypoint15, waypoint8, waypoint17 } end --FCOM location
  if waypoint == waypoint2 then return { waypoint5, waypoint3, waypoint4, waypoint16 } end
  if waypoint == waypoint34 then return { waypoint11, waypoint13, waypoint12 } end
  if waypoint == waypoint35 then return { waypoint4, waypoint10, waypoint3, waypoint3, waypoint9 } end
  if waypoint == waypoint37 then return { waypoint38, waypoint9, waypoint12 } end
  if waypoint == waypoint38 then return { waypoint11, waypoint12, waypoint10, waypoint9, waypoint37 } end
  if waypoint == waypoint39 then return { waypoint4, waypoint4, waypoint35, waypoint10, waypoint8 } end
  return Waypoints
end

AIHuntInitialWaypoints = {
  ["USSR"] = {waypoint17, waypoint8, waypoint11},
  ["BadGuy"] = {waypoint17, waypoint8},
}


SovietTeam1 = { "e4", "e4", "e4", "e4", "e4" }
SovietTeam2 = { "3tnk", "3tnk", "v2rl" }
SovietTeam3 = { "e1", "e1", "e2", "e2", "e2", "3tnk" }
SovietTeam4 = { "e4", "e4", "e4", "e4" }
SovietTeam5 = { "e2", "e2", "e2", "e2", "e2", "e2", "e4", "e4" }
SovietTeam6 = { "e1", "e1", "e2", "e2", "e2" } 
SovietTeam7 = { "dog", "dog" } 
SovietTeam8 = { "e2", "e2", "e2", "e4", "e4" } 
SovietTeam9 = { "e2", "e2", "e2", "e1", "e1" } 
SovietTeam10 = { "dog", "dog", "dog", "e1", "e1" } 
SovietTeam11 = { "ftrk", "ftrk" }
SovietTeam12 = { "e1", "e1", "e1", "e2", "e2", "ftrk" }
SovietTeam13 = { "e4", "e4", "ftrk", "ftrk" }
SovietTeam14 = { "3tnk", "ftrk", "ftrk" }
SovietTeam15 = { "v2rl", "v2rl", "ftrk", "ftrk" }
SovietTeam16 = { "3tnk", "3tnk", "3tnk", "3tnk" }
SovietTeam17 = { "e1", "e1", "e1", "e1", "v2rl", "v2rl" }
SovietTeam18 = { "v2rl", "v2rl", "v2rl" }
SovietTeam19 = { "4tnk" }
SovietTeam20 = { "4tnk", "3tnk", "3tnk" }

SovietTeamGroups = { SovietTeam1, SovietTeam2, SovietTeam3, SovietTeam4, SovietTeam5, SovietTeam6, SovietTeam7, SovietTeam8, SovietTeam9, SovietTeam10, SovietTeam11, SovietTeam12, SovietTeam13, SovietTeam14, SovietTeam15, SovietTeam16, SovietTeam17, SovietTeam18, SovietTeam19, SovietTeam20 }

BadGuyTeam1 = { "yak" }
BadGuyTeam2 = { "yak", "yak" }
BadGuyTeam3 = { "yak", "yak", "yak" }
BadGuyTeam4 = { "mig" }
BadGuyTeam5 = { "mig", "mig" }
BadGuyTeam6 = { "mig", "yak" }
BadGuyTeam7 = { "mig", "yak", "yak" }

BadGuyTeamGroups = { BadGuyTeam1, BadGuyTeam2, BadGuyTeam3, BadGuyTeam4, BadGuyTeam5, BadGuyTeam6, BadGuyTeam7 }


SovietRoute1 = {
  waypoint8.Location, 
  waypoint0.Location, 
  waypoint16.Location, 
  waypoint5.Location, 
  waypoint2.Location 
}

SovietRoute2 = {
  waypoint39.Location, 
  waypoint4.Location, 
  waypoint16.Location, 
  waypoint5.Location, 
  waypoint2.Location 
}

SovietRoute3 = {
  waypoint39.Location, 
  waypoint4.Location, 
  waypoint2.Location 
}

SovietRoute4 = {
  waypoint8.Location, 
  waypoint39.Location, 
  waypoint35.Location, 
  waypoint3.Location, 
  waypoint2.Location 
}

SovietRoute5 = {
  waypoint11.Location, 
  waypoint38.Location, 
  waypoint10.Location, 
  waypoint3.Location, 
  waypoint2.Location 
}

SovietRoute6 = {
  waypoint11.Location, 
  waypoint34.Location, 
  waypoint37.Location, 
  waypoint9.Location, 
  waypoint2.Location 
}

SovietRoute7 = {
  waypoint13.Location, 
  waypoint12.Location, 
  waypoint10.Location, 
  waypoint4.Location, 
  waypoint2.Location 
}

SovietRoute8 = {
  waypoint11.Location, 
  waypoint12.Location, 
  waypoint37.Location, 
  waypoint3.Location, 
  waypoint2.Location 
}

SovietRoute9 = {
  waypoint8.Location, 
  waypoint39.Location, 
  waypoint38.Location, 
  waypoint9.Location, 
  waypoint2.Location 
}

SovietRoute10 = {
  waypoint0.Location, 
  waypoint6.Location, 
  waypoint5.Location, 
  waypoint3.Location, 
  waypoint2.Location 
}

-- double weightage for the main routes
SovietRoutes = { SovietRoute1, SovietRoute2, SovietRoute3, SovietRoute4, SovietRoute5, SovietRoute6, SovietRoute7, SovietRoute8, SovietRoute9, SovietRoute10 }


Waypoints = {
  waypoint0,
  waypoint3,
  waypoint4,
  waypoint5,
  waypoint6,
  waypoint7,
  waypoint8,
  waypoint9,
  waypoint10,
  waypoint11,
  waypoint12,
  waypoint13,
  waypoint16,
  waypoint17,
  waypoint2,
  waypoint34,
  waypoint35,
  waypoint37,
  waypoint38,
  waypoint39,
}  



function PostSetupManualOverride ()
  if bdebug then UserInterface.SetMissionText("PostSetupManualOverride() called at tick "..missiontick, MissionPlayer.Color) end
  
  missionDisplayPlayer = MissionPlayer -- Player.GetPlayer("USSR")
  Player.GetPlayer("BadGuy").Cash = Player.GetPlayer("BadGuy").Cash + AILowCashThreshold

  -- Trees destruction
  Trigger.OnKilled( Actor509, function(_, attacker)
    Actor239.Destroy() 
    Actor240.Destroy() 
  end)
end



AIActivated = false
function TickManualOverride()
  
  if Player.GetPlayer("USSR").UnitsLost >= 1 or Player.GetPlayer("USSR").UnitsKilled >= 1 then AIActivated = true end
  
  if MissionTime == DateTime.Minutes(10) then Media.PlaySpeechNotification(MissionPlayer, "TenMinutesRemaining")
  elseif MissionTime == DateTime.Minutes(5) then Media.PlaySpeechNotification(MissionPlayer, "WarningFiveMinutesRemaining")
  elseif MissionTime == DateTime.Minutes(4) then Media.PlaySpeechNotification(MissionPlayer, "WarningFourMinutesRemaining")
  elseif MissionTime == DateTime.Minutes(3) then Media.PlaySpeechNotification(MissionPlayer, "WarningThreeMinutesRemaining")
  elseif MissionTime == DateTime.Minutes(2) then Media.PlaySpeechNotification(MissionPlayer, "WarningTwoMinutesRemaining")
  elseif MissionTime == DateTime.Minutes(1) then Media.PlaySpeechNotification(MissionPlayer, "WarningOneMinuteRemaining")
  end
  
  -- Mission Time
  NukeChargeTime = NukeChargeTime - 1
  MissionTime = NukeArrivalTime
  
  if NukeChargeTime == 0 then NukeLaunch = true end 
  if not NukeLaunch and Player.GetPlayer("USSR").BuildingsLost + Player.GetPlayer("BadGuy").BuildingsLost >= 15 then NukeLaunch = true end 
  
  if NukeLaunch then
    if not NukeAlreadyLaunched then LaunchNuke() end
    NukeArrivalTime = NukeArrivalTime - 1
    if pObjInfiltrateFCOM and NukeArrivalTime > 0 then missionObjectiveFlavourText[pObjInfiltrateFCOM] = ConvertToDateTime(NukeArrivalTime) end
  end
  if NukeArrivalTime == 0 then NukeFailed() end
  
  
  

  --AI cheats! Shame on me!
	--Utils.Do(HouseGroups.Bots, function(h)
	--	if h.Resources >= h.ResourceCapacity * 0.75 then
	--		h.Cash = h.Cash + h.Resources - h.ResourceCapacity * 0.25
	--		h.Resources = h.ResourceCapacity * 0.25
	--	end
  if AIActivated then
    if Map.LobbyOption("difficulty") == "Hard" then
      if missiontick % 4 == 0 then Player.GetPlayer("BadGuy").Cash = Player.GetPlayer("BadGuy").Cash + 3 end
    elseif Map.LobbyOption("difficulty") == "Normal" then
      if missiontick % 2 == 0 then Player.GetPlayer("BadGuy").Cash = Player.GetPlayer("BadGuy").Cash + 1 end      
    else
      if missiontick % 3 == 0 then Player.GetPlayer("BadGuy").Cash = Player.GetPlayer("BadGuy").Cash + 1 end      
    end 
  end
	--end)
  ------------------------------------------------------------------------------------
  ------ AI Team settings ------------------------------------------------------------
  ----------- Define all actor groups and their routes here
  ----------- IMPORTANT: References to lua functions should be placed in PostSetupManualOverride and not as part of initializing global variables.

  -- Teams will be declared by AITeams[player.Name][groupname], filled by AIActorGroups over the course of the game, and governed by the AI in AIGroupStatus to perform functions in AIFunctions
  ------ Groups in ActorGroups[player.Name]:
  ----------- 
  ----------- [Reserved names, do not touch]
  ----------- Pool                Pool for newly-built and unassigned units. Game will ignore any 'Pool' groupname
  ----------- Defender            Used to counter threats against the enemy when a structure / harvester is under attack (onDamaged). Directly attacks the attacker, then return to base
  ----------- DefenderEscort      Same as Defender but patrols towards the attacker zone instead of chasing the attacker.
  ----------- Hunt                Used when Pool reaches a certain critical mass.
  ----------- 
  ------ All others can be custom-named. The following may be used.
  ----------- Attack_x            Attacking      
  ----------- Patrol_x            Patrol
  ----------- Reinforcement_x     Reinforcement (if included in transport, only apply to the units after disembarkment)
  ----------- Aircraft_Attack_x   Attacking (Aircraft)
  ----------- Aircraft_Patrol_x   Patrol (Aircraft)
  ----------- Navy_Attack_x       Attacking (Navy)
  ----------- Navy_Patrol_x       Patrol (Navy)
  ----------- MCV                 Special MCV stuff (not for this mission though)
  ----------- Custom names        
  ----------- 
  ------ All Groups will follow the commands given by AIFunctions[player.Name][groupname] , except for the reserved groups which will have their own routes.
  
  if missiontick % 500 == 0 then -- don't refresh every tick, waste of time

    AITeams["USSR"] = 
    { 
      -- syntax: TeamName = { actortype, actortype, actortype, actortype, ... }, TeamName2...
      ["USSR Defend 40"] = Utils.Random({ {"3tnk", "e2", "e2", "e1", "e1"} , {"3tnk", "ftrk"} , {"3tnk", "e4", "e4"} }),
      ["USSR Defend 13"] = Utils.Random({ {"e2", "e2", "e1", "e1", "dog"} , {"ftrk", "ftrk"} , {"3tnk"} }),
      ["USSR Patrol 14-15"] = { "e2", "e2", "e2", "4tnk" },
      ["USSR Attack Slot 1"] = Utils.Random(SovietTeamGroups),
      ["USSR Attack Slot 2"] = Utils.Random(SovietTeamGroups),
      ["USSR Attack Slot 3"] = Utils.Random(SovietTeamGroups),
      ["USSR Attack Slot 4"] = Utils.Random(SovietTeamGroups),
      --["USSR Attack Slot 5"] = Utils.Random(SovietTeamGroups),
      --["USSR Attack Slot 6"] = Utils.Random(SovietTeamGroups),
    }

    AITeams["BadGuy"] = 
    { 
      -- syntax: TeamName = { actortype, actortype, actortype, actortype, ... }, TeamName2...
      --["BadGuy Attack Slot 1"] = Utils.Random(BadGuyTeamGroups),
      --["BadGuy Attack Slot 2"] = Utils.Random(BadGuyTeamGroups),
      --["BadGuy Attack Slot 3"] = Utils.Random(BadGuyTeamGroups),
      --["BadGuy Attack Slot 4"] = Utils.Random(BadGuyTeamGroups),
    }

    AIFunctions["BadGuy"] = 
    { 
      -- syntax: TeamName = { Function = functionname, ArgumentTable = functionarguments (table) }, TeamName2...
      --["BadGuy Attack Slot 1"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
      --["BadGuy Attack Slot 2"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
      --["BadGuy Attack Slot 3"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
      --["BadGuy Attack Slot 4"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
    }

    AIFunctions["USSR"] = 
    { 
      -- syntax: TeamName = { Function = functionname, ArgumentTable = functionarguments (table) }, TeamName2...
      ["USSR Defend 40"] = { { Function = ScriptFn_MovementPath, ArgumentTable = {Path = { waypoint40.Location }, Cyclic = true }}},
      ["USSR Defend 13"] = { { Function = ScriptFn_MovementPath, ArgumentTable = {Path = { waypoint13.Location }, Cyclic = true }}},
      ["USSR Patrol 14-15"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = { waypoint14.Location, waypoint15.Location }, WaitForGroup = true, Cyclic = true }}},      
      ["USSR Attack Slot 1"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
      ["USSR Attack Slot 2"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
      ["USSR Attack Slot 3"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
      ["USSR Attack Slot 4"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
      --["USSR Attack Slot 5"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
      --["USSR Attack Slot 6"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
    }
  end
end





