
NukeSiloActors = { MSLO1, MSLO2, MSLO3, MSLO4 }
ForwardCommandPost = FCOMMAND
NukeChargeTime = DateTime.Seconds(900)
NukeArrivalTime = DateTime.Minutes(30) -- - 70  -- final number to ensure the game ends in a flash
MissionTime = DateTime.Seconds(140) 

NukeLaunch = false
NukeAlreadyLaunched = false



Trigger.AfterDelay(DateTime.Seconds(MissionAnnouncementDelaySeconds), function() 
  pObjInvestigation = MissionPlayer.AddPrimaryObjective("Take the facility off-line.")
  pObjDestroyAllNuke = MissionPlayer.AddPrimaryObjective("Destroy all Soviet Nuke Silos.")
end)

NukeNorthEntrance = CPosRectangleArray(48, 51, 51, 52)
Trigger.OnEnteredFootprint(NukeNorthEntrance, function(actor)
  if actor.Owner == MissionPlayer then NukeLaunch = true end
end)

NukeSouthEntrance = CPosRectangleArray(64, 53, 65, 69)
Trigger.OnEnteredFootprint(NukeSouthEntrance, function(actor)
  if actor.Owner == MissionPlayer then NukeLaunch = true end
end)

Trigger.AfterDelay(DateTime.Seconds(20), function() 
  ToggleReveal(1, false)
end)

Utils.Do( NukeSiloActors, function(nukesilo)
  Trigger.OnDamaged(nukesilo, function(a,attacker) 
    if attacker.Owner == MissionPlayer then 
      NukeLaunch = true 
    end
  end)
end)

Trigger.OnDamaged(ForwardCommandPost, function(a,attacker) 
  if attacker.Owner == MissionPlayer then 
    NukeLaunch = true 
  end
end)

Trigger.OnKilled(ForwardCommandPost, function(a,killer) 
  if killer.Owner == MissionPlayer then 
    MissionPlayer.MarkFailedObjective(pObjInfiltrateFCOM)
  end
end)

Trigger.OnKilled(SovietConYard, function(a,killer) 
  if killer.Owner == MissionPlayer then 
    NukeLaunch = true 
  end
end)

function LaunchNuke()
  NukeAlreadyLaunched = true
  ToggleReveal(2, true)
  Utils.Do( NukeSiloActors, function(nukesilo)
    if not nukesilo.IsDead then 
      nukesilo.Owner = Player.GetPlayer("USSR")
      Trigger.AfterDelay(DateTime.Seconds(2), function()
        if not nukesilo.IsDead then 
          nukesilo.Owner = Player.GetPlayer("USSRNukeReserves")
        end
      end)
    end
  end)
  Trigger.AfterDelay(DateTime.Seconds(5), function() 
    pObjInfiltrateFCOM = MissionPlayer.AddPrimaryObjective("Infiltrate the Soviet Command Center with a Spy to stop the nukes!")
    ToggleReveal(2, false)
  end)
end

function NukeFailed()
  MissionPlayer.MarkFailedObjective(pObjInvestigation)
  MissionPlayer.MarkFailedObjective(pObjDestroyAllNuke)
  MissionPlayer.MarkFailedObjective(pObjInfiltrateFCOM)
end

Trigger.OnInfiltrated(ForwardCommandPost, function(a,infiltrator) 
  InfiltratedFCOM()
  ToggleReveal(2, true)
end)

function InfiltratedFCOM()
  
  Trigger.AfterDelay(DateTime.Seconds(3), function() 
    Utils.Do( NukeSiloActors, function(nukesilo)
      if not nukesilo.IsDead then nukesilo.Kill() end
    end)  
    if not ForwardCommandPost.IsDead then ForwardCommandPost.Kill() end
  end)
  
  Trigger.AfterDelay(DateTime.Seconds(5), function() 
    MissionPlayer.MarkCompletedObjective(pObjInvestigation)
    MissionPlayer.MarkCompletedObjective(pObjDestroyAllNuke)
    MissionPlayer.MarkCompletedObjective(pObjInfiltrateFCOM)
  end)
end


function HiddenDestroyerObjective()
  if sObjHidden == nil then
    sObjHidden = MissionPlayer.AddSecondaryObjective("Destroy the Forward Command Post before the GPS is online.")
    MissionPlayer.MarkCompletedObjective(sObjHidden)  
  end
end


