WorldLoaded = function()
	Greece1 = Player.GetPlayer("Greece1")
	Greece2 = Player.GetPlayer("Greece2")
	USSR = Player.GetPlayer("USSR")
	Nod = Player.GetPlayer("Nod")

	-- greece1

	Trigger.OnObjectiveAdded(Greece1, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "New " .. string.lower(p.GetObjectiveType(id)) .. " objective")
	end)
	Trigger.OnObjectiveCompleted(Greece1, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective completed")
	end)
	Trigger.OnObjectiveFailed(Greece1, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "Objective failed")
	end)

	VillageRaidObjective = Greece1.AddPrimaryObjective("Destroy all Soviet Forces in the area,\nincluding the mercenaries in the north.")

	Trigger.OnPlayerWon(Greece1, function()
		Media.PlaySpeechNotification(Greece1, "MissionAccomplished")
	end)

	Trigger.OnPlayerLost(Greece1, function()
		Media.PlaySpeechNotification(Greece1, "MissionFailed")
	end)

	-- greece2

	Trigger.OnObjectiveAdded(Greece2, function(p, id)
		Media.DisplayMessage(p.GetObjectiveDescription(id), "New " .. string.lower(p.GetObjectiveType(id)) .. " objective")
	end)

	KillAllObjective = Greece2.AddPrimaryObjective("Destroy all Soviet Forces in the area,\nincluding the mercenaries in the north.")

	Trigger.OnPlayerWon(Greece2, function()
		Media.PlaySpeechNotification(Greece2, "MissionAccomplished")
	end)

	Trigger.OnPlayerLost(Greece2, function()
		Media.PlaySpeechNotification(Greece2, "MissionFailed")
	end)

end

Tick = function()
	if USSR.HasNoRequiredUnits() and Nod.HasNoRequiredUnits() then
		Greece1.MarkCompletedObjective(KillAllObjective)
	end

	if USSR.HasNoRequiredUnits() and Nod.HasNoRequiredUnits() then
		Greece2.MarkCompletedObjective(KillAllObjective)
	end

	if Greece1.HasNoRequiredUnits() and Greece2.HasNoRequiredUnits() then
		Greece1.MarkFailedObjective(KillAllObjective)
		Greece2.MarkFailedObjective(KillAllObjective)
	end
end