---------------------- GLOBAL OVERRIDES --------------------------------------------
---- To override individual players use the ManualOverride function

------ Player settings -------------------------------------------------------------
  -- InitialCash = the player's initial cash, defaults to 0
  
  -- Bot controls only
  --    BuildTimeMultiplier (default, Structures, Defences, Infantry, Units, Aircraft, Ships), defaults to default, which defaults to 1
  --    CostMultipliers (default, Structures, Defences, Infantry, Units, Aircraft, Ships), defaults to default, which defaults to 1

-- Human players
DefaultInitialCash = 7000

-- Soviet Bots
SovietBotInitialCash = 75000
SovietBotBuildTimeMultiplier = { default = 1, Aircraft = 1 }
SovietBotCostMultiplier = { default = 1, Aircraft = 1 }

-- Allied Bots
AlliedBotInitialCash = 35000
AlliedBotBuildTimeMultiplier = { default = 1, Structures = 1, Aircraft = 1 }
AlliedBotCostMultiplier = { default = 1, Aircraft = 1 }

------------------------------------------------------------------------------------
------ Base settings ---------------------------------------------------------------
  -- IncludeExistingBuildingsInBaseNodes = whether existing buildings should be included in the base node count
  -- ExcludeExistingBuildingWithStringOverride = (string) if the actor's name contains this string, override to exclude the building from the base node list
  
IncludeExistingBuildingsInBaseNodes = true
BaseCenters = { ["Ukraine"] = UkraineBaseWP.Location }
InitialBaseNodes = {
  -- id = name of this entry (for debug, or specific selection only)
  -- owner = the player
  -- type = the actor type
  -- pos = position as { x, y } coordinates 

  -- Example
  -- { id = "A01", owner = Houses["Germany"].Player, type = "powr", pos = { x = 10, y = 12} },
}
 
------------------------------------------------------------------------------------
------ AI settings -----------------------------------------------------------------
AIMaintainExcessPower = 151
AIStructureHPRepair = 0.9
AIUnitHPPursuit = 0.9
AIHarvestersPerRefinery = 2
AILowCashThreshold = 10000
AIEmergencyCashThreshold = 3500

PooltoHuntThreshold = { -- Send all units in Pool to the Hunting group if the number of units surpass this threshold
  ["Germany"] = 30,
  ["Soviet Armour"] = 15,
  ["USSR"] = 45,
  ["Ukraine"] = 25 
}


GetNextWaypointSet = function(waypoint)
  if waypoint == PlayerNorthEntrance then return { PlayerSouthEntrance, WayNorth, WesternCorridorNorth, GermanNorthWestEntrance } end
  if waypoint == PlayerSouthEntrance then return { PlayerNorthEntrance, WesternCorridorSouth, SovietNorthEntrance } end
  if waypoint == WayNorth then return { PlayerNorthEntrance, WesternCorridorNorth , GermanNorthWestEntrance } end
  if waypoint == GermanNorthWestEntrance then return  { PlayerNorthEntrance, WayNorth, GermanChronosphereWP, GermanBaseWest } end
  if waypoint == GermanSouthEntrance then return { SovietEastEntrance, GermanBaseSouth, EasternCorridorSouth } end
  if waypoint == GermanSouthWestEntrance then return { SovietNorthEntrance, SovietEastEntrance, GermanBaseWest, GermanBaseSouth } end
  if waypoint == GermanBaseWest then return  { GermanChronosphereWP, GermanBaseEast, GermanBaseSouth, GermanNorthWestEntrance, GermanSouthWestEntrance } end
  if waypoint == GermanBaseEast then return  { GermanChronosphereWP, GermanBaseSouth, GermanBaseWest, EasternCorridorNorth } end
  if waypoint == GermanBaseSouth then return { GermanChronosphereWP, GermanSouthEntrance, GermanSouthWestEntrance, GermanBaseEast, GermanBaseWest } end
  if waypoint == WesternCorridorSouth then return  { WesternCorridorNorth, SovietNorthEntrance, PlayerSouthEntrance } end
  if waypoint == WesternCorridorNorth then return  { WesternCorridorSouth, PlayerNouthEntrance, WayNorth } end
  if waypoint == EasternCorridorSouth then return  { EasternCorridorNorth, GermanSouthEntrance } end
  if waypoint == EasternCorridorNorth then return  { EasternCorridorSouth, GermanBaseEast } end
  if waypoint == SovietNorthEntrance then return  { SovietNorthEntrance, PlayerSouthEntrance, SovietBaseNorth, GermanSouthWestEntrance, WesternCorridorSouth } end
  if waypoint == SovietEastEntrance then return  { SovietEastEntrance, SovietBaseNorth, GermanSouthEntrance, GermanSouthWestEntrance } end
  if waypoint == SovietSouthEntrance then return  { SovietBaseSouth } end
  if waypoint == SovietBaseNorth then return  { SovietBaseSouth, SovietEastEntrance, SovietNorthEntrance } end
  if waypoint == SovietBaseSouth then return  { SovietSouthEntrance, SovietBaseNorth } end
  if waypoint == GermanChronosphereWP then return  { GermanNorthWestEntrance, GermanBaseWest, GermanBaseSouth, GermanBaseEast } end
  return Waypoints
end

AIHuntInitialWaypoints = {
  ["Germany"] = {GermanNorthWestEntrance, GermanSouthWestEntrance, GermanSouthEntrance},
  ["Soviet Armour"] = {SovietSouthEntrance, SovietNorthEntrance, SovietEastEntrance, EasternCorridorSouth, GermanSouthEntrance},
  ["USSR"] = {WesternCorridorSouth, SovietNorthEntrance, SovietEastEntrance},
  ["Ukraine"] = {EasternCorridorSouth, EasternCorridorNorth, GermanSouthEntrance}
}

AlliedTeam1 = { "e1", "e1", "e1", "e1", "e1", "e3", "e3", "e3", "medi" }
AlliedTeam2 = { "jeep", "jeep", "e3", "e3", "e3" }
AlliedTeam3 = { "1tnk.german", "1tnk.german", "1tnk.german" }
AlliedTeam4 = { "jeep", "jeep", "arty" }
AlliedTeam5 = { "1tnk.german", "1tnk.german", "2tnk.german", "arty" }
AlliedTeam6 = { "e3", "e3", "e3", "e3", "e3", "e3" }
AlliedTeam7 = { "arty", "arty", "arty" }
AlliedTeam8 = { "2tnk.german", "2tnk.german", "2tnk.german", "2tnk.german" }
AlliedTeam9 = { "hind", "hind" }
AlliedTeam10 = { "heli", "heli" }
AlliedTeamGroups = { AlliedTeam1, AlliedTeam2, AlliedTeam3, AlliedTeam4, AlliedTeam5, AlliedTeam6, AlliedTeam7, AlliedTeam8, AlliedTeam9, AlliedTeam10 }


SovietTeam1 = { "e1", "e1", "e1", "e1", "e1", "e1", "e2", "e2", "e2", "e2", "e3", "e3" }
SovietTeam2 = { "e4", "e4", "e4", "e4", "e4", "e4" }
SovietTeam3 = { "ftrk", "ftrk", "ftrk", "e2", "e2", "e2", "e2" }
SovietTeam4 = { "v2rl", "v2rl", "ftrk", "ftrk" }
SovietTeam5 = { "3tnk", "3tnk", "3tnk", "v2rl" }
SovietTeam6 = { "4tnk", "4tnk" } 
SovietTeam7 = { "ttnk", "v2rl", "v2rl" } 
SovietTeam8 = { "ttnk", "ttnk" } 
SovietTeam9 = { "shok", "shok", "shok", "shok", "e1", "e1", "e1", "e1" } 
SovietTeam10 = { "dog", "dog", "dog", "e1", "e1" } 
SovietTeam11 = { "yak", "yak", "yak" }
SovietTeam12 = { "yak", "yak", "yak", "yak", "yak", "yak" }
SovietTeam13 = { "mig", "mig" }
SovietTeamGroups = { SovietTeam1, SovietTeam2, SovietTeam3, SovietTeam4, SovietTeam5, SovietTeam6, SovietTeam7, SovietTeam8, SovietTeam9, SovietTeam10, SovietTeam11, SovietTeam12, SovietTeam13 }




AlliedSouthRoute = { 
  GermanSouthEntrance.Location, 
  SovietEastEntrance.Location, 
  SovietBaseNorth.Location, 
  SovietBaseSouth.Location, 
  SovietSouthEntrance.Location 
}

AlliedWestRoute = { 
  GermanSouthWestEntrance.Location, 
  SovietNorthEntrance.Location, 
  SovietBaseNorth.Location, 
  SovietBaseSouth.Location, 
  SovietSouthEntrance.Location 
}

AlliedPlayerRoute = { 
  GermanNorthWestEntrance.Location, 
  PlayerNorthEntrance.Location, 
  PlayerSouthEntrance.Location, 
  SovietNorthEntrance.Location, 
  SovietBaseNorth.Location, 
  SovietBaseSouth.Location, 
  SovietSouthEntrance.Location 
}


SovietWestRoute = {
  SovietNorthEntrance.Location, 
  PlayerSouthEntrance.Location, 
  PlayerNorthEntrance.Location, 
  GermanNorthWestEntrance.Location, 
  GermanChronosphereWP.Location 
}

SovietSouthWestRoute = {
  GermanSouthWestEntrance.Location, 
  GermanBaseSouth.Location, 
  GermanBaseWest.Location, 
  GermanChronosphereWP.Location 
}

SovietSouthRoute = {
  SovietEastEntrance.Location,
  GermanSouthEntrance.Location, 
  GermanBaseSouth.Location, 
  GermanBaseWest.Location, 
  GermanChronosphereWP.Location 
}

SovietWestCorridorRoute = {
  SovietNorthEntrance.Location, 
  WesternCorridorSouth.Location, 
  WesternCorridorNorth.Location,
  PlayerNorthEntrance.Location, 
  GermanNorthWestEntrance.Location, 
  GermanChronosphereWP.Location 
}

SovietEastCorridorRoute = {
  SovietEastEntrance.Location,
  GermanSouthEntrance.Location,
  EasternCorridorSouth.Location, 
  EasternCorridorNorth.Location,
  GermanBaseEast.Location, 
  GermanChronosphereWP.Location 
}

UkraineSouthRoute = {
  EasternCorridorSouth.Location, 
  GermanSouthEntrance.Location, 
  GermanBaseSouth.Location, 
  GermanBaseWest.Location, 
  GermanChronosphereWP.Location 
}

UkraineEastCorridorRoute = {
  EasternCorridorNorth.Location,
  GermanBaseEast.Location, 
  GermanChronosphereWP.Location 
}

UkraineNorthWestRoute = {
  GermanNorthWestEntrance.Location, 
  GermanChronosphereWP.Location 
}

-- double weightage for the main routes
AlliedRoutes = { AlliedSouthRoute, AlliedWestRoute, AlliedPlayerRoute }
SovietRoutes = { SovietWestRoute, SovietSouthWestRoute, SovietSouthRoute, SovietWestRoute, SovietSouthWestRoute, SovietSouthRoute, SovietWestCorridorRoute, SovietEastCorridorRoute }
--UkraineRoutes = { UkraineSouthRoute, UkraineEastCorridorRoute } --exclude UkraineNorthWestRoute



Waypoints = {
  PlayerNorthEntrance,
	PlayerSouthEntrance,
	WayNorth,
	GermanNorthWestEntrance,
	GermanSouthEntrance,
	GermanSouthWestEntrance,
	GermanBaseWest,
	GermanBaseEast,
	GermanBaseSouth,
	WesternCorridorSouth,
	WesternCorridorNorth,
	EasternCorridorSouth,
	EasternCorridorNorth,
	SovietNorthEntrance,
	SovietEastEntrance,
	SovietSouthEntrance,
	SovietBaseNorth,
	SovietBaseSouth,
	GermanChronosphereWP,
	UkraineBaseWP,
  --Special Waypoints
  --UkraineBaseWP = { Point = UkraineBaseWP } ,
}  



function PostSetupManualOverride ()
  if bdebug then UserInterface.SetMissionText("PostSetupManualOverride() called at tick "..missiontick, MissionPlayer.Color) end
  
  missionDisplayPlayer = Player.GetPlayer("Germany")

	Utils.Do(Map.ActorsInWorld, function(a)
    if a.IsDead then return end
    -- Special hack: Convert 1tnk and 2tnk into their German counterparts (should not leave hacks here...)
    if (a.Type == "1tnk") and a.Owner == Player.GetPlayer("Germany") then
      Actor.Create("1tnk.german", true, { Owner = a.Owner, Location = a.Location, Facing = a.Facing } )
      a.Destroy()
      --a.Type = "1tnk.german"
    end     
    if (a.Type == "2tnk") and a.Owner == Player.GetPlayer("Germany") then
      Actor.Create("2tnk.german", true, { Owner = a.Owner, Location = a.Location, Facing = a.Facing } )
      a.Destroy()
      --a.Type = "2tnk.german"
    end        
	end)

  if Map.LobbyOption("difficulty") == "Mental" then
    PlayerHelipad1.Destroy()
    PlayerHelipad2.Destroy()
  end
end



function TickManualOverride()
  
  if MissionTime == DateTime.Minutes(10) then Media.PlaySpeechNotification(MissionPlayer, "TenMinutesRemaining")
  elseif MissionTime == DateTime.Minutes(5) then Media.PlaySpeechNotification(MissionPlayer, "WarningFiveMinutesRemaining")
  elseif MissionTime == DateTime.Minutes(4) then Media.PlaySpeechNotification(MissionPlayer, "WarningFourMinutesRemaining")
  elseif MissionTime == DateTime.Minutes(3) then Media.PlaySpeechNotification(MissionPlayer, "WarningThreeMinutesRemaining")
  elseif MissionTime == DateTime.Minutes(2) then Media.PlaySpeechNotification(MissionPlayer, "WarningTwoMinutesRemaining")
  elseif MissionTime == DateTime.Minutes(1) then Media.PlaySpeechNotification(MissionPlayer, "WarningOneMinuteRemaining")
  end
  
  -- For the GPS-related objective
  if AlliedTechCenter.Owner.PowerState == "Normal" then
    GPSchargeTime = GPSchargeTime - 1
    ChronosphereChargeTime = ChronosphereChargeTime - 1
    MissionTime = MissionTime - 1
  end
  
  if ObjDefend then
    if AlliedTechCenter.IsDead or TechnologyCenter.IsDead or Chronosphere.IsDead then GPSObjFailed() 
    else
      if MissionTime == 0 then GPSObjComplete() 
      elseif MissionTime > 0 then
        missionObjectiveFlavourText[ObjDefend] = ConvertToDateTime(MissionTime)
      end
    end
  end
  
  if GPSchargeTime == 0 then Media.PlaySpeechNotification(MissionPlayer, "SatelliteLaunched") end
  if ChronosphereChargeTime == 0 then 
    CreateChronoReinforcements(Player.GetPlayer("Germany"), 1)
    CreateChronoReinforcements(Player.GetPlayer("Germany"), 2)
    CreateChronoReinforcements(Player.GetPlayer("Germany"), 3)
    Media.PlaySpeechNotification(MissionPlayer, "ChronosphereCharging")
  end
  
  -- For the civilian objective
  if sObjCivRescue then
    if civiliansDead > civiliansDeathLimit then 
      CivRescueObjFailed()
    else
      if MissionPlayer.IsObjectiveCompleted(ObjDefend) then CivRescueObjComplete() end
      missionObjectiveFlavourText[sObjCivRescue] = civiliansDead.." dead"
    end
  end

  -- For the win-loss objective
  if sObjWinLoss then
    local SovietsLosses = Player.GetPlayer("USSR").DeathsCost + Player.GetPlayer("Soviet Armour").DeathsCost + Player.GetPlayer("Ukraine").DeathsCost
    local AlliedLosses = MissionPlayer.DeathsCost + Player.GetPlayer("Germany").DeathsCost + Player.GetPlayer("Allied Town").DeathsCost + Player.GetPlayer("Allied Navy").DeathsCost
    if MissionPlayer.IsObjectiveCompleted(ObjDefend) then
      if SovietsLosses >= destroyerratio * AlliedLosses then 
        WinLossObjComplete() 
      else
        WinLossObjFailed()
      end
    end
    missionObjectiveFlavourText[sObjWinLoss] = "Kills ".. SovietsLosses .." : Loss ".. AlliedLosses
  end

  -- For the bonus hidden objective
  if SovietCommand.IsDead and not MissionPlayer.IsObjectiveCompleted(ObjDefend) then
    HiddenDestroyerObjective()
  end


  --AI cheats! Shame on me!
	Utils.Do(HouseGroups.Bots, function(h)
		if h.Resources >= h.ResourceCapacity * 0.75 then
			h.Cash = h.Cash + h.Resources - h.ResourceCapacity * 0.25
			h.Resources = h.ResourceCapacity * 0.25
		end
    
    if missiontick % 5 == 0 then h.Cash = h.Cash + 1 end

	end)
  ------------------------------------------------------------------------------------
  ------ AI Team settings ------------------------------------------------------------
  ----------- Define all actor groups and their routes here
  ----------- IMPORTANT: References to lua functions should be placed in PostSetupManualOverride and not as part of initializing global variables.

  -- Teams will be declared by AITeams[player.Name][groupname], filled by AIActorGroups over the course of the game, and governed by the AI in AIGroupStatus to perform functions in AIFunctions
  ------ Groups in ActorGroups[player.Name]:
  ----------- 
  ----------- [Reserved names, do not touch]
  ----------- Pool                Pool for newly-built and unassigned units. Game will ignore any 'Pool' groupname
  ----------- Defender            Used to counter threats against the enemy when a structure / harvester is under attack (onDamaged). Directly attacks the attacker, then return to base
  ----------- DefenderEscort      Same as Defender but patrols towards the attacker zone instead of chasing the attacker.
  ----------- Hunt                Used when Pool reaches a certain critical mass.
  ----------- 
  ------ All others can be custom-named. The following may be used.
  ----------- Attack_x            Attacking      
  ----------- Patrol_x            Patrol
  ----------- Reinforcement_x     Reinforcement (if included in transport, only apply to the units after disembarkment)
  ----------- Aircraft_Attack_x   Attacking (Aircraft)
  ----------- Aircraft_Patrol_x   Patrol (Aircraft)
  ----------- Navy_Attack_x       Attacking (Navy)
  ----------- Navy_Patrol_x       Patrol (Navy)
  ----------- MCV                 Special MCV stuff (not for this mission though)
  ----------- Custom names        
  ----------- 
  ------ All Groups will follow the commands given by AIFunctions[player.Name][groupname] , except for the reserved groups which will have their own routes.
  
  if missiontick % 500 == 0 then -- don't refresh every tick, waste of time
    
    AITeams["Germany"] = 
    { 
      -- syntax: TeamName = { actortype, actortype, actortype, actortype, ... }, TeamName2...
      ["Germany Attack Slot 1"] = Utils.Random(AlliedTeamGroups),
      ["Germany Attack Slot 2"] = Utils.Random(AlliedTeamGroups),
      ["Germany Attack Slot 3"] = Utils.Random(AlliedTeamGroups),
      ["Germany Attack Slot 4"] = Utils.Random(AlliedTeamGroups),
      ["Germany Attack Slot 5"] = Utils.Random(AlliedTeamGroups),
      ["Germany Attack Slot 6"] = Utils.Random(AlliedTeamGroups),
      ["Germany Attack Slot 7"] = Utils.Random(AlliedTeamGroups),
      ["Germany Attack Slot 8"] = Utils.Random(AlliedTeamGroups),
      ["Germany Attack Slot 9"] = Utils.Random(AlliedTeamGroups),
      ["Germany Attack Slot 10"] = Utils.Random(AlliedTeamGroups),
    }

    AITeams["USSR"] = 
    { 
      -- syntax: TeamName = { actortype, actortype, actortype, actortype, ... }, TeamName2...
      ["USSR Attack Slot 1"] = Utils.Random(SovietTeamGroups),
      ["USSR Attack Slot 2"] = Utils.Random(SovietTeamGroups),
      ["USSR Attack Slot 3"] = Utils.Random(SovietTeamGroups),
      ["USSR Attack Slot 4"] = Utils.Random(SovietTeamGroups),
      ["USSR Attack Slot 5"] = Utils.Random(SovietTeamGroups),
      ["USSR Attack Slot 6"] = Utils.Random(SovietTeamGroups),
      ["USSR Attack Slot 7"] = Utils.Random(SovietTeamGroups),
      ["USSR Attack Slot 8"] = Utils.Random(SovietTeamGroups),
      ["USSR Attack Slot 9"] = Utils.Random(SovietTeamGroups),
      ["USSR Attack Slot 10"] = Utils.Random(SovietTeamGroups),
    }

    AIFunctions["Germany"] = 
    { 
      -- syntax: TeamName = { Function = functionname, ArgumentTable = functionarguments (table) }, TeamName2...
      ["Germany Attack Slot 1"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(AlliedRoutes) }}},
      ["Germany Attack Slot 2"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(AlliedRoutes) }}},
      ["Germany Attack Slot 3"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(AlliedRoutes) }}},
      ["Germany Attack Slot 4"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(AlliedRoutes) }}},
      ["Germany Attack Slot 5"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(AlliedRoutes) }}},
      ["Germany Attack Slot 6"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(AlliedRoutes) }}},
      ["Germany Attack Slot 7"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(AlliedRoutes) }}},
      ["Germany Attack Slot 8"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(AlliedRoutes) }}},
      ["Germany Attack Slot 9"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(AlliedRoutes) }}},
      ["Germany Attack Slot 10"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(AlliedRoutes) }}},
    }

    AIFunctions["USSR"] = 
    { 
      -- syntax: TeamName = { Function = functionname, ArgumentTable = functionarguments (table) }, TeamName2...
      ["USSR Attack Slot 1"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
      ["USSR Attack Slot 2"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
      ["USSR Attack Slot 3"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
      ["USSR Attack Slot 4"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
      ["USSR Attack Slot 5"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
      ["USSR Attack Slot 6"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
      ["USSR Attack Slot 7"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
      ["USSR Attack Slot 8"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
      ["USSR Attack Slot 9"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
      ["USSR Attack Slot 10"] = { { Function = ScriptFn_AttackMovementPath, ArgumentTable = {Path = Utils.Random(SovietRoutes) }}},
    }
  end
end





